'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_ftp_proxy.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2007/02/23 09:38:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Load/Save files using direct connection or proxy
'*
'*******************************************************************************
'**
' #1 tFiledlgFtpProxy ' Load/Save files using direct connection or proxy
'**
'\******************************************************************************

testcase tFiledlgFtpProxy

    '///<h3>Open a ftp connection to a server directly and via proxy</h3>
    '///<p>This testcase uses the private environment feature, you need to be 
    '///+ behind a firewall for this to work.</p>
    '///<ul>
    
    const URL = "ftp://ftp.mozilla.org"
    
    dim cProxyName as string
    dim cProxyPort as string
    
    dim brc as boolean
    
    '///+<li>Make sure we have exactly one document open and that this is &quot;The first doc!&quot;</li>
    if ( getDocumentCount() <> 1 ) then
        qaerrorlog( "Restarting the office due too many open documents." )
        ExitRestartTheOffice()
    else
        brc = hIdentifyWriterDoc( "The first doc!" , true )
        if ( not brc ) then
            qaerrorlog( "This is not the first document, restarting office" )
            ExitRestartTheOffice()
        endif
    endif
    
    '///+<li>Retrieve proxy configuration data</li>
    brc = hGetPrivateFtpServer( cProxyName, cProxyPort )
    if ( not brc ) then
        warnlog( "Could not retrieve valid proxy configuration, aborting test" )
        goto endsub
    endif
    
    '///+<li>Configure a valid proxy (uses private environment data)</li>
    hSetProxies( "", "", cProxyName, cProxyPort, "" )
    
    '///+<li>Load the page</li>
    printlog( "FileOpen / Set URL / Load the file" )
    FileOpen
    
    kontext "OeffnenDlg"
    DateiName.setText( URL )
    Oeffnen.click()
    sleep( 10 )
    
    '///+<li>Verify that the document is loaded</li>
    brc = hIdentifyWriterDoc( "FTP Directory: ftp://ftp.mozilla.org/" , true )
    if ( not brc ) then 
        warnlog( "This is either the incorrect file or we failed to load the document" )
    endif
    
    '///+<li>Close the loaded document</li>
    if ( getDocumentCount > 1 ) then
        hDestroyDocument()
    endif
    
    '///+<li>Reset the proxies to "none" (manual, with no proxy settings)</li>
    hSetProxies( "", "", "", "", "" )
    
    '///+<li>Try to load the file with no proxies -> should fail</li>
    '///<ul>
    '///+<li>FileOpen</li>
    FileOpen
    
    '///+<li>Enter filename, click &quot;Open&quot;</li>
    kontext "OeffnenDlg"
    DateiName.setText( URL )
    Oeffnen.click()
    
    '///+<li>Close the &quot;File not found&quot; warning with &quot;OK&quot;</li>
    Kontext "active"
    if ( active.exists( 5 ) ) then
        active.ok()
        
        '///+<li>Close the FileOpen dialog</li>
        kontext "OeffnenDlg"
        OeffnenDlg.cancel()
    else
        warnlog( "File not found warnin is missing" )
    endif
    
    '///</ul>
    '///</ul>


endcase

