'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_multiselection.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2007/05/03 13:07:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Select a huge number of documents and load
'*
'*******************************************************************************
'**
' #1 tFiledlgMultiselection1 ' Select a bunch of documents and load
'**
'\******************************************************************************

testcase tFiledlgMultiselection1()

    use "framework\tools\inc\stringtools.inc"

    '///<h1>Select a number of different documents and load</h1>
    '///<ul>
    
    ' This is a test requested by framework development to be used in multi-
    ' user environments like Terminal Servers. It is used to quickly create
    ' a certain load. Furthermore issues (mostly unconfirmed) have been reported
    ' that loading files using multiselection might lead to a crash.

    '///+<li>Determine the workdirectory</li>
    dim cWorkPath as string
        cWorkPath = gTesttoolPath & "framework\filedlg\input\multiselect\"
        cWorkPath = convertpath( cWorkPath )
        
    dim cMsg as string
        
    dim iCurrentFile as integer
    dim iInitialDocumentCount as integer
    dim iOpenDocuments as integer
    dim iWait as integer 
        iWait = 0
        
    dim brc as boolean
    
    const TESTFILE_COUNT = 60 ' the number of documents in cWorkPath
    
    '///<ul>
    '///+<li>Test enter: Only one document may be open</li>
    if ( getDocumentCount <> 1 ) then
    	printlog( "Restarting office, incorrect number of documents open" )
    	call exitRestartTheOffice()
    endif
    
    '///+<li>Test enter: It must be a WRITER document</li>
    kontext "DocumentWriter"
    if ( not documentwriter.exists() ) then
    	printlog( "Incorrect documenttype, need a WRITER document, restarting" )
    	call exitRestartTheOffice()
    endif
    
    '///+<li>And even more precisely: The first doc!</li>
    if ( not hIdentifyWriterDoc( "The first doc!" , false ) ) then
    	printlog( "Incorrect WRITER document, restarting" )
    	call exitRestartTheOffice()
    endif
    
    '///+<li>Close the navigator if present</li>
    hCloseNavigator()
    '///</ul>
    
    '///+<li>Store the number of open documents (should be exactly one now)</li>
    iInitialDocumentCount = getDocumentCount ' must be exactly 1 at this point
    if ( iInitialDocumentCount <> 1 ) then
    	warnlog( "Expected exactly one writer document (The first doc!)" )
    endif

    '///+<li>Open the filepicker (via menu or toolbar)</li>
    printlog( "FileOpen" )
    FileOpen

    '///+<li>Go to the workdirectory (framework\filedlg\input\multiselect\)</li>
    printlog( "Go to the workdirectory: " & cWorkPath )
    kontext "OeffnenDlg"
    DateiName.typeKeys( cWorkPath )
    Oeffnen.click()
    
    '///+<li>Check for messagebox - if one comes up we cannot continue</li>
    kontext "Active"
    if ( active.exists( 2 ) ) then
    	cMsg = active.getText()
    	cMsg = hRemoveLineBreaks( cMsg )
    	warnlog( "Unexpected messagebox: " & cMsg )
    	active.ok()
    	kontext "OeffnenDlg"
    	OeffnenDlg.cancel()
    	goto endsub
    endif
    
    '///+<li>Select all documents and click &quot;Open&quot;</li>
    printlog( "Select all documents and load them simultaneously" )
    kontext "OeffnenDlg"
    DateiAuswahl.typeKeys( "<HOME>" )
    DateiAuswahl.typeKeys( "<SHIFT END>" )
    Oeffnen.Click()
    
    '///+<li>Wait max 60 seconds for the documents to load</li>
    while ( getDocumentCount < ( TESTFILE_COUNT + 1 ) ) 
    
    	iWait = iWait + 1
    	sleep( 1 )

        if ( iWait = ( TESTFILE_COUNT + 1 ) ) then
        	warnlog( "The documents were not loaded within 60 seconds, abort" )
        	goto endsub
        endif
        
    wend

    printlog( "All documents loaded in " & iWait & " seconds" )

    '///+<li>Close all the files again</li>
    printlog( "Starting to close all documents" )
    for iCurrentFile = 1 to TESTFILE_COUNT
        sleep( 1 )
        FileClose
    next iCurrentFile
    printlog( "Finished closing documents" )
    
    '///+<li>Verify that the correct document is open &quot;The first doc!&quot;</li>
    if ( getDocumentCount <> 1 ) then
    	warnlog( "Only <The first doc!> should be open. This is not the case" )
    	iOpenDocuments = getDocumentCount
    	for iCurrentFile = 1 to iOpenDocuments - 1
    		hDestroyDocument()
        next iCurrentFile
        call ExitRestartTheOffice()
    else
        brc = hIdentifyWriterDoc( "The first doc!" , false )
        if ( not brc ) then
        	warnlog( "Incorrect document order / <The first doc!> is missing" )
        else
            printlog( "Ok, test succeeded" )
        endif
    endif
    
    hCloseNavigator()
    '///</ul>


endcase
