'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: macro_tools.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2007/07/05 12:01:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : Helper functions for Macro tests
' **
'*******************************************************************************
' **
' #1 hInsertMacroFromFile     ' Creates a BASIC Macro (taken from file)
' #0 hMacroOrganizerRunMacro  ' Run a macro from the macro organizer
' **
'\******************************************************************************

function hInsertMacroFromFile( cMacroId ) as integer

    '///<h3>Paste a macro (taken from a file) to the basic IDE</h3>
    '///<i>uses: framework/tools/input/macros.txt</i><br>
    '///<i>Starting point: Basic IDE</i><br>
    '///<u>Note</u>: Overwrites any existing macros in the current module<br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name (ID) of the macro to be inserted (string)</li>
    '///<ul>
    '///+<li>Allowed is any string that corresponds to a section in the source file</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Number of lines inserted (integer)</li>
    '///<ul>
    '///+<li>0: Error, no lines inserted</li>
    '///+<li>&gt; 0: Number of lines</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hInsertMacroFromFile::"
    
    '///+<li>Find the path to the source file</li>
    dim cFile as string
        cFile = gTesttoolPath & "framework/tools/input/macros.txt"
        cFile = convertpath( cFile )
        
    '///+<li>Determine the required array size</li>
    dim iArraySize as integer
        iArraySize = hListFileGetSize( cFile )
        
    dim aInstructionList( iArraySize ) as string
        
    dim iInstructionCount as integer
    dim iCurrentInstruction as integer
    
    dim brc as boolean
    
    '///+<li>retrieve the macro from the file with ID as section</li>
    iInstructionCount = hGetDataFileSection( cFile, _
                                             aInstructionList(), _
                                             cMacroId, "", "" )
                        
    '///+<li>Delete all content from the BASIC IDE edit window</li>
    '///+<li>Insert the code into the IDE line by line</li>
    brc = hDeleteMacro()
    if ( brc ) then

        for iCurrentInstruction = 1 to iInstructionCount
        
            EditWindow.TypeKeys( "<HOME>" )
            EditWindow.TypeKeys( aInstructionList( iCurrentInstruction ) )
            EditWindow.TypeKeys( "<RETURN>" )
            
        next iCurrentInstruction
        printlog( CFN & "Inserted macro: " & cMacroId )
        hInsertMacroFromFile() = iInstructionCount
        
    else
    
        printlog( CFN & "IDE is not empty, will not insert macro" )
        hInsertMacroFromFile() = 0
        
    endif    
    '///</ul>
        
end function

'*******************************************************************************

function hMacroOrganizerRunMacro( cMacroName as string ) as integer

    '///<h3>Execute a macro by name</h3>
    '///<i>Starting point: Any document</i><br>
    '///+<i>The function runs silent</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the macro to be run (string)</li>
    '///<ul>
    '///+<li>Any macro that can run by itself (main)</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Position of the macro in the treelist (integer)</li>
    '///<ul>
    '///+<li>0 = error</li>
    '///+<li>1-n = position of macro</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim irc as integer
    const CFN = "hMacroOrganizerRunMacro::"

    '///+<li>Go to Tools/Macros/Organize Macros/OpenOffice.org Basic</li>
    printlog( CFN & "Enter with option: " & cMacroName )
    ToolsMacro_uno    
    
    '///+<li>Find the Macro</li>
    kontext "Makro"
    hExpandAllNodes( MakroAus )
    irc = hSelectNodeByName( MakroAus , cMacroName )
    hExpandNode( MakroAus, irc )
    hSelectNextNode( MakroAus )

    if ( MakroAus.getSelText() = cMacroName ) then
        printlog( CFN & "Matching object found: " & cMacroName )
    else
        irc = 0
    endif
    
    
    '///+<li>Run the macro</li>
    kontext "Makro"
    if ( Ausfuehren.exists( 1 ) ) then
        if ( Ausfuehren.isEnabled( 1 ) ) then
            Ausfuehren.click()
        else
            printlog( CFN & "Could not execute macro, button is disabled" )
            Makro.close()
            irc = 0
        endif
    else
        printlog( CFN & "Control does not exist/context failed" )
        Makro.close()
        irc = 0
    endif
    
    hMacroOrganizerRunMacro() = irc
    printlog( CFN & "Exit with result: " & irc )
    '///</ul>
    
end function
