'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_wizard_letter.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2007/10/16 07:20:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update Test for Letter Wizard
'*
'*******************************************************************************
'**
' #1 tUpdtWizardLetter ' Update test for Letter Wizard
'**
'\******************************************************************************

testcase tUpdtWizardLetter

    '///<h1>Update test for the letter wizard</h1>
    '///<ul>
    
    dim iErr as integer
    dim brc as boolean
    
    ' Build the filename we want to save the template as.
    dim cTemplateName as string
        cTemplateName = "FWK-Testtool-Template-letterWizard.ott"
        
    dim cTemplatePath as string
        cTemplatePath = gOfficePath & "user\template\" & cTemplateName
        cTemplatePath = convertpath( cTemplatePath )    
        
    '///+<li>Make sure exactly one single writer document is open</li>
    hInitSingleDoc()

    '///+<li>open the letterwizard using the menu, page design opens</li>
    iErr = hOpenWizardWithMenu( "LETTER" )
    if ( iErr = 1 ) then
        warnlog( "#i46909# Wizard crashes/does not open" )
        goto endsub
    endif    

    '///+<li>Page 1 </li>
    kontext "Autopilotletter"    
    printlog( " * Page: Page Design" )
    call dialogtest2( AutopilotLetter, 1 )

    '///+<li>select to create a business letter</li>
    printlog( "   * select a business letter" )
    Business.check()
    sleep( 1 )

    '///+<li>do not accept to overwrite the default template</li>
    kontext "active"
    if ( active.exists( 1 ) ) then
        warnlog( "   * refusing to change the default template" )
        active.cancel()
    endif
    sleep( 3 )

    '///+<li>select business style (here: 2. entry in listbox)</li>
    kontext "Autopilotletter"    
    BusinessStyle.select( 2 )
    sleep( 2 )

    '///+<li>do not accept to overwrite the default template</li>
    kontext "active"
    if ( active.exists( 1 ) ) then
        warnlog( "   * refusing to change the default template" )
        active.cancel()
    endif
    sleep( 3 )

    '///+<li>check to add a letterhead</li>
    kontext "AutopilotLetter"
    LetterHead.Check()

    '///+<li>click next to get to the letterhead-page</li>
    hClickNextButton()

    '///+<li>Page 2</li>
    kontext "AutopilotLetter"
    call dialogtest2( AutopilotLetter, 2 )
    
    '///+<li>check to add a logo</li>
    printlog( "   * check to add logo" )
    Logo.check()
    
    '///+<li>change all metrics for the logo</li>
    printlog( "   * change the metrics of the logo" )
    LogoHeight.settext( "4" )
    LogoWidth.settext( "4" )
    LogoXpos.settext( "1" )
    LogoYpos.settext( "1" )
    
    '///+<li>check to add own address</li>
    printlog( "   * check to add own address" )
    ReturnAddress.check()
    
    '///+<li>change the metrics of the addressfield</li>
    printlog( "   * change the metrics of the address-field" )
    AddressHeight.settext( "4" )
    AddressWidth.settext( "4" )
    AddressXpos.settext( "1" )
    AddressYpos.settext( "1" )
    
    '///+<li>check to show the return-address in envelope window</li>
    printlog( "   * check to show return-address in envelope window" )
    ReturnAddressCompany.check()
    
    '///+<li>make sure the footer checkbox is *not* selected</li>
    printlog( "   * UNcheck to add a footer" )
    IncludeFooter.unCheck()
    
    '///+<li>The footer-height box should be disabled at this point</li>
    printlog( "   * change the height" )
    if ( FooterHeight.isEnabled() ) then
        warnlog( "FooterHeight should not be enabled in this configuration" )
    endif
    
    hClickNextButton()

    '///+<li>Page 3</li>
    kontext "AutopilotLetter"
    call dialogtest2( AutopilotLetter, 3 )    
    
    '///+<li>set letterpage norm to the second entry</li>
    printlog( "   * change letterformat to the second entry" )
    LetterPageNorm.select( 2 )
    
    '///+<li>change the salutation to the second entry</li>
    printlog( "   * change salutation to the second entry" )
    ListSalutation.select( 2 )
    
    '///+<li>change complimentary close to second entry</li>
    printlog( "   * change Complimentary Close to second entry" )
    ListGreetings.select( 2 )
    hClickNextButton()

    '///+<li>Page 4</li>
    kontext "AutopilotLetter"
    call dialogtest2( AutopilotLetter, 4 )
    hClickNextButton()

    '///+<li>Page 5</li>
    kontext "AutopilotLetter"
    call dialogtest2( AutopilotLetter, 5 )    
    
    '///+<li>insert some text into the footer-field</li>
    printlog( "   * enter some text as footer" )
    TextFooter.settext( "Some non-offending text" )
    
    '///+<li>check to include it on any second page</li>
    printlog( "   * check Include only on second ..." )
    IncludeFromPage2.check()
    hClickNextButton()

    '///+<li>Page 6</li>
    kontext "AutopilotLetter"
    call dialogtest2( AutopilotLetter, 6 )   
    
    '///+<li>name the template for further usage</li>
    printlog( "   * name the template for further usage" )
    TemplateName.setText( cTemplateName )
    hSetTemplateSavePath( cTemplatePath )
    
    '///+<li>click the 'finish' button</li>
    hFinishWizard( 1 )
    
    '///+<li>Check for File-Save error</li>
    iErr = hHandleSaveError()
    if ( iErr = 1 ) then
        kontext "AutopilotLetter"
        hFinishWizard( 1 )
    endif
    
    '///+<li>close the document</li>     
    brc = hDestroyDocument()
    if ( not brc ) then
        qaerrorlog( "#i59233# The wizard does not display the new template" )
    endif   
    
    '///+<li>Delete the new template</li>
    hDeleteFile( cTemplatePath )
    
    '///</ul>

endcase


