'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_format_character1.inc,v $
'*
'*  $Revision: 1.9.2.1 $
'*
'*  last change: $Author: hde $ $Date: 2008/02/27 08:01:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Standard character styles formatting 
'*
'\***********************************************************************

sub w_format_character1

   Call tFormatStyles1	'-> Format/Styles with contect menu
   Call tFormatStyles2	'-> Format/Styles with shortcuts

end sub


testcase tFormatStyles1
	Dim iMenuEntry as integer
    
    if hIsExtensionAlreadyInstalled("SunSearchToolbar.oxt") = true then
        iMenuEntry = 5
    else
        iMenuEntry = 4
    endif
	'/// All format styles in context-menu ///
	'/// Open a new document ///
	Call hNewDocument
	printlog "- Style 'Bold' "
	'/// Write 'Style Bold' - execute Context menu 'Style Bold'
	Call wDokSchreiben "Style Bold"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(1)
    wait 500
	' /// Check if changes to style have been made ///
    Kontext "TextObjectbar"
    if Fett.Getstate(2) = 0 then
        Warnlog "Style 'Bold' with context menu has not been set!"
    endif

	Call wDokSchreiben "<End><Mod1 Shift X>"
    wait 500
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'Italic' "
	'/// Write 'Style Itlaic' - execute Context menu 'Style Italic'
	Call wDokSchreiben "Style Italic"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(2)
    wait 500
	' /// Check if changes to style have been made ///
    Kontext "TextObjectbar"
    if Kursiv.Getstate(2) = 0 then
        Warnlog "#58722#Style 'Italic' with context menu has not been set!"
    endif

	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'Underline' "
	'/// Write 'Style Underline' - execute Context menu 'Style Underline'
	Call wDokSchreiben "Style Underline"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(3)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Underline.GetSelIndex <> 2 then Warnlog "Style 'Underline' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"
	
	printlog "- Style 'StrikeThrough' "
	'/// Write 'Style Strikethrough' - execute Context menu 'Style Strikethrough'
	Call wDokSchreiben "Style Strikethrough"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(4)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex <> 2 then Warnlog "Style 'StrikeThrough' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End>"
	Call wDokSchreiben "<Right><Return>"

	printlog "- Style 'Shadow' "
	'/// Write 'Style Shadow' - execute Context menu 'Style Shadow'
	Call wDokSchreiben "Style Shadow"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(5)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Shadow.IsChecked = False then Warnlog "Style 'Shadow' with context menu has not been set!"
	TabFontEffects.Cancel
	Call wDokSchreiben "<End><Right>"
	Call wDokSchreiben "<Return>"

	printlog "- Style 'Outline' "
	'/// Write 'Style Outline' - execute Context menu 'Style Outline'
	Call wDokSchreiben "Style Outline"
	Call wDokSchreiben "<Shift Home>"
	Kontext "DocumentWriter"
	DocumentWriter.OpenContextMenu
	Call hMenuSelectNr(iMenuEntry)	' entry should be 'Style'
    wait 500
    Call hMenuSelectNr(6)
    wait 500
	' /// Check if changes to style have been made ///
	FormatCharacter
	Kontext
	Active.Setpage TabFontEffects
	Kontext "TabFontEffects"
	if Outline.IsChecked = false then Warnlog "Style 'Outline' with context menu has not been set!"
	TabFontEffects.Cancel

	Call hCloseDocument

endcase



testcase tFormatStyles2
	
	'/// All format styles with Shortcuts ///
    '/// This is tested in w_shortcuts.bas
    
endcase

