'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_204b_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: hde $ $Date: 2007/06/05 07:41:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer Table test
'*
'\***********************************************************************


sub w_204b_

   Call wSplittingTableCellsIntoEqualProportions

end sub


testcase wSplittingTableCellsIntoEqualProportions
   Dim i as integer, DaRowHeight as string
   Dim SetRowHeight as boolean
   SetRowHeight = True
   printlog "Based on feature ID: 103485"
   '/// Open a new writer document ///
   Call hNewDocument
   '/// Insert a table with 4 rows and 4 lines ///
   Call TBOhTabelleEinfuegen("SplittingTable", 0, 1, 0, 1, "4", "4")
   '/// Select the table ( Strg + A ) ///
   Call wDokSchreiben ( "<Mod1 A>" )
   '/// Format / Row / Height ///
   Kontext "ZellenHoehe"
   FormatRowHeight
   '/// In upcoming dialog (Row Height) set height to 1,2cm and check 'Fit to size' ///
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Hoehe.Settext "1.20"
   else
      Hoehe.Settext "1,20"
   endif
   Dynamisch.Check
   DaRowHeight = Hoehe.Gettext
   '/// Close 'Row Height' with 'OK' ///
   ZellenHoehe.Ok
   '/// Point cursor to first cell in first row ( Strg + Home ) ///
   Call wDokSchreiben ( "<Mod1 Home>" )
   For i = 1 to 4
      if wCheckRowHeight( DaRowHeight ) = False then SetRowHeight = False
      Call wDokSchreiben ( "<Down>" )
   next i
   if SetRowHeight = True then
      Call wDokSchreiben ( "<Up>", 4 )
      '/// Select 1st and 2nd column ///
      Call wDokSchreiben ( "<Shift Down>", 3 )
      Call wDokSchreiben ( "<Shift Right>" )
      '/// Format / Cell / Merge to merge all cells ///
      TableMergeCells
      '/// Now split previous merged cell into 4 pieces ( horizontally )///
      '/// Format / Cell / Split ///
      TableSplitCell
      Kontext "ZellenTeilen"
      '/// In 'Split Cells' Dialog set 'Split cell into' to 4 ///
      Anzahl.Settext "4"
      '/// Check 'Horizontally' and 'Into equal proportions' ///
      Horizontal.Check
      GleichmaessigTeilen.Check
      '/// Close dialog with 'OK' ///
      ZellenTeilen.Ok
      '/// Now the cell has to be splitted into 4 rows of height 1,2cm ///
      For i = 1 to 4
         if wCheckRowHeight( DaRowHeight ) = False then SetRowHeight = False
         Call wDokSchreiben ( "<Down>" )
      next i
   else
      Warnlog "Error setting the row height !"
   endif

   Call hCloseDocument

endcase
