'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_xml_print_scale.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:28:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check content.xml and styles.xml for correct print scaling settings
'*
'*************************************************************************************************
'*
' #1 subPrintScaling
' #1 tPrintScaling
'*
'\*************************************************************************************************
sub subPrintScaling
  printLog Chr(13) + "---------  Print scaling attributes  ----------"

     call tPrintScaling

end sub

'************************************************************
testcase tPrintScaling
'///<u><b>Check correct print scaling attributes</b></u>///

dim iIndex as INTEGER
dim iInnerIndex as INTEGER
    
dim sExtension
    sExtension = ".ods"

dim sOutputFile as STRING
    sOutputFile = ( gOfficePath & ConvertPath( "user\work\printScaling" ) & sExtension )
    
dim sUnpackedStorageDir as STRING
    sUnpackedStorageDir = ( gOfficePath & ConvertPath( "user\work\printScaling" ))
    if (dir ( sUnpackedStorageDir ) <> "" ) then
        kill ( sUnpackedStorageDir )
    endif
    
dim sContentXML as STRING
    sContentXML = ( sUnpackedStorageDir & ConvertPath( "\content.xml" ))
    
dim sStylesXML as STRING
    sStylesXML = ( sUnpackedStorageDir & ConvertPath( "\styles.xml" ))
    
dim asTableStyleAssocations ( 5 , 3 ) as STRING

dim sNameSheet1 as STRING
    sNameSheet1 = "Ten"
dim sNameSheet2 as STRING
    sNameSheet2 = "Moves"
dim sNameSheet3 as STRING
    sNameSheet3 = "Ahead"
    
dim sNameStyle1 as STRING
    sNameStyle1 = "1stStyle"
dim sNameStyle2 as STRING
    sNameStyle2 = "2ndStyle"
dim sNameStyle3 as STRING
    sNameStyle3 = "3rdStyle"

dim iTablesInDocument as INTEGER
dim iStylesInAutomaticStyles as INTEGER
dim iMasterPageStylesInStylesXML as INTEGER
dim sCurrentTableName as STRING
dim sExpectedTableName as STRING
dim sCurrentTableStyle as STRING
dim sCurrentAutomaticStyle as STRING
dim sCurrentMasterPageStyle as STRING

dim sExpectedScaleTo      as STRING
dim sExpectedScaleToX     as STRING
dim sExpectedScaleToY     as STRING
dim sExpectedScaleToPages as STRING
    
'///<b>PART1: Creating a test document</b>///
'///<ul>
'///<li>Open test document</li>///
    Call hNewDocument
    sleep(2)
    
    for iIndex = 1 to 3
        '///<li>Add minimal content to all sheets</li>///
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "1<RETURN>"
        sleep(1)
        '///<li>Assign specific names for sheets to avoid language dependencies</li>///
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        select case iIndex
               case 1 : Tabellenname.SetText sNameSheet1
               case 2 : Tabellenname.SetText sNameSheet2
               case 3 : Tabellenname.SetText sNameSheet3
        end select
        TabelleUmbenennen.OK
        sleep(1)
        
        '///<li>(Don't forget to change sheets inbetween)</li>///
        EditSheetSelect
        Kontext "SelectSheets"
        if iIndex = 3 then
            '///<li>(At the end return to first sheet)</li>///
            SheetSelectionBox.Select sNameSheet1
        else
            SheetSelectionBox.Select ( iIndex + 1 )
        endif
        SelectSheets.OK
        sleep(1)
    next iIndex
    
    FormatStylesCatalog
    '///<li>Invoke Style catalog</li>///
    Kontext "Vorlagenkatalog"
    Vorlagen.select ( 2 )
    sleep(1)
    '///<li>Create three styles using different page scaling features</li>///
    for iIndex = 1 to 3
        Kontext "Vorlagenkatalog"
        '///<li>Click new</li>///
        Neu.Click
        Kontext
        '///<li>(Page format dilog shoud appear)</li>///
        '///<li>Select Page 'Organizer'</li>///
        active.SetPage TabVerwalten
        '///<li>Close MsgBox when appeared</li>///
        if Active.Exists(2) then
            if Active.GetRT = 304 then
                Printlog Active.GetText
                Active.Yes
            end if
        end if
        Kontext "TabVerwalten"
        '///<li>Assign name for each style</li>///
        select case iIndex
               case 1 : VorlagenName.setText sNameStyle1
               case 2 : VorlagenName.setText sNameStyle2
               case 3 : VorlagenName.setText sNameStyle3
        end select
        Kontext
        '///<li>Select Page 'Sheet'</li>///
        active.SetPage TabTabelleCalc
        Kontext "TabTabelleCalc"
        '///<li>For all three styles use different page scaling features</li>///
        '///<ol>
        scalingMode.Select ( iIndex )
        select case iIndex
               '///<li>Scale size to 55%</li>///
               case 1 : SkalierungProzent.setText "55%"
               '///<li>Scale output to 3 pages wide and 4 pages high</li>///
               case 2 : ScalePageWidth.setText "3"
                        ScalePageHeight.setText "4"
               '///<li>Scale output to a total of 6 pages</li>///
               case 3 : AnzahlMaxSeiten.setText "6"
        end select
        '///<li>Leave page format dilog using OK</li>///
        TabTabelleCalc.OK
        '///</ol>
    next iIndex
    '///<li>Close style catalog using OK</li>///
    Kontext "Vorlagenkatalog"
    Vorlagenkatalog.OK
    sleep(2)
    '///<li>Assign the three styles created to the three sheets in document</li>///
    for iIndex = 1 to 3
    '///<li>First select a sheet</li>///
        EditSheetSelect
        Kontext "SelectSheets"
        SheetSelectionBox.Select ( iIndex  )
        SelectSheets.OK
        sleep(1)
        '///<li>Open the stylist</li>///
        Kontext "Gestalter"
        if NOT Gestalter.exists(2) then
            FormatStylist
        endif
        '///<li>Assign styles using the stylist</li>///
        Kontext "Gestalter"
        Seitenvorlagen.Click
        Kontext "Vorlagenliste"
        Vorlagenliste.TypeKeys "<HOME>"
        sleep (2)
        Vorlagenliste.Select ( iIndex )
        Vorlagenliste.TypeKeys "<RETURN>"
    next iIndex
    '///<li>Close stylist</li>///
    Kontext "Gestalter"
    if Gestalter.exists(2) then
        FormatStylist
    endif
        
    '///<li>Save in current default format</li>///
    if hSpeichernUnterMitFilterKill ( sOutputFile , sFileFormat ) = FALSE then
       warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
       call hCloseDocument
    else
       '///<li>... and close</li>///
       call hCloseDocument
       sleep(3)
'///</ul>
'///<b>PART 2: Checking the XML files</b>///
'///<ul>
       '///<li>Unpack storage to obtain the XML files</li>///
       printlog "Unpack storage of test document."
       UnpackStorage ( sOutputFile , sUnpackedStorageDir )
       printlog "Read 'content.xml' DOM."
       '///<li>Read DOM of content.xml</li>///
       SAXReadFile ( sContentXML )
       sleep(2)

       '///<li>Set the DOM pointer on element 'office:spreadsheet'</li>///
       printlog "Set the DOM pointer on element 'office:spreadsheet'"
       printlog "|-/"
       SAXSeekElement ( "/" )
       printlog "  |-office:document-content"
       SAXSeekElement ( "office:document-content" )
       printlog "    |-office:body"
       SAXSeekElement ( "office:body" )
       printlog "      |-office:spreadsheet"
       SAXSeekElement ( "office:spreadsheet" )
       iTablesInDocument = SAXGetChildCount
       '///<li>Check correct number of sheets</li>///
       if iTablesInDocument <> 3 then
           warnlog "Unexpected number of tables in the document -> Check this out!"
       else
           printlog "        + OK, three tables in document"
       endif
       '///<li>Seek nodes table:table</li>///
       for iIndex = 1 to iTablesInDocument
            printlog "        |-table:table"
            SAXSeekElement ( "table:table" , iIndex )
            '///<li>Get 'table:name' and 'table:style-name' for all tables</li>///
            sCurrentTableName  = SAXGetAttributeValue ( "table:name" )
            sCurrentTableStyle = SAXGetAttributeValue ( "table:style-name" )
            select case iIndex
                   case 1 : sExpectedTableName = sNameSheet1
                   case 2 : sExpectedTableName = sNameSheet2
                   case 3 : sExpectedTableName = sNameSheet3
            end select
            '///<li>Check correct table names</li>///
            if sCurrentTableName <> sExpectedTableName then
                warnlog "OOPS, this table has got an unexpected name -> Check this out!"
            else
                printlog "          + Table name matches expectations"
            endif
            '///<li>Memorize associations of table and style names</li>///
            asTableStyleAssocations ( iIndex , 0 ) = sCurrentTableName
            asTableStyleAssocations ( iIndex , 1 ) = sCurrentTableStyle
            SAXSeekElement ( 0 )
       next iIndex
       SAXSeekElement ( 0 )
       SAXSeekElement ( 0 )
       '///<li>Go back in DOM-tree to 'office:automatic-styles'</li>///
       printlog "        |-office:automatic-styles"
       SAXSeekElement( "office:automatic-styles" )
       iStylesInAutomaticStyles = SAXGetChildCount
       if iStylesInAutomaticStyles <> 5 then
           warnlog "Unexpected number of styles in 'content.xml' -> Check this out!"
       else
           printlog "          + OK, five styles in 'content.xml'"
       endif
       for iIndex = 1 to iStylesInAutomaticStyles
       '///<li>Seek nodes style:style</li>///
           printlog "          |-office:automatic-styles"
           SAXSeekElement( "style:style" , iIndex )
           if SAXGetAttributeValue ( "style:family" ) = "table" then
               sCurrentAutomaticStyle = SAXGetAttributeValue ( "style:name" )
               printlog "            + Found table style " & sCurrentAutomaticStyle & " at postion " & iIndex
               '///<li>Memorize associations of table and master pages names using previously determined style names</li>///
               for iInnerIndex = 1 to iTablesInDocument
                   if sCurrentAutomaticStyle = asTableStyleAssocations ( iInnerIndex , 1 ) then
                       asTableStyleAssocations ( iInnerIndex , 2 ) = SAXGetAttributeValue ( "style:master-page-name" )
                   endif
               next iInnerIndex
           endif
           SAXSeekElement ( 0 )
       next iIndex
       '///<li>Release DOM of 'content.xml'</li>///
       SAXRelease
       printlog "| <<< DOM released <<<"
       printlog ""
       
       printlog "Read 'styles.xml' DOM."
       '///<li>Read DOM of styles.xml</li>///
       SAXReadFile ( sStylesXML )
       sleep(2)
       printlog "Set the DOM pointer on element 'office:master-styles'"
       printlog "|-/"
       SAXSeekElement ( "/" )
       printlog "  |-office:document-styles"
       SAXSeekElement ( "office:document-styles" )
       printlog "    |-office:master-styles"
       SAXSeekElement ( "office:master-styles" )
       iMasterPageStylesInStylesXML = SAXGetChildCount
       '///<li>Seek nodes style:master-page</li>///
       for iIndex = 1 to iMasterPageStylesInStylesXML
           printlog "      |-style:master-page"
           SAXSeekElement( iIndex )
           sCurrentMasterPageStyle = SAXGetAttributeValue ( "style:name" )
           printlog "        + Found table style " & sCurrentMasterPageStyle & " at postion " & iIndex
           for iInnerIndex = 1 to iTablesInDocument
               '///<li>Memorize associations of table names and master page styles using master page names found in 'context.xml'</li>///
               if sCurrentMasterPageStyle = asTableStyleAssocations ( iInnerIndex , 2 ) then
                   if SAXGetElementName = "style:master-page" then
                       printlog "        + Expected style type found"
                   else
                       warnlog "Unexpected style type found -> Check this out!"
                       qaErrorLog SAXGetElementName & " instead of 'style:master-page'"
                   endif
                   asTableStyleAssocations ( iInnerIndex , 3 ) = SAXGetAttributeValue ( "style:page-layout-name" )
                   '///<li>Check correct UI strings for master page styles</li>///
                   select case SAXGetAttributeValue ( "style:display-name" )
                          case sNameStyle1 : sExpectedTableName = sNameSheet1
                          case sNameStyle2 : sExpectedTableName = sNameSheet2
                          case sNameStyle3 : sExpectedTableName = sNameSheet3
                   end select 
                   '///<li>Check if UI strings for master page styles are correctly assigned to the three sheets</li>///
                   if sExpectedTableName <> asTableStyleAssocations ( iInnerIndex , 0 ) then
                       warnlog "Association of UI Style name and table doesn't meet expectation -> Check this out!"
                       qaErrorLog "Expected '" & sExpectedTableName & "' but found '" & asTableStyleAssocations ( iInnerIndex , 0 ) & "'"
                   else
                       printlog "        + Expected table name '" & sExpectedTableName & "' found"
                   endif
               endif
           next iInnerIndex
           SAXSeekElement ( 0 )
       next iIndex
       SAXSeekElement ( 0 )
       '///<li>Go back in DOM-tree to 'office:automatic-styles'</li>///
       printlog "      |-office:automatic-styles"
       SAXSeekElement ( "office:automatic-styles" )

       iStylesInAutomaticStyles = SAXGetChildCount
       '///<li>Seek nodes style:page-layout</li>///
       for iIndex = 1 to iStylesInAutomaticStyles
           printlog "      |-style:page-layout"
           SAXSeekElement (  iIndex )
           sCurrentAutomaticStyle = SAXGetAttributeValue ( "style:name" )
           printlog "        + Found table style " & sCurrentAutomaticStyle & " at postion " & iIndex
           '///<li>Check for each sheet if expected page scaling is correctly assigned</li>///
           for iInnerIndex = 1 to iTablesInDocument
               if sCurrentAutomaticStyle = asTableStyleAssocations ( iInnerIndex , 3 ) then
                   if SAXGetElementName = "style:page-layout" then
                       printlog "        + Expected style type found"
                   else
                       warnlog "Unexpected style type found -> Check this out!"
                       qaErrorLog SAXGetElementName & " instead of 'style:page-layout'"
                   endif
                   printlog "        |-style:page-layout"
                   SAXSeekElement ( "style:page-layout-properties" )
                   select case asTableStyleAssocations ( iInnerIndex , 0 )
                          case sNameSheet1
                               sExpectedScaleTo      = "55%"
                               sExpectedScaleToX     = ""
                               sExpectedScaleToY     = ""
                               sExpectedScaleToPages = ""
                          case sNameSheet2
                               sExpectedScaleTo      = ""
                               sExpectedScaleToX     = "3"
                               sExpectedScaleToY     = "4"
                               sExpectedScaleToPages = ""
                          case sNameSheet3
                               sExpectedScaleTo      = ""
                               sExpectedScaleToX     = ""
                               sExpectedScaleToY     = ""
                               sExpectedScaleToPages = "6"
                   end select
                   if sExpectedScaleTo = SAXGetAttributeValue ( "style:scale-to") then
                       printlog "          + Attribute 'style:scale-to' has expected value: " & SAXGetAttributeValue ( "style:scale-to")
                   else
                       warnlog " Attribute 'style:scale-to' has unexpected value: " & SAXGetAttributeValue ( "style:scale-to")
                       qaErrorLog "Expected: " & sExpectedScaleTo
                   endif
                   if sExpectedScaleToX = SAXGetAttributeValue ( "style:scale-to-X") then
                       printlog "          + Attribute 'style:scale-to-X' has expected value: " & SAXGetAttributeValue ( "style:scale-to-X")
                   else
                       warnlog "Attribute 'style:scale-to-X' has unexpected value: " & SAXGetAttributeValue ( "style:scale-to-X")
                       qaErrorLog "Expected: " & sExpectedScaleToX
                   endif
                   if sExpectedScaleToY = SAXGetAttributeValue ( "style:scale-to-Y") then
                       printlog "          + Attribute 'style:scale-to-Y' has expected value: " & SAXGetAttributeValue ( "style:scale-to-Y")
                   else
                       warnlog "Attribute 'style:scale-to-Y' has unexpected value: " & SAXGetAttributeValue ( "style:scale-to-Y")
                       qaErrorLog "Expected: " & sExpectedScaleToY
                   endif
                   if sExpectedScaleToPages = SAXGetAttributeValue ( "style:scale-to-pages") then
                       printlog "          + Attribute 'style:scale-to-pages' has expected value: " & SAXGetAttributeValue ( "style:scale-to-pages")
                   else
                       warnlog "Attribute 'style:scale-to-pages' has unexpected value: " & SAXGetAttributeValue ( "style:scale-to-pages")
                       qaErrorLog "Expected: " & sExpectedScaleToPages
                   endif
                   SAXSeekElement ( 0 )
               endif
           next iInnerIndex
           SAXSeekElement ( 0 )
       next iIndex
    endif
    '///<li>Release DOM of 'styles.xml'</li>///
    '///<li>-- END --</li>///
    SAXRelease
'///</ul>
endcase

