'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_xml_japanese_candlestick.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: wg $ $Date: 2008/01/24 11:11:02 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : testing japanese candle strick feature in chart 
'*
'*************************************************************************************************
'*
' #1 tJapaneseCandlestickChart  'Check content.xml for attribute chart:japanese-candle-stick
'*
'\*************************************************************************************************

testcase tJapaneseCandlestickChart
'/// <u>Note</u>: Only variant 2 and 4 using the chart:japanese-candle-stick attribute
    dim iTypeNum as INTEGER
    dim iSaxSeekIndex as INTEGER        
    dim sOutputFile as STRING
    dim sChartContentXML as STRING
    dim sUnpackedStorageDir as STRING
    dim sAttrValue as STRING
    
    for iTypeNum = 1 to 4
        if iTypeNum = 1 or iTypeNum = 3 then
            printlog "Skippting variant " & iTypeNum 
        else
            sOutputFile = gOfficePath & ConvertPath("user\work\japaneseCandlestickType" & iTypeNum & ".ods")
            sUnpackedStorageDir = gOfficePath & ConvertPath("user\work\japaneseCandlestickType") & iTypeNum
            if (dir(sUnpackedStorageDir) <> "") then
                RmDir (sUnpackedStorageDir)
            endif
            sChartContentXML = gOfficePath & ConvertPath("user\work\japaneseCandlestickType" & iTypeNum & "\Object 1\content.xml")    
            '/// File / New / Spreadsheet
            Call  hNewDocument
            printlog "Creating a test document for Stock Chart " & iTypeNum & "."                    
            Kontext "DocumentCalc"
            Kontext "RechenleisteCalc"
            if not RechenleisteCalc.isvisible then
                ViewToolbarsFormulaBar
            end if
            sleep(2)
            '/// Type in the 'Name Box' of the 'Formula Bar' [CTRL+A]
            Kontext "RechenleisteCalc"
            Bereich.TypeKeys "<MOD1 A>"
            '/// and then 'A1:F10' to select a range
            Bereich.TypeKeys "A1:F10"
            sleep(1)
            '/// Type [RETURN]
            Bereich.TypeKeys "<RETURN>"
            sleep(2)
            Kontext "DocumentCalc"
            '/// In the Calc document write '=rand()[SHIFT MOD1 RETURN]'
            DocumentCalc.typekeys("=rand()<SHIFT MOD1 RETURN>")      
            '/// Insert / Chart                     
            InsertChartCalc
            sleep(2)
            Kontext "ChartType"
            '/// Select Type 8 'Stock Chart'
            ChooseType.Select(8)
            '/// Select Type 2 or 4
            variant.typeKeys "<HOME>"
            variant.typeKeys "<RIGHT>", (iTypeNum - 1)
            '/// Click FINISH button
            Kontext "ChartWizard"
            ChartWizard.OK
            sleep(2)
            Kontext "DocumentCalc"
            '/// Type twice [ESCAPE]
            DocumentCalc.TypeKeys "<ESCAPE>" , 2
            sleep(2)
            '/// Save document in the <i>OpenDocument</i> format (should be default)
            '///+ as <i>gOfficePath</i>/user/work/japaneseCandlestickType[2|4].ods
            printlog "Save document using native file format."
            if hSpeichernUnterMitFilterKill (sOutputFile , gCalcFilter) = FALSE then
                warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
                call hCloseDocument
            else
                '/// File / Close
                call hCloseDocument
                sleep(3)
                '/// <i>Unzip</i> or <i>unjar</i> the <i>gOfficePath</i>/user/work/japaneseCandlestickType[2|4].ods
                '///+ into the directory <i>gOfficePath</i>/user/work/japaneseCandlestickType[2|4]
                printlog "Unpack storage of test document."
                UnpackStorage(sOutputFile, sUnpackedStorageDir)
                printlog "Read the test documents DOM."
                '/// Use an <i>XML editor</i> like <i><a href="http://www.jedit.org">jEdit</a></i> and open the 
                '///+ <i>structure</i> of the XML file <i>gOfficePath</i>/user/work/japaneseCandlestickType[2|4]/Object 1/content.xml
                SAXReadFile(sChartContentXML)
                sleep(2)                        
                printlog "Set the DOM pointer on element 'office:automatic-styles'"                        
                SAXSeekElement("/")
                '/// The test case is passed if... 
                '///+<ul><li>office:document-content
                '///+<ul><li>office:automatic-styles
                '///+<ul><li>style:style
                '///+...in one of the 10 style:style elements there should be a</li>                        
                '///+<ul><li>style:chart-properties
                '///+<ul><li>chart:japanese-candle-stick 
                '///+with the value <b>true</b></li>                        
                '///+</li></ul></li></ul></ul></li></ul></ul> 
                SAXSeekElement("office:document-content")        
                SAXSeekElement("office:automatic-styles")                                                
                for iSaxSeekIndex = 1 to 10 
                    SAXSeekElement("style:style" , iSaxSeekIndex)                                                                                                                                
                    if SAXHasElement("style:chart-properties") then                            
                        SAXSeekElement("style:chart-properties")                                
                        if SaxGetAttributeName(1) = "chart:japanese-candle-stick" then
                            printlog "Found attribute 'chart:japanese-candle-stick'"                                                                            
                            sAttrValue = SAXGetAttributeValue("chart:japanese-candle-stick")
                            if lcase(sAttrValue) = "true" then
                                printlog "Expected value of 'chart:japanese-candle-stick' = true was found"
                                exit for
                            endif                    
                        endif
                        SAXSeekElement(0)
                    endif
                    SAXSeekElement(0)                            
                next iSaxSeekIndex
                SAXRelease
            endif                                    
        endif
    next iTypeNum
endcase

