/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public class Convert
implements Cloneable {
    private ConverterInfo ci;
    private boolean toOffice;
    private ConvertData inputCD = new ConvertData();

    public Convert(ConverterInfo converterInfo, boolean bl) {
        this.ci = converterInfo;
        this.toOffice = bl;
    }

    public void addInputStream(String string, InputStream inputStream) throws IOException {
        Document document = this.toOffice ? this.ci.getPluginFactory().createDeviceDocument(string, inputStream) : this.ci.getPluginFactory().createOfficeDocument(string, inputStream);
        this.inputCD.addDocument(document);
    }

    public void addInputStream(String string, InputStream inputStream, boolean bl) throws IOException {
        Document document = this.toOffice ? this.ci.getPluginFactory().createDeviceDocument(string, inputStream) : this.ci.getPluginFactory().createOfficeDocument(string, inputStream, bl);
        this.inputCD.addDocument(document);
    }

    public Object clone() {
        Convert convert = null;
        try {
            convert = (Convert)super.clone();
            convert.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Convert clone could not be created");
        }
        return convert;
    }

    public ConvertData convert() throws ConvertException, IOException {
        ConvertData convertData = new ConvertData();
        if (this.toOffice) {
            DocumentDeserializerFactory documentDeserializerFactory = this.ci.getDocDeserializerFactory();
            DocumentDeserializer documentDeserializer = documentDeserializerFactory.createDocumentDeserializer(this.inputCD);
            Document document = documentDeserializer.deserialize();
            convertData.addDocument(document);
            return convertData;
        }
        DocumentSerializerFactory documentSerializerFactory = this.ci.getDocSerializerFactory();
        Enumeration enumeration = this.inputCD.getDocumentEnumeration();
        Document document = (Document)enumeration.nextElement();
        DocumentSerializer documentSerializer = documentSerializerFactory.createDocumentSerializer(document);
        convertData = documentSerializer.serialize();
        return convertData;
    }

    public Document getDeviceDocument(String string, InputStream inputStream) throws IOException {
        return this.ci.getPluginFactory().createDeviceDocument(string, inputStream);
    }

    public DocumentMerger getDocumentMerger(Document document) throws IOException {
        DocumentMergerFactory documentMergerFactory = this.ci.getDocMergerFactory();
        DocumentMerger documentMerger = documentMergerFactory.createDocumentMerger(document);
        return documentMerger;
    }

    public Document getOfficeDocument(String string, InputStream inputStream) throws IOException {
        return this.ci.getPluginFactory().createOfficeDocument(string, inputStream);
    }

    public void reset() {
        this.inputCD.reset();
    }
}

