/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openoffice.xmerge.util.Debug;

class OfficeZip {
    private static final String CONTENTXML = "content.xml";
    private static final String STYLEXML = "styles.xml";
    private static final String METAXML = "meta.xml";
    private static final String SETTINGSXML = "settings.xml";
    private static final String MANIFESTXML = "META-INF/manifest.xml";
    private static final int BUFFERSIZE = 1024;
    private List entryList = new LinkedList();
    private int contentIndex = -1;
    private int styleIndex = -1;
    private int metaIndex = -1;
    private int settingsIndex = -1;
    private int manifestIndex = -1;

    OfficeZip() {
    }

    private ZipEntry createZipEntry(String string, byte[] byArray, int n) {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setMethod(n);
        zipEntry.setSize(byArray.length);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(byArray);
        zipEntry.setCrc(cRC32.getValue());
        zipEntry.setTime(System.currentTimeMillis());
        return zipEntry;
    }

    byte[] getContentXMLBytes() {
        return this.getEntryBytes(this.contentIndex);
    }

    private byte[] getEntryBytes(int n) {
        byte[] byArray = null;
        if (n > -1) {
            Entry entry = (Entry)this.entryList.get(n);
            byArray = entry.bytes;
        }
        return byArray;
    }

    byte[] getManifestXMLBytes() {
        return this.getEntryBytes(this.manifestIndex);
    }

    byte[] getMetaXMLBytes() {
        return this.getEntryBytes(this.metaIndex);
    }

    byte[] getNamedBytes(String string) {
        int n = 0;
        while (n < this.entryList.size()) {
            Entry entry = (Entry)this.entryList.get(n);
            if (entry.zipEntry.getName().equals(string)) {
                return this.getEntryBytes(n);
            }
            ++n;
        }
        return null;
    }

    byte[] getSettingsXMLBytes() {
        return this.getEntryBytes(this.settingsIndex);
    }

    byte[] getStyleXMLBytes() {
        return this.getEntryBytes(this.styleIndex);
    }

    void read(InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        int n = -1;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            Debug.log(4, "reading entry: " + string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            byte[] byArray = new byte[1024];
            while ((n2 = zipInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Entry entry = new Entry(zipEntry, byArray2);
            this.entryList.add(entry);
            ++n;
            if (string.equalsIgnoreCase(CONTENTXML)) {
                this.contentIndex = n;
                continue;
            }
            if (string.equalsIgnoreCase(STYLEXML)) {
                this.styleIndex = n;
                continue;
            }
            if (string.equalsIgnoreCase(METAXML)) {
                this.metaIndex = n;
                continue;
            }
            if (string.equalsIgnoreCase(SETTINGSXML)) {
                this.settingsIndex = n;
                continue;
            }
            if (!string.equalsIgnoreCase(MANIFESTXML)) continue;
            this.manifestIndex = n;
        }
        zipInputStream.close();
    }

    void setContentXMLBytes(byte[] byArray) {
        this.contentIndex = this.setEntryBytes(this.contentIndex, byArray, CONTENTXML);
    }

    private int setEntryBytes(int n, byte[] byArray, String string) {
        if (n > -1) {
            ZipEntry zipEntry;
            Entry entry = (Entry)this.entryList.get(n);
            string = entry.zipEntry.getName();
            int n2 = entry.zipEntry.getMethod();
            entry.zipEntry = zipEntry = this.createZipEntry(string, byArray, n2);
            entry.bytes = byArray;
        } else {
            ZipEntry zipEntry = this.createZipEntry(string, byArray, 8);
            Entry entry = new Entry(zipEntry, byArray);
            this.entryList.add(entry);
            n = this.entryList.size() - 1;
        }
        return n;
    }

    void setManifestXMLBytes(byte[] byArray) {
        this.manifestIndex = this.setEntryBytes(this.manifestIndex, byArray, MANIFESTXML);
    }

    void setMetaXMLBytes(byte[] byArray) {
        this.metaIndex = this.setEntryBytes(this.metaIndex, byArray, METAXML);
    }

    void setNamedBytes(String string, byte[] byArray) {
        int n = 0;
        while (n < this.entryList.size()) {
            Entry entry = (Entry)this.entryList.get(n);
            if (entry.zipEntry.getName().equals(string)) {
                this.setEntryBytes(n, byArray, string);
                return;
            }
            ++n;
        }
        this.setEntryBytes(-1, byArray, string);
    }

    void setSettingsXMLBytes(byte[] byArray) {
        this.settingsIndex = this.setEntryBytes(this.settingsIndex, byArray, SETTINGSXML);
    }

    void setStyleXMLBytes(byte[] byArray) {
        this.styleIndex = this.setEntryBytes(this.styleIndex, byArray, STYLEXML);
    }

    void write(OutputStream outputStream) throws IOException {
        Debug.log(4, "Writing out the following entries into zip.");
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ListIterator listIterator = this.entryList.listIterator();
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            ZipEntry zipEntry = entry.zipEntry;
            String string = zipEntry.getName();
            Debug.log(4, "... " + string);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(entry.bytes);
        }
        zipOutputStream.close();
    }

    private class Entry {
        ZipEntry zipEntry = null;
        byte[] bytes = null;

        Entry(ZipEntry zipEntry, byte[] byArray) {
            this.zipEntry = zipEntry;
            this.bytes = byArray;
        }
    }
}

