/*************************************************************************
 *
 *  $RCSfile: IndexBuilder.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.indexer;

import java.net.URL;
import java.io.*;
import java.util.Hashtable;
import com.sun.xmlsearch.db.*;
import com.sun.xmlsearch.util.*;

class IndexBuilder {
  private static int InitSize = 4096;
  
  private int _free = 0;
  private int _size = InitSize;
  private ConceptLocation[] _locations = new ConceptLocation[_size];
  private int _currentDocID = 0;
  
  private PrefixTranslator _prefixTransl = new PrefixTranslator();
  private Hashtable _stoplist = new Hashtable();

  private Index _index;

  public IndexBuilder(String indexDir) {
    _index = new Index(indexDir, true);
  }
  
  public boolean init() throws Exception {
    if (_index.init()) {
      readStoplist(new File("resources", "NRStop"));
      return true;
    }
    else
      return false;
  }

  private void readStoplist(File file) {
    try {
      LineInput in = new LineInput(new FileInputStream(file));
      String line;
      while ((line = in.readLine()) != null)
	_stoplist.put(line.trim(), this); // value doesn't matter
    }
    catch (IOException e) {
      e.printStackTrace();
    }
  }
  
  public void addPrefixTranslation(String prefix, String replacement) {
    _prefixTransl.addPrefixTranslation(prefix, replacement);
  }
    
  public void close() throws Exception {
    _index.close();
    System.out.println("done");
  }

  private int intern(String name) throws Exception {
    return _index.intern(name);
  }
  
  public void openDocument(String name) throws Exception {
    if (_currentDocID != 0)
      throw new Exception("document already open");
    //    _currentDocID = intern(_prefixTransl.translatePrefix(name));
    _currentDocID = intern(name);
  }
  
  public void storeLocation(String text, int position) throws Exception {
    if (_free == _size) {
      ConceptLocation[] newArray = new ConceptLocation[_size *= 2];
      System.arraycopy(_locations, 0, newArray, 0, _free);
      _locations = newArray;
    }
    _locations[_free++] = new ConceptLocation(intern(text),
					      position,
					      position + text.length());
  }

  public void closeDocument(String title) throws Exception {
    if (_currentDocID == 0)
      throw new Exception("no document open");
    if (_free > 0)
      _index.compress(_currentDocID,
		      intern(title),
		      _locations,
		      _free,
		      null, // extents
		      0);
    _free = 0;
    _currentDocID = 0;		// state: nothing open
  }
}
