/*************************************************************************
 *
 *  $RCSfile: cg_file.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <ary/cpp/cg_file.hxx>


// NOT FULLY DECLARED SERVICES
#include <ary/docu.hxx>
#include <ary/cpp/cpp_disp.hxx>
#include <slots.hxx>
#include "rcids.hxx"



namespace ary
{
namespace cpp
{

FileGroup::FileGroup( Gid                 i_nId,
                      Lid                 i_nFile,
                      const udmstri &     i_sFileName,
                      Rid                 i_nProjectGroup )
    :   sFileName(i_sFileName),
        nId(i_nId),
        nFile(i_nFile),
        nProjectGroup(i_nProjectGroup),
        // aMyClasses,
        // aMyEnums,
        // aMyTypedefs,
        // aMyOperations,
        // aMyVariables,
        // aMyConstants,
        pDocu(0)
{
}

FileGroup::~FileGroup()
{
}

void
FileGroup::Add_Class( Cid i_nId )
{
    aMyClasses.insert(i_nId);
}

void
FileGroup::Add_Enum( Cid i_nId )
{
    aMyEnums.insert(i_nId);
}

void
FileGroup::Add_Typedef( Cid i_nId )
{
    aMyTypedefs.insert(i_nId);
}

void
FileGroup::Add_Operation( Cid i_nId )
{
    aMyOperations.insert(i_nId);
}

void
FileGroup::Add_Variable( Cid i_nId )
{
    aMyVariables.insert(i_nId);
}

void
FileGroup::Add_Constant( Cid i_nId )
{
    aMyConstants.insert(i_nId);
}

Gid
FileGroup::inq_Id_Group() const
{
    return nId;
}

const RepositoryEntity &
FileGroup::inq_RE_Group() const
{
    return *this;
}

const group::SlotList &
FileGroup::inq_Slots() const
{
    static const SlotAccessId aFileSlotData[]
            = { SLOT_Classes, SLOT_Enums, SLOT_Typedefs, SLOT_Operations,
                SLOT_Variables, SLOT_Constants };
    static const std::vector< SlotAccessId >
            aSlots( &aFileSlotData[0],
                      &aFileSlotData[0]
                        + sizeof aFileSlotData / sizeof (SlotAccessId) );
    return aSlots;
}

DYN Slot *
FileGroup::inq_Create_Slot( SlotAccessId i_nSlot ) const
{
    switch ( i_nSlot )
    {
        case SLOT_Classes:          return new Slot_RidSet(aMyClasses);
        case SLOT_Enums:            return new Slot_RidSet(aMyEnums);
        case SLOT_Typedefs:         return new Slot_RidSet(aMyTypedefs);
        case SLOT_Operations:       return new Slot_RidSet(aMyOperations);
        case SLOT_Variables:        return new Slot_RidSet(aMyVariables);
        case SLOT_Constants:        return new Slot_RidSet(aMyConstants);
        default:
                                    return new Slot_Null;
    }   // end switch
}

void
FileGroup::do_StoreAt( ary::Display & o_rOut ) const
{
    ary::cpp::Display * pD = dynamic_cast< ary::cpp::Display* >(&o_rOut);
    if (pD != 0)
    {
     	pD->Display_FileGroup(*this);
    }
}

Rid
FileGroup::inq_Id() const
{
    return nId;
}


RCid
FileGroup::inq_RC() const
{
    return RCID_FILEGROUP;
}

const ary::Documentation &
FileGroup::inq_Info() const
{
    return pDocu ? *pDocu : ary::Documentation::Null_();
}

void
FileGroup::do_Add_Documentation( DYN ary::Documentation & let_drInfo )
{
    pDocu = &let_drInfo;
}


}   // namespace cpp
}   // namespace ary

