/*************************************************************************
 *
 *  $RCSfile: adrbeam.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADRBEAM_HXX
#define ADRBEAM_HXX

#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XUpdateBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORMUPDATE_HXX_
#include <smart/com/sun/star/form/XDatabaseFormUpdate.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATELISTENER_HXX_
#include <smart/com/sun/star/form/XUpdateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATASELECTIONTYPE_HXX_
#include <smart/com/sun/star/form/DataSelectionType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORLISTENER_HXX_
#include <smart/com/sun/star/form/XErrorListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XRESTORELISTENER_HXX_
#include <smart/com/sun/star/form/XRestoreListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEPARAMETEREVENT_HXX_
#include <smart/com/sun/star/form/DatabaseParameterEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XINSERTLISTENER_HXX_
#include <smart/com/sun/star/form/XInsertListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEDELETEEVENT_HXX_
#include <smart/com/sun/star/form/DatabaseDeleteEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XPOSITIONINGLISTENER_HXX_
#include <smart/com/sun/star/form/XPositioningListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HXX_
#include <smart/com/sun/star/form/XBoundComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERLISTENER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XLOADLISTENER_HXX_
#include <smart/com/sun/star/form/XLoadListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_NAVIGATIONBARMODE_HXX_
#include <smart/com/sun/star/form/NavigationBarMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORBROADCASTER_HXX_
#include <smart/com/sun/star/form/XErrorBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_ERROREVENT_HXX_
#include <smart/com/sun/star/form/ErrorEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_LISTSOURCETYPE_HXX_
#include <smart/com/sun/star/form/ListSourceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERBROADCASTER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_TABULATORCYCLE_HXX_
#include <smart/com/sun/star/form/TabulatorCycle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORM_HXX_
#include <smart/com/sun/star/form/XDatabaseForm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCONTROL_HXX_
#include <smart/com/sun/star/form/XBoundControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWDESCRIPTOR_HXX_
#include <smart/com/sun/star/awt/WindowDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_INVALIDATESTYLE_HXX_
#include <smart/com/sun/star/awt/InvalidateStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOOLKIT_HXX_
#include <smart/com/sun/star/awt/XToolkit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWCLASS_HXX_
#include <smart/com/sun/star/awt/WindowClass.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XSYSTEMDEPENDENTWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XSystemDependentWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWATTRIBUTE_HXX_
#include <smart/com/sun/star/awt/WindowAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XPOINTER_HXX_
#include <smart/com/sun/star/awt/XPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_SYSTEMPOINTER_HXX_
#include <smart/com/sun/star/awt/SystemPointer.hxx>
#endif


#ifndef _SV_SPLITWIN_HXX
#include <vcl/splitwin.hxx>
#endif


#ifndef _ADR_TOOLBAR_HXX
#include "toolbar.hxx"
#endif

extern UString gGridModelCommand;

#ifndef _ADR_DATMAN_HXX
#include "datman.hxx"
#endif

class AdrGridwin:	public DockingWindow,
					public XStatusListener,
					public UsrObject
{
private:		
		XWindowRef				xGridWinRef;
		XDatabaseFormRef		xForm;
		XControlModelRef		xGridModel;
		XControlRef				xControl;
		XControlContainerRef	aCtrContainer;

protected:

		void					Resize();  

public:

		AdrGridwin(Window* pParent, WinBits nStyle = 0 );

		void createGridWin(const XControlModelRef&	xDbForm);
		void changeGridModel(const XControlModelRef& xGModel);
		void disposeGridWin();

		// XInterface
		virtual void	acquire()							{ UsrObject::acquire(); }
		virtual void	release()							{ UsrObject::release(); }
		virtual BOOL 	queryInterface( UsrUik aUIK, XInterfaceRef& );
		virtual void*	getImplementation(Reflection *p) 	{ return NULL; }

		// XEventListener
		// we do not hold References to dispatches, so there is nothing to do on disposal
		virtual void 	disposing(const EventObject& Source)
												THROWS( (UsrSystemException) ) {};

		// XStatusListener
		virtual void	statusChanged(const FeatureStateEvent& Event)
												THROWS( (UsrSystemException) );

};


class AdrBeamer: public SplitWindow
{
	private:

		AdrDataManagerHdl		ppDatMan;
		XControllerRef			xController;
		XDatabaseFormRef		xForm;
		
		XFrameRef				xToolBarRef;
		XFrameRef				xGridRef;
		XFrameRef				xAlphaRef;

		XWindowRef				xToolBarWinRef;
		XWindowRef				xGridWinRef;
		XWindowRef				xAlphaWinRef;

		AdrToolBar*				pToolBar;
		AdrGridwin*				pGridWin;
		DockingWindow*			pAlphaWin;

	protected:

		void					createToolBar();  
		void					createGridWin();  
		void					createAlphaWin();

	public:
		
		AdrBeamer(Window* pParent,AdrDataManagerHdl ppDatMan, WinBits nStyle = 0 );
		~AdrBeamer();

		void	SetXController(const XControllerRef&);
};



#endif
