/*************************************************************************
 *
 *  $RCSfile: addrconv.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ADDRCONV_HXX_
#define _ADDRCONV_HXX_

#include <tools/solar.h>
#include <usr/ustring.hxx>
#include <svtools/svarray.hxx>


struct AddrBookNameMapping
{
	::rtl::OUString  _aLogicName;
	::rtl::OUString  _aDBName;
	::rtl::OUString  _aDBStdName;
	
	// database field properties
	sal_Int16		 _aFieldType;
	long			 _aFieldSize;

	BOOL			 _bDBConverted;
	
	AddrBookNameMapping( const char* pLogicStr, const char* pStdStr,
						 sal_Int16 fieldType, long fieldSize )
		: _aLogicName( ::rtl::OUString::createFromAscii( pLogicStr )), 
		  _aDBStdName( ::rtl::OUString::createFromAscii( pStdStr )),
		  _aFieldType( fieldType ), _aFieldSize( fieldSize ),
		  _bDBConverted( FALSE ) {}
};

SV_DECL_OBJARR( AddrBookNameMappingList, AddrBookNameMapping, 4, 4 )
	

class AddressBookConverter
{
	AddrBookNameMappingList	_aNameMappings;

	const ::rtl::OUString& GetStdDBFieldNameFromLangName( const ::rtl::OUString& ) const;
	void                   MarkDBFieldAsConverted( const ::rtl::OUString& );
	BOOL				   BuildNameMapping();
public:
	AddressBookConverter() {}
	BOOL Convert();
};


#endif // _ADDRCONV_HXX_
