/*************************************************************************
 *
 *  $RCSfile: helponstartup.cxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/15 15:14:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_JOBS_HELPONSTARTUP_HXX_
#include <jobs/helponstartup.hxx>
#endif

//_______________________________________________
// own includes

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_TARGETS_H_
#include <targets.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_______________________________________________
// interface includes

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
#include <com/sun/star/frame/XFramesSupplier.hpp>
#endif

//_______________________________________________
// other includes

#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_HELPOPT_HXX
#include <svtools/helpopt.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//_______________________________________________
// namespace

namespace framework{

#ifndef css
namespace css = ::com::sun::star;
#endif

//_______________________________________________
// definitions

/*-----------------------------------------------
    01.09.2003 09:36
-----------------------------------------------*/
DEFINE_XINTERFACE_3(HelpOnStartup                             ,
                     OWeakObject                               ,
                     DIRECT_INTERFACE(css::lang::XTypeProvider),
                     DIRECT_INTERFACE(css::lang::XServiceInfo ),
                     DIRECT_INTERFACE(css::task::XJob         ))

DEFINE_XTYPEPROVIDER_3(HelpOnStartup           ,
                       css::lang::XTypeProvider,
                       css::lang::XServiceInfo ,
                       css::task::XJob         )

DEFINE_XSERVICEINFO_MULTISERVICE(HelpOnStartup                   ,
                                 ::cppu::OWeakObject             ,
                                 SERVICENAME_JOB                 ,
                                 IMPLEMENTATIONNAME_HELPONSTARTUP)

DEFINE_INIT_SERVICE(HelpOnStartup,
                    {
                        /*  Attention
                            I think we don't need any mutex or lock here ... because we are called by our own static method impl_createInstance()
                            to create a new instance of this class by our own supported service factory.
                            see macro DEFINE_XSERVICEINFO_MULTISERVICE and "impl_initService()" for further informations!
                        */
                    }
                   )

/*-----------------------------------------------
    04.09.2003 07:38
-----------------------------------------------*/
HelpOnStartup::HelpOnStartup(const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR)
    : ThreadHelpBase(                                   )
    , m_xSMGR       (xSMGR                              )
    , m_eModule     (SvtModuleOptions::E_UNKNOWN_FACTORY)
{
    // In case this job was started - it must be installed (of course :-))
    // Then the feature "show help on startup" is available in general.
    // We must provide this information to others. Because the help window
    // show a check box to enable/disable this feature. But this check box
    // make no sense in case this job here isnt installed (!).

    // Note: There is no reason to reset this state inside this class again.
    // Because its defined as temp. value (which is not saved inside configuration).
    // So this feature will be enabled during runtime one times only and will be true
    // till the end of this office instance ...

    SvtHelpOptions aHelpOpt; // singleton!
    aHelpOpt.SetHelpOnStartupAvailable(sal_True);
}

/*-----------------------------------------------
    01.09.2003 09:12
-----------------------------------------------*/
HelpOnStartup::~HelpOnStartup()
{
}

/*-----------------------------------------------
    04.09.2003 07:50
-----------------------------------------------*/
css::uno::Any SAL_CALL HelpOnStartup::execute(const css::uno::Sequence< css::beans::NamedValue >& lArguments)
    throw(css::lang::IllegalArgumentException,
          css::uno::Exception                ,
          css::uno::RuntimeException         )
{
    try
    {
        impl_analyzeArgs(lArguments);

        // check current state of the help module
        // Do nothing here, if its already open and the content
        // is not set to the default page for an application module!
        // In such case the user has open his own content there ...
        // and dont whish to be disturbed :-)
        ::rtl::OUString sCurrentURL = impl_getCurrentHelpURL();

        // SAFE -> ----------------------------------
        ReadGuard aReadLock(m_aLock);
        if (sCurrentURL.getLength())
        {
            sal_Bool bIsDefaultURL = sal_False;
            for (THelpURLList::const_iterator pIt  = m_lHelpURLs.begin();
                                              pIt != m_lHelpURLs.end()  ;
                                            ++pIt                       )
            {
                ::rtl::OUString sCheckURL = pIt->second;
                bIsDefaultURL = sCheckURL.equals(sCurrentURL);
                if (bIsDefaultURL)
                    break;
            }
            if (!bIsDefaultURL)
                return css::uno::Any();
        }
        ::rtl::OUString sNewURL = m_lHelpURLs[m_eModule];
        if (!sNewURL.getLength())
            return css::uno::Any();
        aReadLock.unlock();
        // <- SAFE ----------------------------------

        // But if the help module isnt still open (sCurrentURL=""!)
        // or it points to any default page(!)
        // we must overwrite this current content with a new default one,
        // which is suitabe for the new detected application module.
        // Note: The help window brings itself to front ...
        Help* pHelp = Application::GetHelp();
        if (!pHelp)
            return css::uno::Any();
        pHelp->Start(sNewURL, 0);

        // SAFE -> ----------------------------------
        WriteGuard aWriteLock(m_aLock);
        // Dont hold this document alive. May be we are holded alive longer
        // as we wish to live :-)
        m_xDocument.clear();
        aWriteLock.unlock();
        // <- SAFE ----------------------------------
    }
    catch(const css::uno::RuntimeException&)
        { throw; }
    catch(const css::lang::IllegalArgumentException&)
        { throw; }
    catch(const css::uno::Exception&)
        {}

    return css::uno::Any();
}

/*-----------------------------------------------
    04.09.2003 07:42
-----------------------------------------------*/
::rtl::OUString HelpOnStartup::impl_getCurrentHelpURL()
{
    // SAFE -> ------------------------------
    ReadGuard aReadLock(m_aLock);
    css::uno::Reference< css::frame::XFrame > xRoot(m_xSMGR->createInstance(SERVICENAME_DESKTOP), css::uno::UNO_QUERY);
    aReadLock.unlock();
    // <- SAFE ------------------------------

    css::uno::Reference< css::frame::XFramesSupplier > xHelpTask (xRoot->findFrame(SPECIALTARGET_HELPTASK, css::frame::FrameSearchFlag::CHILDREN), css::uno::UNO_QUERY);
    if (!xHelpTask.is())
        return ::rtl::OUString();

    css::uno::Reference< css::frame::XFrame >           xHelpChild;
    css::uno::Reference< css::container::XIndexAccess > xChilds   (xHelpTask->getFrames(), css::uno::UNO_QUERY);
    try
    {
        xChilds->getByIndex(0) >>= xHelpChild;
    }
    catch(const css::lang::IndexOutOfBoundsException&)
    { xHelpChild.clear(); }

    if (!xHelpChild.is())
        return ::rtl::OUString();

    ::rtl::OUString sURL;

    css::uno::Reference< css::frame::XController > xHelpView = xHelpChild->getController();
    if (!xHelpView.is())
        return ::rtl::OUString();

    css::uno::Reference< css::frame::XModel > xHelpContent = xHelpView->getModel();
    if (!xHelpContent.is())
        return ::rtl::OUString();

    return xHelpContent->getURL();
}

/*-----------------------------------------------
    02.09.2003 11:12
-----------------------------------------------*/
::rtl::OUString HelpOnStartup::implst_createHelpURL(const ::rtl::OUString& sBaseURL,
                                                    const ::rtl::OUString& sLocale ,
                                                    const ::rtl::OUString& sSystem )
{
    ::rtl::OUStringBuffer sHelpURL(256);
    sHelpURL.append     (sBaseURL    );
    sHelpURL.appendAscii("?Language=");
    sHelpURL.append     (sLocale     );
    sHelpURL.appendAscii("&System="  );
    sHelpURL.append     (sSystem     );

    return sHelpURL.makeStringAndClear();
}

/*-----------------------------------------------
    04.09.2003 07:45
-----------------------------------------------*/
void HelpOnStartup::impl_analyzeArgs(const css::uno::Sequence< css::beans::NamedValue >& lArguments)
    throw(css::uno::Exception) /* TODO create own exception for internal use! */
{
    css::uno::Sequence< css::beans::NamedValue > lEnvironment;
    css::uno::Sequence< css::beans::NamedValue > lJobConfig;

    const css::beans::NamedValue* p = lArguments.getConstArray();
    sal_Int32                     c = lArguments.getLength();
    sal_Int32                     a = 0;

    for (a=0; a<c; ++a)
    {
        if (p[a].Name.equalsAscii("Environment"))
            p[a].Value >>= lEnvironment;
        else
        if (p[a].Name.equalsAscii("JobConfig"))
            p[a].Value >>= lJobConfig;
    }

    p = lEnvironment.getConstArray();
    c = lEnvironment.getLength();
    for (a=0; a<c; ++a)
    {
        // check for right environment.
        // If its not a DocumentEvent, which triggered this job,
        // we cant work correctly! => return immediatly and do nothing
        if (p[a].Name.equalsAscii("EnvType"))
        {
            ::rtl::OUString sEnvType;
            p[a].Value >>= sEnvType;
            if (!sEnvType.equalsAscii("DOCUMENTEVENT"))
                throw css::uno::Exception(::rtl::OUString::createFromAscii("not the right environment"), static_cast< css::task::XJob* >(this));
        }
        else
        if (p[a].Name.equalsAscii("Model"))
        {
            // SAFE -> --------------------------
            WriteGuard aWriteLock(m_aLock);

            p[a].Value >>= m_xDocument;
            if (!m_xDocument.is())
                throw css::lang::IllegalArgumentException(::rtl::OUString::createFromAscii("invalid model reference"), static_cast< css::task::XJob* >(this), (sal_Int16)a);

            // to prevent us against recursive calling (because the help content itself is loaded
            // as normal writer/wb document!) we must be shure, that this document does not point
            // to a sub view (means all view frames must be top frames).
            css::uno::Reference< css::frame::XController > xController = m_xDocument->getCurrentController();
            if (!xController.is())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("document without current controller? - might a focus problem!"), static_cast< css::task::XJob* >(this));
            css::uno::Reference< css::frame::XFrame > xFrame = xController->getFrame();
            if (!xFrame.is())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("document with controller but no frame!?"), static_cast< css::task::XJob* >(this));
            if (!xFrame->isTop())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("cant work on sub frames"), static_cast< css::task::XJob* >(this));

            m_eModule = SvtModuleOptions::ClassifyFactoryByModel(m_xDocument);
            if (m_eModule == SvtModuleOptions::E_UNKNOWN_FACTORY)
                throw css::uno::Exception(::rtl::OUString::createFromAscii("unsupported application module"), static_cast< css::task::XJob* >(this));

            if (!SvtModuleOptions().IsHelpOnStartupEnabled(m_eModule))
                throw css::uno::Exception(::rtl::OUString::createFromAscii("help on startup disabled"), static_cast< css::task::XJob* >(this));

            aWriteLock.unlock();
            // <- SAFE --------------------------
        }
    }

    // SAFE -> ----------------------------------
    ReadGuard aReadLock(m_aLock);
    // no model -> no well known application module -> no fun!
    if (!m_xDocument.is())
        throw css::uno::Exception(::rtl::OUString::createFromAscii("unsupported application module"), static_cast< css::task::XJob* >(this));
    aReadLock.unlock();
    // <- SAFE ----------------------------------

    // completes help urls with the system parameters "Language" and "System"
    // detect installed locale
    // fallback is english!
    css::uno::Any   aLocale = ::utl::ConfigManager::GetConfigManager()->GetDirectConfigProperty(::utl::ConfigManager::LOCALE);
    ::rtl::OUString sLocale;
    if (!(aLocale >>= sLocale))
        sLocale = ::rtl::OUString::createFromAscii("en-US");

    // detect system
    ::rtl::OUString sSystem = SvtHelpOptions().GetSystem();

    // SAFE -> ----------------------------------
    WriteGuard aWriteLock(m_aLock);

    p = lJobConfig.getConstArray();
    c = lJobConfig.getLength();
    for (a=0; a<c; ++a)
    {
        ::rtl::OUString sBaseURL;

        if (p[a].Name.equalsAscii("BaseHelpURL_Writer"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_Writer"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_WRITER] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_WriterWeb"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_WriterWeb"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_WRITERWEB] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_WriterGlobal"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_WriterGlobal"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_WRITERGLOBAL] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_Calc"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_Calc"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_CALC] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_Impress"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_Impress"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_IMPRESS] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_Draw"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_Draw"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_DRAW] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
        else
        if (p[a].Name.equalsAscii("BaseHelpURL_Math"))
        {
            p[a].Value >>= sBaseURL;
            if (!sBaseURL.getLength())
                throw css::uno::Exception(::rtl::OUString::createFromAscii("invalid config data for BaseHelpURL_Math"), static_cast< css::task::XJob* >(this));
            m_lHelpURLs[SvtModuleOptions::E_MATH] = HelpOnStartup::implst_createHelpURL(sBaseURL, sLocale, sSystem);
        }
    }

    aWriteLock.unlock();
    // <- SAFE ----------------------------------
}

} // namespace framework
