/*************************************************************************
 *
 *  $RCSfile: loadenv.cxx,v $
 *
 *  $Revision: 1.45.74.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/03/25 12:06:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SBX_SBXOBJECT_HXX //autogen
#include <svtools/sbxbase.hxx>
#endif
#ifndef _SFXECODE_HXX
#include <svtools/sfxecode.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

#ifndef __FRAMEWORK_DISPATCH_INTERACTION_HXX_
#include <framework/interaction.hxx>
#endif
#ifndef _COM_SUN_STAR_TASK_ERRORCODEREQUEST_HPP_
#include <com/sun/star/task/ErrorCodeRequest.hpp>
#endif

#include <svtools/ehdl.hxx>
#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/ucb/XContent.hpp>
#include <rtl/ustring.hxx>
#include <so3/transbnd.hxx>             // SvKeyValueIterator
#include <svtools/securityoptions.hxx>

#include <unotools/localfilehelper.hxx>
#include <unotools/ucbstreamhelper.hxx>
#include <unotools/tempfile.hxx>

#pragma hdrstop

#include "doctempl.hxx"
#include "loadenv.hxx"
#include "docfile.hxx"
#include "objitem.hxx"
#include "request.hxx"
#include "objshimp.hxx"
#include "docfilt.hxx"
#include "openflag.hxx"
#include "docinf.hxx"
#include "fcontnr.hxx"
#include "fltfnc.hxx"
#include "dispatch.hxx"
#include "frmdescr.hxx"
#include "fsetvwsh.hxx"
#include "dataurl.hxx"
#include "appdata.hxx"
#include "topfrm.hxx"
#include "docfac.hxx"
#include "sfxresid.hxx"
#include "app.hrc"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::rtl;

//========================================================================

// diese Funktionen sind in appopen.cxx definiert

extern void SetTemplate_Impl( SvStorage*, const String&, const String&, SfxObjectShell* );

// class SfxLoadEnvironment ----------------------------------------------

SfxLoadEnvironment::SfxLoadEnvironment( LoadEnvironment_Impl* pImpl )
	: _pImpl( pImpl )
{
	pImpl->AddRef();
}

SfxLoadEnvironment::~SfxLoadEnvironment()
{
	_pImpl->ReleaseRef();
}

ErrCode SfxLoadEnvironment::DocumentDetected( SfxObjectShell* pObjSh, ErrCode nErr )
{
    return nErr;
}

void SfxLoadEnvironment::SetDataAvailableLink( const Link& rLink )
{
	_pImpl->SetDataAvailableLink(  rLink );
}

class SfxLoadCancellable : public SfxCancellable
{
	SfxFrameWeak    wFrame;
public:
					SfxLoadCancellable( SfxFrame* pFrameP, SfxMedium* pMedium )
						: wFrame( pFrameP ),
		  				SfxCancellable( pMedium->GetCancelManager_Impl(), pMedium->GetURLObject().GetURLNoPass() )
					{}
	virtual void	Cancel();
};

void SfxLoadCancellable::Cancel()
{
	SfxCancellable::Cancel();
	// Damit wir beim loeschen des Frames nicht an den
	// AppCancelManager wandern
	SetManager( 0 );
	if( wFrame.Is() )
		wFrame->CancelTransfers();
}

LoadEnvironment_Impl::~LoadEnvironment_Impl()
{
	aDecoupleLink.ClearPendingCall();

	if ( aDoneLink.IsSet() )
	{
		SfxPoolItem* pRet;
		if( !IsPlugin() && pFrame )
			pRet = new SfxViewFrameItem( 0, &xDoc ? pFrame->GetCurrentViewFrame() : 0);
		else
			pRet = new SfxObjectShellItem( 0, xDoc );

		aDoneLink.Call( pRet );
		delete pRet;
	}

	if( pMedium )
	{
		Link aLink;
		if( pMedium->GetDataAvailableLink() ==
			LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
			pMedium->SetDataAvailableLink( aLink );
		if( pMedium->GetDoneLink() ==
			LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
			pMedium->SetDoneLink( aLink );
		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pIsChildLoad,
						 SfxBoolItem, SID_ISCHILDFRAMELOAD, sal_False );
		if ( pFrame && pIsChildLoad && pIsChildLoad->GetValue() )
			pFrame->LoadFinished_Impl();

		if ( pFrame &&
			 ( !pFrame->GetCurrentDocument() ||
			 pFrame->GetCurrentDocument() == &xDoc && pFrame->GetCurrentDocument()->GetMedium() != pMedium ) )
//		if ( pFrame && pFrame->GetCurrentDocument() && pFrame->GetCurrentDocument()->GetMedium() != pMedium &&
//			 pFrame->GetCurrentDocument() == &xDoc )
			DELETEZ( pMedium );
	}

	if( pFrame && pFrame->GetLoadEnvironment_Impl() == this )
		pFrame->SetLoadEnvironment_Impl( 0 );
	if( pFrame && (
		!xDoc.Is() || xDoc->Get_Impl()->nLoadedFlags == SFX_LOADED_ALL ) )
		pFrame->SetLoadCancelable_Impl( 0 );
	if( bOwnsFrame && pFrame )
		pFrame->DoClose();
    delete pContext;
}

LoadEnvironment_Impl* LoadEnvironment_Impl::Create( const SfxItemSet& rConstSet, BOOL bAllowRO )
{
    // File-Flags
    SfxAllItemSet *pArgs = new SfxAllItemSet( rConstSet );

    // File Name ermitteln
    String aDocFileName;
    String aErrCtxName;

    // Template "offnen?
    BOOL bTemplate = FALSE;
    SFX_ITEMSET_ARG(pArgs, pTemplRegItem, SfxStringItem, SID_TEMPLATE_REGIONNAME, FALSE);
    SFX_ITEMSET_ARG(pArgs, pTemplNamItem, SfxStringItem, SID_TEMPLATE_NAME, FALSE);
    if( pTemplRegItem || pTemplNamItem )
    {
        // Template-Region
        String aTemplateRegion;
        if ( pTemplRegItem )
            aTemplateRegion = pTemplRegItem->GetValue();

        // Template-Name
        String aTemplateName;
        if ( pTemplNamItem )
            aTemplateName = pTemplNamItem->GetValue();

        // File Name aus Region/TemplateName holen
        SfxDocumentTemplates aTemplates;
        if ( !aTemplates.GetFull( aTemplateRegion, aTemplateName, aDocFileName) )
        {
            aErrCtxName = aTemplateRegion;
            aErrCtxName += String::CreateFromAscii(" / ");
            aErrCtxName += aTemplateName;
        }
        else
		{
            INetURLObject aTestObj( aDocFileName );
            if( aTestObj.GetProtocol() == INET_PROT_NOT_VALID )
            {
                // temp. fix until Templates are managed by UCB compatible service
                // does NOT work with locally cached components !
                String aTemp;
                utl::LocalFileHelper::ConvertPhysicalNameToURL( aDocFileName, aTemp );
                aDocFileName = aTemp;
            }

            aErrCtxName = aDocFileName;
            bTemplate = TRUE;
		}
    }
    else
    {
        // File-Name
        SFX_ITEMSET_ARG(pArgs, pFileNameItem, SfxStringItem, SID_FILE_NAME, FALSE);
        DBG_ASSERT( pFileNameItem, "FileName-Arg missing" );

		String aFileURL = pFileNameItem->GetValue();
		aErrCtxName = aDocFileName = aFileURL;
    }

	// optional original-URL( z.B. bei Salvage )
    String aMark;
    SFX_ITEMSET_ARG(pArgs, pUrlItem, SfxStringItem, SID_ORIGURL, FALSE );
	if ( pUrlItem )
	{
		// Mark von original-URL an aDocFileName anh"angen
        INetURLObject aURL( aDocFileName );
        DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "Illegal URL!" );
		aDocFileName = aURL.GetMainURL(INetURLObject::DECODE_TO_IURI);
        aMark = INetURLObject( pUrlItem->GetValue() ).GetMark( INetURLObject::DECODE_WITH_CHARSET );
	}

    SFX_ITEMSET_ARG(pArgs, pMarkItem, SfxStringItem, SID_JUMPMARK, FALSE );
    if ( pMarkItem )
        aMark = pMarkItem->GetValue();

	SfxViewFrame* pCurViewFrame = SfxViewFrame::Current();

    SFX_ITEMSET_ARG(pArgs, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
	SfxObjectShell *pCur = 0;
	if( pFrmItem )
        pCur = pFrmItem->GetFrame() ? pFrmItem->GetFrame()->GetCurrentDocument() : 0;
	if( !pCur )
		pCur = SfxObjectShell::Current();

    // Es kommen hier entweder Marks ohne URL oder absolute URLS rein.
    // SmartRelToAbs erlaubt ausserdem z.B. ueber Basic existente
    // Pfadnamen..

	// Marks ohne URLs duerfen sich nur auf das Target beziehen.
	INetURLObject aObj;
    if( aDocFileName.Len() && aDocFileName.GetChar(0) == '#' && pCur ) // Mark ohne URL
    {
        DBG_ERROR("JumpMark without URL!");
        aMark = aDocFileName.Copy(1);
		if( pCur->HasName())
		{
            aObj.SetURL( pCur->GetMedium()->GetName() );
			aObj.SetMark( aMark );
		}
		else
		{
			String aURL = String::CreateFromAscii( "private:local#" );
			aURL += aMark;
			aObj.SetURL( aURL );
		}

		aErrCtxName  = aObj.GetURLNoMark();
        aErrCtxName += aDocFileName;
    }
    else
        aObj.SetURL( aDocFileName );

    // optional filter name
    String aFilterName;
    SFX_ITEMSET_ARG(pArgs, pFilterItem, SfxStringItem, SID_FILTER_NAME, FALSE );
    if ( pFilterItem )
        aFilterName = pFilterItem->GetValue();

    // Hidden-Item
    BOOL bHidden = FALSE;
    SFX_ITEMSET_ARG(pArgs, pHidItem, SfxBoolItem, SID_HIDDEN, FALSE);
    if ( pHidItem )
        bHidden = pHidItem->GetValue();

    // optional read-only-flag
    BOOL bReadOnly = FALSE;
    SFX_ITEMSET_ARG(pArgs, pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, FALSE );
    if ( pReadOnlyItem && pReadOnlyItem->GetValue() )
        bReadOnly = TRUE;

	if( pFrmItem && pFrmItem->FrameKilled() )
	{
		DBG_ERROR( "FrameHack schlaegt zu!" );
        delete pArgs;
        return 0;;
	}

    const SfxFilter* pFilter = 0;
	if ( aFilterName.Len() )
        pFilter = SFX_APP()->GetFilterMatcher().GetFilter(aFilterName);

    SfxMedium* pFile = new SfxMedium(
        aDocFileName, bReadOnly ? SFX_STREAM_READONLY : SFX_STREAM_READWRITE, FALSE, pFilter, pArgs );
    pFile->UseInteractionHandler( TRUE );
	if ( pUrlItem )
	{
		pFile->SetName( pUrlItem->GetValue(), TRUE );
		pFile->SetTemporary( TRUE );
	}

	// Soll evtl. keine View erzeugt werden ?
	BOOL bCreateView = TRUE;
    SFX_ITEMSET_ARG(pArgs, pCreateViewItem, SfxBoolItem, SID_VIEW, FALSE );
	if ( pCreateViewItem && !pCreateViewItem->GetValue() )
		bCreateView = FALSE;

	USHORT nToDo = LEI_DETECTFILTER |  LEI_LOAD;
	if ( bCreateView )
		nToDo |= LEI_CREATEVIEW;

    BOOL bUseCache = TRUE;
    SFX_ITEMSET_ARG(pArgs, pForceReloadItem, SfxBoolItem, SID_NOCACHE, FALSE );
	if ( pForceReloadItem && pForceReloadItem->GetValue() )
	{
        bUseCache = sal_False;
        pFile->SetUsesCache( FALSE );
	}

    SFX_ITEMSET_ARG(pArgs, pFrameItem, SfxFrameItem, SID_DOCFRAME, FALSE );
    LoadEnvironment_Impl* pLoader = new LoadEnvironment_Impl( pFile, pFrameItem ? pFrameItem->GetFrame() : NULL, nToDo, bAllowRO, bUseCache );

    // ErrorContext aufziehen
    pLoader->SetErrorContext( new SfxErrorContext( ERRCTX_SFX_OPENDOC, aErrCtxName ) );

    if ( bTemplate )
        pLoader->pMedium->GetItemSet()->Put( SfxBoolItem( SID_TEMPLATE, TRUE ) );
    pLoader->SetMark( aMark );
    return pLoader;
}


LoadEnvironment_Impl::LoadEnvironment_Impl( SfxMedium* pMed, SfxFrame* pFrameP, sal_uInt32 eTodoP, sal_Bool bAllowReadOnlyP, sal_Bool bAllowCache )
	: pMedium( pMed )
    , pFrame( pFrameP )
    , pContext( NULL )
    , bOpenTemplate( sal_False )
    , bNewView( sal_False )
    , bSalvage( sal_False )
    , bReadOnly( sal_False )
    , bAllowReadOnly( bAllowReadOnlyP )
    , bUseCache( bAllowCache )
	, nTodo( eTodoP )
	, bHidden( sal_False )
	, nError( 0 )
	, bDocCreated( sal_False )
	, nStartEvent( 0 )
    , bLocal( sal_False )
	, bIsApi( sal_False )
	, bTemplate( sal_False )
	, bPlugIn( sal_False )
	, pNewFrame( 0 )
	, bUsableForLocal( sal_False )
    , bOwnsFrame( sal_False )
	, pAntiImpl( 0 )
	, aDecoupleLink( LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
	, pMatcher( &SFX_APP()->GetFilterMatcher() )
	, bWaitingForFilterDetection( sal_False )
	, bProcessing( sal_False )
{
    SFX_ITEMSET_ARG(pMed->GetItemSet(), pNewViewItem, SfxBoolItem, SID_OPEN_NEW_VIEW, FALSE );
    if ( pNewViewItem )
        bNewView = pNewViewItem->GetValue();

	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSalvageItem, SfxStringItem, SID_DOC_SALVAGE, sal_False );
    if ( pSalvageItem )
        bSalvage = sal_True;

	SFX_ITEMSET_ARG(pMed->GetItemSet(), pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, sal_False);
	if ( pReadOnlyItem )
		bReadOnly = pReadOnlyItem->GetValue();

	SFX_ITEMSET_ARG(pMed->GetItemSet(), pHidItem, SfxBoolItem, SID_HIDDEN, sal_False);
	if ( pHidItem )
		bHidden = pHidItem->GetValue();

	SFX_ITEMSET_ARG( pMed->GetItemSet(), pOwnsItem, SfxBoolItem, SID_OWNS_FRAME, sal_False );
	if ( pOwnsItem )
	{
    	bOwnsFrame = pOwnsItem->GetValue();
    	pMed->GetItemSet()->ClearItem( SID_OWNS_FRAME );
	}

	if( pFrame )
		StartListening( pFrame->GetBroadcaster() );

	pMed->SetTransferPriority( SFX_TFPRIO_DOC );
}

void LoadEnvironment_Impl::CancelTransfers()
{
	// Im CancelTransfers am Medium wird die Ref xThis weggenommen
	SvRefBaseRef xRef( this );
	if( xDoc.Is()  )
	{
		// Falls im DetectFilter gecancelled wurde, gibt es noch kein Medium
		if( !xDoc->GetMedium() )
			xDoc.Clear();
		else
			xDoc->CancelTransfers();
	}
	else if( pMedium )
	{
		pMedium->CancelTransfers();
	}

	if( nError != ERRCODE_IO_BROKENPACKAGE )
		nError = ERRCODE_ABORT;

	// aktiv abbrechen, da vielleicht keine Daten mehr kommen
	if( xOldEnv.Is() )
		xOldEnv->CancelTransfers();
    if ( bProcessing )
    {
        aDecoupleLink.ClearPendingCall();
        aDecoupleLink.Call( this, sal_False, sal_True );
    }
    else
        LoadDataAvailable();
}

sal_Bool UsableForOpen_Impl( SfxObjectShell* pShell, SfxMedium* pMedium  )
{
	if( !pShell )
		return sal_False;

	SfxItemSet* pSet = pMedium->GetItemSet();

	SFX_ITEMSET_ARG( pSet, pTemplateItem, SfxBoolItem, SID_TEMPLATE, sal_False );
	if( pTemplateItem && pTemplateItem->GetValue() )
		return sal_False;

	SfxMedium* pOld = pShell->GetMedium();

	// Dies ist der Filename, falls nur ein Mark im Opendoc mitkam
	String aLocal( DEFINE_CONST_UNICODE("private:local#") );

	// Falls URLs nicht uebereinstimmen und der zu oeffnende Name nicht #xxx
	// ist, nicht verwenden
	if( INetURLObject( pOld->GetOrigURL()) !=
		INetURLObject( pMedium->GetOrigURL() ) && pMedium->GetOrigURL().CompareIgnoreCaseToAscii( aLocal, aLocal.Len() ) != COMPARE_EQUAL )
		return sal_False;

	const INetURLObject& rURL = pMedium->GetURLObject();

	// Falls die Filter nicht uebereinstimmen oder eine ViewId mitgegeben
	// wurde, nicht verwenden
	if( pMedium->GetFilter() &&	pOld->GetOrigFilter() != pMedium->GetFilter() )
		return sal_False;

	return sal_True;
}

sal_Bool UsableForOpen_Impl( SfxFrame* pFrame, SfxMedium* pMedium  )
{
	if( !pFrame )
		return sal_False;

	// View-Id
	SfxItemSet* pSet = pMedium->GetItemSet();
	SFX_ITEMSET_ARG( pSet, pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );
	if ( pViewIdItem && pFrame->GetCurrentViewFrame() &&
		pViewIdItem->GetValue() != pFrame->GetCurrentViewFrame()->GetCurViewId() )
		return sal_False;
	return UsableForOpen_Impl( pFrame->GetCurrentDocument(), pMedium );
}

sal_Bool UsableForLocalJump_Impl( SfxFrame* pFrame, SfxMedium* pMedium )
{
	if( !pFrame )
		return sal_False;
	return UsableForOpen_Impl( pFrame, pMedium );
}

void LoadEnvironment_Impl::Start()
{
	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pRefererItem, SfxStringItem, SID_REFERER, sal_False );
	if( pRefererItem )
		pMedium->SetReferer( pRefererItem->GetValue() );

	eState = CONNECTING;
	sal_uInt32 nErr = ERRCODE_NONE;

	// Eigene Ref halten
	xThis = this;

	// Wenn wirklich geladen werden soll, muss auf bereits geladene
	// Doks geprueft werden
	if( nTodo & LEI_LOAD )
	{
		// Security-Check
		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pRefererItem, SfxStringItem, SID_REFERER, sal_False );
		// the bIsApi is not used any more
		// DBG_ASSERT( pRefererItem || bIsApi, "SID_OPEN... without referer => macro- and slot-URLs will be denied" );

		if( aMark.Len() )
			bLocal = sal_True;

		bUsableForLocal = sal_False;

		// Dies ist der Filename, falls nur ein Mark im Opendoc mitkam
		String aLocal( DEFINE_CONST_UNICODE("private:local#") );

		// View-Id
		// Falls ViewId mitkommt, nicht das lokale doc nehmen
		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );

		SfxObjectShell *pCur;
		SfxFrame *pCurFrame;
		if ( !pFrame || !pFrame->GetCurrentDocument() ||
			pFrame->GetCurrentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() )
		{
			// Bei ContainingDocFrames ( Mail... ) ist der TargetFrame immer das
			// Frameset, auch wenn ein local jump im body ausgef"uhrt werden soll
			pCur = SfxObjectShell::Current();
			pCurFrame = pCur ? SfxViewFrame::Current()->GetFrame() : 0;

			// Wenn ein neuer Frame ge"offnet wurde, keinen Local Jump probieren
			if( !bOwnsFrame && bUseCache )
			{
				if (bLocal)
					bUsableForLocal = UsableForLocalJump_Impl( pCurFrame, pMedium );

				if( !bUsableForLocal )
				{
					// Kein lokaler Sprung im aktuellen Document, wir bleiben
					// beim "ubergebenen Frame
					if ( pFrame )
					{
						pCurFrame = pFrame;
						pCur = pFrame->GetCurrentDocument();
					}

					bUsableForLocal = UsableForLocalJump_Impl( pFrame, pMedium );
				}
				else
				{
					// Lokaler Sprung erw"unscht und m"oglich
					pFrame = SfxViewFrame::Current()->GetFrame();
				}
			}
		}
		else
		{
			pCurFrame = pFrame;
			pCur = pFrame->GetCurrentDocument();
			if( !bOwnsFrame && bUseCache )
				bUsableForLocal = UsableForLocalJump_Impl( pFrame, pMedium );
		}

		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSilentItem, SfxBoolItem, SID_SILENT, sal_False);
		sal_Bool bSilent;
		if( pSilentItem )
			bSilent = pSilentItem->GetValue();
		else
			bSilent = sal_False;

		// bSilent ist fuer Maltes Hilfe
		if( !bUsableForLocal  )
		{
			if( bUseCache )
			{
				//! Hier besser das Itemset reinreichen und drinnen
				//  UsableForLocalJump_Impl usw. fragen
                /*
                xDoc = SFX_APP()->DocAlreadyLoaded( pMedium->GetName(), bSilent, bSilent, !bSilent && !bNewView, 0 );
                if( ( bUsableForLocal = UsableForOpen_Impl( xDoc, pMedium ) ) == TRUE )
				{
					MemCache_Impl &rCache = SfxPickList_Impl::Get()->GetMemCache();
					if ( xDoc.Is() && rCache.IsObjectCached( xDoc ) )
					{
						DBG_ASSERT( !SfxViewFrame::GetFirst( &xDoc ), "visible object is cached => not allowed" );
						rCache.RemoveObject( &xDoc );
						SfxObjectShell_Impl* pDocImpl = xDoc->Get_Impl();
						pDocImpl->bPreparedForClose = sal_False;
						pDocImpl->bClosing = sal_False;
						SfxDocumentInfo &rInfo = xDoc->GetDocInfo();
						xDoc->SetAutoLoad(
							rInfo.GetReloadURL(),
							rInfo.GetReloadDelay() * 1000,
							rInfo.IsReloadEnabled() );
					}
				}
				else
                */
					xDoc.Clear();
			}
		}
		else
		{
            xDoc = pCur;
		}

		if( xDoc.Is() )
		{
			SfxMedium* pDocMed = xDoc->GetMedium();
			pMedium->SetFilter( pDocMed->GetFilter() );
			pDocMed->SetName( pMedium->GetName() );
//            pDocMed->GetItemSet()->ClearItem();
			pDocMed->GetItemSet()->Put( *pMedium->GetItemSet() );
/*
            if( pDocMed->GetContent().is() )
                UCB_Helper::ExecuteCommand( pDocMed->GetContent(), WID_UPDATE );
 */
		}
	}

	if( xDoc.Is() )
	{
		xDoc->Get_Impl()->bIsAbortingImport = sal_False;
		nTodo &= (~( LEI_DETECTFILTER | LEI_LOAD ) );
	}
    else
	{
		if( pFrame )
		{
			if( pFrame->GetLoadEnvironment_Impl() != this )
			{
				xOldEnv = pFrame->GetLoadEnvironment_Impl();
				// Der neue Frame gehoert jetzt dem neuen Ladevorgang
				if( xOldEnv.Is() )
				{
					bOwnsFrame = xOldEnv->bOwnsFrame;
					xOldEnv->bOwnsFrame = sal_False;
				}

				pFrame->SetLoadEnvironment_Impl( this );
			}
			pMedium->SetLoadTargetFrame( pFrame );
			pFrame->SetLoadCancelable_Impl(
				new SfxLoadCancellable(	pFrame, pMedium ) );
		}
	}

    if( nTodo & (LEI_LOAD | LEI_DETECTFILTER ) )
	{
		Link aLink = LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl );
		pMedium->SetDataAvailableLink( aLink );
		pMedium->SetDoneLink( aLink );
	}

	// Fuer diese Protokolle muss hier gecanceled werden, da
	// Connections knapp sind.
	INetProtocol eProt = pMedium->GetURLObject().GetProtocol();
	if( pFrame && ( eProt == INET_PROT_HTTP || eProt == INET_PROT_HTTPS ) && !bUsableForLocal )
	{
		pFrame->CancelTransfers( sal_False );
		if( xOldEnv.Is() )
		{
			xOldEnv->CancelTransfers();
			xOldEnv.Clear();
		}
	}

    LoadDataAvailable();
}

void LoadEnvironment_Impl::ConvertToTemplate()
{
	// Template-Name
    String aName( pMedium->GetName() );
	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTemplNamItem, SfxStringItem, SID_TEMPLATE_NAME, sal_False);
	String aTemplateName;
	if ( pTemplNamItem )
		aTemplateName = pTemplNamItem->GetValue();
	else
    {
		// Interaktiv ( DClick, Contextmenu ) kommt kein Langname mit
		aTemplateName = xDoc->GetDocInfo().GetTitle();
        if ( !aTemplateName.Len() )
        {
            INetURLObject aURL( aName );
            aURL.CutExtension();
            aTemplateName = aURL.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
        }
    }

	pMedium->SetName( String(), sal_True );
	pMedium->Init_Impl();

	if ( !bSalvage )
	{
		if( GetMedium()->GetFilter()->IsOwnFormat() )
		{
			SvStorageRef xTmpStor;
			String aTmpName;
	
			SfxMedium* pDocMedium = xDoc->GetMedium();
			if ( pDocMedium )
			{
				SvStream* pStream = pDocMedium->GetInStream();
				
				if ( pStream )
				{
					aTmpName = ::utl::TempFile().GetURL();
	
					SvStream* pTmpStream = ::utl::UcbStreamHelper::CreateStream( aTmpName,
																					SFX_STREAM_READWRITE,
																					NULL,
																					sal_False );
					pStream->Seek( 0 );
					*pStream >> *pTmpStream;
					delete pTmpStream;
	
					xTmpStor = new SvStorage( aTmpName, SFX_STREAM_READWRITE );
				}
			}
	
			if ( !xTmpStor )
			{
				// this case seems to be impossible but in case it happens use the old approach
	        	xTmpStor = new SvStorage( (xDoc->GetStorage()->GetVersion() >= SOFFICE_FILEFORMAT_60), String() );
				xDoc->GetStorage()->CopyTo( &xTmpStor );
			}
	
			xDoc->DoHandsOff();
			pMedium->SetStorage_Impl( xTmpStor );
			xDoc->ForgetMedium();
			if( !xDoc->DoSaveCompleted( pMedium ) )
				nError = xTmpStor->GetErrorCode();
	        else
				SetTemplate_Impl( xTmpStor, aName, aTemplateName, xDoc );

			if ( aTmpName.Len() )
				xDoc->SetTempNameToRemove_Impl( aTmpName );
		}
		else
		{
			SetTemplate_Impl( xDoc->GetStorage(), aName, aTemplateName, xDoc);
		}
	}

	pMedium->GetItemSet()->ClearItem( SID_DOC_READONLY );
	pMedium->SetOpenMode( SFX_STREAM_READWRITE, sal_True, sal_True );
	xDoc->Broadcast( SfxSimpleHint(SFX_HINT_MODECHANGED) );
	xDoc->Broadcast( SfxDocumentInfoHint( &xDoc->GetDocInfo() ) );
	xDoc->SetNoName();
	xDoc->InvalidateName();
	xDoc->SetModified( sal_False );
}


void LoadEnvironment_Impl::DetectFilter()
{
	SfxApplication* pApp = SFX_APP();
	const SfxFilter* pFilter=0;
	ErrCode nErr = pMatcher->DetectFilter( *pMedium, &pFilter, bPlugIn, bIsApi );
	nError = nErr;
	if ( nErr == ERRCODE_NONE || nErr == ERRCODE_IO_PENDING )
	{
		pMedium->SetFilter( pFilter );
		if( !pMedium->GetOrigFilter( sal_True ) )
			pMedium->SetOrigFilter_Impl( pFilter );
	}

	return;
}

void LoadEnvironment_Impl::Load( const SfxObjectFactory *pFactory )
{
	const SfxFilter*pFilter = pMedium->GetFilter();
	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTemplateItem, SfxBoolItem, SID_TEMPLATE, sal_False);
    bTemplate = pTemplateItem && pTemplateItem->GetValue();
				// MI: z.B. private:calendar/
//				( !pMedium->GetFilter() ||
//				  pMedium->GetFilter()->IsAllowedAsTemplate() );

	SFX_ITEMSET_ARG(pMedium->GetItemSet(), pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, sal_False);
    if( ( bReadOnly || !pReadOnlyItem ) &&  // readonly prinzipiell erlaubt
        ( pFilter && ( pFilter->GetFilterFlags() & SFX_FILTER_OPENREADONLY ) )  // readonly n"otig / sinnvoll
        && !bTemplate )                 // nichts als Vorlage "offnen
	{
		bReadOnly = sal_True;
		if( pMedium->GetOpenMode() == SFX_STREAM_READWRITE )
			pMedium->SetOpenMode( SFX_STREAM_READONLY, sal_False, sal_True );
	}

	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pObjectShellItem, SfxObjectShellItem, SID_OBJECTSHELL, sal_False);
	if( !( pObjectShellItem && ( xDoc = pObjectShellItem->GetObjectShell() ).Is() )
		&& pFactory )
		xDoc = pFactory->CreateObject();
	pMedium->GetItemSet()->ClearItem( SID_OBJECTSHELL );

	if ( !nError && xDoc.Is() )
	{
		if ( pFrame  )
		{
			xDoc->SetActualSize( pFrame->GetWindow().GetOutputSizePixel() );
			xDoc->SetInFrame( pFrame->GetParentFrame() != NULL );
		}

		// beim ersten Activate ein Open-Event verschicken
		//! pPsh nur wg. Absturz im Writer
		bDocCreated = sal_True;
		if ( !bOpenTemplate )
            xDoc->SetActivateEvent_Impl( bTemplate ?  SFX_EVENT_CREATEDOC : SFX_EVENT_OPENDOC );

		sal_Bool bQueryLoadTemplate = sal_False;
		if( !bIsApi && !bHidden )
			bQueryLoadTemplate = sal_True;
		// Passwort?

		if( !(pMedium->GetFilter()->GetFilterFlags() & SFX_FILTER_CREATOR ))
		{
            if( pFilter->GetFilterFlags() & SFX_FILTER_ASYNC )
			{
				pAntiImpl = new SfxLoadEnvironment( this );
                pMedium->SetLoadEnvironment( pAntiImpl );
			}

            // Gegen Rescheduling im DoLoad sch"utzen
            SfxObjectShellRef xSave( xDoc );
            SfxTopFrame* pTop = PTR_CAST( SfxTopFrame, pFrame );
            if ( pTop )
            {
                Window* pWindow = pTop->GetTopWindow_Impl();
                if ( pWindow )
                {
                    String aTitle = xDoc->UpdateTitle( pMedium );
                    aTitle += String::CreateFromAscii( " - " );
                    aTitle += Application::GetDisplayName();
                    pTop->GetTopWindow_Impl()->SetText( aTitle );
                    if( pWindow->GetType() == WINDOW_WORKWINDOW )
                    {
                        SvtModuleOptions::EFactory eFactory;
                        if( SvtModuleOptions::ClassifyFactoryByName( xDoc->GetFactory().GetDocumentServiceName(), eFactory ) )
                        {
                            WorkWindow* pWorkWindow = (WorkWindow*)pWindow;
                            pWorkWindow->SetIcon( (sal_uInt16) SvtModuleOptions().GetFactoryIcon( eFactory ) );
                        }
                    }
                }
            }

			if ( !xDoc->DoLoad(pMedium))
				nError=ERRCODE_IO_GENERAL;
			if( xDoc->GetErrorCode() )
				nError = xDoc->GetErrorCode();
			if( xDoc->IsAbortingImport() )
			{
				nError = ERRCODE_ABORT;
// pFrame darf nicht auf 0 gesetzt werden, da sonst im Destruktor das
// Environment nicht ausgetragen wird
//					pFrame = 0;
			}

            if ( !nError && bSalvage )
            {
                SFX_ITEMSET_ARG(pMedium->GetItemSet(), pFilterItem, SfxStringItem, SID_FILTER_NAME, sal_False );
                SfxFilterMatcher& rMatcher = SFX_APP()->GetFilterMatcher();
                const SfxFilter* pFilter = rMatcher.GetFilter( pFilterItem->GetValue() );
                pMedium->SetFilter( pFilter );
            }

            if( ERRCODE_TOERROR( nError ) )
				return;
		}
		else
		{
			// Es soll nur ein leeres Doc erzeugt werden
			xDoc->DoInitNew(0);
			SfxMedium *pNewMedium = xDoc->GetMedium();
			pNewMedium->SetOpenMode( pMedium->GetOpenMode(), sal_False );
			pNewMedium->SetName( pMedium->GetName() );
			SfxItemSet* pNewSet = new SfxAllItemSet(
				*pMedium->GetItemSet() );
			pNewMedium->SetItemSet( pNewSet );
			xDoc->SetTitle( pMedium->GetName() );
			xDoc->InvalidateName();
			xDoc->SetModified( sal_False );
			pNewMedium->SetFilter( pMedium->GetFilter() );
			pNewMedium->Init_Impl();
			pNewMedium->SetCancelManager_Impl( pMedium->GetCancelManager_Impl());
			pNewMedium->SetLoadTargetFrame( pMedium->GetLoadTargetFrame() );
			delete pMedium;
			pMedium = pNewMedium;
		}
	}
}

void LoadEnvironment_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	SfxSimpleHint* pHint = PTR_CAST( SfxSimpleHint, &rHint );
	if( pHint && pHint->GetId() == SFX_HINT_DYING )
		pFrame = 0;
}

SfxFrame* GetTargetFrame_Impl( const SfxItemSet* pSet, BOOL& rbOwner  )
{
	SFX_ITEMSET_ARG(pSet, pViewItem, SfxBoolItem, SID_VIEW, FALSE);

	if ( pViewItem && !pViewItem->GetValue() )
		// ohne View laden
		return NULL;

	SFX_ITEMSET_ARG(pSet, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
	SFX_ITEMSET_ARG(pSet, pTargetItem, SfxStringItem, SID_TARGETNAME, FALSE);
	SFX_ITEMSET_ARG(pSet, pBoolItem, SfxBoolItem, SID_ONLYSUBFRAMES, FALSE);
	SFX_ITEMSET_ARG(pSet, pRefererItem, SfxStringItem, SID_REFERER, FALSE);
    SFX_ITEMSET_ARG(pSet, pPreviewItem, SfxBoolItem, SID_PREVIEW, FALSE);

	// Frame als Parameter mitgegeben?
	SfxFrame *pFrame = NULL;
	if ( pFrmItem )
		pFrame = pFrmItem->GetFrame();
	SfxFrame *pSource = pFrame;
	SfxFrame *pStart = pFrame;

    if ( pPreviewItem && pPreviewItem->GetValue() )
    {
        DBG_ASSERT( pFrame, "Preview without frame!" );
        return pFrame;
    }

	String aTargetName;
    if ( pTargetItem && pTargetItem->GetValue().Len() )
	{
		// Wenn ein TargetItem mitgegeben wurde, aber kein Frame, den
		// Current ViewFrame nehmen
		SfxViewFrame* pCurViewFrame = SfxViewFrame::Current();
		if ( !pCurViewFrame )
			pCurViewFrame = SfxViewFrame::GetFirst();

		if ( !pFrame && pCurViewFrame )
		{
			pFrame = pCurViewFrame->GetFrame();
			pStart = pFrame;
		}

		if ( pFrame )
		{
			aTargetName = pTargetItem->GetValue();

			// Wenn kein TargetName, dann den vom Current Document
			SfxObjectShell* pCur = SfxObjectShell::Current();
			if( !aTargetName.Len() && pCur )
				aTargetName = pCur->GetDocInfo().GetDefaultTarget();
		}
	}
    else if ( pFrame && (pFrame->GetFrameName().CompareToAscii("mail-body") == COMPARE_EQUAL) )
    {
        // Hack for MailDocument in Office 5.2
        aTargetName = String::CreateFromAscii("_blank");
    }

	BOOL bNewTask =
            aTargetName.CompareToAscii("_blank")	== COMPARE_EQUAL ||
            aTargetName.CompareToAscii("_default")    == COMPARE_EQUAL ||
            aTargetName.CompareToAscii("_null")		== COMPARE_EQUAL;

	if ( pFrame )
	{
		if ( pBoolItem && pBoolItem->GetValue() )
		{
			DBG_ASSERT( aTargetName.Len(), "OnlySubFrames, aber kein Name!" );
			pFrame = pFrame->SearchChildrenForName_Impl( aTargetName );
		}
		else
		{
			if ( !bNewTask || pFrame->GetFrameName().Len() || pFrame->GetCurrentDocument() || pFrame->GetParentFrame() )
				// Auch bei leerem TargetName suchen wg. SmartSelf
				// _blank nur suchen, wenn pFrame nicht schon _blank ist!
				pFrame = pFrame->SearchFrame( aTargetName );
		}
	}

	BOOL bName = ( pFrame == NULL );
    if ( pFrame )
	{
		// Es wurde ein Frame gefunden; dessen Doc darf nicht ersetzt werden,
		// wenn es der Desktop ist oder wenn es embedded ist
		// Ausnahme: neuerdings k"onnen wir auch innerhalb des Desktops browsen, wenn dieser ein Frameset ist
		SfxObjectShell* pCur = pFrame->GetCurrentDocument();
        if( pCur && pCur->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
		{
			pFrame = 0;
			pSource = 0;
			pStart = 0;
		}
	}

	// Kein Frame gefunden -> Neuen Frame nehmen
	if ( !pFrame )
	{
        SFX_ITEMSET_ARG( pSet, pHiddenItem, SfxBoolItem, SID_HIDDEN, FALSE);
        BOOL bHidden =  pHiddenItem && pHiddenItem->GetValue();
        pFrame = SfxTopFrame::Create( NULL, 0, bHidden );
        rbOwner = TRUE;
		if ( !bNewTask && bName )
			pFrame->SetFrameName( aTargetName );
	}
	else
		rbOwner = FALSE;

	return pFrame;
}


void LoadEnvironment_Impl::CreateView()
{
	DBG_ASSERT( xDoc.Is(), "CreateView ohne Doc gferufen" );
	if ( nTodo & LEI_LOAD )
	{
		if( bTemplate && !(pMedium->GetFilter()->GetFilterFlags() & SFX_FILTER_CREATOR ) )
			ConvertToTemplate();
		else
            pMedium->SetUpdatePickList( !bIsApi && !bHidden);

		if( bOpenTemplate )
			xDoc->SetTemplate(sal_True);

		if( xDoc.Is() && nError )
			xDoc->ResetError();

		// ggf. Template pr"ufen ( nur bei Dokumenten im FileSystem )
        if ( xDoc.Is() && !bHidden && !bIsApi && ::utl::LocalFileHelper::IsLocalFile( pMedium->GetName() ) )
			xDoc->UpdateFromTemplate_Impl();
	}

	if ( xDoc.Is() && pFrame )
	{
		SfxMedium &rMedium = *xDoc->GetMedium();
		SvKeyValueIteratorRef xIter( xDoc->GetHeaderAttributes() );
		SvKeyValue aValue;
		for( sal_Bool bCont = xIter->GetFirst( aValue ); bCont; bCont = xIter->GetNext( aValue ) )
		{
			if ( aValue.GetKey().CompareIgnoreCaseToAscii( "Window-Target" ) == COMPARE_EQUAL )
			{
				SfxItemSet *pSet = rMedium.GetItemSet();
				pSet->Put( SfxStringItem( SID_TARGETNAME, aValue.GetValue() ) );
				pSet->Put( SfxFrameItem( SID_DOCFRAME, pFrame ) );
				pSet->ClearItem( SID_ONLYSUBFRAMES );

				sal_Bool bOwns;
                SfxFrame *pNewFrame = GetTargetFrame_Impl( pSet, bOwns );
				if ( pNewFrame != pFrame )
				{
					if( pFrame->GetLoadEnvironment_Impl() == this )
						pFrame->SetLoadEnvironment_Impl( 0 );
					pFrame->SetLoadCancelable_Impl( 0 );

					if ( bOwnsFrame )
					{
						aDoneLink.Call(NULL);
						aDoneLink = Link();
						pFrame->DoClose();
					}

					pFrame = pNewFrame;
					bOwnsFrame = bOwns;

					xOldEnv = pFrame->GetLoadEnvironment_Impl();

					// Der neue Frame gehoert jetzt dem neuen Ladevorgang
					if( xOldEnv.Is() )
					{
						bOwnsFrame = xOldEnv->bOwnsFrame;
						xOldEnv->bOwnsFrame = sal_False;
					}

					pFrame->SetLoadEnvironment_Impl( this );
					rMedium.SetLoadTargetFrame( pFrame );
					pFrame->SetLoadCancelable_Impl( new SfxLoadCancellable(	pFrame, &rMedium ) );

					if( xOldEnv.Is() )
					{
						xOldEnv->CancelTransfers();
						xOldEnv.Clear();
					}
				}

				break;
			}
		}
	}

	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pUserDataItem, SfxStringItem, SID_USER_DATA, sal_False);

	// Falls Lokal, History updaten.
	sal_Bool bIsLocal = sal_False;
	SfxViewFrame* pF = 0;
	if( pFrame && pFrame->GetCurrentDocument() == &xDoc )
	{
		bIsLocal = sal_True;
		String aNewName( pMedium->GetOrigURL() );
		pFrame->UpdatePickEntries();
		pFrame->UpdateHistory(	xDoc, &aNewName );
		if( xDoc->HasName() )
		{
			xDoc->SetName( pMedium->GetName() );
			xDoc->GetMedium()->SetName( pMedium->GetName(), sal_True );
		}
	}

	SfxObjectShell* pCurDoc = pFrame ? pFrame->GetCurrentDocument() : 0;

	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTargetItem, SfxStringItem, SID_TARGETNAME, sal_False);
	if ( pFrame )
	{
		if( pFrame->GetCurrentDocument() != &xDoc )
		{
			// Ist es ein MDIFrame?
			if( bOwnsFrame || pFrame->GetCurrentViewFrame() )
				pFrame->SetItemSet_Impl( pMedium->GetItemSet() );
			if( !pFrame->InsertDocument( xDoc ) )
			{
				nError = ERRCODE_ABORT;
				return;
			}
		}
		else
		{
            if ( pFrame->GetController().is() )
			{
                SFX_ITEMSET_ARG( pMedium->GetItemSet(), pAny, SfxUnoAnyItem, SID_VIEW_DATA, sal_False );
				if ( pAny )
					pFrame->GetController()->restoreViewData( pAny->GetValue() );
			}
		}

		pF = pFrame->GetCurrentViewFrame();
	}
	else
	{
		// sonst View aus Doc laden bzw. neu erzeugen
        pF = SFX_APP()->CreateView_Impl( pMedium->GetItemSet(), xDoc, sal_True, bHidden );
		pFrame = pF->GetFrame();
	}

	// Ab in die Pickliste
	xDoc->Get_Impl()->bWaitingForPicklist = sal_True;

	// ggf. in der View zum Bookmark springen; aber nur wenn keine UserDaten mitkommen, denn die wurden
	// schon beim Erzeugen der View ber"ucksichtigt ( nat"urlich nur wenn eine erzeugt wurde ! )
	if ( bIsLocal && pUserDataItem )
	{
		pFrame->GetCurrentViewFrame()->GetViewShell()->ReadUserData( pUserDataItem->GetValue(), sal_True );
	}
	else if( pF && aMark.Len() && !pUserDataItem )
	{
		MarkData_Impl* pMark = new MarkData_Impl;
		pMark->aMark = aMark;
		xDoc->Get_Impl()->pMarkData = pMark;
		pMark->pFrame = pF;
		if( !xDoc->IsLoading() )
			xDoc->PositionView_Impl();
	}

	String aURL = xDoc->GetMedium()->GetName();

	SFX_APP()->Broadcast( SfxStringHint(
		SID_OPENURL, aURL ) );
	if( pF )
	{
		if( !bDocCreated && !bLocal  )
		{
			if( xDoc->GetMedium()->IsExpired() )
			{
				SfxAllItemSet aSet( SFX_APP()->GetPool() );
				((SfxItemSet*)&aSet)->Put(
					SfxBoolItem( SID_FORCERELOAD, sal_False ) );
				SfxRequest aReq( SID_RELOAD, SFX_CALLMODE_ASYNCHRON, aSet );
				pF->ExecReload_Impl( aReq, sal_True );
			}
		}
	}

	if ( bSalvage )
		xDoc->SetModified(sal_True);
}


sal_Bool LoadEnvironment_Impl::PrepareClose()
{
	if ( pFrame )
	{
		sal_uInt16 nRet = pFrame->PrepareClose_Impl( !bIsApi, sal_True );
		if ( nRet == RET_NEWTASK )
		{
			if( pFrame && pFrame->GetLoadEnvironment_Impl() == this )
				pFrame->SetLoadEnvironment_Impl( &xOldEnv );
			xOldEnv.Clear();
			if ( bOwnsFrame )
			{
				aDoneLink.Call(NULL);
				aDoneLink = Link();
				pFrame->DoClose();
			}
			pFrame = 0;
			nRet = sal_True;
		}
		else if ( nRet )
			pFrame->UpdatePickEntries();
		return (sal_Bool) nRet;
	}
	else
		return sal_True;
}


IMPL_LINK( LoadEnvironment_Impl,LoadDataAvailable_Impl, void* , pVoid )
{
    if ( bProcessing )
	{
		// keine erneuten Aufrufe von aussen, solange ein anderer Aufruf
		// noch nicht komplett abgearbeitet wurde
		aDecoupleLink.ClearPendingCall();
		aDecoupleLink.Call( pVoid, sal_False, sal_True );
	}
    else
    {
        bProcessing = TRUE;
        LoadDataAvailable();
    }

	return 0;
}

void LoadEnvironment_Impl::LoadDataAvailable()
{
    // protect against reentrance ( through multithreading or rescheduling )
	bProcessing = sal_True;

	LoadEnvironment_ImplRef xSave( this );
    if ( Application::IsUICaptured() )
	{
		// Beim synchronen Laden k"onnten aktive UI-Elemente zerst"ort werden
		if ( pMedium->IsDownloadDone_Impl() )
			aDecoupleLink.Call( 0, sal_True, sal_True );
        bProcessing = FALSE;
        return;
	}

    if( pMedium && !nError )
	{
		// Auf aufgetretene Fehler testen
		ErrCode nMedErr = pMedium->GetErrorCode();
		if( nMedErr == ERRCODE_IO_PENDING )
		{
			// Pending gilt nicht als Error
			nMedErr = ERRCODE_NONE;
			pMedium->ResetError();
		}

		if( nMedErr )
			// Error vom Medium auf das LoadEnvironment "ubertragen
			nError = nMedErr;
	}

    if ( nError )
        Error();

	switch( eState )
	{
		case CONNECTING:
		{
			aDecoupleLink.ClearPendingCall();
			eState = DETECTING;
            pMedium->SetLoadEnvironment_Impl( this );
            const SfxFilter* pFilter = pMedium->GetFilter();
            if ( !pFilter )
            {
                DetectFilter();
                pFilter = pMedium->GetFilter();
            }
            else
                pMedium->StartDownload();

            if( pFilter )
            {
                if ( pMedium->IsDownloadDone_Impl() /* || ( pFilter->GetFilterFlags() & SFX_FILTER_ASYNC ) */ )
                    // otherwise wait for Done or DataAvailable Callback
                    LoadDataAvailable();
            }
            else if ( nError == ERRCODE_NONE )
            {
                DBG_ERROR( "LoadEnvironment started without medium or filter!" );
                nError =  ERRCODE_SFX_NOFILTER;
            }

			break;
		}
		case DETECTING :
		{
			sal_Bool bHadToLoad = sal_False;
			if( !xDoc.Is() )
			{
				if( ( nTodo & LEI_LOAD ) && !nError )
				{
					bHadToLoad = sal_True;

                    // Finden der richtigen DocShell fuer den Filter
                    const SfxObjectFactory* pFactory = &(( SfxFactoryFilterContainer *) pMedium->GetFilter()->GetFilterContainer())->GetFactory();
                    if ( !pFactory  )
                    {
                        nError =  ERRCODE_SFX_NOFILTER;
                        break;
                    }

                    if( pFrame )
                        pFrame->CancelTransfers( sal_False );

                    if( xOldEnv.Is() )
                    {
                        xOldEnv->CancelTransfers();
                        xOldEnv.Clear();
                    }

                    Load( pFactory );

					// Jetzt gibt es keinen Weg zur"uck
					xOldEnv.Clear();
					eState = DOWNLOADING;

					// JavaScript URL asynchron
					if( nError == ERRCODE_IO_PENDING || nError == ERRCODE_SFX_RESTART )
					{
						if( nError == ERRCODE_SFX_RESTART )
						{
							nError = 0;
							if ( !pMedium->GetFilter() )
								nTodo |= LEI_DETECTFILTER;
							Start();
						}
						else
							nError = 0;
						break;
					}
				}
			}
            else if( nError != ERRCODE_ABORT && !bUsableForLocal )
				nError = ERRCODE_ABORT;

			// Falls Filter synchron, gleich View erzeugen;
            if( !bHadToLoad || pMedium->GetFilter() )
				eState = CREATINGVIEW;
            LoadDataAvailable();
			break;
		}
		case DOWNLOADING:
		{
            if( pMedium && pMedium->IsOpen() )
				aDataAvailableLink.Call( 0 );
			break;
		}
		case CREATINGVIEW:
		{
			eState = DOWNLOADING;
            if( xDoc.Is() && !ERRCODE_TOERROR( nError ) )
            {
                if( nTodo & LEI_CREATEVIEW )
                {
                    CreateView();
                    if ( bHidden )
                    {
                        // prevent Document from being destroyed in dtor of LoadEnvironment
                        xDoc->OwnerLock( TRUE );
                        xDoc->Get_Impl()->bHiddenLockedByAPI = TRUE;
                    }
                }
                else
                {
                    // prevent Document from being destroyed in dtor of LoadEnvironment
                    xDoc->OwnerLock( TRUE );
                    xDoc->Get_Impl()->bHiddenLockedByAPI = TRUE;
                }
            }

			// Falls wg. UICaptured das Lesen vor"ubergehend eingestellt wurde
			if( pMedium && pMedium->IsOpen() )
				aDataAvailableLink.Call( 0 );

            eState = DONE;
            LoadDataAvailable();
			break;
		}
		case DONE:
        {
			// Falls wg. UICaptured das Lesen vor"ubergehend eingestellt wurde
            if( !nError && pMedium && pMedium->IsOpen() )
				aDataAvailableLink.Call( 0 );

            if( !bDocCreated && ( nTodo & LEI_LOAD ) /* ||
                pMedium && pMedium->GetFilter() &&
                ( pMedium->GetFilter()->GetFilterFlags() &
                    SFX_FILTER_CREATOR ) && !bTemplate */ )  DELETEZ( pMedium );

            if ( aDoneLink.IsSet() )
            {
                SfxPoolItem* pRet;
                if( pFrame )
                    pRet = new SfxViewFrameItem( 0, &xDoc ? pFrame->GetCurrentViewFrame() : 0);
                else
                    pRet = new SfxObjectShellItem( 0, xDoc );

                aDoneLink.Call( pRet );
                delete pRet;
                aDoneLink = Link();
            }

            if ( !nError )
                bOwnsFrame = sal_False;

            if( pMedium )
                pMedium->SetLoadEnvironment( NULL );

			if ( !pMedium || pMedium->IsDownloadDone_Impl() )
            	// Von uns aus kann gel"oscht werden
            	xThis.Clear();

            break;
        }
	}

	bProcessing = sal_False;
}

void LoadEnvironment_Impl::Error()
{
    if( nError != ERRCODE_IO_ABORT && !bHidden )
    {
        sal_Bool bSilent = FALSE;
		if ( pMedium )
		{
			SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSilentItem, SfxBoolItem, SID_SILENT, sal_False);
			if( pSilentItem )
				bSilent = pSilentItem->GetValue();
		}

        // Keine Fehlermeldung beim hidden oder silent
        if( !bIsApi )
        {
            if ( !bSilent && nError != ERRCODE_IO_BROKENPACKAGE )
            {
                if (pMedium)
                {
                    BOOL bWarning = ((nError & ERRCODE_WARNING_MASK) == ERRCODE_WARNING_MASK);

                    ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionHandler > xHandler = pMedium->GetInteractionHandler();
                    if (!xHandler.is() && !bWarning)
                        nError = ERRCODE_IO_ABORT;
                    else
                    if (xHandler.is())
                    {
                        ::com::sun::star::uno::Any aInteraction;
                        ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation > > lContinuations(2);
                        ::framework::ContinuationAbort* pAbort = new ::framework::ContinuationAbort();
                        ::framework::ContinuationApprove* pApprove = new ::framework::ContinuationApprove();
                        lContinuations[0] = ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation >(static_cast< ::com::sun::star::task::XInteractionContinuation* >(pAbort), ::com::sun::star::uno::UNO_QUERY);
                        lContinuations[1] = ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation >(static_cast< ::com::sun::star::task::XInteractionContinuation* >(pApprove), ::com::sun::star::uno::UNO_QUERY);

                        ::com::sun::star::task::ErrorCodeRequest aErrorCode;
                        aErrorCode.ErrCode = nError;
                        aInteraction <<= aErrorCode;

                        ::framework::InteractionRequest* pRequest = new ::framework::InteractionRequest(aInteraction,lContinuations);
                        ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionRequest > xRequest(static_cast< ::com::sun::star::task::XInteractionRequest* >(pRequest), ::com::sun::star::uno::UNO_QUERY);

                        xHandler->handle(xRequest);

                        if (pAbort->isSelected() && !bWarning)
                            nError = ERRCODE_IO_ABORT;
                    }
                }
            }
        }
        else
            SbxBase::SetError( nError );
    }

    ErrCode nFatalError = ERRCODE_TOERROR( nError );
    if( nFatalError )
    {
        if( pFrame && pMedium )
        {
            SFX_ITEMSET_ARG( pMedium->GetItemSet(), pIsChildLoad, SfxBoolItem, SID_ISCHILDFRAMELOAD, sal_False );
            if ( pIsChildLoad && pIsChildLoad->GetValue() )
                pFrame->LoadFinished_Impl();
        }

        if( xDoc.Is() )
        {
            pMedium = 0;
			xDoc->DoClose();
            xDoc.Clear();
        }
        else
            DELETEZ( pMedium );
    }
    else if ( xDoc.Is() )
    {
        if( pMedium )
            pMedium->SetLoadEnvironment( NULL );

        xDoc->ResetError();
    }
    else if ( bIsApi )
    {
        // kein Doc => Warning wird zum Error
        SbxBase::ResetError();
        SbxBase::SetError( nError & ~ERRCODE_WARNING_MASK );
    }

    nError = nFatalError;
    if ( nError )
        eState = DONE;
}

