/*************************************************************************
 *
 *  $RCSfile: xit.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: cl $ $Date: 2001/03/07 13:08:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_XIT_HXX
#define _SVX_XIT_HXX

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _XDEF_HXX
#include "xdef.hxx"
#endif

/************************************************************************/

extern String aNameOrIndexEmptyString;

/************************************************************************/


class XColorTable;
class XDashTable;
class XLineEndTable;
class XHatchTable;
class XBitmapTable;
class XGradientTable;
class SfxItemPool;
class NameOrIndex;
class XPropertyList;

typedef BOOL (*SvxCompareValueFunc)( const NameOrIndex* p1, const NameOrIndex* p2 );

//-------------------
// class NameOrIndex
//-------------------
class NameOrIndex : public SfxStringItem
{
	long    nPalIndex;

protected:
	void    Detach()    { nPalIndex = -1; }

public:
			TYPEINFO();
			NameOrIndex() { nPalIndex = -1; }
			NameOrIndex(USHORT nWhich, long nIndex);
			NameOrIndex(USHORT nWhich,
						const String& rName= aNameOrIndexEmptyString);
			NameOrIndex(USHORT nWhich, SvStream& rIn);
			NameOrIndex(const NameOrIndex& rNameOrIndex);
		   ~NameOrIndex() {};

	virtual int          operator==(const SfxPoolItem& rItem) const;
	virtual SfxPoolItem* Clone(SfxItemPool* pPool = 0) const;
	virtual SfxPoolItem* Create(SvStream& rIn, USHORT nVer) const;
	virtual SvStream&    Store(SvStream& rOut, USHORT nItemVersion ) const;

			String       GetName() const              { return GetValue();   }
			void         SetName(const String& rName) { SetValue(rName);     }
			long         GetIndex() const             { return nPalIndex;    }
			void         SetIndex(long nIndex)        { nPalIndex = nIndex;  }
			BOOL         IsIndex() const          { return (nPalIndex >= 0); }

	/** this static checks if the given NameOrIndex item has a unique name for its value.
		The returned String is a unique name for an item with this value in both given pools.
		Argument pPool2 can be null.
		If returned string equals NameOrIndex->GetName(), the name was already unique.
	*/
	static String CheckNamedItem( const NameOrIndex* pCheckItem, const sal_uInt16 nWhich, const SfxItemPool* pPool1, const SfxItemPool* pPool2, SvxCompareValueFunc pCompareValueFunc, USHORT nPrefixResId, XPropertyList* pDefaults = NULL );
};

#endif
