/*************************************************************************
 *
 *  $RCSfile: rmcache.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ssa $ $Date: 2001/05/18 06:53:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VCL_RMCACHE_HXX_
#define _VCL_RMCACHE_HXX_

#include <list>

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _COM_SUN_STAR_PORTAL_CLIENT_XMULTIINSTANCEFACTORY_HPP_
#include <com/sun/star/portal/client/XMultiInstanceFactory.hpp>
#endif

#ifndef _SV_SVDATA_HXX
#include <svdata.hxx>
#endif

namespace vcl {
	
	template< class T > class InterfaceCache
	{
	private:
		::osl::Mutex m_aMutex;
		::std::list< ::com::sun::star::uno::Reference< T > >		m_aCachedInterfaces;
		::rtl::OUString m_aServiceName;
		::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >			m_xFactory;
		int m_nInterfaces, m_nIncrementInterfaces, m_nMaxInterfaces;
		
		inline void initCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq );
		inline void enlargeCache( int nInterfaces );
	public:
		InterfaceCache( const ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >& xFactory,
						const ::rtl::OUString& rServiceName,
						int nInitialInterfaces, int nIncrement, int nMaxInterfaces ) :
			m_aServiceName( rServiceName ),
			m_xFactory( xFactory ),
			m_nMaxInterfaces( nMaxInterfaces ),
			m_nIncrementInterfaces( nIncrement ),
			m_nInterfaces( 0 )
			{
				enlargeCache( nInitialInterfaces );
			}
		
		InterfaceCache( const ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >& xFactory,
						const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq,
						const ::rtl::OUString& rServiceName, int nIncrement, int nMaxInterfaces ) :
			m_aServiceName( rServiceName ),
			m_xFactory( xFactory ),
			m_nMaxInterfaces( nMaxInterfaces ),
			m_nIncrementInterfaces( nIncrement ),
			m_nInterfaces( 0 )
			{
				initCache( rInterfacesSeq );
			}

		~InterfaceCache() {}

		::com::sun::star::uno::Reference< T > takeInterface();
		inline void putInterface( const ::com::sun::star::uno::Reference< T >& xInterface );
	};

	template< class T >
	void InterfaceCache< T >::initCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq )
	{
		::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
		for( int i = 0; i < rInterfacesSeq.getLength(); i++ )
		{
			::com::sun::star::uno::Reference< T > xInterface;
			rInterfacesSeq.getConstArray()[i] >>= xInterface;
			m_aCachedInterfaces.push_front( xInterface );
			m_nInterfaces++;
		}
		if( m_nInterfaces == 0 )
			m_aCachedInterfaces.push_front( ::com::sun::star::uno::Reference< T >() );
	}

	template< class T >
	void InterfaceCache< T >::enlargeCache( int nInterfaces )
	{
		if( m_xFactory.is() )
		{
			::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any > aInterfaces;
            try
            {
			    aInterfaces = m_xFactory->createInstances( m_aServiceName, nInterfaces );
            
			    for( int i = 0; i < aInterfaces.getLength(); i++ )
			    {
				    ::com::sun::star::uno::Reference< T > xInterface;
				    aInterfaces.getConstArray()[i] >>= xInterface;
				    m_aCachedInterfaces.push_front( xInterface );
				    m_nInterfaces++;
			    }
            }
            catch ( ::com::sun::star::uno::RuntimeException &e )
            {
                rvpExceptionHandler();
            }
            
			if( m_nInterfaces == 0 )
				m_aCachedInterfaces.push_front( ::com::sun::star::uno::Reference< T >() );
		}
	}

	template< class T >
	::com::sun::star::uno::Reference< T > InterfaceCache< T >::takeInterface()
	{
		::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
		
		if( ! m_nInterfaces )
			enlargeCache( m_nIncrementInterfaces );
		::com::sun::star::uno::Reference< T > xRet = m_aCachedInterfaces.front();
	    m_aCachedInterfaces.pop_front();
		m_nInterfaces--;
		return xRet;
	}
	
	template< class T >
	inline void InterfaceCache< T >::putInterface( const ::com::sun::star::uno::Reference< T >& xInterface )
	{
		if( xInterface.is() )
		{
			::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
			if( m_nInterfaces < m_nMaxInterfaces )
			{
				m_aCachedInterfaces.push_front( xInterface );
				m_nInterfaces++;
			}
			else
			{
				while( m_nInterfaces > m_nMaxInterfaces )
				{
                    try
                    {
					    m_aCachedInterfaces.pop_front();
                    }
                    catch ( ::com::sun::star::uno::RuntimeException &e )
                    {
                        rvpExceptionHandler();
                    }
					m_nInterfaces--;
				}
			}
		}
	}


	template< class T, class C > class InterfacePairCache
	{
	private:
		::osl::Mutex m_aMutex;
		::std::list< ::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > > > m_aCachedInterfaces;
		::rtl::OUString m_aServiceName;
		::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >			m_xFactory;
		int m_nInterfaces, m_nIncrementInterfaces, m_nMaxInterfaces;
		
		inline void initCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq );
		inline void enlargeCache( int nInterfaces );
	public:
		InterfacePairCache( const ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >& xFactory,
						const ::rtl::OUString& rServiceName,
						int nInitialInterfaces, int nIncrement, int nMaxInterfaces ) :
			m_aServiceName( rServiceName ),
			m_xFactory( xFactory ),
			m_nMaxInterfaces( nMaxInterfaces ),
			m_nIncrementInterfaces( nIncrement ),
			m_nInterfaces( 0 )
			{
				enlargeCache( nInitialInterfaces );
			}
		
		InterfacePairCache( 
						const ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XMultiInstanceFactory >& xFactory,
						const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq,
						const ::rtl::OUString& rServiceName,
						int nIncrement, int nMaxInterfaces ) :
			m_aServiceName( rServiceName ),
			m_xFactory( xFactory ),
			m_nMaxInterfaces( nMaxInterfaces ),
			m_nIncrementInterfaces( nIncrement ),
			m_nInterfaces( 0 )
			{
				initCache( rInterfacesSeq );
			}

		~InterfacePairCache() {}

		::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > > takeInterface();
		inline void putInterface( const ::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >& );
	};

	template< class T, class C >
	void InterfacePairCache< T, C >::initCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rInterfacesSeq )
	{
		::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
		for( int i = 0; i < rInterfacesSeq.getLength(); i+=2 )
		{
			::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >	aPair;
			rInterfacesSeq.getConstArray()[i]   >>= aPair.first;
			rInterfacesSeq.getConstArray()[i+1] >>= aPair.second;
			m_aCachedInterfaces.push_front( aPair );
			m_nInterfaces++;
		}
		if( m_nInterfaces == 0 )
			m_aCachedInterfaces.push_front( ::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >() );
	}

	template< class T, class C >
	void InterfacePairCache< T, C >::enlargeCache( int nInterfaces )
	{
		if( m_xFactory.is() )
		{
			::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any > aInterfaces;
			aInterfaces = m_xFactory->createInstances( m_aServiceName, nInterfaces );
			for( int i = 0; i < aInterfaces.getLength(); i+=2 )
			{
				::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >	aPair;
				aInterfaces.getConstArray()[i]   >>= aPair.first;
				aInterfaces.getConstArray()[i+1] >>= aPair.second;
				m_aCachedInterfaces.push_front( aPair );
				m_nInterfaces++;
			}
			if( m_nInterfaces == 0 )
				m_aCachedInterfaces.push_front( ::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >() );
		}
	}

	template< class T, class C >
	::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > > InterfacePairCache< T, C >::takeInterface()
	{
		::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
		
		if( ! m_nInterfaces )
			enlargeCache( m_nIncrementInterfaces );
		::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > > aPair = m_aCachedInterfaces.front();
		m_aCachedInterfaces.pop_front();
		m_nInterfaces--;
		return aPair;
	}
	
	template< class T, class C >
	inline void InterfacePairCache< T, C >::putInterface( const ::std::pair< ::com::sun::star::uno::Reference< T >, ::com::sun::star::uno::Reference< C > >& rPair )
	{
		if( rPair.first.is() || rPair.second.is() )
		{
			::osl::Guard< ::osl::Mutex > aGuard( m_aMutex );
			if( m_nInterfaces < m_nMaxInterfaces )
			{
				m_aCachedInterfaces.push_front( rPair );
				m_nInterfaces++;
			}
			else
			{
				while( m_nInterfaces > m_nMaxInterfaces )
				{
                    try
                    {
					    m_aCachedInterfaces.pop_front();
                    }
                    catch ( ::com::sun::star::uno::RuntimeException &e )
                    {
                        rvpExceptionHandler();
                    }
					m_nInterfaces--;
				}
			}
		}
	}

	
} // namespace vcl
#endif
