/*************************************************************************
 *
 *  $RCSfile: ansi1252.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ANSI1252_HXX_
#include "ansi1252.hxx"
#endif

#include <stdio.h>


// image of the encoding gap 128 - 160 (hex 0x80 - 0x100)
//  0 		: dont use / dont care
// -1 		: charwidth is compound width of multiple simple chars
// 'char' 	: take width of this char as a guess for width of the real char 
//
const short Ansi1252FontEncoder::mnRemapTable[ REMAP_TABLE_SIZE ] = 
{
	'C' /* 0x80 /euro */			, 0									,
	',' /* 0x82 /quotesinglbase */	, 'F' /* 0x83 /florin */			,
	'"' /* 0x84 /quotedblbase */	, -1  /* 0x85 /ellipsis */			,
	'2' /* 0x86 /dagger */			, '2' /* 0x87 /daggerdbl */		,
	-1  /* 0x88 /circumflex */		, -1  /* 0x89 /perthousand */		,
	'S' /* 0x8a /Scaron */			, '"' /* 0x8b /guilsinglleft */	,
	-1  /* 0x8c /OE */				, 0									,
	'z' /* 0x8e /zcaron */			, 0									,
	0								, ',' /* 0x91 /quoteleft */		,
	',' /* 0x92 /quoteright */		, '"' /* 0x93 /quotedblleft */		,
	'"' /* 0x94 /quotedblright */	, '*' /* 0x95 /bullet */			,
	'9' /* 0x96 /endash */			, '+' /* 0x97 /emdash */			,
	-1  /* 0x98 /tilde */			, -1  /* 0x99 /trademark */		,
 	's' /* 0x9a /scaron */			, '"' /* 0x9b /guilsinglright */	,
	-1  /* 0x9c /oe */ 			    , 0									,
	'z' /* 0x9e /zcaron */			, 'Y' /* 0x9f /Ydieresis */
};

// Constructor, stores interesting data from 
// SalGraphics::GetCharWidth()
Ansi1252FontEncoder::Ansi1252FontEncoder ( rtl_TextEncoding eCharset, 
	long *pCharWidth, unsigned int nCharFrom, unsigned int nCharTo )
{
	// only reencode iso-8859-1 aka latin1 fonts
	mbReencodableFont = (Bool)(eCharset == RTL_TEXTENCODING_MS_1252);

	mnFixedWidth = 0;
    mbFixedWidthChecked = False;

	// width of chars between 0 and 128 are required for guessing
	// width of chars not found in latin1 fonts, same data as in 
	// SalGraphics::GetCharWidth()

	mpCharWidth  = pCharWidth;
	mnCharFrom   = nCharFrom;  
	mnCharTo     = nCharTo;  
}

// test whether the font is a fixed font
// - return the fixed width ( or zero )
long Ansi1252FontEncoder::nFixedWidth()
{
	if ( !mbFixedWidthChecked )
	{
		int nSmallWidth = nSimpleCharWidth( (unsigned int)'.' );
		int nBigWidth = nSimpleCharWidth( (unsigned int)'W' );

		if (   nSmallWidth == nBigWidth 
			&& nSmallWidth >  0 )
			mnFixedWidth = nBigWidth;
		else
			mnFixedWidth = 0;
		
		mbFixedWidthChecked = True;
	}

	return mnFixedWidth;
}

// wrapper around mnRemapTable
//
short Ansi1252FontEncoder::nMapChar ( unsigned int nChar )
{
	// we're only interested in chars between 128 and 160
	if (   (nChar <  REMAP_TABLE_OFFSET ) 
		|| (nChar > (REMAP_TABLE_OFFSET + REMAP_TABLE_SIZE - 1)) )
		return 0;

	return mnRemapTable[ nChar - REMAP_TABLE_OFFSET ] ;
}

// font-independant question whether we want microsoft font reencoding
// may be called anywhere (-> i.e. in Xprinter)
Bool bAnsi1252ReencodingOn( )
{
	static Bool bEmulationOn = (getenv( "SAL_PUREANSI_ENCODING" ) == NULL);

	return  bEmulationOn; 
}

// font and char dependent question (includes indep. question above)
//
Bool Ansi1252FontEncoder::bEmulateAnsi1252Encoding( unsigned int nChar )
{
	return     mbReencodableFont
			&& bAnsi1252ReencodingOn() 
			&& (nMapChar( nChar ) != 0) ;
}

// calculates the width of a char out of the microsoft-gap by 
// dispatching to specialized routines 
long Ansi1252FontEncoder::nCharWidth ( unsigned int nChar )
{
	long  nWidth;
	long  nFixedCharWidth = nFixedWidth();
	
	short nMappedChar = nMapChar( nChar );

	// dispatch as indicated by nMapChar() resp return fixed with for
	// monospaced fonts
	if ( nMappedChar == 0 )
		return 0L;
	if ( nFixedCharWidth )
		return nFixedCharWidth;
	if ( nMappedChar >  0 )
		return nSimpleCharWidth ( nMappedChar );

	return nCompoundCharWidth ( nChar );	
}

// calculates the width of a char by looking at
// equally wide chars
long Ansi1252FontEncoder::nSimpleCharWidth ( unsigned int nChar )
{
	if ( nChar < mnCharFrom || nChar > mnCharTo )
		return 0;
	
	return mpCharWidth[ nChar - mnCharFrom ];	
} 

// calculates the width of char by weired and loony calculations 
//
long Ansi1252FontEncoder::nCompoundCharWidth ( unsigned int nChar )
{
	long nWidth = 0;

	/* XXX this switch statement must be kept in sync with the (-1) entries
	 *     in mnRemapTable
	 */
	switch ( nChar )
	{	
		case 0x85: /* /ellipsis */ 
			nWidth = 4 * nSimpleCharWidth( (unsigned int)'.' ); 
			break;
		case 0x88: /* /circumflex */
			nWidth = nRoundInt( 
						  (double)0.8 * nSimpleCharWidth( (unsigned int)'^' )); 
			break;
		case 0x89: /* /perthousand */
			nWidth=   nSimpleCharWidth( (unsigned int)'%' ) 
					+ nSimpleCharWidth( (unsigned int)',' ); 
			break;
		case 0x8c: /* /OE */ 
			nWidth = nRoundInt( (double)0.75 * (
									nSimpleCharWidth( (unsigned int)'O' )  
						 		  + nSimpleCharWidth( (unsigned int)'E' ))); 
			break;
		case 0x98: /* /tilde */
			nWidth = nRoundInt( 
					    (double)0.666 * nSimpleCharWidth( (unsigned int)'~' )); 
			break;
		case 0x99: /* /trademark */
			nWidth = nRoundInt( 
						(double)0.666 * (  
						       nSimpleCharWidth( (unsigned int)'T' )
							 + nSimpleCharWidth( (unsigned int)'M' ) )); 
			break;
		case 0x9c: /* /oe */
			nWidth = nRoundInt( (double)0.75 * (
									nSimpleCharWidth( (unsigned int)'o' )  
						 		  + nSimpleCharWidth( (unsigned int)'e' ))); 
			break;
		default:
			fprintf (stderr, "Ansi1252 Encoding: char %x out of sync\n", nChar);
			nWidth = 0; 
	}

	return nWidth;
}

