package com.sun.star.help;

import com.sleepycat.db.*;
import java.io.*;
import java.util.*;
import java.util.jar.*;


public final class HelpDatabases
{
	// The office installation directory for the help system
	// Has to be read from the configuration
	private static String _installDirectory = System.getProperty( "com.sun.star.help.Directory" );

 	public static synchronized void setInstallPath( String _dir )
  	{
   		_installDirectory = _dir;
   	}

	// Holds the databases for the different languages;
	private static final Hashtable _dbHash = new Hashtable();

 	// The same for the jar files
	private static final Hashtable _jarHash = new Hashtable();


	public static final class StaticModuleInformation
 	{
  		private String _startId;
    	private String _programSwitch;
     	private String _title;
		private String _heading;
		private String _fulltext;
		
     	public StaticModuleInformation( String title,
										String startId,
										String programSwitch,
										String heading,
										String fulltext )
      	{
       		_title = title;
         	_startId = startId;
          	_programSwitch = programSwitch;
			_heading = heading;
			_fulltext = fulltext;
       	}

        public String get_title()   { return _title; }
      	public String get_id() { return _startId; }
       	public String get_program() { return _programSwitch; }
		public String get_heading() { return _heading; }
		public String get_fulltext() { return _fulltext; }
  	}


	public static final Hashtable _modInfo = new Hashtable();

	
	
 	public static String getURLMode()
  	{
		return new String( "with-jars" );
		
		// return new String( "with-files" );
   	}

	

    private static final class DbFilter implements FilenameFilter
    {
    	public boolean accept( File dir, String name )
     	{
      		if( dir.exists() && ends( name ) )
        		return true;
          	else
           		return false;
      	}

       	boolean ends( String name )
        {
        	int idx = name.lastIndexOf(  '.' );
         	if( ( name.charAt( idx + 1 ) == 'd' ||
				  name.charAt( idx + 1 ) == 'D' )    && 
				( name.charAt( idx + 2 ) == 'b' ||
				  name.charAt( idx + 2 ) == 'B' ) )
          	{
           		if( name.substring(0,idx).toLowerCase().equals("picture") )
             		return false;

          		return true;
            }
            else
            	return false;
        }
    }


    public static String[] getModuleList( String Language )
    {
		String dirName = _installDirectory + lang( Language );
  		File dirFile = new File( dirName );
    	if( dirFile.isDirectory() )
			return dirFile.list( new DbFilter() );
   		else
     		return null;
    }

	public static String getInstallDirectory()
	{
	    return _installDirectory;
	}


	public static final HashSet langSet = new HashSet();
	
	
	public static synchronized String lang( String Language )
	{
		String ret = Language;
		if( ! langSet.contains( ret ) )
		{
			if( ! (new File( _installDirectory + ret )).exists() )
			{
				int idx;
				if( ( idx = ret.indexOf( '-' ) ) != -1 ||    // Only one is true
					( idx = ret.indexOf( '_' ) ) != -1 )
					ret = ret.substring( 0,idx );
			}
			langSet.add( ret );
		}

		return ret;
	}
	
	
 	public static synchronized StaticModuleInformation getStaticInformationForModule( String Module, String Language )
  	{
   		String key = lang(Language) + File.separator + Module;
     	StaticModuleInformation info = ( StaticModuleInformation ) _modInfo.get( key );
      	if( info == null )
       	{
   			String cfgDat = _installDirectory + key + ".cfg";
			FileInputStream cfgFile = null;
			try
			{
				cfgFile = new FileInputStream( cfgDat );
			}
			catch( FileNotFoundException e )
			{
				e.printStackTrace();
			}
  			try
    		{
				InputStreamReader input;
				try
				{
					input = new InputStreamReader( cfgFile,"UTF8" );
				}
				catch( UnsupportedEncodingException e )
				{
					input = new InputStreamReader( cfgFile );
				}
						
    			String fileContent = new String();
   				char[] buffer = new char[128];
   				while( input.read( buffer,0,128 ) != -1 )
      			{
         			fileContent += new String( buffer );
           			buffer = new char[128];
        		}
				input.close();
				cfgFile.close();

				String current = new String();
    			String lang = null,program = null,startid = null,title = null,heading = "",fulltext="";
				for( int i = 0; i < fileContent.length(); ++i )
    			{
       				char ch = fileContent.charAt( i );
       				if( ch == '\n' || ch == '\r' )
           			{
              			if( current.length() != 0 )
                 		{
                   			// Something to interpret
							if( current.startsWith( "Title" ) )
       						{
                            	title = current.substring( current.indexOf('=') + 1 );
             				}
                 			else if( current.startsWith( "Start" ) )
                    		{
                            	startid = current.substring( current.indexOf('=') + 1 );
                      		}
                        	else if( current.startsWith( "Language" ) )
                         	{
                            	lang = current.substring( current.indexOf('=') + 1 );
                          	}
                           	else if( current.startsWith( "Program" ) )
                            {
                            	program = current.substring( current.indexOf('=') + 1 );
                            }
                           	else if( current.startsWith( "Heading" ) )
                            {
                            	heading = current.substring( current.indexOf('=') + 1 );
                            }
                           	else if( current.startsWith( "FullText" ) )
                            {
                            	fulltext = current.substring( current.indexOf('=') + 1 );
                            }
                   		}
						current = new String();
     				}
					else
     					current += ch;
       			}
          		info = new StaticModuleInformation( title,startid,program,heading,fulltext );
            	_modInfo.put( key,info );
  			}
    		catch( Exception e )
     		{
      			System.err.println( "Corrupted cfg-file: " + cfgDat );
        		e.printStackTrace();
      		}
        }
		
        return info;
   	}



	public static synchronized Db getDatabaseForLanguage( String Database,String Language )
	{
		if( Database == null || Language == null )
			return null;
		String key = lang(Language) + File.separator + Database;       // For example de/swriter
		Db table = ( Db ) _dbHash.get( key );
		if( table == null )
		{
            try
            {
				table = new Db( null,0 );

				String tablePath = _installDirectory + key + ".db";
				table.open( tablePath,null,Db.DB_BTREE,Db.DB_RDONLY,0644 );
				_dbHash.put( key,table );
            }
            catch( DbException e )
            {
				System.err.println( "Unsupported language in helpsystem: " + Language );
    			System.err.println( "module: " + Database );
    			System.err.println( e.getMessage() );
            }
            catch( FileNotFoundException e )
            {
				System.err.println( "Unsupported language in helpsystem: " + Language );
   				System.err.println( "module: " + Database );
    			System.err.println( e.getMessage() );
            }
		}

		return table;
	}


 	static Hashtable _helptextHash = new Hashtable();


	public static synchronized Db getHelptextDbForLanguage( String Database,String Language )
	{
		String key = lang( Language ) + File.separator + Database;       // For example de/swriter
		Db table = ( Db ) _helptextHash.get( key );
		if( table == null )
		{
            try
            {
				table = new Db( null,0 );

				String tablePath = _installDirectory + key + ".ht";
				table.open( tablePath,null,Db.DB_BTREE,Db.DB_RDONLY,0644 );
				_dbHash.put( key,table );
            }
            catch( DbException e )
            {
				System.err.println( "Unsupported language in helpsystem: " + Language );
    			System.err.println( "module: " + Database );
    			System.err.println( e.getMessage() );
            }
            catch( FileNotFoundException e )
            {
				System.err.println( "Unsupported language in helpsystem: " + Language );
   				System.err.println( "module: " + Database );
    			System.err.println( e.getMessage() );
            }
		}

		return table;
	}



	public static synchronized JarFile getJarFileForLanguage( String Database,String Language )
	{
		if( Language == null || Database == null )
			return null;
		
		String key = lang(Language) + File.separator + Database;
		JarFile jarFile = ( JarFile ) _jarHash.get( key );
		if( jarFile == null )
		{
            try
            {
            	File file = new File( _installDirectory + key );
             	if( file.exists() )
              	{
					jarFile = new JarFile( file );
					_jarHash.put( key,jarFile );
     			}
        		else
          			throw new java.io.IOException();
            }
            catch( IOException e )
            {
				System.err.println( "Jarfile not found: " + Database + " " + Language );
            }
		}

		return jarFile;
	}


	public static InputStream getCssSheet()
	{
		try
		{
			return new FileInputStream( _installDirectory + "custom.css" );
		}
		catch( FileNotFoundException e )
		{
			return null;
		}
	}

	
	public static InputStream errorFile( String Language )
	{
		try 
		{
			return new FileInputStream( _installDirectory + lang(Language) + File.separator + "err.html" );
		}
		catch( IOException e )
		{
			String errorFile =
				" <html><body>         "+
				"     The requested document does not exist in the database !!            "+
				" </body></html> ";
			
			return new ByteArrayInputStream( errorFile.getBytes() );
		}
	}



	public static InputStream popupDocument( HelpURLParameter xPar )
	{
//  		String popupFile =
//  			" <help:document xmlns:help=\"http://openoffice.org/2000/help\">         "+
//  			" <help:body>" +
//  			"  <help:popup-cut Id=\""+xPar.get_id()+"\" Eid=\""+xPar.get_eid()+"\"></help:popup-cut> " +
//  		1	" </help:body></help:document> ";
		
		String popupFile =
			" <html>                                                                                 "+
			" <head>                                                                                 "+
			" <help:css-file-link xmlns:help=\"http://openoffice.org/2000/help\"/>                   "+
			" </head>                                                                                "+
			" <body>                                                                                 "+
			" <help:popup-cut Id=\""+xPar.get_id()+"\" Eid=\""+xPar.get_eid()+"\" xmlns:help=\"http://openoffice.org/2000/help\"></help:popup-cut>  "+
			" </body>                                                                                "+
			" </html>                                                                                ";
		
		System.out.println( popupFile );

		return new ByteArrayInputStream( popupFile.getBytes() );
	}


	private static final Hashtable _keyword = new Hashtable();


 	public static final class KeywordInfo
  	{
   		int pos = 0;
   		String[] listKey = new String[100];
		String[][] listId;
		String[][] listAnchor;
  		String[][] listTitle;

		public String [] getKeywordList()
  		{
    		return listKey;
    	}

     	public String[][] getIdList()
      	{
       		return listId;
       	}


		public String[][] getAnchorList()
		{
			return listAnchor;
		}

     	public String[][] getTitleList()
      	{
       		return listTitle;
       	}

     	private void realloc( int length )
      	{
    		String[] buff = listKey;
        	listKey = new String[ length ];
         	int count = ( listKey.length > buff.length ) ? buff.length : listKey.length;
           	for( int i = 0; i < count; ++i )
              	listKey[i] = buff[i];
        	buff = null;
       	}


        public String[] getTitleForIndex( int i )
        {
			return listTitle[i];
        }


     	void insert( String id )
		{
			if( pos == listKey.length )
				realloc( pos + 100 );
			listKey[ pos++ ] = id;
   		}


      	public String[] insertId( int index,String ids )
       	{
        	int pos = 0;
        	String[] test = new String[10];
        	while( ids != null && ids.length() != 0 )
         	{
          		int idx = ids.indexOf( ';' );
            	if( pos == test.length )
             	{
    				String[] buff = test;
        			test = new String[ pos+10 ];
           			for( int i = 0; i < buff.length; ++i )
              			test[i] = buff[i];
        			buff = null;
              	}

             	test[pos++] = ids.substring(0,idx);
             	ids = ids.substring( 1+idx );
          	}

       		String[] buff = test;
        	test = new String[ pos ];
           	for( int i = 0; i < pos; ++i )
            	test[i] = buff[i];

      		listId[index] = test;
			listAnchor[index] = new String[test.length];

			for( int k = 0; k < listId[index].length; ++k )
			{
				if( listId[index][k] == null )
				{
					listId[index][k] = "";
					listAnchor[index][k] = "";
				}
				else
				{
					int idx = listId[index][k].indexOf('#');
					if( idx != -1 )
					{
						listAnchor[index][k] = listId[index][k].substring(1+idx).trim();
						listId[index][k] = listId[index][k].substring(0,idx).trim();
					}
					else
						listAnchor[index][k] = "";
				}
			}
			
			listTitle[index] = new String[test.length];
   			return test;
		}



     	public void sort()
      	{
			realloc( pos );
   			Arrays.sort( listKey );
      		listId = new String[ listKey.length ][];
      		listAnchor = new String[ listKey.length ][];
        	listTitle = new String[ listKey.length ][];
       	}
   	}

	
 	public static synchronized KeywordInfo getKeyword( String Database, String Language )
  	{
   		String keyStr = lang(Language) + File.separator + Database;
		KeywordInfo info = ( KeywordInfo ) _keyword.get( keyStr );
		
  		if( info == null )
    	{
     		try
       		{
				HashMap internalHash = new HashMap();
				String fileName = HelpDatabases.getInstallDirectory() + keyStr + ".key";
        		Db table = new Db( null,0 );
				System.err.println( fileName );
				table.open( fileName,null,Db.DB_BTREE,Db.DB_RDONLY,0644 );
				Dbc cursor = table.cursor( null,0 );
				StringDbt key = new StringDbt();
				StringDbt data = new StringDbt();

				boolean first = true;
  				key.set_flags( Db.DB_DBT_MALLOC );      // Initially the cursor must allocate the necessary memory
     			data.set_flags( Db.DB_DBT_MALLOC );
        		info = new KeywordInfo();

				String keyStri;
				
				while( Db.DB_NOTFOUND != cursor.get( key,data,Db.DB_NEXT ) )
				{
					keyStri = key.getString();
					info.insert( keyStri );
		       		internalHash.put( keyStri,data.getString() );
					if( first )
          			{
						key.set_flags( Db.DB_DBT_REALLOC );
     					data.set_flags( Db.DB_DBT_REALLOC );
         				first = false;
            		}
            	}

             	info.sort();
            	cursor.close();
            	table.close( 0 );
				
    			String[] keywords = info.getKeywordList();
       			Db table2 = getDatabaseForLanguage( Database,Language );
       			for( int i = 0; i < keywords.length; ++i )
          		{
					String[] id = info.insertId( i,((String)internalHash.get( keywords[i])) );
         			String[] title = info.getTitleForIndex( i );

     				for( int j = 0; j < id.length; ++j )
     				{
						StringDbt key1 = new StringDbt(); 
						key1.setString( id[j] );
      					StringDbt data1 = new StringDbt();
						try
      					{
         					table2.get( null,key1,data1,0 );
							title[j] = data1.getTitle();
       					}
            			catch( Exception e )
               			{
							e.printStackTrace();
                  			title[j] = "";
                  		}
         			}
            	}

            	_keyword.put( keyStr,info );
            }
			catch( Exception e )
   			{
				e.printStackTrace();
				System.err.println( "any other exception in getKeyword: " + e.getMessage() );
      		}
		}

		return info;
	}

}    // end class HelpDatabases




