/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryHit.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:32:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.util.Location;

class QueryHit {
  private int _doc;
  private int _begin;
  private int _end;
  private double _score;
  private final int[] _concepts;

  public QueryHit(Location loc, double penalty, int nColumns) {
    _score = penalty;
    _doc = loc.getDocument();
    _begin = loc.getBegin();
    _end = loc.getEnd();
    _concepts = new int[nColumns];
  }
  
  public String toString() {
    return "[doc = "+_doc+", "+_begin+", "+_end+", "+_score+"]";
  }

  public int getDocument() {
    return _doc;
  }

  public int getBegin() {
    return _begin;
  }

  public int getEnd() {
    return _end;
  }

  public double getScore() {
    return _score;
  }

  public int[] getArray() {
    return _concepts;
  }

  public boolean betterThan(QueryHit x) {
    if (_score < x._score) return true;
    if (_score > x._score) return false;
    if (_begin < x._begin) return true;
    if (_begin > x._begin) return false;
    if (_end < x._end) return true;
    if (_end > x._end) return false;
    return false;
  }
}
