/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: findpos.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 12:54:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "sal/config.h"

#include "findpos.hxx"

#include "com/sun/star/uno/Sequence.hxx"
#include "comphelper/types.hxx"
#include "rtl/ustring.hxx"
#include "sal/types.h"

#include <algorithm>

namespace detail {

sal_Int32 findPos(
    const ::rtl::OUString& aStr,
    const ::com::sun::star::uno::Sequence< ::rtl::OUString >& rList)
{
    const ::rtl::OUString* pStrList = rList.getConstArray();
    const ::rtl::OUString* pResult = ::std::lower_bound(
        pStrList, pStrList + rList.getLength(), aStr );
    if ( ( pResult != pStrList + rList.getLength() ) && ( *pResult == aStr ) )
        return ( pResult - pStrList );

    return -1;
}

}
