

package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.ConstantCreator;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateConstantAction extends NodeAction
    implements Create
{

    public CreateConstantAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((ConstantCreator)anode[0].getCookie(ConstantCreator.class)).createConstant();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(ConstantCreator.class) != null;
    }

    public String getName()
    {
        return "Create Constant";
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Constant");
    }

    protected String iconResource()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateConstant");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

        
}
