/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XclImpPivotTables.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:38:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/



#ifndef SC_XCLIMPPIVOTTABLES_HXX
#define SC_XCLIMPPIVOTTABLES_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif

#ifndef SC_XIROOT_HXX
#include "xiroot.hxx"
#endif
namespace binfilter {

class ScDPSaveData;
class ScfUInt16List;
class XclImpStream;


//_________________________________________________________

enum XclImpPTSourceType
{
	PTST_ExcelOrDB,					// MS Excel list or database
	PTST_extern,					// external data source"
	PTST_MultConsoldRngs,			// multiple consolidation ranges
	PTST_PivTab,					// pivot table
	PTST_ScenMan,					// scenario manager summary report
	PTST_unknown
};

//_________________________________________________________

class XclImpPivotCacheItem
{
private:
protected:
public:
	virtual						~XclImpPivotCacheItem();
	virtual BOOL				IsString() const;
	virtual BOOL				IsDouble() const;
};


class XclImpPivotCacheStringItem : public XclImpPivotCacheItem
{
private:
	String						aText;

protected:
public:
	inline						XclImpPivotCacheStringItem( const String& rText ) : aText( rText )	{}
	virtual BOOL				IsString() const;

	inline const String&		GetCont() const		{ return aText; }
};


class XclImpPivotCacheDoubleItem : public XclImpPivotCacheItem
{
private:
	double						fVal;

protected:
public:
	inline						XclImpPivotCacheDoubleItem( double fNewVal ) : fVal( fNewVal )	{}
	virtual BOOL				IsDouble() const;

	inline double				GetCont() const		{ return fVal; }
};

//_________________________________________________________

class XclImpPivotCacheField : private List
{
private:
	String						aName;
	BOOL						bReadLater;

	inline XclImpPivotCacheItem* _First()	{ return (XclImpPivotCacheItem*) List::First(); }
	inline XclImpPivotCacheItem* _Next()	{ return (XclImpPivotCacheItem*) List::Next(); }

protected:
public:
	inline						XclImpPivotCacheField( const String& rName ) :
									aName( rName ), bReadLater( FALSE )	{}
	virtual						~XclImpPivotCacheField();

	inline const XclImpPivotCacheItem* Get( UINT16 nIndex ) const
									{ return (const XclImpPivotCacheItem*) List::GetObject( nIndex ); }

	inline const String*		GetName() const				{ return &aName; }
	inline BOOL					GetReadState() const		{ return bReadLater; }
	inline void					SetReadState( BOOL bRL )	{ bReadLater = bRL; }

	inline void					Append( XclImpPivotCacheItem* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }
};

//_________________________________________________________

class XclImpPivotCache : private List
{
private:
	UINT16						nStreamId;
	XclImpPTSourceType			eSrcType;
	ScRange						aSrcRange;
	String						aFileName;
	String						aTabName;
	BOOL						bSelf;

	inline XclImpPivotCacheField* _First()	{ return (XclImpPivotCacheField*) List::First(); }
	inline XclImpPivotCacheField* _Next()	{ return (XclImpPivotCacheField*) List::Next(); }
	XclImpPivotCacheField*		GetFirstReadLater();
	XclImpPivotCacheField*		GetNextReadLater();

	inline void					Append( XclImpPivotCacheField* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }

protected:
public:
								XclImpPivotCache( RootData* pExcRoot, UINT16 nStreamId );
	virtual						~XclImpPivotCache();

	void						SetSourceType( UINT16 nType );
	void						SetSource( UINT8 nC1, UINT16 nR1, UINT8 nC2, UINT16 nR2,
											const String& rFName, const String& rTName,
											BOOL bSelfRef );

								List::Count;
	inline XclImpPTSourceType	GetSourceType() const	{ return eSrcType; }
	inline const ScRange&		GetSourceRange() const	{ return aSrcRange; }
	inline const String&		GetFileName() const		{ return aFileName; }
	inline const String&		GetTabName() const		{ return aTabName; }
	inline BOOL					IsSelfRef() const		{ return bSelf; }
	const XclImpPivotCacheItem*	GetItem( UINT16 nFieldId, UINT16 nItemId ) const;
	const String*				GetFieldName( UINT16 nFieldId ) const;
};

//_________________________________________________________

class XclImpPivotCacheList : private List
{
private:
	inline XclImpPivotCache*	_First()	{ return (XclImpPivotCache*) List::First(); }
	inline XclImpPivotCache*	_Next()		{ return (XclImpPivotCache*) List::Next(); }

protected:
public:
	virtual						~XclImpPivotCacheList();

	inline void					Append( XclImpPivotCache* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }
	inline XclImpPivotCache*	Get( UINT16 nIndex )
									{ return (XclImpPivotCache*) List::GetObject( nIndex ); }
};

//_________________________________________________________

class XclImpPivotDataItem
{
private:
	UINT16						nIndex;
	UINT16						nFunction;
	UINT16						nDisplay;
	UINT16						nSXVDInd;
	UINT16						pSXVIInd;
	UINT16						nFormat;
	String*						pLayoutName;

protected:
public:
								XclImpPivotDataItem( UINT16 nI, UINT16 nFunc, UINT16 nD,
												UINT16 nF, String* pName );
	virtual						~XclImpPivotDataItem();

	UINT16						GetIndex() const		{ return nIndex; }
	UINT16						GetFunction() const		{ return nFunction; }
	const String*				GetLayoutName() const	{ return pLayoutName; }
};

//_________________________________________________________

class XclImpPivotDataItemList : protected List
{
private:
	inline XclImpPivotDataItem*	_First()	{ return (XclImpPivotDataItem*) List::First(); }
	inline XclImpPivotDataItem*	_Next()		{ return (XclImpPivotDataItem*) List::Next(); }

protected:
public:
	virtual						~XclImpPivotDataItemList();

	inline void					Append( XclImpPivotDataItem* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }

								List::Count;
	inline const XclImpPivotDataItem* First()	{ return (const XclImpPivotDataItem*) List::First(); }
	inline const XclImpPivotDataItem* Next()	{ return (const XclImpPivotDataItem*) List::Next(); }
};

//_________________________________________________________

class XclImpPivotFieldItem
{
private:
	UINT16						nType;		// -> SXVI
	UINT16						nCache;
	BOOL						bHidden;
	BOOL						bHideDetail;
	BOOL						bFormula;
	BOOL						bMissing;

protected:
public:
								XclImpPivotFieldItem( UINT16 nT, UINT16 nC, UINT16 nGrBit );
								XclImpPivotFieldItem( XclImpPivotFieldItem& r );

	inline UINT16				GetType() const			{ return nType; }
	inline UINT16				GetCacheIndex() const	{ return nCache; }
	inline BOOL					IsHidden() const		{ return bHidden; }
	inline BOOL					IsHideDetail() const	{ return bHideDetail; }
};

//_________________________________________________________

class XclImpPivotFieldItemList : protected List
{
private:
	inline XclImpPivotFieldItem* _First()	{ return (XclImpPivotFieldItem*) List::First(); }
	inline XclImpPivotFieldItem* _Next()	{ return (XclImpPivotFieldItem*) List::Next(); }

protected:
public:
	inline						XclImpPivotFieldItemList()	{	}
								XclImpPivotFieldItemList( XclImpPivotFieldItemList& r );
	virtual						~XclImpPivotFieldItemList();

	inline void					Append( XclImpPivotFieldItem* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }

								List::Count;
	inline const XclImpPivotFieldItem* First()	{ return (const XclImpPivotFieldItem*) List::First(); }
	inline const XclImpPivotFieldItem* Next()	{ return (const XclImpPivotFieldItem*) List::Next(); }
	inline const XclImpPivotFieldItem* Get( UINT32 nIndex ) const
									{ return (const XclImpPivotFieldItem*) List::GetObject( nIndex ); }
};

//_________________________________________________________

class XclImpPivotTabField
{
private:
	XclImpPivotFieldItemList	aItemList;

	String*						pLayoutName;		// NULL = use name in cache
	UINT16						nCacheIndex;		// index to field name

	UINT16						nIndex;				// row/col = order of fields in list
													// page    = index to SXVI
	UINT16						nNumOfSubtotals;
	UINT16						nNumOfItems;
	USHORT						nAxis;
	UINT16						nSubType;
	BOOL						bShowEmpty;

protected:
public:
								XclImpPivotTabField( UINT16 nAxis, UINT16 nNOSubt,
													UINT16 nSType, UINT16 nNOItems,
													UINT16 nCI, const String* pName );
								XclImpPivotTabField( XclImpPivotTabField& r, UINT16 nSubT, const String* pName );
	virtual						~XclImpPivotTabField();

	inline void					AppendItem( UINT16 nItemType, UINT16 nCache, UINT16 nGrBit );

	inline void					SetIndex( UINT16 nInd )			{ nIndex = nInd; }
	inline void					SetShowEmpty( BOOL bShowE )		{ bShowEmpty = bShowE; }
	inline UINT16				GetIndex() const				{ return nIndex; }
	inline UINT16				GetSubType() const		   		{ return nSubType; }
	inline const XclImpPivotFieldItemList& GetItemList() const	{ return aItemList; }
	inline UINT16				GetCacheIndex() const			{ return nCacheIndex; }
	inline BOOL					GetShowEmpty() const			{ return bShowEmpty; }
	inline const String*		GetLayoutName() const			{ return pLayoutName; }
	const String*				GetCacheName( XclImpPivotCache* pCache ) const;
};

inline void XclImpPivotTabField::AppendItem( UINT16 nItemType, UINT16 nCache, UINT16 nGrBit )
{
	aItemList.Append( new XclImpPivotFieldItem( nItemType, nCache, nGrBit ) );
}

inline const String* XclImpPivotTabField::GetCacheName( XclImpPivotCache* pCache ) const
{
	return pCache ? pCache->GetFieldName( nCacheIndex ) : NULL;
}

//_________________________________________________________

class XclImpPivotTabFieldList : protected List
{
private:
    ScfUInt16List*              pIndexList;
	UINT16						nIndexCnt;

	inline XclImpPivotTabField*	_First()	{ return (XclImpPivotTabField*) List::First(); }
	inline XclImpPivotTabField*	_Next()		{ return (XclImpPivotTabField*) List::Next(); }
	inline XclImpPivotTabField*	_Get( UINT32 nIndex ) const
									{ return (XclImpPivotTabField*) List::GetObject( nIndex ); }
	XclImpPivotTabField*		_FindIndex( UINT16 nIndex );

protected:
public:
	inline						XclImpPivotTabFieldList() : pIndexList( NULL )	{}
	virtual						~XclImpPivotTabFieldList();

								List::Count;
	inline const XclImpPivotTabField* First()	{ return (const XclImpPivotTabField*) List::First(); }
	inline const XclImpPivotTabField* Next()	{ return (const XclImpPivotTabField*) List::Next(); }
	inline const XclImpPivotTabField* Get( UINT32 nIndex ) const
									{ return (const XclImpPivotTabField*) List::GetObject( nIndex ); }

	const XclImpPivotTabField*	FirstInOrder();	// uses pIndexList if present
	const XclImpPivotTabField*	NextInOrder();

	inline void					Append( XclImpPivotTabField* pNew )
									{ List::Insert( pNew, LIST_APPEND ); }
	inline void					SetIndex( UINT32 nField, UINT16 nIndex );
	void						AddIndex( UINT16 nIndex );

	XclImpPivotTabField*		CreateDuplicate( UINT16 nCache, UINT16 nSubT, const String* pName );
};

inline void XclImpPivotTabFieldList::SetIndex( UINT32 nField, UINT16 nIndex )
{
	XclImpPivotTabField* pField = _Get( nField );
	if( pField )
		pField->SetIndex( nIndex );
}

//_________________________________________________________

class XclImpPivotTable : public ExcRoot
{
private:
	ScRange						aViewRange;
	ScRange						aOutputRange;

	XclImpPivotTabField*		pActField;
	XclImpPivotTabField*		pActDataField;

	XclImpPivotTabFieldList*	pColFieldList;
	XclImpPivotTabFieldList*	pRowFieldList;
	XclImpPivotTabFieldList*	pPageFieldList;
	XclImpPivotTabFieldList*	pDataFieldList;
	XclImpPivotTabFieldList*	pFullDataList;
	UINT16						nSxIvdTurn;

	UINT16						nFlags;
	UINT16						nDimCol;
	UINT16						nDimRow;
	UINT16						nDimPage;
	UINT16						nDimData;
	UINT16						nSxLiInd;		// current SXLI record

	XclImpPivotDataItemList*	pDataItemList;

	XclImpPivotCache*			pCache;
	UINT16						nCacheIndexCnt;

	void						Init();
	void						CreateFullDataList();
	void						DecodeSubTotals( long& rCount, USHORT* pFuncs, UINT16 nFlags );
	void						SetFields( XclImpPivotTabFieldList& rList, USHORT nOrient,
											ScDPSaveData& rSaveData );

protected:
public:
								XclImpPivotTable( XclImpStream& rIn, RootData* pRD, UINT8 nTab );
	virtual						~XclImpPivotTable();

	void						AddViewField( XclImpStream& rIn );
	inline void					SetShowEmpty( BOOL bShowEmpty );
	void						AddViewItem( UINT16 nItemType, UINT16 nCache, UINT16 nGrBit );
	void						ReadRCFieldIDs( XclImpStream& rIn );
	void						AddPageItemInfo( UINT16 nSXVD, UINT16 nSXVI );
	void						AddDataItem( XclImpStream& rIn );

	inline BOOL					IsInPivotRange( const ScAddress& rAddr ) const
									{ return aOutputRange.In( rAddr ); }

	void						Apply();
};

inline void XclImpPivotTable::SetShowEmpty( BOOL bShowE )
{
	if( pActField )
		pActField->SetShowEmpty( bShowE );
}

//_________________________________________________________

class XclImpPivotTableList : protected List
{
private:
protected:
public:
	virtual						~XclImpPivotTableList();

								List::Count;
	inline XclImpPivotTable*	First()	{ return (XclImpPivotTable*) List::First(); }
	inline XclImpPivotTable*	Next()	{ return (XclImpPivotTable*) List::Next(); }
	inline XclImpPivotTable*	Get( UINT32 nIndex ) const
									{ return ( XclImpPivotTable* ) List::GetObject( nIndex ); }

	inline void					Append( XclImpPivotTable* pNewPivTab )
									{ List::Insert( pNewPivTab, LIST_APPEND ); }

	BOOL						IsInPivotRange( UINT16 nCol, UINT16 nRow, UINT16 nTab ) const;

	void						Apply();
};


} //namespace binfilter
#endif

