/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_TemplateScanner.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:46:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "TemplateScanner.hxx"

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

#ifndef _VOS_MUTEX_HXX
#include <vos/mutex.hxx>
#endif

#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::rtl;
using namespace ::ucb;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::ucb;

//STRIP001 namespace { 
//STRIP001 const OUString TITLE            = OUString::createFromAscii ("Title");
//STRIP001 const OUString TARGET_DIR_URL   = OUString::createFromAscii ("TargetDirURL");
//STRIP001 const OUString DESCRIPTION      = OUString::createFromAscii ("TypeDescription");
//STRIP001 const OUString TARGET_URL       = OUString::createFromAscii ("TargetURL");
//STRIP001 
//STRIP001 const OUString DOCTEMPLATES     = OUString::createFromAscii ("com.sun.star.frame.DocumentTemplates");
//STRIP001 
//STRIP001 //  These strings are used to find impress templates in the tree of 
//STRIP001 //  template files.  Should probably be determined dynamically.
//STRIP001 const OUString IMPRESS_BIN_TEMPLATE = OUString::createFromAscii ("application/vnd.stardivision.impress");
//STRIP001 const OUString IMPRESS_XML_TEMPLATE = OUString::createFromAscii ("application/vnd.sun.xml.impress");
//STRIP001 // The following id comes from the bugdoc in #i2764#.
//STRIP001 const OUString IMPRESS_XML_TEMPLATE_B = OUString::createFromAscii ("Impress 2.0");
//STRIP001 }
//STRIP001 
//STRIP001 namespace sd 
//STRIP001 {
//STRIP001 
//STRIP001 TemplateScanner::TemplateScanner (void)
//STRIP001 {
//STRIP001     //  empty;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 TemplateScanner::~TemplateScanner (void)
//STRIP001 {
//STRIP001     // Delete all entries of the template list that have not been
//STRIP001     // transferred to another object.
//STRIP001     std::vector<TemplateDir*>::iterator I;
//STRIP001     for (I=maFolderList.begin(); I!=maFolderList.end(); I++)
//STRIP001         if (*I != NULL)
//STRIP001             delete *I;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void TemplateScanner::GetTemplateRoot (void)
//STRIP001 {
//STRIP001     Reference<lang::XMultiServiceFactory> xFactory = 
//STRIP001         ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 
//STRIP001     Reference<frame::XDocumentTemplates> xTemplates (
//STRIP001         xFactory->createInstance (DOCTEMPLATES), UNO_QUERY);
//STRIP001 
//STRIP001     if (xTemplates.is())
//STRIP001         mxTemplateRoot = xTemplates->getContent();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void TemplateScanner::ScanEntries (Content& rRoot, TemplateDir* pDir)
//STRIP001 {
//STRIP001     Reference<XCommandEnvironment> aCmdEnv;
//STRIP001 
//STRIP001     //  We are interested only in three properties: the entry's name, 
//STRIP001     //  its URL, and its content type.
//STRIP001     Sequence<OUString> aProps (3);
//STRIP001     aProps[0] = TITLE;
//STRIP001     aProps[1] = TARGET_URL;
//STRIP001     aProps[2] = DESCRIPTION;
//STRIP001 
//STRIP001     //  Create a cursor to iterate over the templates in this folders.
//STRIP001     ResultSetInclude eInclude = INCLUDE_DOCUMENTS_ONLY;
//STRIP001     Reference<XResultSet> xResultSet (rRoot.createCursor (aProps, eInclude));
//STRIP001 
//STRIP001     if (xResultSet.is())
//STRIP001     {
//STRIP001         Reference<XContentAccess> xContentAccess (xResultSet, UNO_QUERY);
//STRIP001         Reference<XRow> xRow (xResultSet, UNO_QUERY);
//STRIP001 
//STRIP001         //  Iterate over the template folder.
//STRIP001         while (xResultSet->next())
//STRIP001         {
//STRIP001             OUString aTitle (xRow->getString (1));
//STRIP001             OUString aTargetURL (xRow->getString (2));
//STRIP001             OUString aContentType (xRow->getString (3));
//STRIP001 
//STRIP001             OUString aId = xContentAccess->queryContentIdentifierString();
//STRIP001             Content  aContent = Content (aId, aCmdEnv);
//STRIP001             if ( ! aContent.isDocument ())
//STRIP001                 continue;
//STRIP001                 
//STRIP001             //  Check wether the entry is an impress template.  If so add a
//STRIP001             //  new entry to the resulting list (which is created first if
//STRIP001             //  necessary).
//STRIP001             if (    (aContentType == IMPRESS_BIN_TEMPLATE) 
//STRIP001                 ||  (aContentType == IMPRESS_XML_TEMPLATE)
//STRIP001                 ||  (aContentType == IMPRESS_XML_TEMPLATE_B))
//STRIP001                 pDir->m_aEntries.push_back (
//STRIP001                     new TemplateEntry (aTitle, aTargetURL));
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void TemplateScanner::ScanFolders (void)
//STRIP001 {
//STRIP001     try
//STRIP001     {
//STRIP001         //  Create content for template folders.
//STRIP001         Reference<XCommandEnvironment> aCmdEnv;
//STRIP001         Content aTemplateDir (mxTemplateRoot, aCmdEnv);
//STRIP001 
//STRIP001         //  Define the list of properties we are interested in.
//STRIP001         Sequence<OUString> aProps (2);
//STRIP001         aProps[0] = TITLE;
//STRIP001         aProps[1] = TARGET_DIR_URL;
//STRIP001         
//STRIP001         //  Create an cursor to iterate over the template folders.
//STRIP001         ResultSetInclude eInclude = INCLUDE_FOLDERS_ONLY;
//STRIP001         Reference<XResultSet> xResultSet (aTemplateDir.createCursor (
//STRIP001             aProps, eInclude));
//STRIP001 
//STRIP001         if (xResultSet.is())
//STRIP001         {
//STRIP001             Reference<XContentAccess> xContentAccess (xResultSet, UNO_QUERY);
//STRIP001             Reference<XRow> xRow (xResultSet, UNO_QUERY);
//STRIP001 
//STRIP001             while (xResultSet->next())
//STRIP001             {
//STRIP001                 OUString aTitle (xRow->getString (1));
//STRIP001                 OUString aTargetDir (xRow->getString (2));
//STRIP001                 
//STRIP001                 OUString aId = xContentAccess->queryContentIdentifierString();
//STRIP001                 Content  aContent = Content (aId, aCmdEnv);
//STRIP001                 if (aContent.isFolder())
//STRIP001                 {
//STRIP001                     //  Scan the folder and insert it into the list of 
//STRIP001                     //  template folders.
//STRIP001                     TemplateDir* pDir = new TemplateDir (aTitle, aTargetDir);
//STRIP001                     if (pDir != NULL)
//STRIP001                     {
//STRIP001                         ScanEntries (aContent, pDir);
//STRIP001                         if (pDir->m_aEntries.empty())
//STRIP001                             delete pDir;
//STRIP001                         else
//STRIP001                         {
//STRIP001                             ::vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001                             maFolderList.push_back(pDir);
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     catch(::com::sun::star::uno::Exception&)
//STRIP001     {
//STRIP001         //  Ignore all exceptions.
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void TemplateScanner::Scan (void)
//STRIP001 {
//STRIP001     GetTemplateRoot ();
//STRIP001     ScanFolders ();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 std::vector<TemplateDir*>& TemplateScanner::GetFolderList (void)
//STRIP001 {
//STRIP001     return maFolderList;
//STRIP001 }
//STRIP001 
//STRIP001 }
}
