/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fuinsfil.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:12:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SFX_PROGRESS_HXX
#include <bf_sfx2/progress.hxx>
#endif
#ifndef _OUTLINER_HXX
#include <bf_svx/outliner.hxx>
#endif
#ifndef _EDITENG_HXX
#include <bf_svx/editeng.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <bf_sfx2/printer.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <bf_svx/svdorect.hxx>
#endif
#ifndef _SVDUNDO_HXX //autogen
#include <bf_svx/svdundo.hxx>
#endif
#ifndef _SVDOUTL_HXX //autogen
#include <bf_svx/svdoutl.hxx>
#endif
#ifndef _SFXSTBMGR_HXX //autogen
#include <bf_sfx2/stbmgr.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _FORBIDDENCHARACTERSTABLE_HXX
#include <bf_svx/forbiddencharacterstable.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX //autogen
#include <bf_sfx2/docfilt.hxx>
#endif
#ifndef _SFX_FCONTNR_HXX //autogen
#include <bf_sfx2/fcontnr.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#include <bf_svx/dialogs.hrc>

#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFilePicker.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif

#include "sdresid.hxx"
#include "fuinsfil.hxx"
#include "drawdoc.hxx"
#include "sdwindow.hxx"
#include "sdview.hxx"
#include "strings.hrc"
#include "stlpool.hxx"
#include "glob.hrc"
#include "sdpage.hxx"
#include "strmname.h"
#include "strings.hrc"
#include "drviewsh.hxx"
#include "outlview.hxx"
#include "docshell.hxx"
#include "app.hrc"
#include "unmovss.hxx"
#include "inspagob.hxx"
#include "sdoutl.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star;
using namespace ::rtl;


//STRIP001 TYPEINIT1( FuInsertFile, FuPoor );
//STRIP001 
//STRIP001 #define POOL_BUFFER_SIZE		(USHORT)32768
//STRIP001 #define BASIC_BUFFER_SIZE		(USHORT)8192
//STRIP001 #define DOCUMENT_BUFFER_SIZE	(USHORT)32768
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuInsertFile::FuInsertFile(SdViewShell*    pViewSh,
//STRIP001 						   SdWindow*	   pWin,
//STRIP001 						   SdView*		   pView,
//STRIP001 						   SdDrawDocument* pDoc,
//STRIP001 						   SfxRequest&	   rReq)
//STRIP001 		   : FuPoor(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	SfxFilterMatcher&       rMatcher = SFX_APP()->GetFilterMatcher();
//STRIP001     ::std::vector< String > aFilterVector;
//STRIP001 	const SfxItemSet*       pArgs = rReq.GetArgs ();
//STRIP001 
//STRIP001     FuInsertFile::GetSupportedFilterVector( aFilterVector );
//STRIP001     
//STRIP001     if (!pArgs)
//STRIP001 	{
//STRIP001         sfx2::FileDialogHelper      aFileDialog( WB_OPEN | SFXWB_INSERT | WB_STDMODAL );
//STRIP001 		Reference< XFilePicker >    xFilePicker( aFileDialog.GetFilePicker(), UNO_QUERY );
//STRIP001 		Reference< XFilterManager > xFilterManager( xFilePicker, UNO_QUERY );
//STRIP001 		SfxFilterContainer*	        pCont = NULL;
//STRIP001 		const SfxFilter*	        pFilter = NULL;
//STRIP001 
//STRIP001 		aFileDialog.SetTitle( String( SdResId(STR_DLG_INSERT_PAGES_FROM_FILE ) ) );
//STRIP001 
//STRIP001 		if( pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS )
//STRIP001 			pCont = rMatcher.GetContainer( String( RTL_CONSTASCII_USTRINGPARAM( "simpress" ) ) );
//STRIP001 		else
//STRIP001 			pCont = rMatcher.GetContainer( String( RTL_CONSTASCII_USTRINGPARAM( "sdraw" ) ) );
//STRIP001 
//STRIP001 		if( xFilterManager.is() )
//STRIP001 		{
//STRIP001     		// Get filter for current format
//STRIP001 			try
//STRIP001 			{
//STRIP001         		String  aExt;
//STRIP001             	String  aAllSpec( SdResId( STR_ALL_FILES ) );
//STRIP001 
//STRIP001 				xFilterManager->appendFilter( aAllSpec, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.*" ) ) );
//STRIP001 				xFilterManager->setCurrentFilter( aAllSpec ); // set default-filter (<All>)
//STRIP001 
//STRIP001 				// Get main filter
//STRIP001                 pFilter = pCont->GetFilter( 0 );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001 				// Get Draw filter for Impress and Impress filter for Draw as secondary filter
//STRIP001 				if( pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS )
//STRIP001 					aExt = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ".sxd" ) );
//STRIP001 				else
//STRIP001 					aExt = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ".sxi" ) );
//STRIP001 
//STRIP001 				pFilter = pCont->GetFilter4Extension( aExt );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001 				// Get other filters
//STRIP001 				pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARIMPRESS_50 );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 			
//STRIP001             	pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARIMPRESS_50, SFX_FILTER_TEMPLATEPATH );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001 				pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW_50 );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 			
//STRIP001             	pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW_50, SFX_FILTER_TEMPLATEPATH  );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001 				pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW_40 );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 			
//STRIP001             	pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW_40, SFX_FILTER_TEMPLATEPATH  );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001 				pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 			
//STRIP001             	pFilter = pCont->GetFilter4ClipBoardId( SOT_FORMATSTR_ID_STARDRAW, SFX_FILTER_TEMPLATEPATH  );
//STRIP001 				if( pFilter )
//STRIP001 					xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001                 // add additional supported filters
//STRIP001                 ::std::vector< String >::const_iterator aIter( aFilterVector.begin() );
//STRIP001 
//STRIP001                 while( aIter != aFilterVector.end() )
//STRIP001                 {
//STRIP001                     if( ( pFilter = rMatcher.GetFilter4Mime( *aIter ) ) != NULL )
//STRIP001     		            xFilterManager->appendFilter( pFilter->GetUIName(), pFilter->GetDefaultExtension() );
//STRIP001 
//STRIP001                     ++aIter;
//STRIP001                 }
//STRIP001 			}
//STRIP001 			catch(IllegalArgumentException)
//STRIP001 			{
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( aFileDialog.Execute() != ERRCODE_NONE )
//STRIP001 			return;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aFilterName = aFileDialog.GetCurrentFilter();
//STRIP001 			aFile = aFileDialog.GetPath();
//STRIP001 			so3::StaticBaseUrl::SetBaseURL( aFile );
//STRIP001 			aFile = so3::StaticBaseUrl::SmartRelToAbs( aFile, FALSE,
//STRIP001 												INetURLObject::WAS_ENCODED,
//STRIP001 												INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SFX_REQUEST_ARG (rReq, pFileName, SfxStringItem, ID_VAL_DUMMY0, FALSE);
//STRIP001 		SFX_REQUEST_ARG (rReq, pFilterName, SfxStringItem, ID_VAL_DUMMY1, FALSE);
//STRIP001 
//STRIP001 		aFile = pFileName->GetValue ();
//STRIP001 
//STRIP001 		if( pFilterName )
//STRIP001 			aFilterName = pFilterName->GetValue ();
//STRIP001 		else
//STRIP001 			aFilterName = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.sdd" ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 	SfxMedium*			pMedium = new SfxMedium( aFile, STREAM_READ | STREAM_NOCREATE, FALSE );
//STRIP001 	const SfxFilter*	pFilter = NULL;
//STRIP001 	ErrCode				nErr = SFX_APP()->GetFilterMatcher().GuessFilter( *pMedium, &pFilter, SFX_FILTER_IMPORT, SFX_FILTER_NOTINSTALLED | SFX_FILTER_EXECUTABLE );
//STRIP001 	BOOL				bDrawMode = pViewSh->ISA(SdDrawViewShell);
//STRIP001     BOOL                bInserted = FALSE;
//STRIP001 
//STRIP001 	if( pFilter )
//STRIP001     {
//STRIP001 		pMedium->SetFilter( pFilter );
//STRIP001         aFilterName = pFilter->GetFilterName();
//STRIP001     }
//STRIP001 
//STRIP001 	if( pMedium->IsStorage() )
//STRIP001 	{
//STRIP001 		// Storage
//STRIP001 		SvStorage* pStorage = pMedium->GetStorage();
//STRIP001 
//STRIP001 		if( pStorage )
//STRIP001         {
//STRIP001             BOOL bOwnDocument = FALSE;
//STRIP001 
//STRIP001             if( pStorage->IsStream( pStarDrawDoc ) || pStorage->IsStream( pStarDrawDoc3 ) )
//STRIP001             {
//STRIP001                 // binary document
//STRIP001                 bOwnDocument = TRUE;
//STRIP001             }
//STRIP001             else if( ( pStorage->IsStream( pStarDrawXMLContent ) || pStorage->IsStream( pStarDrawOldXMLContent ) ) &&
//STRIP001                      ( !pFilter || 
//STRIP001                        ( aFilterName.SearchAscii( "StarOffice XML (Draw)" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "StarOffice XML (Impress)" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "draw_StarOffice_XML_Impress" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "impress_StarOffice_XML_Draw" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "impress_StarOffice_XML_Impress_Template" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "draw_StarOffice_XML_Draw_Template" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "draw_StarOffice_XML_Draw" ) != STRING_NOTFOUND ||
//STRIP001 				         aFilterName.SearchAscii( "impress_StarOffice_XML_Impress" ) != STRING_NOTFOUND ) ) )
//STRIP001             {
//STRIP001                 // XML document
//STRIP001                 bOwnDocument = TRUE;
//STRIP001             }
//STRIP001 		
//STRIP001             if( bOwnDocument )
//STRIP001             {
//STRIP001 			    pMedium->Close();
//STRIP001 
//STRIP001 			    if( bDrawMode )
//STRIP001 				    InsSDDinDrMode( pMedium );
//STRIP001 			    else
//STRIP001 				    InsSDDinOlMode( pMedium );
//STRIP001 
//STRIP001                 bInserted = TRUE;
//STRIP001             }
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( pFilter )
//STRIP001 	{
//STRIP001         BOOL bFound = ( ::std::find( aFilterVector.begin(), aFilterVector.end(), pFilter->GetMimeType() ) != aFilterVector.end() );
//STRIP001 
//STRIP001         if( !bFound &&
//STRIP001             ( aFilterName.SearchAscii( "Text" ) != STRING_NOTFOUND ||
//STRIP001 			  aFilterName.SearchAscii( "Rich" ) != STRING_NOTFOUND ||
//STRIP001               aFilterName.SearchAscii( "RTF" )  != STRING_NOTFOUND ||
//STRIP001 			  aFilterName.SearchAscii( "HTML" ) != STRING_NOTFOUND ) )
//STRIP001         {
//STRIP001             bFound = TRUE;
//STRIP001         }
//STRIP001 
//STRIP001         if( bFound )
//STRIP001 		{
//STRIP001 			if( bDrawMode )
//STRIP001 				InsTextOrRTFinDrMode(pMedium);
//STRIP001 			else
//STRIP001 				InsTextOrRTFinOlMode(pMedium);
//STRIP001 
//STRIP001             bInserted = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pMedium;
//STRIP001 	pDocSh->SetWaitCursor( FALSE );
//STRIP001 
//STRIP001     if( !bInserted )
//STRIP001     {
//STRIP001         ErrorBox aErrorBox( pWindow, WB_OK, String( SdResId( STR_READ_DATA_ERROR ) ) );
//STRIP001 		aErrorBox.Execute();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 FuInsertFile::~FuInsertFile()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::Activate()
//STRIP001 {
//STRIP001 	FuPoor::Activate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::Deactivate()
//STRIP001 {
//STRIP001 	FuPoor::Deactivate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL FuInsertFile::InsSDDinDrMode(SfxMedium* pMedium)
//STRIP001 {
//STRIP001 	BOOL bOK = FALSE;
//STRIP001 
//STRIP001 	// Liste mit Seitennamen (wenn NULL, dann alle Seiten)
//STRIP001 	List* pBookmarkList = NULL;
//STRIP001 
//STRIP001 	pDocSh->SetWaitCursor( FALSE );
//STRIP001 	SdInsertPagesObjsDlg* pDlg = new SdInsertPagesObjsDlg( NULL, pDoc,
//STRIP001 													pMedium, aFile );
//STRIP001 
//STRIP001 	// Ev. wird eine QueryBox geoeffnet ("Links aktualisieren?"),
//STRIP001 	// daher wird der Dialog der aktuelle DefModalDialogParent
//STRIP001 	Window* pDefParent = GetpApp()->GetDefDialogParent();
//STRIP001 	GetpApp()->SetDefDialogParent(pDlg);
//STRIP001 
//STRIP001 	USHORT nRet = pDlg->Execute();
//STRIP001 
//STRIP001 	GetpApp()->SetDefDialogParent(pDefParent);
//STRIP001 
//STRIP001 	pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 	if( nRet == RET_OK )
//STRIP001 	{
//STRIP001 		// Zuerst Seiten einfuegen
//STRIP001 		pBookmarkList = pDlg->GetList( 1 ); // Seiten
//STRIP001 		BOOL bLink = pDlg->IsLink();
//STRIP001 		BOOL bReplace = FALSE;
//STRIP001 		SdPage* pPage = NULL;
//STRIP001 		SdView* pView = pViewShell->GetView();
//STRIP001 
//STRIP001 		if (pView->ISA(SdOutlineView))
//STRIP001 		{
//STRIP001 			pPage = ((SdOutlineView*) pView)->GetActualPage();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pPage = (SdPage*) pView->GetPageViewPvNum(0)->GetPage();
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nPos = 0xFFFF;
//STRIP001 
//STRIP001 		if (pPage && !pPage->IsMasterPage())
//STRIP001 		{
//STRIP001 			if (pPage->GetPageKind() == PK_STANDARD)
//STRIP001 			{
//STRIP001 				nPos = pPage->GetPageNum() + 2;
//STRIP001 			}
//STRIP001 			else if (pPage->GetPageKind() == PK_NOTES)
//STRIP001 			{
//STRIP001 				nPos = pPage->GetPageNum() + 1;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL  bNameOK;
//STRIP001 		List* pObjectBookmarkList = pDlg->GetList( 2 ); // Objekte
//STRIP001 		List* pExchangeList = NULL;
//STRIP001 
//STRIP001 		// Es werden ausgewaehlte Seiten und/oder ausgewaehlte Objekte oder
//STRIP001 		// alles eingefuegt, wenn pBookmarkList NULL ist!
//STRIP001 		if( pBookmarkList || !pObjectBookmarkList )
//STRIP001 		{
//STRIP001 			// Um zu gewaehrleisten, dass alle Seitennamen eindeutig sind, werden
//STRIP001 			// die einzufuegenden geprueft und gegebenenfalls in einer Ersatzliste
//STRIP001 			// aufgenommen
//STRIP001 			// bNameOK == FALSE -> Benutzer hat abgebrochen
//STRIP001 			bNameOK = pView->GetExchangeList( pExchangeList, pBookmarkList, 0 );
//STRIP001 
//STRIP001 			if( bNameOK )
//STRIP001 				bOK = pDoc->InsertBookmarkAsPage( pBookmarkList, pExchangeList,
//STRIP001 									bLink, bReplace, nPos,
//STRIP001 									FALSE, NULL, TRUE, TRUE, FALSE );
//STRIP001 
//STRIP001 			// Loeschen der BookmarkList
//STRIP001 			if( pBookmarkList )
//STRIP001 			{
//STRIP001 				String* pString = (String*) pBookmarkList->First();
//STRIP001 				while( pString )
//STRIP001 				{
//STRIP001 					delete pString;
//STRIP001 					pString = (String*) pBookmarkList->Next();
//STRIP001 				}
//STRIP001 				delete pBookmarkList;
//STRIP001 				pBookmarkList = NULL;
//STRIP001 			}
//STRIP001 			// Loeschen der ExchangeList
//STRIP001 			if( pExchangeList )
//STRIP001 			{
//STRIP001 				String* pString = (String*) pExchangeList->First();
//STRIP001 				while( pString )
//STRIP001 				{
//STRIP001 					delete pString;
//STRIP001 					pString = (String*) pExchangeList->Next();
//STRIP001 				}
//STRIP001 				delete pExchangeList;
//STRIP001 				pExchangeList = NULL;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// Dann Objekte einfuegen
//STRIP001 		//pBookmarkList = pDlg->GetList( 2 ); // Objekte
//STRIP001 		pBookmarkList = pObjectBookmarkList;
//STRIP001 
//STRIP001 		// Um zu gewaehrleisten... (s.o.)
//STRIP001 		bNameOK = pView->GetExchangeList( pExchangeList, pBookmarkList, 1 );
//STRIP001 
//STRIP001 		if( bNameOK )
//STRIP001 			bOK = pDoc->InsertBookmarkAsObject( pBookmarkList, pExchangeList,
//STRIP001 								bLink, NULL, NULL);
//STRIP001 
//STRIP001 		// Loeschen der BookmarkList
//STRIP001 		if( pBookmarkList )
//STRIP001 		{
//STRIP001 			String* pString = (String*) pBookmarkList->First();
//STRIP001 			while( pString )
//STRIP001 			{
//STRIP001 				delete pString;
//STRIP001 				pString = (String*) pBookmarkList->Next();
//STRIP001 			}
//STRIP001 			delete pBookmarkList;
//STRIP001 			pBookmarkList = NULL;
//STRIP001 		}
//STRIP001 		// Loeschen der ExchangeList
//STRIP001 		if( pExchangeList )
//STRIP001 		{
//STRIP001 			String* pString = (String*) pExchangeList->First();
//STRIP001 			while( pString )
//STRIP001 			{
//STRIP001 				delete pString;
//STRIP001 				pString = (String*) pExchangeList->Next();
//STRIP001 			}
//STRIP001 			delete pExchangeList;
//STRIP001 			pExchangeList = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pDlg->IsRemoveUnnessesaryMasterPages() )
//STRIP001 			pDoc->RemoveUnnessesaryMasterPages();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDlg;
//STRIP001 
//STRIP001 	return (bOK);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::InsTextOrRTFinDrMode(SfxMedium* pMedium)
//STRIP001 {
//STRIP001 	pDocSh->SetWaitCursor( FALSE );
//STRIP001 	SdInsertPagesObjsDlg* pDlg = new SdInsertPagesObjsDlg( NULL, pDoc,
//STRIP001 														NULL, aFile );
//STRIP001 
//STRIP001 	USHORT nRet = pDlg->Execute();
//STRIP001 	pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 	if( nRet == RET_OK )
//STRIP001 	{
//STRIP001 		BOOL bLink = pDlg->IsLink();
//STRIP001 
//STRIP001 		// gewaehltes Dateiformat: Text oder RTF oder HTML (Default ist Text)
//STRIP001 		USHORT nFormat = EE_FORMAT_TEXT;
//STRIP001 
//STRIP001 		if( aFilterName.SearchAscii( "Rich") != STRING_NOTFOUND )
//STRIP001 			nFormat = EE_FORMAT_RTF;
//STRIP001 		else if( aFilterName.SearchAscii( "HTML" ) != STRING_NOTFOUND )
//STRIP001 			nFormat = EE_FORMAT_HTML;
//STRIP001 
//STRIP001 		// einen eigenen Outliner erzeugen, denn:
//STRIP001 		// der Dokument-Outliner koennte gerade vom Gliederungsmodus
//STRIP001 		// benutzt werden;
//STRIP001 		// der Draw-Outliner der Drawing Engine koennte zwischendurch
//STRIP001 		// was zeichnen muessen;
//STRIP001 		// der globale Outliner koennte in SdPage::CreatePresObj
//STRIP001 		// benutzt werden
//STRIP001 //		SfxItemPool* pPool = pDoc->GetDrawOutliner().GetEmptyItemSet().GetPool();
//STRIP001 		SdrOutliner* pOutliner = new SdOutliner( pDoc, OUTLINERMODE_TEXTOBJECT );
//STRIP001 //		pOutliner->SetStyleSheetPool((SfxStyleSheetPool*)pDoc->GetStyleSheetPool());
//STRIP001 //		pOutliner->SetEditTextObjectPool(pPool);
//STRIP001 //		pOutliner->SetForbiddenCharsTable( pDoc->GetForbiddenCharsTable() );
//STRIP001 
//STRIP001 		// Referenz-Device setzen
//STRIP001 		pOutliner->SetRefDevice( SD_MOD()->GetRefDevice( *pDocSh ) );
//STRIP001 
//STRIP001 		SdPage* pPage = ((SdDrawViewShell*)pViewShell)->GetActualPage();
//STRIP001 		aLayoutName = pPage->GetLayoutName();
//STRIP001 		aLayoutName.Erase(aLayoutName.SearchAscii(SD_LT_SEPARATOR));
//STRIP001 
//STRIP001 		pOutliner->SetPaperSize(pPage->GetSize());
//STRIP001 		pOutliner->SetMinDepth(0);
//STRIP001 
//STRIP001 		SvStream* pStream = pMedium->GetInStream();
//STRIP001 		DBG_ASSERT( pStream, "Kein InStream!" );
//STRIP001 		pStream->Seek( 0 );
//STRIP001 
//STRIP001 		ULONG nErr = pOutliner->Read( *pStream, nFormat, pDocSh->GetHeaderAttributes() );
//STRIP001 
//STRIP001 		if (nErr || !pOutliner->GetEditEngine().GetText().Len())
//STRIP001 		{
//STRIP001 			ErrorBox aErrorBox( pWindow, (WinBits)WB_OK,
//STRIP001 					  String(SdResId(STR_READ_DATA_ERROR)));
//STRIP001 			aErrorBox.Execute();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// ist es eine Masterpage?
//STRIP001 			if (((SdDrawViewShell*)pViewShell)->GetEditMode() == EM_MASTERPAGE &&
//STRIP001 				!pPage->IsMasterPage())
//STRIP001 			{
//STRIP001 				pPage = (SdPage*)pPage->GetMasterPage(0);
//STRIP001 			}
//STRIP001 
//STRIP001 			DBG_ASSERT(pPage, "Seite nicht gefunden");
//STRIP001 
//STRIP001 			// wenn gerade editiert wird, in dieses Textobjekt einfliessen lassen
//STRIP001 			OutlinerView* pOutlinerView = pView->GetTextEditOutlinerView();
//STRIP001 			if( pOutlinerView )
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pView->GetTextEditObject();
//STRIP001 				if( pObj &&
//STRIP001 					pObj->GetObjInventor()   == SdrInventor &&
//STRIP001 					pObj->GetObjIdentifier() == OBJ_TITLETEXT &&
//STRIP001 					pOutliner->GetParagraphCount() > 1 )
//STRIP001 				{
//STRIP001 					// In Titelobjekten darf nur ein Absatz vorhanden sein
//STRIP001 					while ( pOutliner->GetParagraphCount() > 1 )
//STRIP001 					{
//STRIP001 						Paragraph* pPara = pOutliner->GetParagraph( 0 );
//STRIP001 						ULONG nLen = pOutliner->GetText( pPara, 1 ).Len();
//STRIP001 						pOutliner->QuickDelete( ESelection( 0, (USHORT) nLen, 1, 0 ) );
//STRIP001 						pOutliner->QuickInsertLineBreak( ESelection( 0, (USHORT) nLen, 0, (USHORT) nLen ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			OutlinerParaObject* pOPO = pOutliner->CreateParaObject();
//STRIP001 
//STRIP001 			if (pOutlinerView)
//STRIP001 			{
//STRIP001 				pOutlinerView->InsertText(*pOPO);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SdrRectObj* pTO = new SdrRectObj(OBJ_TEXT);
//STRIP001 				pTO->SetOutlinerParaObject(pOPO);
//STRIP001 
//STRIP001 				pView->BegUndo(String(SdResId(STR_UNDO_INSERT_TEXTFRAME)));
//STRIP001 				pPage->InsertObject(pTO);
//STRIP001 
//STRIP001 				// koennte groesser sein als die max. erlaubte Groesse:
//STRIP001 				// falls noetig, die Objektgroesse begrenzen
//STRIP001 				Size aSize(pOutliner->CalcTextSize());
//STRIP001 				Size aMaxSize = pDoc->GetMaxObjSize();
//STRIP001 				aSize.Height() = Min(aSize.Height(), aMaxSize.Height());
//STRIP001 				aSize.Width()  = Min(aSize.Width(), aMaxSize.Width());
//STRIP001 				aSize = pWindow->LogicToPixel(aSize);
//STRIP001 
//STRIP001 				// in der Mitte des Fensters absetzen
//STRIP001 				Size aTemp(pWindow->GetOutputSizePixel());
//STRIP001 				Point aPos(aTemp.Width() / 2, aTemp.Height() / 2);
//STRIP001 				aPos.X() -= aSize.Width() / 2;
//STRIP001 				aPos.Y() -= aSize.Height() / 2;
//STRIP001 				aSize = pWindow->PixelToLogic(aSize);
//STRIP001 				aPos = pWindow->PixelToLogic(aPos);
//STRIP001 				pTO->SetLogicRect(Rectangle(aPos, aSize));
//STRIP001 
//STRIP001 				if (pDlg->IsLink())
//STRIP001 				{
//STRIP001 					pTO->SetTextLink(aFile, aFilterName, gsl_getSystemTextEncoding() );
//STRIP001 				}
//STRIP001 
//STRIP001 				pView->AddUndo(new SdrUndoInsertObj(*pTO));
//STRIP001 				pView->EndUndo();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pOutliner;
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::InsTextOrRTFinOlMode(SfxMedium* pMedium)
//STRIP001 {
//STRIP001 	// gewaehltes Dateiformat: Text oder RTF oder HTML (Default ist Text)
//STRIP001 	USHORT nFormat = EE_FORMAT_TEXT;
//STRIP001 
//STRIP001 	if( aFilterName.SearchAscii( "Rich") != STRING_NOTFOUND )
//STRIP001 		nFormat = EE_FORMAT_RTF;
//STRIP001 	else if( aFilterName.SearchAscii( "HTML" ) != STRING_NOTFOUND )
//STRIP001 		nFormat = EE_FORMAT_HTML;
//STRIP001 
//STRIP001 	Outliner*	   pDocliner = ((SdOutlineView*)pView)->GetOutliner();
//STRIP001 	List*		   pList	 = pDocliner->GetView(0)->CreateSelectionList();
//STRIP001 	Paragraph*	   pPara	 = (Paragraph*)pList->First();
//STRIP001 
//STRIP001 	// wo soll eingefuegt werden?
//STRIP001 	while ( pDocliner->GetDepth( (USHORT) pDocliner->GetAbsPos( pPara ) ) != 0)
//STRIP001 	{
//STRIP001 		pPara = pDocliner->GetParent(pPara);
//STRIP001 	}
//STRIP001 	ULONG nTargetPos = pDocliner->GetAbsPos(pPara) + 1;
//STRIP001 
//STRIP001 	// Layout der Vorgaengerseite uebernehmen
//STRIP001 	USHORT nPage = 0;
//STRIP001 	pPara = pDocliner->GetParagraph( pDocliner->GetAbsPos( pPara ) - 1 );
//STRIP001 	while (pPara)
//STRIP001 	{
//STRIP001 		ULONG nPos = pDocliner->GetAbsPos( pPara );
//STRIP001 		if ( pDocliner->GetDepth( (USHORT) nPos ) == 0 )
//STRIP001 			nPage++;
//STRIP001 		pPara = pDocliner->GetParagraph( nPos - 1 );
//STRIP001 	}
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 	aLayoutName = pPage->GetLayoutName();
//STRIP001 	aLayoutName.Erase(aLayoutName.SearchAscii(SD_LT_SEPARATOR));
//STRIP001 
//STRIP001 	// einen eigenen Outliner erzeugen, denn:
//STRIP001 	// der Dokument-Outliner koennte gerade vom Gliederungsmodus
//STRIP001 	// benutzt werden;
//STRIP001 	// der Draw-Outliner der Drawing Engine koennte zwischendurch
//STRIP001 	// was zeichnen muessen;
//STRIP001 	// der globale Outliner koennte in SdPage::CreatePresObj
//STRIP001 	// benutzt werden
//STRIP001 	Outliner* pOutliner = new Outliner( &pDoc->GetItemPool(), OUTLINERMODE_OUTLINEOBJECT );
//STRIP001 	pOutliner->SetStyleSheetPool((SfxStyleSheetPool*)pDoc->GetStyleSheetPool());
//STRIP001 
//STRIP001 	// Referenz-Device setzen
//STRIP001 	pOutliner->SetRefDevice(SD_MOD()->GetRefDevice( *pDocSh ));
//STRIP001 	pOutliner->SetPaperSize(Size(0x7fffffff, 0x7fffffff));
//STRIP001 
//STRIP001 	SvStream* pStream = pMedium->GetInStream();
//STRIP001 	DBG_ASSERT( pStream, "Kein InStream!" );
//STRIP001 	pStream->Seek( 0 );
//STRIP001 
//STRIP001 	ULONG nErr = pOutliner->Read(*pStream, nFormat, pDocSh->GetHeaderAttributes());
//STRIP001 
//STRIP001 	if (nErr || !pOutliner->GetEditEngine().GetText().Len())
//STRIP001 	{
//STRIP001 		ErrorBox aErrorBox( pWindow, (WinBits)WB_OK,
//STRIP001 				  String(SdResId(STR_READ_DATA_ERROR)));
//STRIP001 		aErrorBox.Execute();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ULONG nParaCount = pOutliner->GetParagraphCount();
//STRIP001 
//STRIP001 		// fuer Fortschrittsanzeige: Anzahl der Ebene-0-Absaetze
//STRIP001 		USHORT nNewPages = 0;
//STRIP001 		pPara = pOutliner->GetParagraph( 0 );
//STRIP001 		while (pPara)
//STRIP001 		{
//STRIP001 			ULONG nPos = pOutliner->GetAbsPos( pPara );
//STRIP001 			if( pOutliner->GetDepth( (USHORT) nPos ) == 0 )
//STRIP001 				nNewPages++;
//STRIP001 			pPara = pOutliner->GetParagraph( ++nPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocSh->SetWaitCursor( FALSE );
//STRIP001 
//STRIP001 		SfxProgress* pProgress = new SfxProgress( pDocSh, String( SdResId(STR_CREATE_PAGES)), nNewPages);
//STRIP001 		if( pProgress )
//STRIP001 			pProgress->SetState( 0, 100 );
//STRIP001 
//STRIP001 		nNewPages = 0;
//STRIP001 
//STRIP001 		pDocliner->GetUndoManager().EnterListAction(
//STRIP001 									String(SdResId(STR_UNDO_INSERT_FILE)), String() );
//STRIP001 
//STRIP001 		ULONG nSourcePos = 0;
//STRIP001 		SfxStyleSheet* pStyleSheet = pPage->GetStyleSheetForPresObj( PRESOBJ_OUTLINE );
//STRIP001 		Paragraph* pSourcePara = pOutliner->GetParagraph( 0 );
//STRIP001 		while (pSourcePara)
//STRIP001 		{
//STRIP001 			ULONG nPos = pOutliner->GetAbsPos( pSourcePara );
//STRIP001 			USHORT nDepth = pOutliner->GetDepth( (USHORT) nPos );
//STRIP001 
//STRIP001 			// den letzte Absatz nur uebernehmen, wenn er gefuellt ist
//STRIP001 			if (nSourcePos < nParaCount - 1 ||
//STRIP001 				pOutliner->GetText(pSourcePara).Len() > 0)
//STRIP001 			{
//STRIP001 				pDocliner->Insert( pOutliner->GetText(pSourcePara), nTargetPos, nDepth );
//STRIP001 				String aStyleSheetName( pStyleSheet->GetName() );
//STRIP001 				aStyleSheetName.Erase( aStyleSheetName.Len()-1, 1 );
//STRIP001 				aStyleSheetName += String::CreateFromInt32( nDepth );
//STRIP001 				SfxStyleSheetBasePool* pStylePool = pDoc->GetStyleSheetPool();
//STRIP001 				SfxStyleSheet* pOutlStyle = (SfxStyleSheet*) pStylePool->Find( aStyleSheetName, pStyleSheet->GetFamily() );
//STRIP001 				pDocliner->SetStyleSheet( nTargetPos, pOutlStyle );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nDepth == 0 )
//STRIP001 			{
//STRIP001 				nNewPages++;
//STRIP001 				if( pProgress )
//STRIP001 					pProgress->SetState( nNewPages );
//STRIP001 			}
//STRIP001 
//STRIP001 			pSourcePara = pOutliner->GetParagraph( ++nPos );
//STRIP001 			nTargetPos++;
//STRIP001 			nSourcePos++;
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocliner->GetUndoManager().LeaveListAction();
//STRIP001 
//STRIP001 		if( pProgress )
//STRIP001 			delete pProgress;
//STRIP001 
//STRIP001 		pDocSh->SetWaitCursor( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pOutliner;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::InsSDDinOlMode(SfxMedium* pMedium)
//STRIP001 {
//STRIP001 	SdOutlineView* pOlView = (SdOutlineView*)pView;
//STRIP001 
//STRIP001 	// Outliner-Inhalte ins SdDrawDocument uebertragen
//STRIP001 	pOlView->PrepareClose();
//STRIP001 
//STRIP001 	// einlesen wie im Zeichenmodus
//STRIP001 	if (InsSDDinDrMode(pMedium))
//STRIP001 	{
//STRIP001 		Outliner* pOutliner = pOlView->GetViewByWindow(pWindow)->GetOutliner();
//STRIP001 
//STRIP001 		// Benachrichtigungs-Links temporaer trennen
//STRIP001 		Link aOldParagraphInsertedHdl = pOutliner->GetParaInsertedHdl();
//STRIP001 		pOutliner->SetParaInsertedHdl( Link(NULL, NULL));
//STRIP001 		Link aOldParagraphRemovingHdl = pOutliner->GetParaRemovingHdl();
//STRIP001 		pOutliner->SetParaRemovingHdl( Link(NULL, NULL));
//STRIP001 		Link aOldDepthChangedHdl	  = pOutliner->GetDepthChangedHdl();
//STRIP001 		pOutliner->SetDepthChangedHdl( Link(NULL, NULL));
//STRIP001 		Link aOldBeginMovingHdl 	  = pOutliner->GetBeginMovingHdl();
//STRIP001 		pOutliner->SetBeginMovingHdl( Link(NULL, NULL));
//STRIP001 		Link aOldEndMovingHdl		  = pOutliner->GetEndMovingHdl();
//STRIP001 		pOutliner->SetEndMovingHdl( Link(NULL, NULL));
//STRIP001 
//STRIP001 		Link aOldStatusEventHdl 	  = pOutliner->GetStatusEventHdl();
//STRIP001 		pOutliner->SetStatusEventHdl(Link(NULL, NULL));
//STRIP001 
//STRIP001 		pOutliner->Clear();
//STRIP001 		pOlView->FillOutliner();
//STRIP001 
//STRIP001 		// Links wieder setzen
//STRIP001 		pOutliner->SetParaInsertedHdl(aOldParagraphInsertedHdl);
//STRIP001 		pOutliner->SetParaRemovingHdl(aOldParagraphRemovingHdl);
//STRIP001 		pOutliner->SetDepthChangedHdl(aOldDepthChangedHdl);
//STRIP001 		pOutliner->SetBeginMovingHdl(aOldBeginMovingHdl);
//STRIP001 		pOutliner->SetEndMovingHdl(aOldEndMovingHdl);
//STRIP001 		pOutliner->SetStatusEventHdl(aOldStatusEventHdl);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FuInsertFile::GetSupportedFilterVector( ::std::vector< String >& rFilterVector )
//STRIP001 {
//STRIP001 	SfxFilterMatcher&   rMatcher = SFX_APP()->GetFilterMatcher();
//STRIP001     const SfxFilter*    pSearchFilter = NULL;
//STRIP001 
//STRIP001     rFilterVector.clear();
//STRIP001 
//STRIP001 	if( ( pSearchFilter = rMatcher.GetFilter4Mime( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "text/plain" ) ) ) ) != NULL )
//STRIP001         rFilterVector.push_back( pSearchFilter->GetMimeType() );
//STRIP001 
//STRIP001 	if( ( pSearchFilter = rMatcher.GetFilter4Mime( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "application/rtf" ) ) ) ) != NULL )
//STRIP001         rFilterVector.push_back( pSearchFilter->GetMimeType() );
//STRIP001 
//STRIP001 	if( ( pSearchFilter = rMatcher.GetFilter4Mime( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "text/html" ) ) ) ) != NULL )
//STRIP001         rFilterVector.push_back( pSearchFilter->GetMimeType() );
//STRIP001 }
}
