/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galtheme.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:56:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//STRIP001 #define ENABLE_BYTESTRING_STREAM_OPERATORS
//STRIP001 
//STRIP001 #include <tools/urlobj.hxx>
//STRIP001 #include <tools/vcompat.hxx>
//STRIP001 #include <tools/new.hxx>
//STRIP001 #include <unotools/streamwrap.hxx>
//STRIP001 #include <unotools/ucbstreamhelper.hxx>
//STRIP001 #include <unotools/tempfile.hxx>
//STRIP001 #include <unotools/localfilehelper.hxx>
//STRIP001 #include <ucbhelper/content.hxx>
//STRIP001 #include <so3/svstor.hxx>
//STRIP001 #include <sot/formats.hxx>
//STRIP001 #include <sot/filelist.hxx>
//STRIP001 #include <vcl/virdev.hxx>
//STRIP001 #include <vcl/cvtgrf.hxx>
//STRIP001 #include <svtools/itempool.hxx>
//STRIP001 #include <bf_sfx2/docfile.hxx>
//STRIP001 #include "svdograf.hxx"
//STRIP001 #include "fmpage.hxx"
//STRIP001 #include "codec.hxx"
//STRIP001 #include "unomodel.hxx"
//STRIP001 #include "fmmodel.hxx"
//STRIP001 #include "fmview.hxx"
//STRIP001 #include "galmisc.hxx"
//STRIP001 #include "galtheme.hxx"

//STRIP001 #ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
//STRIP001 #include <com/sun/star/sdbc/XResultSet.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
//STRIP001 #include <com/sun/star/ucb/XContentAccess.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
//STRIP001 #include <com/sun/star/io/XInputStream.hpp>
//STRIP001 #endif
//STRIP001 namespace binfilter {

// --------------
// - Namespaces -
// --------------

//STRIP001 using namespace ::ucb;
//STRIP001 using namespace ::rtl;
//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::io;
//STRIP001 using namespace ::com::sun::star::ucb;

// ------------
// - SgaTheme -
// ------------

//STRIP001 GalleryTheme::GalleryTheme( Gallery* pGallery, GalleryThemeEntry* pThemeEntry ) :
//STRIP001 		pParent		( pGallery ),
//STRIP001 		pThm		( pThemeEntry ),
//STRIP001 		mnLockCount	( 0 ),
//STRIP001 		nDragPos	( 0 ),
//STRIP001 		bDragging	( FALSE )
//STRIP001 {
//STRIP001 	ImplCreateSvDrawStorage();
//STRIP001 
//STRIP001 	if( pThm->IsImported() )
//STRIP001 		aImportName = pThm->GetThemeName();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryTheme::~GalleryTheme()
//STRIP001 {
//STRIP001 	ImplWrite();
//STRIP001 
//STRIP001 	for( GalleryObject* pEntry = aObjectList.First(); pEntry; pEntry = aObjectList.Next() )
//STRIP001 		delete pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::ImplCreateSvDrawStorage()
//STRIP001 {
//STRIP001 	if( !pThm->IsImported() )
//STRIP001 		aSvDrawStorageRef = new SvStorage( FALSE, GetSdvURL().GetMainURL( INetURLObject::NO_DECODE ), pThm->IsReadOnly() ? STREAM_READ : STREAM_STD_READWRITE );
//STRIP001 	else
//STRIP001 		aSvDrawStorageRef.Clear();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::ImplWriteSgaObject( const SgaObject& rObj, ULONG nPos, GalleryObject* pExistentEntry )
//STRIP001 {
//STRIP001 	SvStream*	pOStm = ::utl::UcbStreamHelper::CreateStream( GetSdgURL().GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE );
//STRIP001 	BOOL		bRet = FALSE;
//STRIP001 
//STRIP001 	if( pOStm )
//STRIP001 	{
//STRIP001 		const sal_uInt32 nOffset = pOStm->Seek( STREAM_SEEK_TO_END );
//STRIP001 
//STRIP001 		*pOStm << rObj;
//STRIP001 
//STRIP001 		if( !pOStm->GetError() )
//STRIP001 		{
//STRIP001 			GalleryObject* pEntry;
//STRIP001 
//STRIP001 			if( !pExistentEntry )
//STRIP001 			{
//STRIP001 				pEntry = new GalleryObject;
//STRIP001 				aObjectList.Insert( pEntry, nPos );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pEntry = pExistentEntry;
//STRIP001 
//STRIP001 			pEntry->aURL = rObj.GetURL();
//STRIP001 			pEntry->nOffset = nOffset;
//STRIP001 			pEntry->eObjKind = rObj.GetObjKind();
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pOStm;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObject* GalleryTheme::ImplReadSgaObject( GalleryObject* pEntry )
//STRIP001 {
//STRIP001 	SgaObject* pSgaObj = NULL;
//STRIP001 
//STRIP001 	if( pEntry )
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( GetSdgURL().GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			sal_uInt32 nInventor;
//STRIP001 
//STRIP001 			// Ueberpruefen, ob das File ein gueltiges SGA-File ist
//STRIP001 			pIStm->Seek( pEntry->nOffset );
//STRIP001 			*pIStm >> nInventor;
//STRIP001 
//STRIP001 			if( nInventor == COMPAT_FORMAT( 'S', 'G', 'A', '3' ) )
//STRIP001 			{
//STRIP001 				pIStm->Seek( pEntry->nOffset );
//STRIP001 
//STRIP001 				switch( pEntry->eObjKind )
//STRIP001 				{
//STRIP001 					case( SGA_OBJ_BMP ):	pSgaObj = new SgaObjectBmp(); break;
//STRIP001 					case( SGA_OBJ_ANIM ):	pSgaObj = new SgaObjectAnim(); break;
//STRIP001 					case( SGA_OBJ_INET ):	pSgaObj = new SgaObjectINet(); break;
//STRIP001 					case( SGA_OBJ_SVDRAW ):	pSgaObj = new SgaObjectSvDraw(); break;
//STRIP001 					case( SGA_OBJ_SOUND ):	pSgaObj = new SgaObjectSound(); break;
//STRIP001 
//STRIP001 					default:
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pSgaObj )
//STRIP001 				{
//STRIP001 					*pIStm >> *pSgaObj;
//STRIP001 					pSgaObj->ImplUpdateURL( pEntry->aURL );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSgaObj;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::ImplRead()
//STRIP001 {
//STRIP001 	SvStream* pIStm	= ::utl::UcbStreamHelper::CreateStream( GetThmURL().GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 	if( pIStm )
//STRIP001 	{
//STRIP001 		*pIStm >> *this;
//STRIP001 		delete pIStm;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::ImplWrite()
//STRIP001 {
//STRIP001 	if( IsModified() )
//STRIP001 	{
//STRIP001 		INetURLObject aPathURL( GetThmURL() );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		DBG_ASSERT( aPathURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 		if( FileExists( aPathURL ) || CreateDir( aPathURL ) )
//STRIP001 		{
//STRIP001 #ifdef UNX
//STRIP001 			SvStream* pOStm	= ::utl::UcbStreamHelper::CreateStream( GetThmURL().GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_COPY_ON_SYMLINK | STREAM_TRUNC );
//STRIP001 #else
//STRIP001 			SvStream* pOStm	= ::utl::UcbStreamHelper::CreateStream( GetThmURL().GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC );
//STRIP001 #endif
//STRIP001 			
//STRIP001 			if( pOStm )
//STRIP001 			{
//STRIP001 				*pOStm << *this;
//STRIP001 				delete pOStm;
//STRIP001 			}
//STRIP001 
//STRIP001 			ImplSetModified( FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 INetURLObject GalleryTheme::ImplGetURL( const GalleryObject* pObject ) const
//STRIP001 {
//STRIP001 	INetURLObject aURL;
//STRIP001 
//STRIP001 	if( pObject )
//STRIP001 	{
//STRIP001 		if( IsImported() )
//STRIP001 		{
//STRIP001 			INetURLObject aPathURL( GetParent()->GetImportURL( GetName() ) );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 			aPathURL.Append( pObject->aURL.GetName() );
//STRIP001 			aURL = aPathURL;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aURL = pObject->aURL;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aURL;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 INetURLObject GalleryTheme::ImplCreateUniqueURL( SgaObjKind eObjKind, ULONG nFormat )
//STRIP001 {
//STRIP001     INetURLObject   aDir( GetParent()->GetUserURL() );
//STRIP001     INetURLObject   aInfoFileURL( GetParent()->GetUserURL() );
//STRIP001     INetURLObject   aNewURL;
//STRIP001 	sal_uInt32		nNextNumber;
//STRIP001     sal_Char*       pExt;
//STRIP001     BOOL            bExists;
//STRIP001 
//STRIP001     aDir.Append( String( RTL_CONSTASCII_USTRINGPARAM( "dragdrop" ) ) );
//STRIP001     CreateDir( aDir );
//STRIP001 
//STRIP001 	aInfoFileURL.Append( String( RTL_CONSTASCII_USTRINGPARAM( "sdddndx1" ) ) );
//STRIP001     
//STRIP001 	// read next possible number
//STRIP001     if( FileExists( aInfoFileURL ) )
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aInfoFileURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			*pIStm >> nNextNumber; 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nNextNumber = 1999;
//STRIP001 
//STRIP001     // create extension
//STRIP001     if( nFormat )
//STRIP001     {
//STRIP001         switch( nFormat )
//STRIP001         {
//STRIP001             case( CVT_BMP ): pExt = ".bmp"; break;
//STRIP001             case( CVT_GIF ): pExt = ".gif"; break;
//STRIP001             case( CVT_JPG ): pExt = ".jpg"; break;
//STRIP001             case( CVT_MET ): pExt = ".met"; break;
//STRIP001             case( CVT_PCT ): pExt = ".pct"; break;
//STRIP001             case( CVT_PNG ): pExt = ".png"; break;
//STRIP001             case( CVT_SVM ): pExt = ".svm"; break;
//STRIP001             case( CVT_TIF ): pExt = ".tif"; break;
//STRIP001             case( CVT_WMF ): pExt = ".wmf"; break;
//STRIP001             case( CVT_EMF ): pExt = ".emf"; break;
//STRIP001 
//STRIP001             default:
//STRIP001                 pExt = ".grf";
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     do
//STRIP001     {
//STRIP001         // get URL
//STRIP001 	    if( SGA_OBJ_SVDRAW == eObjKind )
//STRIP001 	    {
//STRIP001             String aFileName( RTL_CONSTASCII_USTRINGPARAM( "gallery/svdraw/dd" ) );
//STRIP001 		    aNewURL = INetURLObject( aFileName += String::CreateFromInt32( ++nNextNumber % 99999999 ), INET_PROT_PRIV_SOFFICE );
//STRIP001 
//STRIP001             bExists = FALSE;
//STRIP001 
//STRIP001 		    for( GalleryObject* pEntry = aObjectList.First(); pEntry && !bExists; pEntry = aObjectList.Next() )
//STRIP001 			    if( pEntry->aURL == aNewURL )
//STRIP001                     bExists = TRUE;
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 	    {
//STRIP001             String aFileName( RTL_CONSTASCII_USTRINGPARAM( "dd" ) );
//STRIP001 
//STRIP001             aFileName += String::CreateFromInt32( ++nNextNumber % 999999 );
//STRIP001             aFileName += String( pExt, RTL_TEXTENCODING_ASCII_US );
//STRIP001 
//STRIP001             aNewURL = aDir;
//STRIP001 		    aNewURL.Append( aFileName );
//STRIP001             
//STRIP001             bExists = FileExists( aNewURL );
//STRIP001 	    }
//STRIP001     }
//STRIP001     while( bExists );
//STRIP001 
//STRIP001 	// write updated number
//STRIP001     SvStream* pOStm = ::utl::UcbStreamHelper::CreateStream( aInfoFileURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE );
//STRIP001 
//STRIP001 	if( pOStm )
//STRIP001 	{
//STRIP001 		*pOStm << nNextNumber;
//STRIP001 		delete pOStm;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aNewURL;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::ImplBroadcast( ULONG nUpdatePos )
//STRIP001 {
//STRIP001 	if( !IsBroadcasterLocked() )
//STRIP001 	{
//STRIP001 		if( GetObjectCount() && ( nUpdatePos >= GetObjectCount() ) )
//STRIP001 			nUpdatePos = GetObjectCount() - 1;
//STRIP001 
//STRIP001 		Broadcast( GalleryHint( GALLERY_HINT_THEME_UPDATEVIEW, GetName(), nUpdatePos ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::UnlockBroadcaster( ULONG nUpdatePos )
//STRIP001 {
//STRIP001 	DBG_ASSERT( mnLockCount, "Broadcaster is not locked" );
//STRIP001 
//STRIP001 	if( mnLockCount && !--mnLockCount )
//STRIP001 		ImplBroadcast( nUpdatePos );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertObject( const SgaObject& rObj, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rObj.IsValid() )
//STRIP001 	{
//STRIP001 		GalleryObject*	pEntry = aObjectList.First();
//STRIP001 		GalleryObject*	pFoundEntry = NULL;
//STRIP001 		ULONG			nUpdatePos = LIST_APPEND;
//STRIP001 
//STRIP001 		for( ; pEntry && !pFoundEntry; pEntry = aObjectList.Next() )
//STRIP001 			if( pEntry->aURL == rObj.GetURL() )
//STRIP001 				pFoundEntry = pEntry;
//STRIP001 
//STRIP001 		if( pFoundEntry )
//STRIP001         {
//STRIP001     		GalleryObject aNewEntry;
//STRIP001 
//STRIP001             // update title of new object if neccessary
//STRIP001             if( !rObj.GetTitle().Len() )
//STRIP001             {
//STRIP001                 SgaObject* pOldObj = ImplReadSgaObject( pFoundEntry );
//STRIP001 
//STRIP001                 if( pOldObj )
//STRIP001                 {
//STRIP001                     ( (SgaObject&) rObj ).SetTitle( pOldObj->GetTitle() );
//STRIP001                     delete pOldObj;
//STRIP001                 }
//STRIP001             }
//STRIP001             else if( rObj.GetTitle() == String( RTL_CONSTASCII_USTRINGPARAM( "__<empty>__" ) ) )
//STRIP001                 ( (SgaObject&) rObj ).SetTitle( String() );
//STRIP001 
//STRIP001             ImplWriteSgaObject( rObj, nInsertPos, &aNewEntry );
//STRIP001 			pFoundEntry->nOffset = aNewEntry.nOffset;
//STRIP001         }
//STRIP001 		else
//STRIP001 			ImplWriteSgaObject( rObj, nInsertPos, NULL );
//STRIP001 
//STRIP001 		ImplSetModified( bRet = TRUE );
//STRIP001 		ImplBroadcast( pFoundEntry ? aObjectList.GetPos( pFoundEntry ) : nInsertPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObject* GalleryTheme::AcquireObject( ULONG nPos )
//STRIP001 {
//STRIP001 	return ImplReadSgaObject( aObjectList.GetObject( nPos ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::ReleaseObject( SgaObject* pObject )
//STRIP001 {
//STRIP001 	delete pObject;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::RemoveObject( ULONG nPos )
//STRIP001 {
//STRIP001 	GalleryObject* pEntry = aObjectList.Remove( nPos );
//STRIP001 
//STRIP001 	if( !aObjectList.Count() )
//STRIP001 		KillFile( GetSdgURL() );
//STRIP001 
//STRIP001 	if( pEntry )
//STRIP001 	{
//STRIP001 		if( SGA_OBJ_SVDRAW == pEntry->eObjKind )
//STRIP001 			aSvDrawStorageRef->Remove( pEntry->aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		delete pEntry;
//STRIP001 		ImplSetModified( TRUE );
//STRIP001 		ImplBroadcast( nPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( pEntry != NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::ChangeObjectPos( ULONG nOldPos, ULONG nNewPos )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( nOldPos != nNewPos )
//STRIP001 	{
//STRIP001 		GalleryObject* pEntry = aObjectList.GetObject( nOldPos );
//STRIP001 
//STRIP001 		if( pEntry )
//STRIP001 		{
//STRIP001 			aObjectList.Insert( pEntry, nNewPos );
//STRIP001 
//STRIP001 			if( nNewPos < nOldPos )
//STRIP001 				nOldPos++;
//STRIP001 
//STRIP001 			aObjectList.Remove( nOldPos );
//STRIP001 			ImplSetModified( bRet = TRUE );
//STRIP001 			ImplBroadcast( ( nNewPos < nOldPos ) ? nNewPos : ( nNewPos - 1 ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::Actualize( const Link& rActualizeLink, GalleryProgress* pProgress )
//STRIP001 {
//STRIP001 	if( !IsReadOnly() && !IsImported() )
//STRIP001 	{
//STRIP001 		Graphic			aGraphic;
//STRIP001 		String			aFormat;
//STRIP001 		GalleryObject*	pEntry;
//STRIP001 		const ULONG		nCount = aObjectList.Count();
//STRIP001 		ULONG			i;
//STRIP001 
//STRIP001 		LockBroadcaster();
//STRIP001 		bAbortActualize = FALSE;
//STRIP001 
//STRIP001 		// LoeschFlag zuruecksetzen
//STRIP001 		for ( i = 0; i < nCount; i++ )
//STRIP001 			aObjectList.GetObject( i )->bDummy = FALSE;
//STRIP001 
//STRIP001 		for( i = 0; ( i < nCount ) && !bAbortActualize; i++ )
//STRIP001 		{
//STRIP001 			if( pProgress )
//STRIP001 				pProgress->Update( i, nCount - 1 );
//STRIP001 
//STRIP001 			pEntry = aObjectList.GetObject( i );
//STRIP001 			
//STRIP001             const INetURLObject aURL( pEntry->aURL );
//STRIP001 
//STRIP001             rActualizeLink.Call( (void*) &aURL );
//STRIP001 
//STRIP001 			// SvDraw-Objekte werden spaeter aktualisiert
//STRIP001 			if( pEntry->eObjKind != SGA_OBJ_SVDRAW )
//STRIP001 			{
//STRIP001 				// Hier muss noch etwas eingebaut werden,
//STRIP001 				// das Files auf den ensprechenden Eintrag matched
//STRIP001 				// Grafiken als Grafik-Objekte in die Gallery aufnehmen
//STRIP001 				if( pEntry->eObjKind == SGA_OBJ_SOUND )
//STRIP001 				{
//STRIP001 					SgaObjectSound aObjSound( aURL );
//STRIP001 					if( !InsertObject( aObjSound ) )
//STRIP001 						pEntry->bDummy = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aGraphic.Clear();
//STRIP001 
//STRIP001 					if ( GalleryGraphicImport( aURL, aGraphic, aFormat ) )
//STRIP001 					{
//STRIP001 						SgaObject* pNewObj;
//STRIP001 
//STRIP001 						if ( SGA_OBJ_INET == pEntry->eObjKind )
//STRIP001 							pNewObj = (SgaObject*) new SgaObjectINet( aGraphic, aURL, aFormat );
//STRIP001 						else if ( aGraphic.IsAnimated() )
//STRIP001 							pNewObj = (SgaObject*) new SgaObjectAnim( aGraphic, aURL, aFormat );
//STRIP001 						else
//STRIP001 							pNewObj = (SgaObject*) new SgaObjectBmp( aGraphic, aURL, aFormat );
//STRIP001 
//STRIP001 						if( !InsertObject( *pNewObj ) )
//STRIP001 							pEntry->bDummy = TRUE;
//STRIP001 
//STRIP001 						delete pNewObj;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pEntry->bDummy = TRUE; // Loesch-Flag setzen
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if ( aSvDrawStorageRef.Is() )
//STRIP001 				{
//STRIP001 					const String		aStmName( GetSvDrawStreamNameFromURL( pEntry->aURL ) );
//STRIP001 					SvStorageStreamRef	pIStm = aSvDrawStorageRef->OpenStream( aStmName, STREAM_READ );
//STRIP001 
//STRIP001 					if( pIStm && !pIStm->GetError() )
//STRIP001 					{
//STRIP001 						pIStm->SetBufferSize( 16384 );
//STRIP001 
//STRIP001 						SgaObjectSvDraw aNewObj( *pIStm, pEntry->aURL );
//STRIP001 						
//STRIP001                         if( !InsertObject( aNewObj ) )
//STRIP001 							pEntry->bDummy = TRUE;
//STRIP001 
//STRIP001 						pIStm->SetBufferSize( 0L );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// remove all entries with set flag
//STRIP001 		pEntry = aObjectList.First();
//STRIP001 		while( pEntry )
//STRIP001 		{
//STRIP001 			if( pEntry->bDummy )
//STRIP001 			{
//STRIP001 				delete aObjectList.Remove( pEntry );
//STRIP001 				pEntry = aObjectList.GetCurObject();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pEntry = aObjectList.Next();
//STRIP001 		}
//STRIP001 
//STRIP001 		// update theme
//STRIP001 		::utl::TempFile	aTmp;
//STRIP001 		INetURLObject	aInURL( GetSdgURL() );
//STRIP001 		INetURLObject	aTmpURL( aTmp.GetURL() );
//STRIP001 
//STRIP001 		DBG_ASSERT( aInURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 		DBG_ASSERT( aTmpURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aInURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 		SvStream* pTmpStm = ::utl::UcbStreamHelper::CreateStream( aTmpURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC );
//STRIP001 
//STRIP001 		if( pIStm && pTmpStm )
//STRIP001 		{
//STRIP001 			pEntry = aObjectList.First();
//STRIP001 
//STRIP001 			while( pEntry )
//STRIP001 			{
//STRIP001 				SgaObject* pObj;
//STRIP001 
//STRIP001 				switch( pEntry->eObjKind )
//STRIP001 				{
//STRIP001 					case( SGA_OBJ_BMP ):	pObj = new SgaObjectBmp(); break;
//STRIP001 					case( SGA_OBJ_ANIM ):	pObj = new SgaObjectAnim(); break;
//STRIP001 					case( SGA_OBJ_INET ):	pObj = new SgaObjectINet(); break;
//STRIP001 					case( SGA_OBJ_SVDRAW ):	pObj = new SgaObjectSvDraw(); break;
//STRIP001 					case (SGA_OBJ_SOUND):	pObj = new SgaObjectSound(); break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						pObj = NULL;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( pObj )
//STRIP001 				{
//STRIP001 					pIStm->Seek( pEntry->nOffset );
//STRIP001 					*pIStm >> *pObj;
//STRIP001 					pEntry->nOffset = pTmpStm->Tell();
//STRIP001 					*pTmpStm << *pObj;
//STRIP001 					delete pObj;
//STRIP001 				}
//STRIP001 
//STRIP001 				pEntry = aObjectList.Next();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERROR( "File(s) could not be opened" );
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pIStm;
//STRIP001 		delete pTmpStm;
//STRIP001 
//STRIP001 		CopyFile( aTmpURL, aInURL );
//STRIP001 		KillFile( aTmpURL );
//STRIP001 		
//STRIP001 		ULONG nStorErr = 0;
//STRIP001 
//STRIP001 		{
//STRIP001 			SvStorageRef aTempStorageRef( new SvStorage( FALSE, aTmpURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_STD_READWRITE ) );
//STRIP001 			aSvDrawStorageRef->CopyTo( aTempStorageRef );
//STRIP001 			nStorErr = aSvDrawStorageRef->GetError();
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !nStorErr )
//STRIP001 		{
//STRIP001 			aSvDrawStorageRef.Clear();
//STRIP001 			CopyFile( aTmpURL, GetSdvURL() );
//STRIP001 			ImplCreateSvDrawStorage();
//STRIP001 		}
//STRIP001 
//STRIP001 		KillFile( aTmpURL );
//STRIP001 		ImplSetModified( TRUE );
//STRIP001 		ImplWrite();
//STRIP001 		UnlockBroadcaster();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryThemeEntry* GalleryTheme::CreateThemeEntry( const INetURLObject& rURL, BOOL bReadOnly )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	GalleryThemeEntry*	pRet = NULL;
//STRIP001 
//STRIP001 	if( FileExists( rURL ) )
//STRIP001 	{
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( rURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 		
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			String			aThemeName;
//STRIP001 			sal_uInt32		nThemeId = 0;
//STRIP001 			sal_uInt16		nVersion;
//STRIP001 			BOOL			bThemeNameFromResource = FALSE;
//STRIP001 
//STRIP001 			*pIStm >> nVersion;
//STRIP001 
//STRIP001 			if( nVersion <= 0x00ff )
//STRIP001 			{
//STRIP001 				ByteString aTmpStr;
//STRIP001 
//STRIP001 				*pIStm >> aTmpStr; aThemeName = String( aTmpStr.GetBuffer(), RTL_TEXTENCODING_UTF8 );
//STRIP001 
//STRIP001 				// Charakterkonvertierung durchfuehren
//STRIP001 				if( nVersion >= 0x0004 )
//STRIP001 				{
//STRIP001 					sal_uInt32	nCount;
//STRIP001 					sal_uInt16	nTemp16;
//STRIP001 
//STRIP001 					*pIStm >> nCount >> nTemp16;
//STRIP001 					pIStm->Seek( STREAM_SEEK_TO_END );
//STRIP001 
//STRIP001 					// pruefen, ob es sich um eine neuere Version handelt;
//STRIP001 					// daher um 520Bytes (8Bytes Kennung + 512Bytes Reserverpuffer ) zurueckspringen,
//STRIP001 					// falls dies ueberhaupt moeglich ist
//STRIP001 					if( pIStm->Tell() >= 520 )
//STRIP001 					{
//STRIP001 						ULONG nId1, nId2;
//STRIP001 
//STRIP001 						pIStm->SeekRel( -520 );
//STRIP001 						*pIStm >> nId1 >> nId2;
//STRIP001 
//STRIP001 						if( nId1 == COMPAT_FORMAT( 'G', 'A', 'L', 'R' ) &&
//STRIP001 							nId2 == COMPAT_FORMAT( 'E', 'S', 'R', 'V' ) )
//STRIP001 						{
//STRIP001 							VersionCompat* pCompat = new VersionCompat( *pIStm, STREAM_READ );
//STRIP001 
//STRIP001 							*pIStm >> nThemeId;
//STRIP001 
//STRIP001 							if( pCompat->GetVersion() >= 2 )
//STRIP001 							{
//STRIP001 								*pIStm >> bThemeNameFromResource;
//STRIP001 							}
//STRIP001 
//STRIP001 							delete pCompat;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				INetURLObject aPathURL( rURL );
//STRIP001 
//STRIP001 				aPathURL.removeSegment();
//STRIP001 				aPathURL.removeFinalSlash();
//STRIP001 				pRet = new GalleryThemeEntry( aPathURL, aThemeName,
//STRIP001 											  rURL.GetBase().Copy( 2, 6 ).ToInt32(),
//STRIP001 											  bReadOnly, FALSE, FALSE, nThemeId,
//STRIP001 											  bThemeNameFromResource );
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::GetThumb( ULONG nPos, Bitmap& rBmp, BOOL bProgress )
//STRIP001 {
//STRIP001 	SgaObject*	pObj = AcquireObject( nPos );
//STRIP001 	BOOL		bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObj )
//STRIP001 	{
//STRIP001 		rBmp = pObj->GetThumbBmp();
//STRIP001 		ReleaseObject( pObj );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::GetGraphic( ULONG nPos, Graphic& rGraphic, BOOL bProgress )
//STRIP001 {
//STRIP001 	const GalleryObject*	pObject = ImplGetGalleryObject( nPos );
//STRIP001 	BOOL					bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObject )
//STRIP001 	{
//STRIP001 		const INetURLObject aURL( ImplGetURL( pObject ) );
//STRIP001 
//STRIP001 		switch( pObject->eObjKind )
//STRIP001 		{
//STRIP001 			case( SGA_OBJ_BMP ):
//STRIP001 			case( SGA_OBJ_ANIM ):
//STRIP001 			case( SGA_OBJ_INET ):
//STRIP001 			{
//STRIP001 				String aFilterDummy;
//STRIP001 				bRet = ( GalleryGraphicImport( aURL, rGraphic, aFilterDummy, bProgress ) != SGA_IMPORT_NONE );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SGA_OBJ_SVDRAW ):
//STRIP001 			{
//STRIP001 				FmFormModel	aModel;
//STRIP001 
//STRIP001 				aModel.GetItemPool().FreezeIdRanges();
//STRIP001 
//STRIP001 				if( GetModel( nPos, aModel, bProgress ) )
//STRIP001 				{
//STRIP001 					ImageMap aIMap;
//STRIP001 
//STRIP001 					if( CreateIMapGraphic( aModel, rGraphic, aIMap ) )
//STRIP001 						bRet = TRUE;
//STRIP001 					else
//STRIP001 					{
//STRIP001 						VirtualDevice aVDev;
//STRIP001 						aVDev.SetMapMode( MapMode( MAP_100TH_MM ) );
//STRIP001 						FmFormView aView( &aModel, &aVDev );
//STRIP001 
//STRIP001 						aView.SetMarkHdlHidden( TRUE );
//STRIP001 						aView.ShowPagePgNum( 0, Point() );
//STRIP001 						aView.MarkAll();
//STRIP001 						rGraphic = aView.GetAllMarkedGraphic();
//STRIP001 						bRet = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( SGA_OBJ_SOUND ):
//STRIP001 			{
//STRIP001 				SgaObject* pObj = AcquireObject( nPos );
//STRIP001 
//STRIP001 				if( pObj )
//STRIP001 				{
//STRIP001 					Bitmap aBmp( pObj->GetThumbBmp() );
//STRIP001 					aBmp.Replace( COL_LIGHTMAGENTA, COL_WHITE );
//STRIP001 					rGraphic = aBmp;
//STRIP001 					ReleaseObject( pObj );
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertGraphic( const Graphic& rGraphic, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rGraphic.GetType() != GRAPHIC_NONE )
//STRIP001     {
//STRIP001 		ULONG           nExportFormat = CVT_UNKNOWN;
//STRIP001 		const GfxLink	aGfxLink( ( (Graphic&) rGraphic ).GetLink() );
//STRIP001 
//STRIP001 		if( aGfxLink.GetDataSize() )
//STRIP001 		{
//STRIP001 			switch( aGfxLink.GetType() )
//STRIP001 			{
//STRIP001 				case( GFX_LINK_TYPE_EPS_BUFFER ): nExportFormat = CVT_SVM; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_GIF ): nExportFormat = CVT_GIF; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_JPG ): nExportFormat = CVT_JPG; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_PNG ): nExportFormat = CVT_PNG; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_TIF ): nExportFormat = CVT_TIF; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_WMF ): nExportFormat = CVT_WMF; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_MET ): nExportFormat = CVT_MET; break;
//STRIP001 				case( GFX_LINK_TYPE_NATIVE_PCT ): nExportFormat = CVT_PCT; break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 		    if( rGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 		    {
//STRIP001 			    if( rGraphic.IsAnimated() )
//STRIP001 				    nExportFormat = CVT_GIF;
//STRIP001 			    else
//STRIP001 				    nExportFormat = CVT_PNG;
//STRIP001 		    }
//STRIP001 		    else
//STRIP001                 nExportFormat = CVT_SVM;
//STRIP001 		}
//STRIP001 
//STRIP001         const INetURLObject aURL( ImplCreateUniqueURL( SGA_OBJ_BMP, nExportFormat ) );
//STRIP001 		SvStream*           pOStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC );
//STRIP001 
//STRIP001         if( pOStm )
//STRIP001         {
//STRIP001 		    pOStm->SetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 
//STRIP001             if( CVT_SVM == nExportFormat )
//STRIP001             {
//STRIP001 			    GDIMetaFile aMtf( rGraphic.GetGDIMetaFile() );
//STRIP001 
//STRIP001 			    aMtf.Write( *pOStm );
//STRIP001 			    bRet = ( pOStm->GetError() == ERRCODE_NONE );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 if( aGfxLink.GetDataSize() )
//STRIP001                 {
//STRIP001                     pOStm->Write( aGfxLink.GetData(), aGfxLink.GetDataSize() );
//STRIP001                     bRet = ( pOStm->GetError() == ERRCODE_NONE );
//STRIP001                 }
//STRIP001                 else
//STRIP001                     bRet = ( GraphicConverter::Export( *pOStm, rGraphic, nExportFormat ) == ERRCODE_NONE );
//STRIP001             }
//STRIP001 
//STRIP001             delete pOStm;
//STRIP001         }
//STRIP001 
//STRIP001 		if( bRet )
//STRIP001 		{
//STRIP001 			const SgaObjectBmp aObjBmp( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 			InsertObject( aObjBmp, nInsertPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::GetModel( ULONG nPos, FmFormModel& rModel, BOOL bProgress )
//STRIP001 {
//STRIP001 	const GalleryObject*	pObject = ImplGetGalleryObject( nPos );
//STRIP001 	BOOL					bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObject && ( SGA_OBJ_SVDRAW == pObject->eObjKind ) )
//STRIP001 	{
//STRIP001 		const INetURLObject aURL( ImplGetURL( pObject ) );
//STRIP001 		SvStorageRef		xStor( GetSvDrawStorage() );
//STRIP001 
//STRIP001 		if( xStor.Is() )
//STRIP001 		{
//STRIP001 			const String		aStmName( GetSvDrawStreamNameFromURL( aURL ) );
//STRIP001 			SvStorageStreamRef	xIStm( xStor->OpenStream( aStmName, STREAM_READ ) );
//STRIP001 
//STRIP001 			if( xIStm.Is() && !xIStm->GetError() )
//STRIP001 			{
//STRIP001 				xIStm->SetBufferSize( STREAMBUF_SIZE );
//STRIP001 				bRet = GallerySvDrawImport( *xIStm, rModel );
//STRIP001 				xIStm->SetBufferSize( 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertModel( const FmFormModel& rModel, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	INetURLObject	aURL( ImplCreateUniqueURL( SGA_OBJ_SVDRAW ) );
//STRIP001 	SvStorageRef	xStor( GetSvDrawStorage() );
//STRIP001 	BOOL			bRet = FALSE;
//STRIP001 
//STRIP001 	if( xStor.Is() )
//STRIP001 	{
//STRIP001 		const String		aStmName( GetSvDrawStreamNameFromURL( aURL ) );
//STRIP001 		SvStorageStreamRef	xOStm( xStor->OpenStream( aStmName, STREAM_WRITE | STREAM_TRUNC ) );
//STRIP001 
//STRIP001 		if( xOStm.Is() && !xOStm->GetError() )
//STRIP001 		{
//STRIP001 			SvMemoryStream	aMemStm( 65535, 65535 );
//STRIP001 			FmFormModel*	pFormModel = (FmFormModel*) &rModel;
//STRIP001 
//STRIP001 		    pFormModel->BurnInStyleSheetAttributes();
//STRIP001 		    pFormModel->SetStreamingSdrModel( TRUE );
//STRIP001 		    pFormModel->RemoveNotPersistentObjects( TRUE );
//STRIP001 		    
//STRIP001             {
//STRIP001 			    ::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream > xDocOut( new utl::OOutputStreamWrapper( aMemStm ) );
//STRIP001 		    
//STRIP001         	    if( xDocOut.is() )
//STRIP001                     SvxDrawingLayerExport( pFormModel, xDocOut );
//STRIP001 		    }
//STRIP001 
//STRIP001 		    pFormModel->SetStreamingSdrModel( FALSE );
//STRIP001             aMemStm.Seek( 0 );
//STRIP001 
//STRIP001 		    xOStm->SetBufferSize( 16348 );
//STRIP001 			GalleryCodec aCodec( *xOStm );
//STRIP001 		    aCodec.Write( aMemStm );
//STRIP001 
//STRIP001 		    if( !xOStm->GetError() )
//STRIP001 		    {
//STRIP001 			    SgaObjectSvDraw	aObjSvDraw( rModel, aURL );
//STRIP001 			    bRet = InsertObject( aObjSvDraw, nInsertPos );
//STRIP001 		    }
//STRIP001 
//STRIP001 		    xOStm->SetBufferSize( 0L );
//STRIP001             xOStm->Commit();
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::GetModelStream( ULONG nPos, SotStorageStreamRef& rxModelStream, BOOL bProgress )
//STRIP001 {
//STRIP001 	const GalleryObject*	pObject = ImplGetGalleryObject( nPos );
//STRIP001 	BOOL					bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObject && ( SGA_OBJ_SVDRAW == pObject->eObjKind ) )
//STRIP001 	{
//STRIP001 		const INetURLObject aURL( ImplGetURL( pObject ) );
//STRIP001 		SvStorageRef		xStor( GetSvDrawStorage() );
//STRIP001 
//STRIP001 		if( xStor.Is() )
//STRIP001 		{
//STRIP001 			const String		aStmName( GetSvDrawStreamNameFromURL( aURL ) );
//STRIP001 			SvStorageStreamRef	xIStm( xStor->OpenStream( aStmName, STREAM_READ ) );
//STRIP001 
//STRIP001 			if( xIStm.Is() && !xIStm->GetError() )
//STRIP001 			{
//STRIP001             	UINT32 nVersion = 0;
//STRIP001 
//STRIP001                 xIStm->SetBufferSize( 16348 );
//STRIP001 
//STRIP001 	            if( GalleryCodec::IsCoded( *xIStm, nVersion ) )
//STRIP001                 {
//STRIP001                     if( 1 == nVersion )
//STRIP001                     {
//STRIP001                         FmFormModel aModel;
//STRIP001 
//STRIP001                     	aModel.GetItemPool().FreezeIdRanges();
//STRIP001 	
//STRIP001                         if( GallerySvDrawImport( *xIStm, aModel ) )
//STRIP001                         {
//STRIP001 			                aModel.BurnInStyleSheetAttributes();
//STRIP001 			                aModel.SetStreamingSdrModel( TRUE );
//STRIP001 			                aModel.RemoveNotPersistentObjects( TRUE );
//STRIP001 
//STRIP001 			                {
//STRIP001 				                ::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream> xDocOut( new utl::OOutputStreamWrapper( *rxModelStream ) );
//STRIP001 				                
//STRIP001                                 if( SvxDrawingLayerExport( &aModel, xDocOut ) )
//STRIP001 					                rxModelStream->Commit();
//STRIP001 			                }
//STRIP001 
//STRIP001         			        aModel.SetStreamingSdrModel( FALSE );
//STRIP001                     	}
//STRIP001                     }
//STRIP001                     else if( 2 == nVersion )
//STRIP001                     {
//STRIP001                         GalleryCodec aCodec( *xIStm );
//STRIP001                         aCodec.Read( *rxModelStream );
//STRIP001                     }
//STRIP001     
//STRIP001                     bRet = ( rxModelStream->GetError() == ERRCODE_NONE );
//STRIP001                 }
//STRIP001 
//STRIP001                 xIStm->SetBufferSize( 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertModelStream( const SotStorageStreamRef& rxModelStream, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	INetURLObject	aURL( ImplCreateUniqueURL( SGA_OBJ_SVDRAW ) );
//STRIP001 	SvStorageRef	xStor( GetSvDrawStorage() );
//STRIP001 	BOOL			bRet = FALSE;
//STRIP001 
//STRIP001 	if( xStor.Is() )
//STRIP001 	{
//STRIP001 		const String		aStmName( GetSvDrawStreamNameFromURL( aURL ) );
//STRIP001 		SvStorageStreamRef	xOStm( xStor->OpenStream( aStmName, STREAM_WRITE | STREAM_TRUNC ) );
//STRIP001 
//STRIP001 		if( xOStm.Is() && !xOStm->GetError() )
//STRIP001 		{
//STRIP001             GalleryCodec    aCodec( *xOStm );
//STRIP001             SvMemoryStream  aMemStm( 65535, 65535 );
//STRIP001 
//STRIP001 		    xOStm->SetBufferSize( 16348 );
//STRIP001             aCodec.Write( *rxModelStream );
//STRIP001             
//STRIP001 		    if( !xOStm->GetError() )
//STRIP001 		    {
//STRIP001 			    xOStm->Seek( 0 );
//STRIP001                 SgaObjectSvDraw	aObjSvDraw( *xOStm, aURL );
//STRIP001 			    bRet = InsertObject( aObjSvDraw, nInsertPos );
//STRIP001 		    }
//STRIP001 
//STRIP001 		    xOStm->SetBufferSize( 0L );
//STRIP001             xOStm->Commit();
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::GetURL( ULONG nPos, INetURLObject& rURL, BOOL bProgress )
//STRIP001 {
//STRIP001 	const GalleryObject*	pObject = ImplGetGalleryObject( nPos );
//STRIP001 	BOOL					bRet = FALSE;
//STRIP001 
//STRIP001 	if( pObject )
//STRIP001 	{
//STRIP001 		rURL = INetURLObject( ImplGetURL( pObject ) );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertURL( const INetURLObject& rURL, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	Graphic			aGraphic;
//STRIP001 	String			aFormat;
//STRIP001 	SgaObject*		pNewObj = NULL;
//STRIP001 	const USHORT	nImportRet = GalleryGraphicImport( rURL, aGraphic, aFormat );
//STRIP001 	BOOL			bRet = FALSE;
//STRIP001 
//STRIP001 	if( nImportRet != SGA_IMPORT_NONE )
//STRIP001 	{
//STRIP001 		if ( SGA_IMPORT_INET == nImportRet )
//STRIP001 			pNewObj = (SgaObject*) new SgaObjectINet( aGraphic, rURL, aFormat );
//STRIP001 		else if ( aGraphic.IsAnimated() )
//STRIP001 			pNewObj = (SgaObject*) new SgaObjectAnim( aGraphic, rURL, aFormat );
//STRIP001 		else
//STRIP001 			pNewObj = (SgaObject*) new SgaObjectBmp( aGraphic, rURL, aFormat );
//STRIP001 	}
//STRIP001 	else if( GalleryIsSoundFile( rURL ) )
//STRIP001 		pNewObj = (SgaObject*) new SgaObjectSound( rURL );
//STRIP001 
//STRIP001 	if( pNewObj && InsertObject( *pNewObj, nInsertPos ) )
//STRIP001 		bRet = TRUE;
//STRIP001 
//STRIP001 	delete pNewObj;
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertFileOrDirURL( const INetURLObject& rFileOrDirURL, ULONG nInsertPos )
//STRIP001 {
//STRIP001     INetURLObject                   aURL;
//STRIP001     ::std::vector< INetURLObject >  aURLVector;
//STRIP001 	BOOL                            bRet = FALSE;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content         aCnt( rFileOrDirURL.GetMainURL( INetURLObject::NO_DECODE ), uno::Reference< XCommandEnvironment >() );
//STRIP001 		sal_Bool        bFolder;
//STRIP001 
//STRIP001 		aCnt.getPropertyValue( OUString::createFromAscii( "IsFolder" ) ) >>= bFolder;
//STRIP001 
//STRIP001 		if( bFolder )
//STRIP001 		{
//STRIP001 			uno::Sequence< OUString > aProps( 1 );
//STRIP001 			aProps.getArray()[ 0 ] == OUString::createFromAscii( "Url" );
//STRIP001 			uno::Reference< sdbc::XResultSet > xResultSet( aCnt.createCursor( aProps, INCLUDE_DOCUMENTS_ONLY ) );
//STRIP001 
//STRIP001 			if( xResultSet.is() )
//STRIP001 			{
//STRIP001 				uno::Reference< XContentAccess > xContentAccess( xResultSet, uno::UNO_QUERY );
//STRIP001 
//STRIP001 				if( xContentAccess.is() )
//STRIP001 				{
//STRIP001 					while( xResultSet->next() )
//STRIP001 					{
//STRIP001 						aURL.SetSmartURL( xContentAccess->queryContentIdentifierString() );
//STRIP001                         aURLVector.push_back( aURL );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001             aURLVector.push_back( rFileOrDirURL );
//STRIP001 	}
//STRIP001 	catch( const ContentCreationException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001     ::std::vector< INetURLObject >::const_iterator aIter( aURLVector.begin() ), aEnd( aURLVector.end() );
//STRIP001 
//STRIP001     while( aIter != aEnd )
//STRIP001         bRet = bRet || InsertURL( *aIter++, nInsertPos );
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryTheme::InsertTransferable( const ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable >& rxTransferable, ULONG nInsertPos )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rxTransferable.is() )
//STRIP001 	{
//STRIP001 		TransferableDataHelper	aDataHelper( rxTransferable );
//STRIP001 		Graphic*				pGraphic = NULL;
//STRIP001 
//STRIP001 		if( aDataHelper.HasFormat( SOT_FORMATSTR_ID_DRAWING ) )
//STRIP001 		{
//STRIP001 			SotStorageStreamRef xModelStm;
//STRIP001 
//STRIP001 			if( aDataHelper.GetSotStorageStream( SOT_FORMATSTR_ID_DRAWING, xModelStm ) )
//STRIP001 				bRet = InsertModelStream( xModelStm, nInsertPos );
//STRIP001 		}
//STRIP001 		else if( aDataHelper.HasFormat( SOT_FORMAT_FILE_LIST ) ||
//STRIP001                  aDataHelper.HasFormat( FORMAT_FILE ) )
//STRIP001 		{
//STRIP001             FileList aFileList;
//STRIP001 
//STRIP001             if( aDataHelper.HasFormat( SOT_FORMAT_FILE_LIST ) )
//STRIP001                 aDataHelper.GetFileList( SOT_FORMAT_FILE_LIST, aFileList );
//STRIP001             else
//STRIP001             {
//STRIP001                 String aFile;
//STRIP001 
//STRIP001                 aDataHelper.GetString( FORMAT_FILE, aFile );
//STRIP001 
//STRIP001                 if( aFile.Len() )
//STRIP001                     aFileList.AppendFile( aFile );
//STRIP001             }
//STRIP001 
//STRIP001             for( sal_uInt32 i = 0, nCount = aFileList.Count(); i < nCount; ++i )
//STRIP001             {
//STRIP001                 const String    aFile( aFileList.GetFile( i ) );
//STRIP001                 INetURLObject   aURL( aFile );
//STRIP001 
//STRIP001                 if( aURL.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001                 {
//STRIP001                     String aLocalURL;
//STRIP001                     
//STRIP001                     if( ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aFile, aLocalURL ) )
//STRIP001                         aURL = INetURLObject( aLocalURL );
//STRIP001                 }
//STRIP001 
//STRIP001                 if( aURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001                     bRet = InsertFileOrDirURL( aURL, nInsertPos );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Graphic	aGraphic;
//STRIP001 			ULONG	nFormat = 0;
//STRIP001 
//STRIP001 			if( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ) )
//STRIP001 				nFormat = SOT_FORMATSTR_ID_SVXB;
//STRIP001 			else if( aDataHelper.HasFormat( FORMAT_GDIMETAFILE ) )
//STRIP001 				nFormat = FORMAT_GDIMETAFILE;
//STRIP001 			else if( aDataHelper.HasFormat( FORMAT_BITMAP ) )
//STRIP001 				nFormat = FORMAT_BITMAP;
//STRIP001 
//STRIP001 			if( nFormat && aDataHelper.GetGraphic( nFormat, aGraphic ) )
//STRIP001 				pGraphic = new Graphic( aGraphic );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pGraphic )
//STRIP001 		{
//STRIP001 			bRet = FALSE;
//STRIP001 
//STRIP001 			if( aDataHelper.HasFormat( SOT_FORMATSTR_ID_SVIM ) )
//STRIP001 			{
//STRIP001 
//STRIP001 				ImageMap aImageMap;
//STRIP001 
//STRIP001 				if( aDataHelper.GetImageMap( SOT_FORMATSTR_ID_SVIM, aImageMap ) )
//STRIP001 				{
//STRIP001 					FmFormModel			aModel;
//STRIP001 					SgaUserDataFactory	aFactory;
//STRIP001 
//STRIP001 					aModel.GetItemPool().FreezeIdRanges();
//STRIP001 
//STRIP001 					SdrPage*	pPage = aModel.AllocPage( FALSE );
//STRIP001 					SdrGrafObj*	pGrafObj = new SdrGrafObj( *pGraphic );
//STRIP001 
//STRIP001 					pGrafObj->InsertUserData( new SgaIMapInfo( aImageMap ) );
//STRIP001 					pPage->InsertObject( pGrafObj );
//STRIP001 					aModel.SetPageNotValid( TRUE );
//STRIP001 					aModel.InsertPage( pPage );
//STRIP001 					bRet = InsertModel( aModel, nInsertPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !bRet )
//STRIP001 				bRet = InsertGraphic( *pGraphic, nInsertPos );
//STRIP001 
//STRIP001 			delete pGraphic;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::CopyToClipboard( Window* pWindow, ULONG nPos )
//STRIP001 {
//STRIP001 	GalleryTransferable* pTransferable = new GalleryTransferable( this, nPos );
//STRIP001 	pTransferable->CopyToClipboard( pWindow );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryTheme::StartDrag( Window* pWindow, ULONG nPos )
//STRIP001 {
//STRIP001 	GalleryTransferable* pTransferable = new GalleryTransferable( this, nPos );
//STRIP001 	pTransferable->StartDrag( pWindow, DND_ACTION_COPY | DND_ACTION_LINK );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& GalleryTheme::WriteData( SvStream& rOStm ) const
//STRIP001 {
//STRIP001 	const INetURLObject	aRelURL1( GetParent()->GetRelativeURL() );
//STRIP001 	const INetURLObject	aRelURL2( GetParent()->GetUserURL() );
//STRIP001 	INetURLObject		aNewURL, aTempURL;
//STRIP001 	sal_uInt32			nCount = GetObjectCount();
//STRIP001 	BOOL				bRel;
//STRIP001 
//STRIP001 	rOStm << (sal_uInt16) 0x0004;
//STRIP001 	rOStm << ByteString( GetRealName(), RTL_TEXTENCODING_UTF8 );
//STRIP001 	rOStm << nCount << (sal_uInt16) gsl_getSystemTextEncoding();
//STRIP001 
//STRIP001 	for( sal_uInt32 i = 0; i < nCount; i++ )
//STRIP001 	{
//STRIP001 		const GalleryObject* pObj = ImplGetGalleryObject( i );
//STRIP001 		String				 aPath;
//STRIP001 
//STRIP001 		if( SGA_OBJ_SVDRAW == pObj->eObjKind )
//STRIP001 		{
//STRIP001 			aPath = GetSvDrawStreamNameFromURL( pObj->aURL );
//STRIP001 			bRel = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aPath = pObj->aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 			bRel = ( ( aPath.Erase( aRelURL1.GetMainURL( INetURLObject::NO_DECODE ).Len() ) ) == aRelURL1.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 			if( bRel && ( pObj->aURL.GetMainURL( INetURLObject::NO_DECODE ).Len() > ( aRelURL1.GetMainURL( INetURLObject::NO_DECODE ).Len() + 1 ) ) )
//STRIP001 			{
//STRIP001 				aPath = pObj->aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 				aPath = aPath.Erase( 0, aRelURL1.GetMainURL( INetURLObject::NO_DECODE ).Len() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aPath = pObj->aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 				
//STRIP001 				bRel = ( ( aPath.Erase( aRelURL2.GetMainURL( INetURLObject::NO_DECODE ).Len() ) ) == aRelURL2.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 				if( bRel && ( pObj->aURL.GetMainURL( INetURLObject::NO_DECODE ).Len() > ( aRelURL2.GetMainURL( INetURLObject::NO_DECODE ).Len() + 1 ) ) )
//STRIP001 				{
//STRIP001 					aPath = pObj->aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 					aPath = aPath.Erase( 0, aRelURL2.GetMainURL( INetURLObject::NO_DECODE ).Len() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aPath = pObj->aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		rOStm << bRel << ByteString( aPath, RTL_TEXTENCODING_UTF8 ) << pObj->nOffset << (sal_uInt16) pObj->eObjKind;
//STRIP001 	}
//STRIP001 
//STRIP001 	// neuerdings wird ein 512-Byte-Reservepuffer gechrieben;
//STRIP001 	// um diesen zu erkennen werden zwei ULONG-Ids geschrieben
//STRIP001 	rOStm << COMPAT_FORMAT( 'G', 'A', 'L', 'R' ) << COMPAT_FORMAT( 'E', 'S', 'R', 'V' );
//STRIP001 
//STRIP001 	const long		nReservePos = rOStm.Tell();
//STRIP001 	VersionCompat*	pCompat = new VersionCompat( rOStm, STREAM_WRITE, 2 );
//STRIP001 
//STRIP001 	rOStm << (sal_uInt32) GetId() << IsThemeNameFromResource(); // ab Version 2
//STRIP001 
//STRIP001 	delete pCompat;
//STRIP001 
//STRIP001 	// Rest des Puffers auffuellen
//STRIP001 	const long	nRest = Max( 512L - ( (long) rOStm.Tell() - nReservePos ), 0L );
//STRIP001 
//STRIP001 	if( nRest )
//STRIP001 	{
//STRIP001 		char* pReserve = new char[ nRest ];
//STRIP001 		memset( pReserve, 0, nRest );
//STRIP001 		rOStm.Write( pReserve, nRest );
//STRIP001 		delete[] pReserve;
//STRIP001 	}
//STRIP001 
//STRIP001 	return rOStm;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& GalleryTheme::ReadData( SvStream& rIStm )
//STRIP001 {
//STRIP001 	sal_uInt32			nCount;
//STRIP001 	sal_uInt16			nVersion;
//STRIP001 	ByteString			aTmpStr;
//STRIP001 	String				aThemeName;
//STRIP001 	rtl_TextEncoding	nTextEncoding;
//STRIP001 
//STRIP001 	aImportName = String();
//STRIP001 	rIStm >> nVersion >> aTmpStr >> nCount;
//STRIP001 
//STRIP001 	if( nVersion >= 0x0004 )
//STRIP001 	{
//STRIP001 		UINT16 nTmp16;
//STRIP001 		rIStm >> nTmp16;
//STRIP001 		nTextEncoding = (rtl_TextEncoding) nTmp16;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nTextEncoding = RTL_TEXTENCODING_UTF8;
//STRIP001 
//STRIP001 	aThemeName = String( aTmpStr.GetBuffer(), nTextEncoding );
//STRIP001 
//STRIP001 	if( nCount <= ( 1L << 14 ) )
//STRIP001 	{
//STRIP001 		GalleryObject*	pObj;
//STRIP001 		INetURLObject	aRelURL1( GetParent()->GetRelativeURL() );
//STRIP001 		INetURLObject	aRelURL2( GetParent()->GetUserURL() );
//STRIP001 		sal_uInt32		nId1, nId2;
//STRIP001 		BOOL			bRel;
//STRIP001 
//STRIP001 		for( pObj = aObjectList.First(); pObj; pObj = aObjectList.Next() )
//STRIP001 			delete pObj;
//STRIP001 
//STRIP001 		aObjectList.Clear();
//STRIP001 
//STRIP001 		for( sal_uInt32 i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pObj = new GalleryObject;
//STRIP001 
//STRIP001 			ByteString	aTmpStr;
//STRIP001 			String		aFileName;
//STRIP001 			String		aPath;
//STRIP001 			sal_uInt16	nTemp;
//STRIP001 
//STRIP001 			rIStm >> bRel >> aTmpStr >> pObj->nOffset;
//STRIP001 			rIStm >> nTemp; pObj->eObjKind = (SgaObjKind) nTemp;
//STRIP001 
//STRIP001 			aFileName = String( aTmpStr.GetBuffer(), gsl_getSystemTextEncoding() );
//STRIP001 
//STRIP001 			if( bRel )
//STRIP001 			{
//STRIP001 				aFileName.SearchAndReplaceAll( '\\', '/' );
//STRIP001 				aPath = aRelURL1.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 
//STRIP001 				if( aFileName.GetChar( 0 ) != '/' )
//STRIP001 			    		aPath += '/';
//STRIP001 				
//STRIP001 				aPath += aFileName;
//STRIP001 
//STRIP001 				pObj->aURL = INetURLObject( aPath );
//STRIP001 
//STRIP001 				if( !FileExists( pObj->aURL ) )
//STRIP001 				{
//STRIP001 					aPath = aRelURL2.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 
//STRIP001 					if( aFileName.GetChar( 0 ) != '/' )
//STRIP001 						aPath += '/';
//STRIP001 
//STRIP001 					aPath += aFileName;
//STRIP001 
//STRIP001 					// assign this URL, even in the case it is not valid (#94482)
//STRIP001                     pObj->aURL = INetURLObject( aPath );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( SGA_OBJ_SVDRAW == pObj->eObjKind )
//STRIP001 				{
//STRIP001 					const static String aBaseURLStr( RTL_CONSTASCII_USTRINGPARAM( "gallery/svdraw/" ) );
//STRIP001 					
//STRIP001 					String aDummyURL( aBaseURLStr );
//STRIP001 					pObj->aURL = INetURLObject( aDummyURL += aFileName, INET_PROT_PRIV_SOFFICE );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001                     String aLocalURL;
//STRIP001 
//STRIP001 					pObj->aURL = INetURLObject( aFileName );
//STRIP001 
//STRIP001 					if( ( pObj->aURL.GetProtocol() == INET_PROT_NOT_VALID ) &&
//STRIP001 						::utl::LocalFileHelper::ConvertPhysicalNameToURL( aFileName, aLocalURL ) )
//STRIP001 					{
//STRIP001 						pObj->aURL = INetURLObject( aLocalURL );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			aObjectList.Insert( pObj, LIST_APPEND );
//STRIP001 		}
//STRIP001 
//STRIP001 		rIStm >> nId1 >> nId2;
//STRIP001 
//STRIP001 		// in neueren Versionen befindet sich am Ende ein 512-Byte-Reservepuffer;
//STRIP001 		// die Daten befinden sich am Anfang dieses Puffers und
//STRIP001 		// sind durch eine VersionCompat geklammert
//STRIP001 		if( !rIStm.IsEof() &&
//STRIP001 			nId1 == COMPAT_FORMAT( 'G', 'A', 'L', 'R' ) &&
//STRIP001 			nId2 == COMPAT_FORMAT( 'E', 'S', 'R', 'V' ) )
//STRIP001 		{
//STRIP001 			VersionCompat*	pCompat = new VersionCompat( rIStm, STREAM_READ );
//STRIP001 			sal_uInt32		nTemp32;
//STRIP001 			BOOL			bThemeNameFromResource = FALSE;
//STRIP001 
//STRIP001 			rIStm >> nTemp32;
//STRIP001 
//STRIP001 			if( pCompat->GetVersion() >= 2 )
//STRIP001 			{
//STRIP001 				rIStm >> bThemeNameFromResource;
//STRIP001 			}
//STRIP001 
//STRIP001 			SetId( nTemp32, bThemeNameFromResource );
//STRIP001 			delete pCompat;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rIStm.SetError( SVSTREAM_READ_ERROR );
//STRIP001 
//STRIP001 	ImplSetModified( FALSE );
//STRIP001 
//STRIP001 	return rIStm;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator<<( SvStream& rOut, const GalleryTheme& rTheme )
//STRIP001 {
//STRIP001 	return rTheme.WriteData( rOut );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, GalleryTheme& rTheme )
//STRIP001 {
//STRIP001 	return rTheme.ReadData( rIn );
//STRIP001 }
//STRIP001 }
