/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tbcontrl.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:17:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPOOLITEM_HXX //autogen
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX //autogen wg. ToolBox
#include <vcl/toolbox.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX //autogen wg. System
//#include <vcl/system.hxx>
//#endif
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
#ifndef _CTRLBOX_HXX //autogen
#include <svtools/ctrlbox.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
#ifndef _SFX_TPLPITEM_HXX
#include <bf_sfx2/tplpitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWSH_HXX //autogen
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXISETHINT_HXX
#include <svtools/isethint.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_FONTOPTIONS_HXX
#include <svtools/fontoptions.hxx>
#endif
#pragma hdrstop

#define _SVX_TBCONTRL_CXX

// auto strip #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #endif

#include "dialogs.hrc"
#include "svxitems.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE	0
#define ITEMID_FONTLIST		SID_ATTR_CHAR_FONTLIST
#define ITEMID_FONT			SID_ATTR_CHAR_FONT
#define ITEMID_FONTHEIGHT	SID_ATTR_CHAR_FONTHEIGHT
#define ITEMID_COLOR		SID_ATTR_CHAR_COLOR
#define ITEMID_BRUSH		SID_ATTR_BRUSH
#define ITEMID_BOX			SID_ATTR_BORDER_OUTER
#define ITEMID_BOXINFO		SID_ATTR_BORDER_INNER
#define ITEMID_LINE			SID_FRAME_LINESTYLE

// auto strip #include "htmlmode.hxx"
// auto strip #include "xtable.hxx"
#include "fontitem.hxx"
#include "fhgtitem.hxx"
// auto strip #include "brshitem.hxx"
#include "boxitem.hxx"
#include "colritem.hxx"
#include "flstitem.hxx"
#include "bolnitem.hxx"
// auto strip #include "drawitem.hxx"
#include "tbcontrl.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
namespace binfilter {

// ------------------------------------------------------------------------

#define IMAGE_COL_TRANSPARENT		COL_LIGHTMAGENTA
#define MAX_MRU_FONTNAME_ENTRIES	5
#define LOGICAL_EDIT_HEIGHT         12
// STATIC DATA -----------------------------------------------------------

#ifndef DELETEZ
#define DELETEZ(p) (delete (p), (p)=NULL)
#endif
#define MAX_STYLES_ENTRIES	((USHORT)26)

void lcl_ResizeValueSet( Window &rWin, ValueSet &rValueSet );
void lcl_CalcSizeValueSet( Window &rWin, ValueSet &rValueSet, const Size &aItemSize );
BOOL lcl_FontChangedHint( const SfxHint &rHint );

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxStyleToolBoxControl, SfxTemplateItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontNameToolBoxControl, SvxFontItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontHeightToolBoxControl, SvxFontHeightItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontColorExtToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameToolBoxControl, SvxBoxItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameLineStyleToolBoxControl, SvxLineItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameLineColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxReloadControllerItem,	SfxBoolItem );

//========================================================================
// class SvxStyleBox_Impl -----------------------------------------------------
//========================================================================

class SvxStyleBox_Impl : public ListBox
{
public:
    SvxStyleBox_Impl( Window* pParent, USHORT nSlot, SfxStyleFamily eFamily, SfxBindings& rBind );
	~SvxStyleBox_Impl();

	void 			SetFamily( SfxStyleFamily eNewFamily );
	BOOL			IsVisible() { return bVisible; }

//STRIP001 	virtual long	PreNotify( NotifyEvent& rNEvt );
//STRIP001 	virtual long	Notify( NotifyEvent& rNEvt );
//STRIP001     virtual void    DataChanged( const DataChangedEvent& rDCEvt );
    virtual void	StateChanged( StateChangedType nStateChange ){DBG_BF_ASSERT(0, "STRIP");}//STRIP001 virtual void	StateChanged( StateChangedType nStateChange );

	void			SetVisibilityListener( const Link& aVisListener ) { aVisibilityListener = aVisListener; }
	void			RemoveVisibilityListener() { aVisibilityListener = Link(); }

protected:
//STRIP001 	virtual void	Select();

private:
	USHORT			nSlotId;
	SfxStyleFamily	eStyleFamily;
	USHORT			nCurSel;
	BOOL			bRelease;
	SfxBindings&	rBindings;
    Size            aLogicalSize;
	Link			aVisibilityListener;
	BOOL			bVisible;

//STRIP001 	void			ReleaseFocus();
};

//========================================================================
// class SvxFontNameBox --------------------------------------------------
//========================================================================

class SvxFontNameBox_Impl : public FontNameBox, public SfxListener
{
private:
	const FontList*	pFontList;
	Font			aCurFont;
    Size            aLogicalSize;
	String			aCurText;
	USHORT			nFtCount;
	BOOL			bRelease;
	SfxBindings&	rBindings;

//STRIP001 	void			ReleaseFocus_Impl();
	void			EnableControls_Impl();

protected:
//STRIP001 	virtual void 	Select();
	virtual void	Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
//STRIP001     virtual void    DataChanged( const DataChangedEvent& rDCEvt );

public:
    SvxFontNameBox_Impl( Window* pParent, SfxBindings& rBind, WinBits nStyle = WB_SORT );

//STRIP001 	void			FillList();
	void			Update( const SvxFontItem* pFontItem );
	USHORT			GetListCount() { return nFtCount; }
	void			Clear() { FontNameBox::Clear(); nFtCount = 0; }
	void			Fill( const FontList* pList )
						{ FontNameBox::Fill( pList );
						  nFtCount = pList->GetFontNameCount(); }
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();
};

//========================================================================
// class SvxFontSizeBox_Impl --------------------------------------------------
//========================================================================

class SvxFontHeightToolBoxControl;

class SvxFontSizeBox_Impl : public FontSizeBox
{
private:
	SvxFontHeightToolBoxControl*	pCtrl;
	String							aCurText;
    Size                            aLogicalSize;
	BOOL							bRelease;
	SfxBindings&					rBindings;

//STRIP001 	void				ReleaseFocus_Impl();

protected:
//STRIP001 	virtual void        Select();
//STRIP001     virtual void        DataChanged( const DataChangedEvent& rDCEvt );

public:
                        SvxFontSizeBox_Impl( Window* pParent,
										SvxFontHeightToolBoxControl& rCtrl, SfxBindings& rBind );

	void				StateChanged_Impl( SfxItemState eState,
										   const SfxPoolItem* pState );
	void				Update( const SvxFontItem& rFontItem );

	virtual long		Notify( NotifyEvent& rNEvt );
};

//========================================================================
// class SvxColorWindow_Impl --------------------------------------------------
//========================================================================

//STRIP001 class SvxColorWindow_Impl : public SfxPopupWindow, public SfxListener
//STRIP001 {
//STRIP001 private:
//STRIP001 	const USHORT	theSlotId;
//STRIP001 	ValueSet		aColorSet;
//STRIP001 
//STRIP001 #if _SOLAR__PRIVATE
//STRIP001 	DECL_LINK( SelectHdl, void * );
//STRIP001 #endif
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void    Resize();
//STRIP001 	virtual BOOL	Close();
//STRIP001 
//STRIP001 public:
//STRIP001     SvxColorWindow_Impl( USHORT nId, USHORT nSlotId,
//STRIP001 					const String& rWndTitle,
//STRIP001 					SfxBindings& rBindings );
//STRIP001     ~SvxColorWindow_Impl();
//STRIP001 	void            StartSelection();
//STRIP001 
//STRIP001 	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 							const SfxHint& rHint, const TypeId& rHintType );
//STRIP001     virtual void        KeyInput( const KeyEvent& rKEvt );
//STRIP001 
//STRIP001 	virtual SfxPopupWindow* Clone() const;
//STRIP001 };

//========================================================================
// class SvxFrameWindow_Impl --------------------------------------------------
//========================================================================

// fuer den SelectHdl werden die Modifier gebraucht, also
// muss man sie im MouseButtonUp besorgen

class SvxFrmValueSet_Impl : public ValueSet
{
	USHORT			nModifier;

	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
public:
    SvxFrmValueSet_Impl(Window* pParent,  WinBits nWinStyle)
		: ValueSet(pParent, nWinStyle), nModifier(0) {}
	USHORT			GetModifier() const {return nModifier;}

};

//STRIP001 void SvxFrmValueSet_Impl::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	nModifier = rMEvt.GetModifier();
//STRIP001 	ValueSet::MouseButtonUp(rMEvt);
//STRIP001 }

//STRIP001 class SvxFrameWindow_Impl : public SfxPopupWindow
//STRIP001 {
//STRIP001 private:
//STRIP001     SvxFrmValueSet_Impl  aFrameSet;
//STRIP001 	ImageList 		aImgList;
//STRIP001 
//STRIP001 #if _SOLAR__PRIVATE
//STRIP001 	DECL_LINK( SelectHdl, void * );
//STRIP001 #endif
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void    Resize();
//STRIP001 	virtual BOOL	Close();
//STRIP001 	virtual Window*	GetPreferredKeyInputWindow();
//STRIP001 	virtual void	GetFocus();
//STRIP001 
//STRIP001 public:
//STRIP001     SvxFrameWindow_Impl( USHORT nId, SfxBindings& rBindings, BOOL bParagraphMode );
//STRIP001 
//STRIP001 	void            StartSelection();
//STRIP001 
//STRIP001 	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 								  const SfxPoolItem* pState );
//STRIP001 	virtual SfxPopupWindow* Clone() const;
//STRIP001 	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 
//STRIP001 	inline BOOL		IsHighContrast( void ) const;
//STRIP001 };

//STRIP001 inline BOOL SvxFrameWindow_Impl::IsHighContrast( void ) const
//STRIP001 {
//STRIP001 	return GetDisplayBackground().GetColor().IsDark();
//STRIP001 }

//========================================================================
// class SvxLineWindow_Impl ---------------------------------------------------
//========================================================================
//STRIP001 class SvxLineWindow_Impl : public SfxPopupWindow
//STRIP001 {
//STRIP001 private:
//STRIP001 	ValueSet		aLineSet;
//STRIP001 
//STRIP001 #if _SOLAR__PRIVATE
//STRIP001 	void			MakeLineBitmap( USHORT nNo, Bitmap& rBmp, const Size& rSize, String& rStr,
//STRIP001 									const Color& rLine, const Color& rBack );
//STRIP001 	DECL_LINK( SelectHdl, void * );
//STRIP001 #endif
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void    Resize();
//STRIP001 	virtual BOOL	Close();
//STRIP001 	virtual Window*	GetPreferredKeyInputWindow();
//STRIP001 	virtual void	GetFocus();
//STRIP001     virtual void    DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 	void			CreateBitmaps( void );
//STRIP001 public:
//STRIP001     SvxLineWindow_Impl( USHORT nId, SfxBindings& rBindings );
//STRIP001 
//STRIP001 	void					StartSelection();
//STRIP001 	virtual SfxPopupWindow* Clone() const;
//STRIP001 };

//########################################################################
// Hilfsklassen:
//========================================================================
// class SvxTbxButtonColorUpdater_Impl ----------------------------------------
//========================================================================
#define TBX_UPDATER_MODE_NONE 				0x00
#define TBX_UPDATER_MODE_CHAR_COLOR 		0x01
#define TBX_UPDATER_MODE_CHAR_BACKGROUND 	0x02
#define TBX_UPDATER_MODE_CHAR_COLOR_NEW		0x03

class SvxTbxButtonColorUpdater_Impl
{
public:
                SvxTbxButtonColorUpdater_Impl( USHORT nTbxBtnId,
										  ToolBox* ptrTbx, USHORT nMode = 0 );
                ~SvxTbxButtonColorUpdater_Impl();

	void 		Update( const Color& rColor );

protected:
//STRIP001 	void 		DrawChar(VirtualDevice&, const Color&);

private:
	USHORT		nDrawMode;
	USHORT		nBtnId;
	ToolBox*	pTbx;
	Bitmap*		pBtnBmp;
	Color		aCurColor;
	Rectangle	theUpdRect;
	Size		theBmpSize;
	BOOL		bWasHiContrastMode;
};

//========================================================================
// class SfxStyleControllerItem ------------------------------------------
//========================================================================
class SvxStyleToolBoxControl;

class SfxStyleControllerItem_Impl : public SfxControllerItem
{
public:
    SfxStyleControllerItem_Impl( USHORT nId, SfxBindings& rBindings, SvxStyleToolBoxControl& rTbxCtl );

protected:
	virtual void StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );

private:
	SvxStyleToolBoxControl& rControl;
};

//========================================================================
// class SvxStyleBox_Impl -----------------------------------------------------
//========================================================================

/*N*/ SvxStyleBox_Impl::SvxStyleBox_Impl( Window* pParent, USHORT nSlot, SfxStyleFamily eFamily, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	ListBox( pParent, SVX_RES( RID_SVXTBX_STYLE ) ),
/*N*/ 
/*N*/ 	eStyleFamily( eFamily ),
/*N*/ 	nSlotId		( nSlot ),
/*N*/ 	bRelease	( TRUE ),
/*N*/ 	rBindings	( rBind )
/*N*/ 
/*N*/ {
/*N*/     aLogicalSize = PixelToLogic( GetSizePixel(), MAP_APPFONT );
/*N*/ }

/*N*/ SvxStyleBox_Impl::~SvxStyleBox_Impl()
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxStyleBox_Impl::ReleaseFocus()
//STRIP001 {
//STRIP001 	if ( !bRelease )
//STRIP001 	{
//STRIP001 		bRelease = TRUE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxStyleBox_Impl::Select()
//STRIP001 {
//STRIP001     // Tell base class about selection so that AT get informed about it.
//STRIP001     ListBox::Select();
//STRIP001 
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		SfxStringItem aItem( nSlotId, GetSelectEntry() );
//STRIP001 		SfxUInt16Item aFamily( SID_STYLE_FAMILY, eStyleFamily );
//STRIP001 		rBindings.GetDispatcher()->Execute(
//STRIP001 			nSlotId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, &aFamily, 0L );
//STRIP001         ReleaseFocus();
//STRIP001 	}
//STRIP001 }
// -----------------------------------------------------------------------

/*N*/ void SvxStyleBox_Impl::SetFamily( SfxStyleFamily eNewFamily )
/*N*/ {
/*N*/ 	eStyleFamily = eNewFamily;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 long SvxStyleBox_Impl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 
//STRIP001 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
//STRIP001 		nCurSel = GetSelectEntryPos();
//STRIP001     else if(EVENT_LOSEFOCUS == nType)
//STRIP001         SelectEntryPos(GetSavedValue());
//STRIP001 	return ListBox::PreNotify( rNEvt );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 long SvxStyleBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = 0;
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
//STRIP001 
//STRIP001 		switch ( nCode )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 			case KEY_TAB:
//STRIP001 			{
//STRIP001 				if ( KEY_TAB == nCode )
//STRIP001 					bRelease = FALSE;
//STRIP001 				else
//STRIP001 					nHandled = 1;
//STRIP001 				Select();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				SelectEntryPos( nCurSel );
//STRIP001 				ReleaseFocus();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nHandled ? nHandled : ListBox::Notify( rNEvt );
//STRIP001 }
/* -----------------------------08.03.2002 13:03------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxStyleBox_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001         Size aDropSize( aLogicalSize.Width(), LOGICAL_EDIT_HEIGHT);
//STRIP001         SetDropDownSizePixel(LogicToPixel(aDropSize, MAP_APPFONT));
//STRIP001     }
//STRIP001 
//STRIP001     ListBox::DataChanged( rDCEvt );
//STRIP001 }

//STRIP001 void SvxStyleBox_Impl::StateChanged( StateChangedType nStateChange )
//STRIP001 {
//STRIP001 	ListBox::StateChanged( nStateChange );
//STRIP001 
//STRIP001 	if ( nStateChange == STATE_CHANGE_VISIBLE )
//STRIP001 	{
//STRIP001 		bVisible = IsReallyVisible();
//STRIP001 		if ( aVisibilityListener.IsSet() )
//STRIP001 			aVisibilityListener.Call( this );
//STRIP001 	}
//STRIP001 	else if ( nStateChange == STATE_CHANGE_INITSHOW )
//STRIP001 	{
//STRIP001 		bVisible = TRUE;
//STRIP001 		if ( aVisibilityListener.IsSet() )
//STRIP001 			aVisibilityListener.Call( this );
//STRIP001 	}
//STRIP001 }


// -----------------------------------------------------------------------

#define BRUSH(style,name) BrushStyle(style),SVX_RESSTR(name)
#define COLOR(color,name) Color(color),SVX_RESSTR(name)

//STRIP001 BOOL GetDocFontList_Impl( const FontList** ppFontList, SvxFontNameBox_Impl* pBox )
//STRIP001 {
//STRIP001 	BOOL bChanged = FALSE;
//STRIP001 	const SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	SvxFontListItem* pFontListItem = NULL;
//STRIP001 
//STRIP001 	if ( pDocSh )
//STRIP001 		pFontListItem =
//STRIP001 			(SvxFontListItem*)pDocSh->GetItem( SID_ATTR_CHAR_FONTLIST );
//STRIP001 
//STRIP001 	if ( pFontListItem )
//STRIP001 	{
//STRIP001 		const FontList*	pNewFontList = pFontListItem->GetFontList();
//STRIP001 		DBG_ASSERT( pNewFontList, "Doc-FontList not available!" );
//STRIP001 
//STRIP001 		// keine alte Liste, aber neue Liste
//STRIP001 		if ( !*ppFontList && pNewFontList )
//STRIP001 		{
//STRIP001 			// => "ubernehmen
//STRIP001 			*ppFontList = pNewFontList;
//STRIP001 			bChanged = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Vergleich der Fontlisten ist nicht vollkommen
//STRIP001 			// wird die Fontliste am Doc geaendert, kann man hier
//STRIP001 			// nur ueber die Listbox Aenderungen feststellen, weil
//STRIP001 			// ppFontList dabei schon upgedatet wurde
//STRIP001 			bChanged =
//STRIP001 				( ( *ppFontList != pNewFontList ) ||
//STRIP001 				  pBox->GetListCount() != pNewFontList->GetFontNameCount() );
//STRIP001 			HACK(vergleich ist unvollstaendig)
//STRIP001 
//STRIP001 			if ( bChanged )
//STRIP001 				*ppFontList = pNewFontList;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pBox )
//STRIP001 			pBox->Enable();
//STRIP001 	}
//STRIP001 	else if ( pBox )
//STRIP001 		pBox->Disable();
//STRIP001 
//STRIP001 	// in die FontBox ggf. auch die neue Liste f"ullen
//STRIP001 	if ( pBox && bChanged )
//STRIP001 	{
//STRIP001 		if ( *ppFontList )
//STRIP001 			pBox->Fill( *ppFontList );
//STRIP001 		else
//STRIP001 			pBox->Clear();
//STRIP001 	}
//STRIP001 	return bChanged;
//STRIP001 }

//========================================================================
// class SvxFontNameBox_Impl --------------------------------------------------
//========================================================================

/*N*/ SvxFontNameBox_Impl::SvxFontNameBox_Impl( Window* pParent, SfxBindings& rBind, WinBits nStyle ) :
/*N*/ 
/*N*/ 	FontNameBox	( pParent, nStyle | WinBits( WB_DROPDOWN | WB_AUTOHSCROLL ) ),
/*N*/     aLogicalSize(55,80),
/*N*/ 	pFontList	( NULL ),
/*N*/ 	nFtCount	( 0 ),
/*N*/ 	bRelease	( TRUE ),
/*N*/ 	rBindings	( rBind )
/*N*/ 
/*N*/ {
/*N*/     SetSizePixel(LogicToPixel( aLogicalSize, MAP_APPFONT ));
/*N*/     EnableControls_Impl();
/*N*/ 	StartListening( *SFX_APP() );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontNameBox_Impl::FillList()
//STRIP001 {
//STRIP001 	// alte Selektion merken, und am Ende wieder setzen
//STRIP001 	Selection aOldSel = GetSelection();
//STRIP001 	// hat sich Doc-Fontlist geaendert?
//STRIP001 	GetDocFontList_Impl( &pFontList, this );
//STRIP001 	aCurText = GetText();
//STRIP001 	SetSelection( aOldSel );
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::Update( const SvxFontItem* pFontItem )
/*N*/ {
/*N*/ 	if ( pFontItem )
/*N*/ 	{
/*N*/ 		aCurFont.SetName		( pFontItem->GetFamilyName() );
/*N*/ 		aCurFont.SetFamily		( pFontItem->GetFamily() );
/*N*/ 		aCurFont.SetStyleName	( pFontItem->GetStyleName() );
/*N*/ 		aCurFont.SetPitch		( pFontItem->GetPitch() );
/*N*/ 		aCurFont.SetCharSet		( pFontItem->GetCharSet() );
/*N*/ 	}
/*N*/ 	String aCurName = aCurFont.GetName();
/*N*/ 	if ( GetText() != aCurName )
/*N*/ 		SetText( aCurName );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontNameBox_Impl::PreNotify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	USHORT nType = rNEvt.GetType();
/*N*/ 
/*N*/ 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		FillList();
/*N*/     return FontNameBox::PreNotify( rNEvt );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontNameBox_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	long nHandled = 0;
/*N*/ 
/*N*/ 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/ 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
/*?*/ 
/*?*/ 		switch ( nCode )
/*?*/ 		{
/*?*/ 			case KEY_RETURN:
/*?*/ 			case KEY_TAB:
/*?*/ 			{
/*?*/ 				if ( KEY_TAB == nCode )
/*?*/ 					bRelease = FALSE;
/*?*/ 				else
/*?*/ 					nHandled = 1;
/*?*/ 				Select();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			case KEY_ESCAPE:
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				SetText( aCurText );
//STRIP001 /*?*/ 				ReleaseFocus_Impl();
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/     else if ( EVENT_LOSEFOCUS == rNEvt.GetType() )
/*N*/ 	{
/*?*/ 		Window* pFocusWin = Application::GetFocusWindow();
/*?*/ 		if ( !HasFocus() && GetSubEdit() != pFocusWin )
/*?*/ 			SetText( GetSavedValue() );
/*N*/ 	}
/*N*/ 
/*N*/ 	return nHandled ? nHandled : FontNameBox::Notify( rNEvt );
/*N*/ }
/* -----------------------------08.03.2002 13:23------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxFontNameBox_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001         Size aDropSize( aLogicalSize.Width(), LOGICAL_EDIT_HEIGHT);
//STRIP001         SetDropDownSizePixel(LogicToPixel(aDropSize, MAP_APPFONT));
//STRIP001     }
//STRIP001 
//STRIP001     FontNameBox::DataChanged( rDCEvt );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontNameBox_Impl::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	if ( !bRelease )
//STRIP001 	{
//STRIP001 		bRelease = TRUE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::EnableControls_Impl()
/*N*/ {
/*N*/ 	SvtFontOptions aFontOpt;
/*N*/ 	BOOL bEnable = aFontOpt.IsFontHistoryEnabled();
/*N*/ 	USHORT nEntries = bEnable ? MAX_MRU_FONTNAME_ENTRIES : 0;
/*N*/ 	if ( GetMaxMRUCount() != nEntries )
/*N*/ 	{
/*N*/ 		// refill in the next GetFocus-Handler
/*N*/ 		pFontList = NULL;
/*N*/ 		Clear();
/*N*/ 		SetMaxMRUCount( nEntries );
/*N*/ 	}
/*N*/ 
/*N*/ 	bEnable = aFontOpt.IsFontWYSIWYGEnabled();
/*N*/ 	EnableWYSIWYG( bEnable );
/*N*/ 	EnableSymbols( bEnable );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	SfxItemSetHint* pHint = PTR_CAST(SfxItemSetHint, &rHint);
/*N*/ 	if ( pHint )
/*?*/ 		EnableControls_Impl();
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontNameBox_Impl::Select()
//STRIP001 {
//STRIP001 	FontNameBox::Select();
//STRIP001 
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		if ( pFontList )
//STRIP001 		{
//STRIP001 			FontInfo aInfo( pFontList->Get( GetText(),
//STRIP001 											aCurFont.GetWeight(),
//STRIP001 											aCurFont.GetItalic() ) );
//STRIP001 			aCurFont = aInfo;
//STRIP001 
//STRIP001 			SvxFontItem aFontItem( aInfo.GetFamily(),
//STRIP001 								   aInfo.GetName(),
//STRIP001 								   aInfo.GetStyleName(),
//STRIP001 								   aInfo.GetPitch(),
//STRIP001 								   aInfo.GetCharSet(),
//STRIP001 								   SID_ATTR_CHAR_FONT );
//STRIP001 
//STRIP001             rBindings.GetDispatcher()->Execute( SID_ATTR_CHAR_FONT, SFX_CALLMODE_RECORD, &aFontItem, 0L );
//STRIP001 		}
//STRIP001 		ReleaseFocus_Impl();
//STRIP001 	}
//STRIP001 }

//========================================================================
// class SvxFontSizeBox_Impl --------------------------------------------------
//========================================================================

/*N*/ SvxFontSizeBox_Impl::SvxFontSizeBox_Impl( Window* pParent, SvxFontHeightToolBoxControl &rCtrl, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	FontSizeBox( pParent, WinBits( WB_DROPDOWN ) ),
/*N*/ 
/*N*/ 	pCtrl		( &rCtrl ),
/*N*/ 	bRelease	( TRUE ),
/*N*/     rBindings   ( rBind ),
/*N*/     aLogicalSize(20,80)
/*N*/ 
/*N*/ {
/*N*/     SetSizePixel(LogicToPixel( aLogicalSize, MAP_APPFONT ));
/*N*/ 	SetValue( 0 );
/*N*/ 	SetText( String() );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontSizeBox_Impl::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	if ( !bRelease )
//STRIP001 	{
//STRIP001 		bRelease = TRUE;
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontSizeBox_Impl::Select()
//STRIP001 {
//STRIP001 	FontSizeBox::Select();
//STRIP001 
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = pCtrl->GetCoreMetric();
//STRIP001 		long nSelVal = GetValue();
//STRIP001 		long nVal = LogicToLogic( nSelVal, MAP_POINT, (MapUnit)eUnit ) / 10;
//STRIP001 		SvxFontHeightItem aFontHeightItem( nVal, 100, SID_ATTR_CHAR_FONTHEIGHT );
//STRIP001 		rBindings.GetDispatcher()->Execute(
//STRIP001 			SID_ATTR_CHAR_FONTHEIGHT, SFX_CALLMODE_RECORD, &aFontHeightItem, 0L );
//STRIP001 		ReleaseFocus_Impl();
//STRIP001 	}
//STRIP001 }
// -----------------------------------------------------------------------

/*N*/ void SvxFontSizeBox_Impl::StateChanged_Impl( SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 	{
/*N*/ 		// Metric Umrechnen
/*N*/ 		long nH = ( (const SvxFontHeightItem*)pState )->GetHeight() * 10;
/*N*/ 		long nVal = LogicToLogic( nH, (MapUnit)pCtrl->GetCoreMetric(), MAP_POINT );
/*N*/ 
/*N*/ 		// ge"andert => neuen Wert setzen
/*N*/ 		if ( GetValue() != nVal )
/*N*/ 			SetValue( nVal );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// Wert in der Anzeige l"oschen
/*N*/ 		SetValue( -1L );
/*N*/ 		SetText( String() );
/*N*/ 	}
/*N*/     SaveValue();
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontSizeBox_Impl::Update( const SvxFontItem& rFontItem )
/*N*/ {
/*N*/ 	// Fontliste vom Document abholen
/*N*/ 	const SfxObjectShell* pDocSh = SfxObjectShell::Current();
/*N*/ 	const SvxFontListItem* pFontListItem = (const SvxFontListItem*)
/*N*/ 		( pDocSh ? pDocSh->GetItem( SID_ATTR_CHAR_FONTLIST ) : NULL );
/*N*/ 
/*N*/ 	// Sizes-Liste auff"ullen
/*N*/ 	long nOldVal = GetValue(); // alten Wert merken
/*N*/ 	FontInfo aFontInfo;
/*N*/ 	FASTBOOL bCreate = FALSE;
/*N*/ 	const FontList* pFontList = pFontListItem ? pFontListItem->GetFontList() : NULL;
/*N*/ 	if ( pFontList )
/*N*/ 	{
/*N*/ 		aFontInfo = FontInfo( pFontList->Get( rFontItem.GetFamilyName(), rFontItem.GetStyleName() ) );
/*N*/ 		Fill( aFontInfo, pFontList );
/*N*/ 	}
/*N*/ 	SetValue( nOldVal ); // alten Wert wiederherstellen
/*N*/ 	aCurText = GetText(); // zum R"ucksetzen bei ESC merken
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontSizeBox_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	long nHandled = 0;
/*N*/ 
/*N*/ 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/ 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
/*?*/ 
/*?*/ 		switch ( nCode )
/*?*/ 		{
/*?*/ 			case KEY_RETURN:
/*?*/ 			case KEY_TAB:
/*?*/ 			{
/*?*/ 				if ( KEY_TAB == nCode )
/*?*/ 					bRelease = FALSE;
/*?*/ 				else
/*?*/ 					nHandled = 1;
/*?*/ 				Select();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			case KEY_ESCAPE:
/*?*/				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				SetText( aCurText );
//STRIP001 /*?*/ 				ReleaseFocus_Impl();
//STRIP001 /*?*/ 				nHandled = 1;
/*?*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/     else if(EVENT_LOSEFOCUS == rNEvt.GetType())
/*N*/ 	{
/*?*/ 		Window* pFocusWin = Application::GetFocusWindow();
/*?*/ 		if(!HasFocus() && GetSubEdit() != pFocusWin)
/*?*/ 			SetText(GetSavedValue());
/*N*/ 	}
/*N*/ 
/*N*/ 	return nHandled ? nHandled : FontSizeBox::Notify( rNEvt );
/*N*/ }
/* -----------------------------08.03.2002 13:24------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxFontSizeBox_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         SetSizePixel(LogicToPixel(aLogicalSize, MAP_APPFONT));
//STRIP001         Size aDropSize( aLogicalSize.Width(), LOGICAL_EDIT_HEIGHT);
//STRIP001         SetDropDownSizePixel(LogicToPixel(aDropSize, MAP_APPFONT));
//STRIP001     }
//STRIP001 
//STRIP001     FontSizeBox::DataChanged( rDCEvt );
//STRIP001 }

//========================================================================
// class SvxColorWindow_Impl --------------------------------------------------
//========================================================================
#ifndef WB_NO_DIRECTSELECT
#define WB_NO_DIRECTSELECT      ((WinBits)0x04000000)
#endif

//STRIP001 SvxColorWindow_Impl::SvxColorWindow_Impl( USHORT nId, USHORT nSlotId,
//STRIP001 								const String& rWndTitle,
//STRIP001 								SfxBindings& rBindings ) :
//STRIP001 
//STRIP001     SfxPopupWindow( nId, WinBits( WB_BORDER | WB_STDFLOATWIN | WB_3DLOOK|WB_DIALOGCONTROL ), rBindings ),
//STRIP001 
//STRIP001 	theSlotId( nSlotId ),
//STRIP001     aColorSet( this, WinBits( WB_ITEMBORDER | WB_NAMEFIELD | WB_3DLOOK | WB_NO_DIRECTSELECT) )
//STRIP001 
//STRIP001 {
//STRIP001 	SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	const SfxPoolItem* pItem = NULL;
//STRIP001 	XColorTable* pColorTable = NULL;
//STRIP001 	const Size aSize12( 12, 12 );
//STRIP001 
//STRIP001 	if ( pDocSh )
//STRIP001 		if ( 0 != ( pItem = pDocSh->GetItem( SID_COLOR_TABLE ) ) )
//STRIP001 			pColorTable = ( (SvxColorTableItem*)pItem )->GetColorTable();
//STRIP001 
//STRIP001 	if ( SID_ATTR_CHAR_COLOR_BACKGROUND == theSlotId || SID_BACKGROUND_COLOR == theSlotId )
//STRIP001 	{
//STRIP001 		aColorSet.SetStyle( aColorSet.GetStyle() | WB_NONEFIELD );
//STRIP001 		aColorSet.SetText( SVX_RESSTR( RID_SVXSTR_TRANSPARENT ) );
//STRIP001 	}
//STRIP001     else if ( SID_ATTR_CHAR_COLOR == theSlotId || SID_ATTR_CHAR_COLOR2 == theSlotId)
//STRIP001 	{
//STRIP001         SfxPoolItem* pDummy;
//STRIP001         SfxItemState eState = rBindings.QueryState(SID_ATTR_AUTO_COLOR_INVALID, pDummy);
//STRIP001         if(SFX_ITEM_DEFAULT > eState)
//STRIP001         {
//STRIP001             aColorSet.SetStyle( aColorSet.GetStyle() | WB_NONEFIELD );
//STRIP001             aColorSet.SetText( SVX_RESSTR( RID_SVXSTR_AUTOMATIC ) );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pColorTable )
//STRIP001 	{
//STRIP001 		short i = 0;
//STRIP001 		long nCount = pColorTable->Count();
//STRIP001 		XColorEntry* pEntry = NULL;
//STRIP001 		Color aColWhite( COL_WHITE );
//STRIP001 		String aStrWhite( SVX_RES(RID_SVXITEMS_COLOR_WHITE) );
//STRIP001 
//STRIP001 		if ( nCount > 80 )
//STRIP001 			// bei mehr als 80 Farben ScrollBar anzeigen
//STRIP001 			aColorSet.SetStyle( aColorSet.GetStyle() | WB_VSCROLL );
//STRIP001 
//STRIP001 		for ( i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pColorTable->Get(i);
//STRIP001 			aColorSet.InsertItem( i+1, pEntry->GetColor(), pEntry->GetName() );
//STRIP001 		}
//STRIP001 
//STRIP001 		while ( i < 80 )
//STRIP001 		{
//STRIP001 			// bei weniger als 80 Farben, mit Weiss auff"ullen
//STRIP001 			aColorSet.InsertItem( i+1, aColWhite, aStrWhite );
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     aColorSet.SetSelectHdl( LINK( this, SvxColorWindow_Impl, SelectHdl ) );
//STRIP001 	aColorSet.SetColCount( 8 );
//STRIP001 	aColorSet.SetLineCount( 10 );
//STRIP001 
//STRIP001 	lcl_CalcSizeValueSet( *this, aColorSet, aSize12 );
//STRIP001 
//STRIP001 	SetHelpId( HID_POPUP_COLOR );
//STRIP001 	aColorSet.SetHelpId( HID_POPUP_COLOR_CTRL );
//STRIP001 
//STRIP001 	SetText( rWndTitle );
//STRIP001 	aColorSet.Show();
//STRIP001 //    aColorSet.GrabFocus();
//STRIP001 	StartListening( rBindings );
//STRIP001 }

//STRIP001 SvxColorWindow_Impl::~SvxColorWindow_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 void SvxColorWindow_Impl::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     aColorSet.KeyInput(rKEvt);
//STRIP001 }

//STRIP001 SfxPopupWindow* SvxColorWindow_Impl::Clone() const
//STRIP001 {
//STRIP001     return new SvxColorWindow_Impl( GetId(), theSlotId, GetText(), (SfxBindings&)GetBindings() );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxColorWindow_Impl, SelectHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nItemId = aColorSet.GetSelectItemId();
//STRIP001 	if ( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	if ( !nItemId && ( SID_ATTR_CHAR_COLOR_BACKGROUND == theSlotId  || SID_BACKGROUND_COLOR == theSlotId ) )
//STRIP001         GetBindings().Execute( theSlotId );
//STRIP001     else if ( !nItemId && (SID_ATTR_CHAR_COLOR == theSlotId || SID_ATTR_CHAR_COLOR2  == theSlotId) )
//STRIP001     {
//STRIP001         SvxColorItem aColorItem( COL_AUTO, theSlotId );
//STRIP001 		GetBindings().GetDispatcher()->Execute( theSlotId, SFX_CALLMODE_RECORD, &aColorItem, 0L );
//STRIP001     }
//STRIP001     else
//STRIP001 	{
//STRIP001 		SvxColorItem aColorItem( aColorSet.GetItemColor( nItemId ), theSlotId );
//STRIP001 		GetBindings().GetDispatcher()->Execute( theSlotId, SFX_CALLMODE_RECORD, &aColorItem, 0L );
//STRIP001 	}
//STRIP001 
//STRIP001 	aColorSet.SetNoSelection();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxColorWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	lcl_ResizeValueSet( *this, aColorSet);
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxColorWindow_Impl::StartSelection()
//STRIP001 {
//STRIP001 	aColorSet.StartSelection();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxColorWindow_Impl::Close()
//STRIP001 {
//STRIP001 	return SfxPopupWindow::Close();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxColorWindow_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	const SfxPoolItemHint* pItemHint = PTR_CAST( SfxPoolItemHint, &rHint );
//STRIP001 	SvxColorTableItem* pItem = pItemHint ?
//STRIP001 		PTR_CAST( SvxColorTableItem, pItemHint->GetObject() ) : NULL;
//STRIP001 	XColorTable* pColorTable = pItem ? pItem->GetColorTable() : NULL;
//STRIP001 
//STRIP001 	if ( pColorTable )
//STRIP001 	{
//STRIP001 		// Die Liste der Farben (ColorTable) hat sich ge"andert:
//STRIP001 		short i = 0;
//STRIP001 		long nCount = pColorTable->Count();
//STRIP001 		XColorEntry* pEntry = NULL;
//STRIP001 		Color aColWhite( COL_WHITE );
//STRIP001 		String aStrWhite( SVX_RES( RID_SVXITEMS_COLOR_WHITE ) );
//STRIP001 
//STRIP001 		// ScrollBar an oder aus
//STRIP001 		WinBits nBits = aColorSet.GetStyle();
//STRIP001 		if ( nCount > 80 )
//STRIP001 			nBits &= ~WB_VSCROLL;
//STRIP001 		else
//STRIP001 			nBits |= WB_VSCROLL;
//STRIP001 		aColorSet.SetStyle( nBits );
//STRIP001 
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			pEntry = pColorTable->Get(i);
//STRIP001 			aColorSet.SetItemColor( i + 1, pEntry->GetColor() );
//STRIP001 			aColorSet.SetItemText ( i + 1, pEntry->GetName() );
//STRIP001 		}
//STRIP001 
//STRIP001 		while ( i < 80 )
//STRIP001 		{
//STRIP001 			aColorSet.SetItemColor( i + 1, aColWhite );
//STRIP001 			aColorSet.SetItemText ( i + 1, aStrWhite );
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//========================================================================
// class SvxFrameWindow_Impl --------------------------------------------------
//========================================================================

//STRIP001 SvxFrameWindow_Impl::SvxFrameWindow_Impl( USHORT nId, SfxBindings& rBindings, BOOL bParagraphMode ) :
//STRIP001 
//STRIP001 	SfxPopupWindow( nId, WinBits( WB_BORDER | WB_STDFLOATWIN | WB_3DLOOK | WB_DIALOGCONTROL ), rBindings ),
//STRIP001 
//STRIP001 	aFrameSet	( this, WinBits( WB_ITEMBORDER | WB_DOUBLEBORDER | WB_3DLOOK | WB_NO_DIRECTSELECT ) )
//STRIP001 
//STRIP001 {
//STRIP001 	aImgList = ImageList( SVX_RES( IsHighContrast()? RID_SVXIL_FRAME_HC : RID_SVXIL_FRAME ) );
//STRIP001 
//STRIP001 	/*
//STRIP001 	 *  1       2        3         4
//STRIP001 	 *  -------------------------------------
//STRIP001 	 *	NONE    LEFT     RIGHT     LEFTRIGHT
//STRIP001 	 *	TOP     BOTTOM   TOPBOTTOM OUTER
//STRIP001 	 *  -------------------------------------
//STRIP001 	 *	HOR	    HORINNER VERINNER	ALL			<- kann ueber bParagraphMode
//STRIP001 	 *                                             abgeschaltet werden
//STRIP001 	 */
//STRIP001 
//STRIP001 	USHORT i = 0;
//STRIP001 
//STRIP001 	for ( i=1; i<9; i++ )
//STRIP001 		aFrameSet.InsertItem( i, aImgList.GetImage(i) );
//STRIP001 
//STRIP001 	if ( !bParagraphMode )
//STRIP001 		for ( i = 9; i < 13; i++ )
//STRIP001 			aFrameSet.InsertItem( i, aImgList.GetImage(i) );
//STRIP001 
//STRIP001 	aFrameSet.SetColCount( 4 );
//STRIP001     aFrameSet.SetSelectHdl( LINK( this, SvxFrameWindow_Impl, SelectHdl ) );
//STRIP001 
//STRIP001 	lcl_CalcSizeValueSet( *this, aFrameSet,Size( 20, 20 ));
//STRIP001 
//STRIP001 	SetHelpId( HID_POPUP_FRAME );
//STRIP001 	SetText( SVX_RESSTR(RID_SVXSTR_FRAME) );
//STRIP001 	aFrameSet.Show();
//STRIP001 }

//STRIP001 SfxPopupWindow* SvxFrameWindow_Impl::Clone() const
//STRIP001 {
//STRIP001 	//! HACK: wie bekomme ich den Paragraph-Mode ??
//STRIP001     return new SvxFrameWindow_Impl( GetId(), (SfxBindings&)GetBindings(), FALSE );
//STRIP001 }

//STRIP001 Window* SvxFrameWindow_Impl::GetPreferredKeyInputWindow()
//STRIP001 {
//STRIP001 	return &aFrameSet;
//STRIP001 }

//STRIP001 void SvxFrameWindow_Impl::GetFocus()
//STRIP001 {
//STRIP001 	aFrameSet.GrabFocus();
//STRIP001 }

//STRIP001 void SvxFrameWindow_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxPopupWindow::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		aImgList = ImageList( SVX_RES( IsHighContrast()? RID_SVXIL_FRAME_HC : RID_SVXIL_FRAME ) );
//STRIP001 
//STRIP001 		USHORT	nNumOfItems = aFrameSet.GetItemCount();
//STRIP001 
//STRIP001 		for( USHORT i = 1 ; i <= nNumOfItems ; ++i )
//STRIP001 			aFrameSet.SetItemImage( i, aImgList.GetImage( i ) );
//STRIP001 	}
//STRIP001 }
// -----------------------------------------------------------------------

#define FRM_VALID_LEFT 		0x01
#define FRM_VALID_RIGHT 	0x02
#define FRM_VALID_TOP 		0x04
#define FRM_VALID_BOTTOM 	0x08
#define FRM_VALID_HINNER 	0x10
#define FRM_VALID_VINNER 	0x20
#define FRM_VALID_OUTER		0x0f
#define FRM_VALID_ALL       0xff

//
// Per default bleiben ungesetzte Linien unveraendert
// Mit Shift werden ungesetzte Linien zurueckgsetzt
//
//STRIP001 IMPL_LINK( SvxFrameWindow_Impl, SelectHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	Color				aColBlack( COL_BLACK );
//STRIP001 	SvxBoxItem			aBorderOuter( SID_ATTR_BORDER_OUTER );
//STRIP001 	SvxBoxInfoItem		aBorderInner( SID_ATTR_BORDER_INNER );
//STRIP001 	SvxBorderLine		theDefLine,
//STRIP001 						*pLeft = 0,
//STRIP001 						*pRight = 0,
//STRIP001 						*pTop = 0,
//STRIP001 						*pBottom = 0;
//STRIP001 	USHORT				nSel = aFrameSet.GetSelectItemId();
//STRIP001 	USHORT 				nModifier = aFrameSet.GetModifier();
//STRIP001 	BYTE 				nValidFlags = 0;
//STRIP001 
//STRIP001 	switch ( nSel )
//STRIP001 	{
//STRIP001 		case 1: nValidFlags |= FRM_VALID_ALL;
//STRIP001 		break;	// NONE
//STRIP001 		case 2: pLeft = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_LEFT;
//STRIP001 		break;	// LEFT
//STRIP001 		case 3: pRight = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_RIGHT;
//STRIP001 		break;	// RIGHT
//STRIP001 		case 4: pLeft = pRight = &theDefLine;
//STRIP001 				nValidFlags |= 	FRM_VALID_RIGHT|FRM_VALID_LEFT;
//STRIP001 		break;	// LEFTRIGHT
//STRIP001 		case 5: pTop = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_TOP;
//STRIP001 		break;	// TOP
//STRIP001 		case 6: pBottom = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_BOTTOM;
//STRIP001 		break;	// BOTTOM
//STRIP001 		case 7: pTop =  pBottom = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_BOTTOM|FRM_VALID_TOP;
//STRIP001 		break;	// TOPBOTTOM
//STRIP001 		case 8: pLeft = pRight = pTop = pBottom = &theDefLine;
//STRIP001 				nValidFlags |= FRM_VALID_OUTER;
//STRIP001 		break;	// OUTER
//STRIP001 
//STRIP001 		// Tabelle innen:
//STRIP001 		case 9: // HOR
//STRIP001 			pTop = pBottom = &theDefLine;
//STRIP001 			aBorderInner.SetLine( &theDefLine, BOXINFO_LINE_HORI );
//STRIP001 			aBorderInner.SetLine( NULL, BOXINFO_LINE_VERT );
//STRIP001 			nValidFlags |= FRM_VALID_HINNER|FRM_VALID_TOP|FRM_VALID_BOTTOM;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 10: // HORINNER
//STRIP001 			pLeft = pRight = pTop = pBottom = &theDefLine;
//STRIP001 			aBorderInner.SetLine( &theDefLine, BOXINFO_LINE_HORI );
//STRIP001 			aBorderInner.SetLine( NULL, BOXINFO_LINE_VERT );
//STRIP001 			nValidFlags |= FRM_VALID_RIGHT|FRM_VALID_LEFT|FRM_VALID_HINNER|FRM_VALID_TOP|FRM_VALID_BOTTOM;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 11: // VERINNER
//STRIP001 			pLeft = pRight = pTop = pBottom = &theDefLine;
//STRIP001 			aBorderInner.SetLine( NULL, BOXINFO_LINE_HORI );
//STRIP001 			aBorderInner.SetLine( &theDefLine, BOXINFO_LINE_VERT );
//STRIP001 			nValidFlags |= FRM_VALID_RIGHT|FRM_VALID_LEFT|FRM_VALID_VINNER|FRM_VALID_TOP|FRM_VALID_BOTTOM;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case 12: // ALL
//STRIP001 			pLeft = pRight = pTop = pBottom = &theDefLine;
//STRIP001 			aBorderInner.SetLine( &theDefLine, BOXINFO_LINE_HORI );
//STRIP001 			aBorderInner.SetLine( &theDefLine, BOXINFO_LINE_VERT );
//STRIP001 			nValidFlags |= FRM_VALID_ALL;
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	aBorderOuter.SetLine( pLeft, BOX_LINE_LEFT );
//STRIP001 	aBorderOuter.SetLine( pRight, BOX_LINE_RIGHT );
//STRIP001 	aBorderOuter.SetLine( pTop, BOX_LINE_TOP );
//STRIP001 	aBorderOuter.SetLine( pBottom, BOX_LINE_BOTTOM );
//STRIP001 
//STRIP001 	if(nModifier == KEY_SHIFT)
//STRIP001 		nValidFlags |= FRM_VALID_ALL;
//STRIP001 	aBorderInner.SetValid( VALID_TOP, 		0 != (nValidFlags&FRM_VALID_TOP ));
//STRIP001 	aBorderInner.SetValid( VALID_BOTTOM, 	0 != (nValidFlags&FRM_VALID_BOTTOM ));
//STRIP001 	aBorderInner.SetValid( VALID_LEFT, 		0 != (nValidFlags&FRM_VALID_LEFT));
//STRIP001 	aBorderInner.SetValid( VALID_RIGHT, 	0 != (nValidFlags&FRM_VALID_RIGHT ));
//STRIP001 	aBorderInner.SetValid( VALID_HORI, 		0 != (nValidFlags&FRM_VALID_HINNER ));
//STRIP001 	aBorderInner.SetValid( VALID_VERT, 		0 != (nValidFlags&FRM_VALID_VINNER));
//STRIP001 	aBorderInner.SetValid( VALID_DISTANCE, TRUE );
//STRIP001 	aBorderInner.SetValid( VALID_DISABLE, FALSE );
//STRIP001 
//STRIP001 	if ( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute(
//STRIP001 		SID_ATTR_BORDER, SFX_CALLMODE_RECORD, &aBorderOuter, &aBorderInner, 0L );
//STRIP001 	aFrameSet.SetNoSelection();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxFrameWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	lcl_ResizeValueSet( *this, aFrameSet);
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxFrameWindow_Impl::StateChanged(
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pState )
//STRIP001 	{
//STRIP001 		const SfxUInt16Item* pItem = PTR_CAST( SfxUInt16Item, pState );
//STRIP001 
//STRIP001 		if ( pItem )
//STRIP001 		{
//STRIP001 			BOOL bParMode   = (BOOL)pItem->GetValue();
//STRIP001 			BOOL bTableMode = ( aFrameSet.GetItemCount() == 12 );
//STRIP001 			BOOL bResize    = FALSE;
//STRIP001 
//STRIP001 			if ( bTableMode && bParMode )
//STRIP001 			{
//STRIP001 				for ( USHORT i = 9; i < 13; i++ )
//STRIP001 					aFrameSet.RemoveItem(i);
//STRIP001 				bResize = TRUE;
//STRIP001 			}
//STRIP001 			else if ( !bTableMode && !bParMode )
//STRIP001 			{
//STRIP001 				for ( USHORT i = 9; i < 13; i++ )
//STRIP001 					aFrameSet.InsertItem( i, aImgList.GetImage(i) );
//STRIP001 				bResize = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bResize )
//STRIP001 			{
//STRIP001 				lcl_CalcSizeValueSet( *this, aFrameSet,Size( 20, 20 ));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SfxPopupWindow::StateChanged( nSID, eState, pState );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxFrameWindow_Impl::StartSelection()
//STRIP001 {
//STRIP001 	aFrameSet.StartSelection();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxFrameWindow_Impl::Close()
//STRIP001 {
//STRIP001 	return SfxPopupWindow::Close();
//STRIP001 }

//========================================================================
// class SvxLineWindow_Impl --------------------------------------------------
//========================================================================

//STRIP001 SvxLineWindow_Impl::SvxLineWindow_Impl( USHORT nId, SfxBindings &rBindings ) :
//STRIP001 
//STRIP001 	SfxPopupWindow( nId, WinBits( WB_BORDER | WB_STDFLOATWIN | WB_3DLOOK | WB_DIALOGCONTROL ), rBindings ),
//STRIP001 
//STRIP001 	aLineSet( this, WinBits( WB_3DLOOK | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_NAMEFIELD | WB_NONEFIELD | WB_NO_DIRECTSELECT ) )
//STRIP001 {
//STRIP001 	Size	aBmpSize( 55, 12 );
//STRIP001 	CreateBitmaps();
//STRIP001 
//STRIP001 	aLineSet.SetColCount( 2 );
//STRIP001     aLineSet.SetSelectHdl( LINK( this, SvxLineWindow_Impl, SelectHdl ) );
//STRIP001 	aLineSet.SetText( SVX_RESSTR(STR_NONE) );
//STRIP001 
//STRIP001 	lcl_CalcSizeValueSet( *this, aLineSet, aBmpSize );
//STRIP001 
//STRIP001 	SetHelpId( HID_POPUP_LINE );
//STRIP001 	SetText( SVX_RESSTR(RID_SVXSTR_FRAME_STYLE) );
//STRIP001 	aLineSet.Show();
//STRIP001 }

//STRIP001 SfxPopupWindow* SvxLineWindow_Impl::Clone() const
//STRIP001 {
//STRIP001     return new SvxLineWindow_Impl( GetId(), (SfxBindings&)GetBindings() );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineWindow_Impl::MakeLineBitmap( USHORT nNo, Bitmap& rBmp, const Size& rSize, String& rStr,
//STRIP001 											const Color& rLineCol, const Color& rBackCol )
//STRIP001 {
//STRIP001 	VirtualDevice	aVirDev( *this );
//STRIP001 	Rectangle		aRect( Point(2,0), Size(rSize.Width()-4,0) );
//STRIP001 
//STRIP001 	// grau einfaerben und Bitmap sichern:
//STRIP001 	aVirDev.SetOutputSizePixel( rSize );
//STRIP001 	aVirDev.SetLineColor();
//STRIP001 	aVirDev.SetFillColor( rBackCol );
//STRIP001 	aVirDev.DrawRect( Rectangle( Point(0,0), rSize ) );
//STRIP001 	aVirDev.SetFillColor( rLineCol );
//STRIP001 
//STRIP001     sal_uInt16 nLineWidth = 0;
//STRIP001 	switch ( nNo )
//STRIP001 	{
//STRIP001 		case 1: // DEF_LINE_WIDTH_0
//STRIP001 			aRect.Top() 	= 6;
//STRIP001 			aRect.Bottom()	= 6;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 2: // DEF_LINE_WIDTH_1
//STRIP001 			aRect.Top() 	= 5;
//STRIP001 			aRect.Bottom()	= 6;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) DEF_LINE_WIDTH_1/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 3: // DEF_LINE_WIDTH_2
//STRIP001 			aRect.Top() 	= 5;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) DEF_LINE_WIDTH_2/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 4: // DEF_LINE_WIDTH_3
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aVirDev.DrawRect( Rectangle( Point(2,4), Point(37,7) ) );
//STRIP001 			nLineWidth = (USHORT) DEF_LINE_WIDTH_3/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 5: // DEF_LINE_WIDTH_4
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 8;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) DEF_LINE_WIDTH_4/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 6: // DEF_DOUBLE_LINE0
//STRIP001 			aRect.Top() 	= 5;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE0_OUT+DEF_DOUBLE_LINE0_IN+DEF_DOUBLE_LINE0_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 7: // DEF_DOUBLE_LINE7
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 4;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE7_OUT+DEF_DOUBLE_LINE7_IN+DEF_DOUBLE_LINE7_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 8: // DEF_DOUBLE_LINE1
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 8;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE1_OUT+DEF_DOUBLE_LINE1_IN+DEF_DOUBLE_LINE1_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 9: // DEF_DOUBLE_LINE2
//STRIP001 			aRect.Top() 	= 3;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 8;
//STRIP001 			aRect.Bottom()	= 10;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE2_OUT+DEF_DOUBLE_LINE2_IN+DEF_DOUBLE_LINE2_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 10: // DEF_DOUBLE_LINE8
//STRIP001 			aRect.Top() 	= 3;
//STRIP001 			aRect.Bottom()	= 4;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE8_OUT+DEF_DOUBLE_LINE8_IN+DEF_DOUBLE_LINE8_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 11: // DEF_DOUBLE_LINE9
//STRIP001 			aRect.Top() 	= 3;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 8;
//STRIP001 			aRect.Bottom()	= 8;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE9_OUT+DEF_DOUBLE_LINE9_IN+DEF_DOUBLE_LINE9_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 12: // DEF_DOUBLE_LINE10
//STRIP001 			aRect.Top() 	= 2;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 8;
//STRIP001 			aRect.Bottom()	= 8;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE10_OUT+DEF_DOUBLE_LINE10_IN+DEF_DOUBLE_LINE10_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 13: // DEF_DOUBLE_LINE3
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE3_OUT+DEF_DOUBLE_LINE3_IN+DEF_DOUBLE_LINE3_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 14: // DEF_DOUBLE_LINE4
//STRIP001 			aRect.Top() 	= 4;
//STRIP001 			aRect.Bottom()	= 4;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 6;
//STRIP001 			aRect.Bottom()	= 7;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE4_OUT+DEF_DOUBLE_LINE4_IN+DEF_DOUBLE_LINE4_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 15: // DEF_DOUBLE_LINE5
//STRIP001 			aRect.Top() 	= 3;
//STRIP001 			aRect.Bottom()	= 5;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 8;
//STRIP001 			aRect.Bottom()	= 9;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE5_OUT+DEF_DOUBLE_LINE5_IN+DEF_DOUBLE_LINE5_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case 16: // DEF_DOUBLE_LINE6
//STRIP001 			aRect.Top() 	= 3;
//STRIP001 			aRect.Bottom()	= 4;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			aRect.Top() 	= 7;
//STRIP001 			aRect.Bottom()	= 9;
//STRIP001 			aVirDev.DrawRect( aRect );
//STRIP001 			nLineWidth = (USHORT) (DEF_DOUBLE_LINE6_OUT+DEF_DOUBLE_LINE6_IN+DEF_DOUBLE_LINE6_DIST)/20;
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001     if ( nLineWidth )
//STRIP001     {
//STRIP001         rStr = String::CreateFromInt32( nLineWidth );
//STRIP001 	    rStr.AppendAscii(" pt");
//STRIP001     }
//STRIP001 	rBmp = aVirDev.GetBitmap( Point(0,0), rSize );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineWindow_Impl, SelectHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SvxLineItem		aLineItem;
//STRIP001 	USHORT			n1 = 0,
//STRIP001 					n2 = 0,
//STRIP001 					n3 = 0;
//STRIP001 	BOOL			bSetLine = TRUE;
//STRIP001 
//STRIP001 	switch ( aLineSet.GetSelectItemId() )
//STRIP001 	{
//STRIP001 		case  1: n1 = DEF_LINE_WIDTH_0; break;
//STRIP001 		case  2: n1 = DEF_LINE_WIDTH_1; break;
//STRIP001 		case  3: n1 = DEF_LINE_WIDTH_2; break;
//STRIP001 		case  4: n1 = DEF_LINE_WIDTH_3; break;
//STRIP001 		case  5: n1 = DEF_LINE_WIDTH_4; break;
//STRIP001 
//STRIP001 		case  6: n1 = DEF_DOUBLE_LINE0_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE0_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE0_DIST;	 break;
//STRIP001 		case  7: n1 = DEF_DOUBLE_LINE7_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE7_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE7_DIST;	 break;
//STRIP001 		case  8: n1 = DEF_DOUBLE_LINE1_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE1_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE1_DIST;	 break;
//STRIP001 		case  9: n1 = DEF_DOUBLE_LINE2_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE2_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE2_DIST;	 break;
//STRIP001 		case 10: n1 = DEF_DOUBLE_LINE8_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE8_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE8_DIST;	 break;
//STRIP001 		case 11: n1 = DEF_DOUBLE_LINE9_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE9_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE9_DIST;	 break;
//STRIP001 		case 12: n1 = DEF_DOUBLE_LINE10_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE10_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE10_DIST; break;
//STRIP001 		case 13: n1 = DEF_DOUBLE_LINE3_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE3_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE3_DIST;	 break;
//STRIP001 		case 14: n1 = DEF_DOUBLE_LINE4_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE4_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE4_DIST;	 break;
//STRIP001 		case 15: n1 = DEF_DOUBLE_LINE5_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE5_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE5_DIST;	 break;
//STRIP001 		case 16: n1 = DEF_DOUBLE_LINE6_OUT;
//STRIP001 				 n2 = DEF_DOUBLE_LINE6_IN;
//STRIP001 				 n3 = DEF_DOUBLE_LINE6_DIST;	 break;
//STRIP001 		case  0:
//STRIP001 		default:
//STRIP001 			bSetLine = FALSE;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if ( bSetLine )
//STRIP001 	{
//STRIP001 		SvxBorderLine aTmp( NULL, n1, n2, n3 );
//STRIP001 		aLineItem.SetLine( &aTmp );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aLineItem.SetLine( 0 );
//STRIP001 
//STRIP001 	if ( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute( SID_FRAME_LINESTYLE, SFX_CALLMODE_RECORD, &aLineItem, 0L );
//STRIP001 	aLineSet.SetNoSelection();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	lcl_ResizeValueSet( *this, aLineSet);
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineWindow_Impl::StartSelection()
//STRIP001 {
//STRIP001 	aLineSet.StartSelection();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxLineWindow_Impl::Close()
//STRIP001 {
//STRIP001 	return SfxPopupWindow::Close();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 Window* SvxLineWindow_Impl::GetPreferredKeyInputWindow()
//STRIP001 {
//STRIP001 	return &aLineSet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineWindow_Impl::GetFocus()
//STRIP001 {
//STRIP001 	aLineSet.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLineWindow_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxPopupWindow::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		CreateBitmaps();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLineWindow_Impl::CreateBitmaps( void )
//STRIP001 {
//STRIP001 	Size					aBmpSize( 55, 12 );
//STRIP001 	Bitmap					aBmp;
//STRIP001 	String					aStr;
//STRIP001 
//STRIP001 	const StyleSettings&	rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	svtools::ColorConfig aColorConfig;
//STRIP001 	Color					aLineCol( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 	Color					aBackCol( rStyleSettings.GetWindowColor() );
//STRIP001 	aLineSet.Clear();
//STRIP001 
//STRIP001 	for( USHORT i = 1 ; i < 17 ; ++i )
//STRIP001 	{
//STRIP001 		MakeLineBitmap( i, aBmp, aBmpSize, aStr, aLineCol, aBackCol );
//STRIP001 		aLineSet.InsertItem( i, aBmp, aStr );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

#undef BRUSH
#undef COLOR
#undef GET_DOCFONTLIST

//########################################################################
// Hilfsklassen

//========================================================================
// class SvxTbxButtonColorUpdater_Impl ----------------------------------------
//========================================================================

/*N*/ SvxTbxButtonColorUpdater_Impl::SvxTbxButtonColorUpdater_Impl( USHORT nTbxBtnId,
/*N*/ 													ToolBox* ptrTbx,
/*N*/ 													USHORT nMode ) :
/*N*/ 	nDrawMode		  ( nMode ),
/*N*/ 	nBtnId			  ( nTbxBtnId ),
/*N*/ 	pTbx			  ( ptrTbx ),
/*N*/ 	pBtnBmp			  ( NULL ),
/*N*/ 	aCurColor		  ( COL_TRANSPARENT )
/*N*/ {
/*N*/     if (nTbxBtnId == SID_BACKGROUND_COLOR)
/*N*/         nDrawMode = TBX_UPDATER_MODE_CHAR_COLOR_NEW;
/*N*/ 	DBG_ASSERT( pTbx, "ToolBox not found :-(" );
/*N*/ 	bWasHiContrastMode = pTbx ? ( pTbx->GetBackground().GetColor().IsDark() ) : FALSE;
/*N*/ 	Update(nTbxBtnId == SID_ATTR_CHAR_COLOR2 ? COL_BLACK : COL_GRAY);
/*N*/ 	return;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxTbxButtonColorUpdater_Impl::~SvxTbxButtonColorUpdater_Impl()
/*N*/ {
/*N*/ 	delete pBtnBmp;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxTbxButtonColorUpdater_Impl::Update( const Color& rColor )
/*N*/ {
/*N*/ 	Image	aImage( pTbx->GetItemImage( nBtnId ) );
/*N*/ 	BOOL	bSizeChanged = ( theBmpSize != aImage.GetSizePixel() );
/*N*/ 	BOOL	bDisplayModeChanged = ( bWasHiContrastMode != pTbx->GetBackground().GetColor().IsDark() );
/*N*/ 
/*N*/     Color aColor( rColor );
/*N*/     
/*N*/     // #109290# Workaround for SetFillColor with COL_AUTO
/*N*/     if ( aColor.GetColor() == COL_AUTO )
/*N*/         aColor = Color( IMAGE_COL_TRANSPARENT );
/*N*/ 
/*N*/ 	if ( aCurColor == aColor && !bSizeChanged && !bDisplayModeChanged )
/*N*/ 		return;
/*N*/ 
/*N*/ 	VirtualDevice aVirDev( *pTbx );
/*N*/ 	Point aNullPnt;
/*N*/ 
/*N*/ 	if ( bSizeChanged || bDisplayModeChanged )
/*N*/ 	{
/*N*/ 		bWasHiContrastMode = pTbx->GetBackground().GetColor().IsDark();
/*N*/ 		theBmpSize = aImage.GetSizePixel();
/*N*/ 
/*N*/ 		if ( theBmpSize.Width() <= 16 )
/*N*/ 			theUpdRect = Rectangle( Point(7,7), Size(8,8) );
/*N*/ 		else
/*N*/ 			theUpdRect = Rectangle( Point(14,14), Size(11,11) );
/*N*/ 
/*N*/ 		aVirDev.SetLineColor();
/*N*/ 		aVirDev.SetOutputSizePixel( theBmpSize );
/*N*/ 		aVirDev.SetFillColor( Color( IMAGE_COL_TRANSPARENT ) );
/*N*/ 		aVirDev.DrawRect( Rectangle( aNullPnt, theBmpSize ) );
/*N*/ 		aVirDev.DrawImage( aNullPnt, aImage );
/*N*/ 		delete pBtnBmp;
/*N*/ 		pBtnBmp = new Bitmap( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 		if ( nDrawMode != TBX_UPDATER_MODE_CHAR_COLOR_NEW )
/*N*/ 			aVirDev.DrawRect( theUpdRect );
/*N*/ 	}
/*N*/ 	else if ( !pBtnBmp )
/*?*/ 		pBtnBmp = new Bitmap( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 
/*N*/ 	aVirDev.SetOutputSizePixel( theBmpSize );
/*N*/ 	aVirDev.DrawBitmap( aNullPnt, *pBtnBmp );
/*N*/ 
/*N*/ 	// Choose line color according to background color
/*N*/ 	if ( pTbx->GetBackground().GetColor().IsDark() )
/*?*/ 		aVirDev.SetLineColor( COL_WHITE );
/*N*/ 	else
/*N*/ 		aVirDev.SetLineColor( COL_BLACK );
/*N*/ 
/*N*/ 	if ( nDrawMode == TBX_UPDATER_MODE_CHAR_COLOR_NEW &&
/*N*/ 		 ( aColor.GetColor() != COL_AUTO &&
/*N*/ 		   aColor.GetColor() != IMAGE_COL_TRANSPARENT ))
/*N*/ 	{
/*N*/ 		// Draw border only if COLOR_AUTO is the new color!
/*N*/ 		aVirDev.SetLineColor( aColor );
/*N*/ 	}
/*N*/ 	aVirDev.SetFillColor( aColor );
/*N*/ 
/*N*/ 	if ( nDrawMode == TBX_UPDATER_MODE_CHAR_COLOR_NEW )
/*N*/ 	{
/*N*/ 		// New mode for our new high contrast enabled bitmaps
/*N*/ 		if ( theBmpSize.Width() <= 16 )
/*N*/ 			theUpdRect = Rectangle( Point( 0,12 ), Size(theBmpSize.Width(), 4 ) );
/*N*/ 		else
/*?*/ 			theUpdRect = Rectangle( Point( 1,19 ), Size( 24,6 ) );
/*N*/ 		aVirDev.DrawRect( theUpdRect );
/*N*/ 	}
/*N*/ 	else if ( nDrawMode != TBX_UPDATER_MODE_NONE )
/*N*/ 	{
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 DrawChar( aVirDev, aColor );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aVirDev.DrawRect( theUpdRect );
/*N*/ 
/*N*/ 	aCurColor = aColor;
/*N*/ 
/*N*/     // The following code asumes that we cannot change the display color depth
/*N*/     // during Office runtime. Which is at least NOT true for newer Windows versions!
/*N*/ 	const Bitmap	aBmp( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 	static Color	aTransparentColor;
/*N*/ 	static sal_Bool	bTransparentColorInitialized = sal_False;
/*N*/ 
/*N*/ 	if( !bTransparentColorInitialized )
/*N*/ 	{
/*N*/ 		aVirDev.DrawPixel( aNullPnt, IMAGE_COL_TRANSPARENT );
/*N*/ 		aTransparentColor = aVirDev.GetPixel( aNullPnt );
/*N*/ 		bTransparentColorInitialized = sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	Bitmap	aMaskBitmap = aBmp.CreateMask( aTransparentColor );
/*N*/ 	Image aNewImage( aBmp, aMaskBitmap );
/*N*/ 	pTbx->SetItemImage( nBtnId, aNewImage );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxTbxButtonColorUpdater_Impl::DrawChar( VirtualDevice& rVirDev, const Color& rCol )
//STRIP001 {
//STRIP001 	Font aOldFont = rVirDev.GetFont();
//STRIP001 	Font aFont = aOldFont;
//STRIP001 	Size aSz = aFont.GetSize();
//STRIP001 	aSz.Height() = theBmpSize.Height();
//STRIP001 	aFont.SetSize( aSz );
//STRIP001 	aFont.SetWeight( WEIGHT_BOLD );
//STRIP001 
//STRIP001 	if ( nDrawMode == TBX_UPDATER_MODE_CHAR_COLOR )
//STRIP001 	{
//STRIP001 		aFont.SetColor( rCol );
//STRIP001 		aFont.SetFillColor( Color( IMAGE_COL_TRANSPARENT ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rVirDev.SetPen( Pen( PEN_NULL ) );
//STRIP001 		rVirDev.SetFillColor( rCol );
//STRIP001 		Rectangle aRect( Point(0,0), theBmpSize );
//STRIP001 		rVirDev.DrawRect( aRect );
//STRIP001 		aFont.SetFillColor( rCol );
//STRIP001 	}
//STRIP001 	rVirDev.SetFont( aFont );
//STRIP001 	Size aTxtSize(rVirDev.GetTextWidth( 'A' ), rVirDev.GetTextHeight());
//STRIP001 	Point aPos( ( theBmpSize.Width() - aTxtSize.Width() ) / 2,
//STRIP001 				( theBmpSize.Height() - aTxtSize.Height() ) / 2 );
//STRIP001 
//STRIP001 	rVirDev.DrawText( aPos, 'A' );
//STRIP001 	rVirDev.SetFont( aOldFont );
//STRIP001 }
//========================================================================
// class SfxStyleControllerItem_Impl ------------------------------------------
//========================================================================

/*N*/ SfxStyleControllerItem_Impl::SfxStyleControllerItem_Impl(
/*N*/ 				USHORT					nId,		// Family-ID
/*N*/ 				SfxBindings&			rBindings,	// the Bindings
/*N*/ 				SvxStyleToolBoxControl&	rTbxCtl )	// Controller-Instanz, dem
/*N*/ 													// dieses Item zugeordnet ist.
/*N*/ 	:	SfxControllerItem	( nId, rBindings ),
/*N*/ 		rControl			( rTbxCtl )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SfxStyleControllerItem_Impl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	switch ( GetId() )
/*N*/ 	{
/*N*/ 		case SID_STYLE_FAMILY1:
/*N*/ 		case SID_STYLE_FAMILY2:
/*N*/ 		case SID_STYLE_FAMILY3:
/*N*/ 		case SID_STYLE_FAMILY4:
/*N*/ 		case SID_STYLE_FAMILY5:
/*N*/ 		{
/*N*/ 			const USHORT nIdx = GetId() - SID_STYLE_FAMILY_START;
/*N*/ 
/*N*/ 			if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 			{
/*N*/ 				const SfxTemplateItem* pStateItem =
/*N*/ 					PTR_CAST( SfxTemplateItem, pState );
/*N*/ 				DBG_ASSERT( pStateItem != NULL, "SfxTemplateItem expected" );
/*N*/ 				rControl.SetFamilyState( nIdx, pStateItem );
/*N*/ 			}
/*N*/ 			else
/*N*/ 				rControl.SetFamilyState( nIdx, NULL );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//########################################################################

//========================================================================
// class SvxStyleToolBoxControl ------------------------------------------
//========================================================================

/*N*/ SvxStyleToolBoxControl::SvxStyleToolBoxControl( USHORT		 nId,
/*N*/ 												ToolBox&	 rTbx,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl	( nId, rTbx, rBindings ),
/*N*/ 		pStyleSheetPool		( NULL ),
/*N*/ 		nActFamily			( 0xffff ),
/*N*/ 		bListening			( FALSE )
/*N*/ {
/*N*/ 	rBindings.ENTERREGISTRATIONS();
/*N*/ 	USHORT i=0;
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/         pBoundItems [i] = new SfxStyleControllerItem_Impl( SID_STYLE_FAMILY_START + i, rBindings, *this );
/*N*/ 		pFamilyState[i] = NULL;
/*N*/ 	}
/*N*/ 	rBindings.LEAVEREGISTRATIONS();
/*N*/ 
/*N*/ 	// Default now: Unbind() controllers until we get our first visibility notification from our UI control.
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/ 		pBoundItems[i]->UnBind();
/*N*/ 		DBG_ASSERT( !pBoundItems[i]->IsBound(), "Invalidate bindings state!" );
/*N*/ 	}
/*N*/ 	UnBind();
/*N*/ 	DBG_ASSERT( !IsBound(), "Invalidate bindings state!" );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxStyleToolBoxControl::~SvxStyleToolBoxControl()
/*N*/ {
/*N*/ 	for( USHORT i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/ 		DELETEZ( pBoundItems [i] );
/*N*/ 		DELETEZ( pFamilyState[i] );
/*N*/ 	}
/*N*/ 	pStyleSheetPool = NULL;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SfxStyleFamily SvxStyleToolBoxControl::GetActFamily()
/*N*/ {
/*N*/ 	switch ( nActFamily-1 + SID_STYLE_FAMILY_START )
/*N*/ 	{
/*?*/ 		case SID_STYLE_FAMILY1:	return SFX_STYLE_FAMILY_CHAR;
/*N*/ 		case SID_STYLE_FAMILY2:	return SFX_STYLE_FAMILY_PARA;
/*?*/ 		case SID_STYLE_FAMILY3:	return SFX_STYLE_FAMILY_FRAME;
/*?*/ 		case SID_STYLE_FAMILY4:	return SFX_STYLE_FAMILY_PAGE;
/*?*/ 		case SID_STYLE_FAMILY5:	return SFX_STYLE_FAMILY_PSEUDO;
/*?*/ 		default:
/*?*/ 			DBG_ERROR( "unknown style family" );
/*?*/ 			break;
/*?*/ 	}
/*?*/ 	return SFX_STYLE_FAMILY_PARA;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::FillStyleBox()
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = (SvxStyleBox_Impl*)GetToolBox().GetItemWindow( GetId() );
/*N*/ 
/*N*/ 	DBG_ASSERT( pStyleSheetPool, "StyleSheetPool not found!" );
/*N*/ 	DBG_ASSERT( pBox,			 "Control not found!" );
/*N*/ 
/*N*/ 	if ( pStyleSheetPool && pBox && nActFamily!=0xffff )
/*N*/ 	{
/*N*/ 		const SfxStyleFamily	eFamily 	= GetActFamily();
/*N*/ 		USHORT					nCount  	= pStyleSheetPool->Count();
/*N*/ 		USHORT 					i			= 0;
/*N*/ 		SfxStyleSheetBase*		pStyle  	= NULL;
/*N*/ 		BOOL 					bDoFill 	= FALSE;
/*N*/ 
/*N*/ 		pStyleSheetPool->SetSearchMask( eFamily, SFXSTYLEBIT_USED );
/*N*/ 
/*N*/ 		//------------------------------
/*N*/ 		// Ueberpruefen, ob Fill noetig:
/*N*/ 		//------------------------------
/*N*/ 
/*N*/ 		pStyle = pStyleSheetPool->First();
/*N*/ 
/*N*/ 		if ( nCount != pBox->GetEntryCount() )
/*N*/ 		{
/*N*/ 			bDoFill = TRUE;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			while ( pStyle && !bDoFill )
/*?*/ 			{
/*?*/ 				bDoFill = ( pBox->GetEntry(i) != pStyle->GetName() );
/*?*/ 				pStyle = pStyleSheetPool->Next();
/*?*/ 				i++;
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( bDoFill )
/*N*/ 		{
/*N*/ 			pBox->SetUpdateMode( FALSE );
/*N*/ 			pBox->Clear();
/*N*/ 
/*N*/ 			// Listbox nur so gross, wie Eintraege vorhanden,
/*N*/ 			// hoechstens MAX_STYLES_ENTRIES Eintraege
/*N*/ 			// mindestens 4 Eintraege
/*N*/ 
/*N*/ 			if ( nCount > MAX_STYLES_ENTRIES )
/*?*/ 				nCount = MAX_STYLES_ENTRIES;
/*N*/ 			else if (nCount < 4)
/*N*/ 				nCount = 4;
/*N*/ 
/*N*/ 			nCount += 1; // +1 fuer Selektion
/*N*/ 
/*N*/ 			Size aSize( pBox->GetOutputSizePixel() );
/*N*/ 			long nNewHeight = nCount * (14 + 2) ; // 14 == TextHeight
/*N*/ 
/*N*/ 			if ( aSize.Height() != nNewHeight )
/*N*/ 			{
/*N*/ 				aSize.Height() = nNewHeight;
/*N*/ 				pBox->SetOutputSizePixel( aSize );
/*N*/ 			}
/*N*/ 
/*N*/ 			pStyle = pStyleSheetPool->First();
/*N*/ 
/*N*/ 			while ( pStyle )
/*N*/ 			{
/*N*/ 				pBox->InsertEntry( pStyle->GetName() );
/*N*/ 				pStyle = pStyleSheetPool->Next();
/*N*/ 			}
/*N*/ 
/*N*/ 			pBox->SetUpdateMode( TRUE );
/*N*/ 			pBox->SetFamily( eFamily );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SelectStyle( const String& rStyleName )
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = (SvxStyleBox_Impl*)GetToolBox().GetItemWindow( GetId() );
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( pBox )
/*N*/ 	{
/*N*/ 		String aStrSel( pBox->GetSelectEntry() );
/*N*/ 
/*N*/ 		if ( rStyleName.Len() > 0 )
/*N*/ 		{
/*N*/ 			if ( rStyleName != aStrSel )
/*N*/ 				pBox->SelectEntry( rStyleName );
/*N*/ 		}
/*N*/ 		else
/*?*/ 			pBox->SetNoSelection();
/*N*/         pBox->SaveValue();
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::Update()
/*N*/ {
/*N*/ 	SfxStyleSheetBasePool*	pPool	  = NULL;
/*N*/ 	SfxObjectShell*		pDocShell = SfxObjectShell::Current();
/*N*/ 
/*N*/ 	if ( pDocShell )
/*N*/ 		pPool = pDocShell->GetStyleSheetPool();
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 		if( pFamilyState[i] )
/*N*/ 			break;
/*N*/ 
/*N*/ 	if ( i==MAX_FAMILIES || !pPool )
/*N*/ 	{
/*N*/ 		pStyleSheetPool = pPool;
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	const SfxTemplateItem* pItem = NULL;
/*N*/ 
/*N*/ 	if ( nActFamily == 0xffff || 0 == (pItem = pFamilyState[nActFamily-1]) )
/*N*/ 		// aktueller Bereich nicht innerhalb der erlaubten Bereiche
/*N*/ 		// oder Default
/*N*/ 	{
/*N*/ 		pStyleSheetPool = pPool;
/*N*/ 		nActFamily		= 2;
/*N*/ 
/*N*/ 		pItem = pFamilyState[nActFamily-1];
/*N*/ 		if ( !pItem )
/*N*/ 		{
/*?*/ 			nActFamily++;
/*?*/ 			pItem = pFamilyState[nActFamily-1];
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !pItem )
/*N*/ 			DBG_WARNING( "Unknown Family" ); // can happens
/*N*/ 	}
/*N*/ 	else if ( pPool != pStyleSheetPool )
/*?*/ 		pStyleSheetPool = pPool;
/*N*/ 
/*N*/ 	FillStyleBox(); // entscheidet selbst, ob gefuellt werden muss
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		SelectStyle( pItem->GetStyleName() );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
/*N*/ 	const TypeId& rBCType, const SfxHint&  rHint, const TypeId& rHintType )
/*N*/ {
/*N*/ 	if ( rHint.Type() == TYPE(SfxSimpleHint) &&
/*N*/ 		 ( (SfxSimpleHint&)rHint ).GetId() == SFX_HINT_UPDATEDONE )
/*N*/ 	{
/*N*/ 		Update();	// Aktualisierung anstossen
/*N*/ 		EndListening( GetBindings() );
/*N*/ 		bListening = FALSE;
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SetFamilyState( USHORT nIdx,
/*N*/ 											 const SfxTemplateItem* pItem )
/*N*/ {
/*N*/ 	DELETEZ( pFamilyState[nIdx] );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pFamilyState[nIdx] = new SfxTemplateItem( *pItem );
/*N*/ 
/*N*/ 	if( !bListening )
/*N*/ 	{
/*N*/ 		StartListening( GetBindings() );
/*N*/ 		bListening = TRUE;
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*?*/ IMPL_LINK( SvxStyleToolBoxControl, VisibilityNotification, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	// Call ReBind() && UnBind() according to visibility
//STRIP001 	SvxStyleBox_Impl* pBox = (SvxStyleBox_Impl*)( GetToolBox().GetItemWindow( GetId() ));
//STRIP001 	if ( pBox->IsVisible() && !IsBound() )
//STRIP001 	{
//STRIP001 		// Rebind controllers again
//STRIP001 		GetBindings().ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 		for ( USHORT i=0; i<MAX_FAMILIES; i++ )
//STRIP001 			pBoundItems	[i]->ReBind();
//STRIP001 
//STRIP001 		ReBind();
//STRIP001 		GetBindings().LEAVEREGISTRATIONS();
//STRIP001 
//STRIP001 		// Invalidate slots
//STRIP001 		for ( i=0; i<MAX_FAMILIES; i++ )
//STRIP001 			GetBindings().Invalidate( SID_STYLE_FAMILY_START + i );
//STRIP001 		GetBindings().Invalidate( GetId() );
//STRIP001 	}
//STRIP001 	else if ( !pBox->IsVisible() && IsBound() )
//STRIP001 	{
//STRIP001 		for ( USHORT i=0; i<MAX_FAMILIES; i++ )
//STRIP001 			pBoundItems	[i]->UnBind();
//STRIP001 		UnBind();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
/*?*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 		 nId	= GetId();
/*N*/ 	ToolBox&	 rTbx   = GetToolBox();
/*N*/     SvxStyleBox_Impl* pBox   = (SvxStyleBox_Impl*)(rTbx.GetItemWindow( nId ));
/*N*/ 	TriState	 eTri	= STATE_NOCHECK;
/*N*/ 
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DISABLED == eState )
/*N*/ 		pBox->Disable();
/*N*/ 	else
/*N*/ 		pBox->Enable();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 			eTri = ((const SfxBoolItem*)pState)->GetValue()
/*N*/ 						? STATE_CHECK
/*N*/ 						: STATE_NOCHECK;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.SetItemState( nId, eTri );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxStyleToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = new SvxStyleBox_Impl( pParent,
/*N*/ 										 SID_STYLE_APPLY,
/*N*/ 										 SFX_STYLE_FAMILY_PARA, GetBindings() );
/*N*/ 
/*N*/ 	// Set visibility listener to bind/unbind controller
/*N*/ 	pBox->SetVisibilityListener( LINK( this, SvxStyleToolBoxControl, VisibilityNotification ));
/*N*/ 
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontNameToolBoxControl ---------------------------------------
//========================================================================

/*N*/ SvxFontNameToolBoxControl::SvxFontNameToolBoxControl(
/*N*/ 											USHORT			nId,
/*N*/ 											ToolBox&		rTbx ,
/*N*/ 											SfxBindings&	rBindings)
/*N*/ 
/*N*/ 	:	SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 			nId	= GetId();
/*N*/ 	ToolBox&		rTbx   = GetToolBox();
/*N*/     SvxFontNameBox_Impl* pBox   = (SvxFontNameBox_Impl*)(rTbx.GetItemWindow( nId ));
/*N*/ 	TriState		eTri   = STATE_NOCHECK;
/*N*/ 
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DISABLED == eState )
/*N*/ 	{
/*N*/ 		pBox->Disable();
/*N*/ 		pBox->Update( (const SvxFontItem*)NULL );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pBox->Enable();
/*N*/ 
/*N*/ 		if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( pState->ISA(SvxFontItem), "falscher ItemType" );
/*N*/ 			pBox->Update( (const SvxFontItem*) pState );
/*N*/ 		}
/*N*/ 		else
/*?*/ 			pBox->SetText( String() );
/*N*/         pBox->SaveValue();
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 			eTri = ((const SfxBoolItem*)pState)->GetValue()
/*N*/ 						? STATE_CHECK
/*N*/ 						: STATE_NOCHECK;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.SetItemState( nId, eTri );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxFontNameToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     SvxFontNameBox_Impl* pBox = new SvxFontNameBox_Impl( pParent, GetBindings() );
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontHeightToolBoxControl -------------------------------------
//========================================================================

/*N*/ SvxFontHeightToolBoxControl::SvxFontHeightToolBoxControl( USHORT nId, ToolBox& rTbx,
/*N*/ 														  SfxBindings& rBindings ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 
/*N*/ 	aFontNameForwarder	( SID_ATTR_CHAR_FONT, *this ),
/*N*/ 	pBox				( NULL ),
/*N*/ 	pFontItem			( NULL )
/*N*/ 
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ SvxFontHeightToolBoxControl::~SvxFontHeightToolBoxControl()
/*N*/ {
/*N*/ 	delete pFontItem;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontHeightToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	// FontHeight?
/*N*/ 	if ( SID_ATTR_CHAR_FONTHEIGHT == nSID )
/*N*/ 	{
/*N*/ 		SfxToolBoxControl::StateChanged( nSID, eState, pState );
/*N*/ 		pBox->StateChanged_Impl( eState, pState );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// FontItem (Name) nur zur sp"aterne Verwendung merken
/*N*/ 		delete pFontItem;
/*N*/ 		pFontItem = (eState == SFX_ITEM_AVAILABLE) ? (SvxFontItem*)pState->Clone() : NULL;
/*N*/ 
/*N*/ 		if ( pFontItem )
/*N*/ 			pBox->Update( *pFontItem );
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxFontHeightToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     pBox = new SvxFontSizeBox_Impl( pParent, *this, GetBindings() );
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontColorToolBoxControl --------------------------------------
//========================================================================

/*N*/ SvxFontColorToolBoxControl::SvxFontColorToolBoxControl(
/*N*/ 										USHORT			nId,
/*N*/ 										ToolBox&		rTbx ,
/*N*/ 										SfxBindings&	rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl	( nId, rTbx, rBindings ),
/*N*/ 	pBtnUpdater(new SvxTbxButtonColorUpdater_Impl(nId, &GetToolBox(), TBX_UPDATER_MODE_CHAR_COLOR_NEW ))
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFontColorToolBoxControl::~SvxFontColorToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxFontColorToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxFontColorToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001     SvxColorWindow_Impl* pColorWin =
//STRIP001         new SvxColorWindow_Impl( GetId(), SID_ATTR_CHAR_COLOR,
//STRIP001 							SVX_RESSTR( RID_SVXITEMS_EXTRAS_CHARCOLOR ),
//STRIP001 							GetBindings() );
//STRIP001 
//STRIP001     pColorWin->StartPopupMode( &GetToolBox(),
//STRIP001         FLOATWIN_POPUPMODE_GRABFOCUS|FLOATWIN_POPUPMODE_ALLOWTEAROFF );
//STRIP001 	pColorWin->StartSelection();
//STRIP001 	return pColorWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFontColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	const SvxColorItem*	pItem = 0;
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 	   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pBtnUpdater->Update( pItem->GetValue());
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxColorToolBoxControl --------------------------------
//========================================================================

/*N*/ SvxColorToolBoxControl::SvxColorToolBoxControl(	USHORT  nId, ToolBox& rTbx, SfxBindings& rBindings ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl	( nId, rTbx, rBindings )
/*N*/ {
/*N*/     pBtnUpdater = new SvxTbxButtonColorUpdater_Impl( nId, &GetToolBox() );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxColorToolBoxControl::~SvxColorToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxColorToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxColorToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	USHORT nResId = GetId() == SID_BACKGROUND_COLOR ?
//STRIP001 						RID_SVXSTR_BACKGROUND : RID_SVXSTR_COLOR;
//STRIP001     SvxColorWindow_Impl* pColorWin = new SvxColorWindow_Impl( GetId(),
//STRIP001 									SID_BACKGROUND_COLOR,
//STRIP001 									SVX_RESSTR(nResId),
//STRIP001 									GetBindings() );
//STRIP001 
//STRIP001     pColorWin->StartPopupMode( &GetToolBox(),
//STRIP001         FLOATWIN_POPUPMODE_GRABFOCUS|FLOATWIN_POPUPMODE_ALLOWTEAROFF );
//STRIP001 	pColorWin->StartSelection();
//STRIP001 	return pColorWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	const SvxColorItem*	pItem	= 0;
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pBtnUpdater->Update( pItem->GetValue() );
/*N*/ 
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFontColorExtToolBoxControl --------------------------------------
//========================================================================

/*N*/ SvxFontColorExtToolBoxControl::SvxFontColorExtToolBoxControl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rTbx,
/*N*/ 	SfxBindings& rBindings
/*N*/ ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 	pBtnUpdater(0),
/*N*/ 	aForward( SID_ATTR_CHAR_COLOR2 == nId
/*N*/ 				? SID_ATTR_CHAR_COLOR_EXT
/*N*/ 				: SID_ATTR_CHAR_COLOR_BACKGROUND_EXT, *this )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nMode =	SID_ATTR_CHAR_COLOR2 == nId
/*N*/ 		? TBX_UPDATER_MODE_CHAR_COLOR_NEW :	TBX_UPDATER_MODE_CHAR_COLOR_NEW;
/*N*/     pBtnUpdater = new SvxTbxButtonColorUpdater_Impl( nId, &GetToolBox(), nMode );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFontColorExtToolBoxControl::~SvxFontColorExtToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxFontColorExtToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONTIMEOUT;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxFontColorExtToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001     SvxColorWindow_Impl* pColorWin =
//STRIP001         new SvxColorWindow_Impl( GetId(), GetId(),
//STRIP001 							SVX_RESSTR( RID_SVXITEMS_EXTRAS_CHARCOLOR ),
//STRIP001 							GetBindings() );
//STRIP001 
//STRIP001 	if ( GetId() == SID_ATTR_CHAR_COLOR_BACKGROUND )
//STRIP001 		pColorWin->SetText( SVX_RESSTR( RID_SVXSTR_EXTRAS_CHARBACKGROUND ) );
//STRIP001 
//STRIP001     pColorWin->StartPopupMode( &GetToolBox(),
//STRIP001         FLOATWIN_POPUPMODE_GRABFOCUS|FLOATWIN_POPUPMODE_ALLOWTEAROFF );
//STRIP001 	pColorWin->StartSelection();
//STRIP001 	return pColorWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFontColorExtToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	const SvxColorItem*	pItem = 0;
/*N*/ 
/*N*/ 	if ( nSID == SID_ATTR_CHAR_COLOR_EXT ||
/*N*/ 		 nSID == SID_ATTR_CHAR_COLOR_BACKGROUND_EXT )
/*N*/ 	{
/*N*/ 		if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		{
/*N*/ 			const SfxBoolItem* pBool = PTR_CAST( SfxBoolItem, pState );
/*N*/ 			rTbx.CheckItem( nId, pBool && pBool->GetValue());
/*N*/ 		}
/*N*/ 		rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 		if ( pItem )
/*N*/ 			pBtnUpdater->Update( pItem->GetValue() );
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SvxFontColorExtToolBoxControl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	USHORT nId = ( SID_ATTR_CHAR_COLOR2 == GetId() ) ? SID_ATTR_CHAR_COLOR_EXT
//STRIP001 													 : SID_ATTR_CHAR_COLOR_BACKGROUND_EXT;
//STRIP001 	SfxBoolItem aItem( nId, GetToolBox().IsItemChecked( GetId() ) );
//STRIP001 	GetBindings().GetDispatcher()->Execute( nId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 }

//========================================================================
// class SvxFrameToolBoxControl ------------------------------------------
//========================================================================

/*N*/ SvxFrameToolBoxControl::SvxFrameToolBoxControl( USHORT		 nId,
/*N*/ 												ToolBox&	 rTbx,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 		bParagraphMode	 ( FALSE )
/*N*/ {
/*N*/ 	rTbx.SetItemBits( nId, TIB_DROPDOWN | rTbx.GetItemBits( nId ) );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxFrameToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxFrameToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001     SvxFrameWindow_Impl* pFrameWin = new SvxFrameWindow_Impl( GetId(),
//STRIP001 													GetBindings(),
//STRIP001 													bParagraphMode );
//STRIP001 
//STRIP001 	pFrameWin->StartPopupMode( &GetToolBox(), FLOATWIN_POPUPMODE_GRABFOCUS | FLOATWIN_POPUPMODE_ALLOWTEAROFF );
//STRIP001 	pFrameWin->StartSelection();
//STRIP001 
//STRIP001 	return pFrameWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFrameToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 					nId		= GetId();
/*N*/ 	ToolBox&	 			rTbx	= GetToolBox();
/*N*/ 	const SfxUInt16Item* 	pItem	= 0;
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		pItem = PTR_CAST( SfxUInt16Item, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*?*/ 		bParagraphMode = (BOOL)pItem->GetValue();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, (SFX_ITEM_DONTCARE == eState)
/*N*/ 								? STATE_DONTKNOW
/*N*/ 								: STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFrameLineStyleToolBoxControl ---------------------------------
//========================================================================

/*N*/ SvxFrameLineStyleToolBoxControl::SvxFrameLineStyleToolBoxControl(
/*N*/ 											USHORT   		nId,
/*N*/ 											ToolBox& 		rTbx,
/*N*/ 											SfxBindings&	rBindings )
/*N*/ 
/*N*/ 	:    SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ {
/*N*/ 	rTbx.SetItemBits( nId, TIB_DROPDOWN | rTbx.GetItemBits( nId ) );
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxFrameLineStyleToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxFrameLineStyleToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001     SvxLineWindow_Impl* pLineWin = new SvxLineWindow_Impl( GetId(), GetBindings() );
//STRIP001 
//STRIP001 	pLineWin->StartPopupMode( &GetToolBox(), TRUE );
//STRIP001 	pLineWin->StartSelection();
//STRIP001 
//STRIP001 	return pLineWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFrameLineStyleToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 		 nId	= GetId();
/*N*/ 	ToolBox&	 rTbx   = GetToolBox();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, (SFX_ITEM_DONTCARE == eState)
/*N*/ 								? STATE_DONTKNOW
/*N*/ 								: STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFrameLineColorToolBoxControl ---------------------------------
//========================================================================

/*N*/ SvxFrameLineColorToolBoxControl::SvxFrameLineColorToolBoxControl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rTbx,
/*N*/ 	SfxBindings& rBindings
/*N*/ ) :
/*N*/ 
/*N*/     SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/     pBtnUpdater(new SvxTbxButtonColorUpdater_Impl(   nId, &GetToolBox() ))
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFrameLineColorToolBoxControl::~SvxFrameLineColorToolBoxControl()
/*N*/ {
/*N*/ 
/*N*/     delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindowType SvxFrameLineColorToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPopupWindow*	SvxFrameLineColorToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001     SvxColorWindow_Impl* pColorWin = new SvxColorWindow_Impl( GetId(),
//STRIP001 									SID_FRAME_LINECOLOR,
//STRIP001 									SVX_RESSTR(RID_SVXSTR_FRAME_COLOR),
//STRIP001 									GetBindings() );
//STRIP001 
//STRIP001     pColorWin->StartPopupMode( &GetToolBox(),
//STRIP001         FLOATWIN_POPUPMODE_GRABFOCUS|FLOATWIN_POPUPMODE_ALLOWTEAROFF );
//STRIP001 	pColorWin->StartSelection();
//STRIP001 	return pColorWin;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ void SvxFrameLineColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ 
/*N*/     const SvxColorItem* pItem = 0;
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/     {
/*N*/ 	   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/         if ( pItem )
/*N*/             pBtnUpdater->Update( pItem->GetValue());
/*N*/     }
/*N*/ }

// class SvxReloadControllerItem_Impl ------------------------------------

class SvxReloadControllerItem_Impl
{
public:
	Image* pNormalImage;
	Image* pSpecialImage;

	SvxReloadControllerItem_Impl() :
		pSpecialImage( 0 ), pNormalImage( new Image( SVX_RES( RID_SVX_RELOAD_NORMAL ) ) ) {}
	~SvxReloadControllerItem_Impl() { delete pNormalImage; delete pSpecialImage; }

	Image& GetNormalImage() { return *pNormalImage; }
	Image& GetSpecialImage()
		{
			if ( !pSpecialImage )
				pSpecialImage = new Image( SVX_RES( RID_SVX_RELOAD_SPECIAL ) );
			return *pSpecialImage;
		}
};

// -----------------------------------------------------------------------

/*?*/ SvxReloadControllerItem::SvxReloadControllerItem(
/*?*/ 	USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	: pImpl( new SvxReloadControllerItem_Impl ),
/*?*/ 	  SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemImage( nId, pImpl->GetNormalImage() );
/*?*/ }

// -----------------------------------------------------------------------

//STRIP001 SvxReloadControllerItem::~SvxReloadControllerItem()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxReloadControllerItem::StateChanged(
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	SfxBoolItem* pItem = PTR_CAST( SfxBoolItem, pState );
//STRIP001 	ToolBox& rBox = GetToolBox();
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		rBox.SetItemImage( GetId(),
//STRIP001 				pItem->GetValue() ? pImpl->GetSpecialImage() :
//STRIP001 				pImpl->GetNormalImage() );
//STRIP001 	}
//STRIP001 	rBox.EnableItem( GetId(), eState != SFX_ITEM_DISABLED );
//STRIP001 //	SfxToolBoxControl::StateChanged( nSID, eState, pState );
//STRIP001 }

//========================================================================

//STRIP001 void lcl_ResizeValueSet( Window &rWin, ValueSet &rValueSet )
//STRIP001 {
//STRIP001 	Size aSize = rWin.GetOutputSizePixel();
//STRIP001 	aSize.Width()  -= 4;
//STRIP001 	aSize.Height() -= 4;
//STRIP001 	rValueSet.SetPosSizePixel( Point(2,2), aSize );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void lcl_CalcSizeValueSet( Window &rWin, ValueSet &rValueSet, const Size &aItemSize ) \
//STRIP001 {
//STRIP001 	Size aSize = rValueSet.CalcWindowSizePixel( aItemSize );
//STRIP001 	aSize.Width()  += 4;
//STRIP001 	aSize.Height() += 4;
//STRIP001 	rWin.SetOutputSizePixel( aSize );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL lcl_FontChangedHint( const SfxHint &rHint )
//STRIP001 {
//STRIP001 	SfxPoolItemHint *pItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 	if ( pItemHint )
//STRIP001 	{
//STRIP001 		SfxPoolItem *pItem = pItemHint->GetObject();
//STRIP001 		return ( pItem->Which() == SID_ATTR_CHAR_FONTLIST );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxSimpleHint* pSimpleHint = PTR_CAST(SfxSimpleHint, &rHint);
//STRIP001 		return pSimpleHint && ( SFX_HINT_DATACHANGED ==
//STRIP001 							( pSimpleHint->GetId() & SFX_HINT_DATACHANGED ) );
//STRIP001 	}
//STRIP001 }
// -----------------------------------------------------------------------------
/*?*/ ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SvxFontNameBox_Impl::CreateAccessible()
/*?*/ {DBG_BF_ASSERT(0, "STRIP");::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > x; return x;//STRIP001 
//STRIP001 	FillList();
//STRIP001 	return FontNameBox::CreateAccessible();
/*?*/ }
}
