/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: templdlg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:43:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_TEMPLDLG_HXX
#define _SFX_TEMPLDLG_HXX

// include ---------------------------------------------------------------

#include <rsc/rscsfx.hxx>

#include <bf_sfx2/dockwin.hxx>
#include <bf_sfx2/childwin.hxx>
#include <bf_sfx2/basedlgs.hxx>
namespace binfilter {

class SfxTemplateDialog_Impl;
class SfxTemplateCatalog_Impl;

// class ISfxTemplateCommon ----------------------------------------------

class ISfxTemplateCommon
{
public:
	virtual SfxStyleFamily GetActualFamily() const = 0;
	virtual String GetSelectedEntry() const = 0;
};

// class SfxTemplateDialog -----------------------------------------------

class SfxTemplateDialog : public SfxDockingWindow
{
private:
	SfxTemplateDialog_Impl *pImpl;

	virtual void DataChanged( const DataChangedEvent& _rDCEvt );
	virtual void Resize();
	virtual SfxChildAlignment
						CheckAlignment(SfxChildAlignment,SfxChildAlignment);
	virtual void		StateChanged( StateChangedType nStateChange );

public:
	virtual void Update();
	ISfxTemplateCommon* GetISfxTemplateCommon();
	SfxTemplateDialog(SfxBindings*, SfxChildWindow*, Window*);
	~SfxTemplateDialog();

private:
friend class SfxTemplateDialogWrapper;
friend class SfxTemplateDialog_Impl;
};

// class SfxTemplateCatalog ----------------------------------------------

//STRIP001 class SfxTemplateCatalog : public SfxModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 	SfxTemplateCatalog_Impl *pImpl;
//STRIP001 
//STRIP001 public:
//STRIP001 	SfxTemplateCatalog(Window * pParent, SfxBindings *pBindings);
//STRIP001 	~SfxTemplateCatalog();
//STRIP001 	friend class SfxTemplateCatalog_Impl;
//STRIP001 };

// class SfxTemplateDialogWrapper ----------------------------------------

class SfxTemplateDialogWrapper : public SfxChildWindow
{
public:
				SfxTemplateDialogWrapper
					(Window*,USHORT,SfxBindings*,SfxChildWinInfo*);
				SFX_DECL_CHILDWINDOW(SfxTemplateDialogWrapper);
};

}//end of namespace binfilter
#endif

