/***************************************************************************
 *   Copyright (C) 2008 by BogDan Vatra                                    *
 *   bogdan@licentia.eu                                                    *
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef BARCODEITEM_H
#define BARCODEITEM_H

#include <QGraphicsItem>
#include <qzint.h>

/**
 @author BogDan Vatra <taipan@licentia.eu>
*/

class BarcodeItem : public QGraphicsItem
{
public:
	BarcodeItem();
	~BarcodeItem();
	QRectF boundingRect() const;
	void paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0);
    void paint(QPainter * painter, const QRectF &r);

public:
	mutable Zint::QZint bc;
	int w,h;
	Zint::QZint::AspectRatioMode ar;
};

#endif
