/**********************************************************************
 *
 *    FILE:            PointSprite.cpp
 *
 *    DESCRIPTION:    Read/Write osg::PointSprite in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "PointSprite.h"
#include "Object.h"

using namespace ive;

void PointSprite::write(DataOutputStream* out){
    // Write PointSprite's identification.
    out->writeInt(IVEPOINTSPRITE);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        throw Exception("PointSprite::write(): Could not cast this osg::PointSprite to an osg::Object.");
    // Write PointSprite's properties.

    // Write mode
    out->writeInt(getCoordOriginMode());
}

void PointSprite::read(DataInputStream* in){
    // Peek on PointSprite's identification.
    int id = in->peekInt();
    if(id == IVEPOINTSPRITE){
        // Read PointSprite's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            throw Exception("PointSprite::read(): Could not cast this osg::PointSprite to an osg::Object.");
        // Read PointSprite's properties

        // Read mode
        setCoordOriginMode((osg::PointSprite::CoordOriginMode)in->readInt());

    }
    else{
        throw Exception("PointSprite::read(): Expected PointSprite identification.");
    }
}

