/*
 * Copyright (C) 2007 Voice Sistem SRL
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * History:
 * --------
 *  2007-08-01 initial version (ancuta)
 */

#ifndef _DP_DB_H_
#define _DP_DB_H

#include "../../str.h"
#include "../../db/db.h"

#define DP_TABLE_NAME			"dialplan"
#define DPID_COL				"dpid"
#define PR_COL					"pr"
#define MATCH_OP_COL			"match_op"
#define MATCH_EXP_COL			"match_exp"
#define MATCH_LEN_COL			"match_len"
#define SUBST_EXP_COL			"subst_exp"
#define REPL_EXP_COL			"repl_exp"
#define ATTRS_COL				"attrs"


#define DP_TABLE_VERSION		1
#define DP_TABLE_COL_NO 		8

extern char* dp_db_url;
extern char* dp_table_name;
extern char* dpid_column; 
extern char* pr_column; 
extern char* match_op_column; 
extern char* match_exp_column; 
extern char* match_len_column; 
extern char* subst_exp_column; 
extern char* repl_exp_column; 
extern char* attrs_column; 

int init_db_data();
int dp_connect_db();
void dp_disconnect_db();

#endif
