//                                               -*- C++ -*-
/**
 *  @file  NumericalPointWithDescription.hxx
 *  @brief NumericalPointWithDescription extends the classical mathematical point with a description of the coordinates
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NumericalPointWithDescription.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX
#define OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX

#include "NumericalPoint.hxx"
#include "Description.hxx"
#include "Pointer.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class NumericalPointWithDescription
       *
       * NumericalPointWithDescription extends the classical mathematical point with a description of the coordinates
       */

      class NumericalPointWithDescription
	: public NumericalPoint
      {
	CLASSNAME;

      public:

	typedef Common::StorageManager StorageManager;

	/** Default constructor */
	NumericalPointWithDescription();

	/** Constructor with size */
	NumericalPointWithDescription(const UnsignedLong size,
				      const NumericalScalar value = 0.0);

	/** Constructor from a collection */
	NumericalPointWithDescription(const Type::Collection<NumericalScalar> & coll);

	/** Constructor from a base class */
	NumericalPointWithDescription(const Common::Pointer<NumericalPoint> & p_base);

	/** Virtual constructor */
	virtual NumericalPointWithDescription * clone() const;

	/** Destructor */
	virtual ~NumericalPointWithDescription() throw();

	/** Description Accessor */
	void setDescription(const Description & description);
	Description getDescription() const;

	/** String converter */
	String __repr__() const;
	String __str__() const;


	/** Method save() stores the object through the StorageManager */
	virtual void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(StorageManager::Advocate & adv);	

      private:

	/** The description of all components */
	Description description_;

      }; /* class NumericalPointWithDescription */

      

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX */
