//                                               -*- C++ -*-
/**
 *  @file  MarginalTransformationEvaluation.hxx
 *  @brief Class for the Nataf transformationEvaluation evaluation for elliptical
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: MarginalTransformationEvaluation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_MARGINALTRANSFORMATIONEVALUATION_HXX
#define OPENTURNS_MARGINALTRANSFORMATIONEVALUATION_HXX

#include "OTprivate.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Matrix.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class MarginalTransformationEvaluation
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class MarginalTransformationEvaluation
	: public Base::Func::NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathEvaluationImplementation NumericalMathEvaluationImplementation;
	typedef Base::Type::Matrix                                Matrix;
	typedef Base::Type::NumericalPoint                        NumericalPoint;
	typedef Model::Distribution                               Distribution;
	typedef Base::Type::Collection<Distribution>              DistributionCollection;
	typedef Base::Common::InternalException                   InternalException;
	typedef Base::Common::InvalidArgumentException            InvalidArgumentException;

	enum TranformationDirection { FROM, TO, FROMTO };

	/** Parameter constructor */
	MarginalTransformationEvaluation(const DistributionCollection & distributionCollection,
					 const UnsignedLong direction = FROM);

	/** Parameter constructor */
	MarginalTransformationEvaluation(const DistributionCollection & inputDistributionCollection,
					 const DistributionCollection & outputDistributionCollection);

	/** Virtual constructor */
	virtual MarginalTransformationEvaluation * clone() const;

	/** Evaluation */
	NumericalPoint operator () (const NumericalPoint & in) const
	  /* throw (InvalidArgumentException, InternalException) */;

	/** Gradient according to the marginal parameters */
	Matrix parametersGradient(const NumericalPoint & in) const;
	  
	/** Accessor for input point dimension */
	UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

	/** Direction accessor */
	void setDirection(const TranformationDirection direction);
	UnsignedLong getDirection() const;

	/** Input distribution collection accessor */
	void setInputDistributionCollection(const DistributionCollection & inputDistributionCollection);
	DistributionCollection getInputDistributionCollection() const;

	/** Output distribution collection accessor */
	void setOutputDistributionCollection(const DistributionCollection & outputDistributionCollection);
	DistributionCollection getOutputDistributionCollection() const;

	/** String converter */
	String __repr__() const;

      protected:

    
      private:
	// Make the gradient and the hessian friend classes of the evaluation in order to share the input and output distribution collections
	friend class MarginalTransformationGradient;
	friend class MarginalTransformationHessian;

	// marginal distributions of the input
	DistributionCollection inputDistributionCollection_;

	// Marginal distributions of the output
	DistributionCollection outputDistributionCollection_;

	// Direction of the transformation
	UnsignedLong direction_;

      }; /* MarginalTransformationEvaluation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_MARGINALTRANSFORMATIONEVALUATION_HXX */
