//                                               -*- C++ -*-
/**
 *  @file  t_ComposedDistribution_large.cxx
 *  @brief The test file of class ComposedDistribution for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_ComposedDistribution_large.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "ComposedDistribution.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "IndependentCopula.hxx"
#include "IdentityMatrix.hxx"
#include "Indices.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;




int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    NumericalPoint meanPoint(1);
    meanPoint[0] = 1.0;
    NumericalPoint sigma(1);
    sigma[0] = 3.0;
    CorrelationMatrix R(1);
    R(0, 0) = 1.0;
    // Create a collection of distribution
    UnsignedLong dimension(2000);
    fullprint << "Creating a composed distribution of dimension " << dimension << std::endl;
    ComposedDistribution::DistributionCollection aCollection(dimension, Normal(meanPoint, sigma, R));

    for (UnsignedLong i = 0; i < dimension; i++)
      {
	aCollection[i] = Normal(meanPoint, sigma, R);
      }

    // Create a copula
    IndependentCopula aCopula(dimension);
    // Instanciate one distribution object
    ComposedDistribution distribution(aCollection, aCopula);
    fullprint << "Distribution created." << std::endl;
    // Is this distribution an elliptical distribution?
    fullprint << "Elliptical distribution= " << (distribution.isElliptical() ? "true" : "false") << std::endl;

    // Has this distribution an elliptical copula?
    fullprint << "Elliptical copula= " << (distribution.hasEllipticalCopula() ? "true" : "false") << std::endl;

    // Has this distribution an independent copula?
    fullprint << "Independent copula= " << (distribution.hasIndependentCopula() ? "true" : "false") << std::endl;

    // Test for sampling
    UnsignedLong size = 10;
    NumericalSample anotherSample = distribution.getNumericalSample( size );

    // Define a point
    NumericalPoint zero(dimension, 0.0);

    // Show PDF and CDF of zero point
    NumericalScalar zeroPDF = distribution.computePDF( zero );
    NumericalScalar zeroCDF = distribution.computeCDF( zero );
    fullprint << " pdf=" << zeroPDF
	      << " cdf=" << zeroCDF
	      << std::endl;
    // Get 95% quantile
    NumericalPoint quantile = distribution.computeQuantile( 0.95 );
    fullprint << "Quantile=" << quantile << std::endl;
    fullprint << "CDF(quantile)=" << distribution.computeCDF(quantile) << std::endl;

    // Extract a 2-D marginal
    Indices indices(2, 0);
    indices[0] = 1;
    indices[1] = 0;
    fullprint << "indices=" << indices << std::endl;
    Distribution margins(distribution.getMarginal(indices));
    fullprint << "margins=" << margins << std::endl;
    fullprint << "margins PDF=" << margins.computePDF(NumericalPoint(2)) << std::endl;
    fullprint << "margins CDF="<< margins.computeCDF(NumericalPoint(2)) << std::endl;
    quantile = margins.computeQuantile(0.5);
    fullprint << "margins quantile=" << quantile << std::endl;
    fullprint << "margins CDF(quantile)=" << margins.computeCDF(quantile) << std::endl;
    fullprint << "margins realization=" << margins.getRealization() << std::endl;
    NumericalSample sample(margins.getNumericalSample(1000));
    fullprint << "margins sample mean=" << sample.computeMean() << std::endl;
    fullprint << "margins sample covariance=" << sample.computeCovariance() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
