#                                               -*- Python -*-
#
#  __init__.py
#
#  (C) Copyright 2005-2010 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2009-01-28 14:45:54 +0100 (mer, 28 jan 2009) $
#  Id:      $Id: Makefile.am 1087 2009-01-28 13:45:54Z dutka $
#
import openturns_preload

from common import *
from wrapper import *
from typ import *
from statistics import *
from graph import *
from func import *
from diff import *
from optim import *
from solver import *
from base import *

from model_dist import *
from experiment import *
from orthogonalbasis import *
from metamodel import *
from isoprobabilistictransformation import *
from analytical import *
from simulation import *
from stattests import *
from uncertainty import *

import os
import sys
import platform

# This code prints the version number when the module is imported
if not ( ( os.environ.has_key( 'OPENTURNS_PYTHON_SILENT' ) and ( len(os.environ[ 'OPENTURNS_PYTHON_SILENT' ]) != 0 ) ) or ( "--silent" in sys.argv ) ):
  sys.stderr.write( "Welcome to OpenTURNS version %s\n" % PlatformInfo.GetVersion() )

# This code sets the sys.path (through site module) to point to the module standard dirs
dirs = os.getenv("OPENTURNS_MODULE_PATH", None)
if dirs:
    import string
    if(platform.system() != "Windows"):
        path_separator = ":"
    else:
        path_separator = ";"
    dirlist = string.split(dirs, path_separator)
else:
    dirlist = list()
dirlist.append( "%s/openturns/lib/openturns/module" % os.getenv("HOME") )
dirlist.append( Path.GetModuleDirectory() )
dirlist.append( Path.GetInstallationDirectory() )

import site
for d in dirlist:
    if(platform.system() != "Windows"):
        python_suffix = "/lib/python%d.%d/site-packages" % ( sys.version_info[0], sys.version_info[1] )
    else:
        python_suffix = "/lib/python%d%d/site-packages" % ( sys.version_info[0], sys.version_info[1] )
    site.addsitedir( d + python_suffix )

def PRINT(obj):
  return repr(obj)
