//                                               -*- C++ -*-
/**
 *  @file  OTAlgo.hxx
 *  @brief The external header file of Open TURNS for subdir Algo
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTAlgo.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTALGO_HXX
#define OPENTURNS_OTALGO_HXX

#include "FittingAlgorithmImplementation.hxx"
#include "FittingAlgorithm.hxx"
#include "KFold.hxx"
#include "CorrectedLeaveOneOut.hxx"
#include "ApproximationAlgorithmImplementation.hxx"
#include "ApproximationAlgorithm.hxx"
#include "ApproximationAlgorithmImplementationFactory.hxx"
#include "Lasso.hxx"
#include "LassoFactory.hxx"
#include "LeastSquaresMetaModelSelection.hxx"
#include "LeastSquaresMetaModelSelectionFactory.hxx"
#include "PenalizedLeastSquaresAlgorithm.hxx"
#include "PenalizedLeastSquaresAlgorithmFactory.hxx"
#include "FFTImplementation.hxx"
#include "FFT.hxx"
#include "KissFFT.hxx"
#include "kissfft.hh"

#endif /* OPENTURNS_OTALGO_HXX */
