//                                               -*- C++ -*-
/**
 *  @file  PostAnalyticalSimulation.cxx
 *  @brief PostAnalyticalSimulation is a generic view of postAnalyticalSimulation methods for computing
 * probabilities and related quantities by sampling and estimation
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-06-04 11:47:22 +0200 (mer, 04 jun 2008) $
 *  Id:      $Id: PostAnalyticalSimulation.cxx 840 2008-06-04 09:47:22Z lebrun $
 */
#include "PostAnalyticalSimulation.hxx"

BEGIN_NAMESPACE_OPENTURNS



/*
 * @class PostAnalyticalSimulation
 */

CLASSNAMEINIT(PostAnalyticalSimulation);

/* Constructor with parameters */
PostAnalyticalSimulation::PostAnalyticalSimulation(const AnalyticalResult & analyticalResult)
  : Simulation(analyticalResult.getLimitStateVariable()),
    analyticalResult_(analyticalResult),
    standardEvent_(StandardEvent(getEvent())),
    standardDistribution_(standardEvent_.getImplementation()->getAntecedent()->getDistribution())
{
  // Compute the probability associated to the analytical result
  controlProbability_ = standardDistribution_.getMarginal(0).computeCDF(-analyticalResult.getHasoferReliabilityIndex());
}

/* Analytical result accessor */
AnalyticalResult PostAnalyticalSimulation::getAnalyticalResult() const
{
  return analyticalResult_;
}

/* Control probability accessor */
NumericalScalar PostAnalyticalSimulation::getControlProbability() const
{
  return controlProbability_;
}

/* String converter */
String PostAnalyticalSimulation::__repr__() const
{
  OSS oss;
  oss << "class=" << PostAnalyticalSimulation::GetClassName()
      << " analyticalResult=" << analyticalResult_
      << " controlProbability_=" << controlProbability_;
  return oss;
}

END_NAMESPACE_OPENTURNS
