//                                               -*- C++ -*-
/**
 *  @file  BoxCoxFactory.hxx
 *  @brief This class is enables to estimate parameters of the BoxCox model
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: BoxCoxFactory.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_BOXCOXFACTORY_HXX
#define OPENTURNS_BOXCOXFACTORY_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "TimeSeries.hxx"
#include "BoxCoxTransform.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class BoxCoxFactory
 */

class BoxCoxFactory
  : public PersistentObject
{

  CLASSNAME;

public:

  /** Default constructor without parameters */
  BoxCoxFactory(const String & name = DefaultName);

  /** Default constructor without parameters */
  BoxCoxFactory(const NumericalScalar alpha,
                const String & name = DefaultName);

  /** alpha accessors */
  NumericalScalar getAlpha() const;
  void setAlpha(const NumericalScalar alpha);

  /** Virtual copy constructor */
  BoxCoxFactory * clone() const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

  /** Build the factory from data by estimating the best \lambda which maximizes the log-likelihood function */
  BoxCoxTransform * build(const TimeSeries & timeSeries) const;


protected:

  /** Likelihood function */
  NumericalScalar computeLogLikelihood(const NumericalScalar & lambda) const;

  /** wrapper function passed to cobyla */
  static int ComputeObjectiveAndConstraint( int n,
                                            int m,
                                            double * x,
                                            double * f,
                                            double * con,
                                            void * state);

  /** only used to pass data to be used in computeLogLikeliHood */
  mutable NumericalSample sample_;

  /** only used to pass data to be used in computeLogLikeliHood */
  mutable NumericalScalar scalar_;

  /** alpha is a scalar used for translating values */
  NumericalScalar alpha_;

} ; /* class BoxCoxFactory */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BOXCOXFACTORY_HXX */
