//                                               -*- C++ -*-
/**
 *  @file  StandardEvent.hxx
 *  @brief The class that implements an event based on a composite random vector whose
 *   antecedent has a spherical distribution
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: StandardEvent.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_STANDARDEVENT_HXX
#define OPENTURNS_STANDARDEVENT_HXX

#include "OTprivate.hxx"
#include "RandomVector.hxx"
#include "Event.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class StandardEvent
 *
 * The class that implements an event based on a composite random vector whose
 * antecedent has a spherical distribution
 */
class StandardEvent
  : public Event
{
  CLASSNAME;

public:


  /** Default constructor */
  StandardEvent();

  /** Constructor from RandomVector */
  StandardEvent(const RandomVector & antecedent,
                const ComparisonOperator & op,
                const NumericalScalar threshold,
                const String & name = DefaultName);

  /** Constructor from Event */
  StandardEvent(const Event & event,
                const String & name = DefaultName);


protected:


private:

}; /* class StandardEvent */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_STANDARDEVENT_HXX */
