###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for hplip vulnerabilities USN-674-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840211);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "674-2");
  script_cve_id("CVE-2008-2940", "CVE-2008-2941");
  script_name( "Ubuntu Update for hplip vulnerabilities USN-674-2");
  desc = "

  Vulnerability Insight:

  USN-674-1 provided packages to fix vulnerabilities in HPLIP. Due to an
  internal archive problem, the updates for Ubuntu 7.10 would not install
  properly. This update provides fixed packages for Ubuntu 7.10.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  It was discovered that the hpssd tool of hplip did not validate
  privileges in the alert-mailing function. A local attacker could
  exploit this to gain privileges and send e-mail messages from the
  account of the hplip user. This update alters hplip behaviour by
  preventing users from setting alerts and by moving alert configuration
  to a root-controlled /etc/hp/alerts.conf file. (CVE-2008-2940)
  
  It was discovered that the hpssd tool of hplip did not correctly
  handle certain commands. A local attacker could use a specially
  crafted packet to crash hpssd, leading to a denial of service.
  (CVE-2008-2941)

  Affected Software/OS:
  hplip vulnerabilities on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000783.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hplip vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"hpijs", ver:"2.7.7+2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hplip-dbg", ver:"2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hplip", ver:"2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hplip-data", ver:"2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hplip-doc", ver:"2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hplip-gui", ver:"2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hpijs-ppds", ver:"2.7.7+2.7.7.dfsg.1-0ubuntu5.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}