##############################################################################
# OpenVAS Vulnerability Test
# $ secpod_winrar_detect.nasl 4470 2009-09-15 13:10:24Z sep $
#
# WinRAR Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http//www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901021);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("WinRAR Version Detection");
  desc = "
  Overview : This script finds the installed WinRAR and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of WinRAR in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\WinRAR.exe";
if(!registry_key_exists(key:key))
{
  exit(0);
}

path =  registry_get_sz(key:key, item:"Path");

if("WinRAR" >< path)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path +"\WinRAR.exe");

  rarVer = GetVer(file:file, share:share);

  if(isnull(rarVer))
  {
    path = path + "\WhatsNew.txt";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);

    rarVer = read_file(share:share, file:file, offset:0, count:1000);
    if(rarVer != NULL)
    {
      rarVer = eregmatch(pattern:"[v|V]ersion ([0-9.]+)", string:rarVer);
      if(rarVer[1] != NULL){
         rarVer = rarVer[1];
      }
    }
  }

 set_kb_item(name:"WinRAR/Ver", value:rarVer);
 security_note(data:"WinRAR version " + rarVer + " was detected on the host");
}
