/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#include "oroborus.h" 
 
/* 
 * 
 * Load pixmap file 
 * 
 */ 

void load_pixmap_file(char *dir, char *file_name, Pixmap *pm, Pixmap *mask, int *w, int *h, XpmColorSymbol *colsym, int numsym) 
{ 
  char *full_file_name=NULL; 
  char *data[]={ "1 1 2 1", 
                 "  c None", 
                 ". c #000000", 
                 "." }; 
  XpmAttributes attr; 
 
#ifdef DEBUG 
  printf("load_pixmap_file\n"); 
#endif 
 
  attr.valuemask=XpmSize|XpmColorSymbols; 
  attr.colorsymbols=colsym; 
  attr.numsymbols=numsym; 
 
  /* Build full file name */ 
  if((full_file_name=malloc(strlen(dir)+strlen(file_name)+2))==NULL)
  { 
    fprintf(stderr, "%s: Memory allocation failed in function load_pixmap_file.\n", PROGNAME);
    exit(1);
  }
 
  sprintf(full_file_name, "%s/%s", dir, file_name);  
 
  /* Read pixmap and get size */ 
  if(XpmReadFileToPixmap(dpy, root, full_file_name, pm, mask, &attr))
  {
    fprintf(stderr, "%s: Can't load pixmap %s.\n", PROGNAME, full_file_name); 
    XpmCreatePixmapFromData(dpy, root, data, pm, mask, &attr);
  }
     
  if(w) 
    *w=attr.width; 
  if(h) 
    *h=attr.height; 
 
  /* Free allocated memory */ 
  free(full_file_name); 
} 
 
/* 
 * 
 * Load pixmaps 
 * 
 */ 

void load_pixmaps(char *pixmap_dir, XpmColorSymbol *colsym, int numsyms) 
{ 
#ifdef DEBUG 
  printf("load_pixmaps\n"); 
#endif 
 
  /* Load resize pixmaps */ 
  load_pixmap_file(pixmap_dir, "resize-active.xpm", &config.resize.pixmap[FRAME_ACTIVE], &config.resize.mask[0], &config.resize.width, &config.resize.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "resize-inactive.xpm", &config.resize.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load hide button pixmaps */ 
  load_pixmap_file(pixmap_dir, "hide-active.xpm", &config.hide.pixmap[FRAME_ACTIVE], &config.hide.mask[0], &config.hide.width, &config.hide.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "hide-inactive.xpm", &config.hide.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "hide-pressed.xpm", &config.hide.pixmap[BUTTON_PRESSED], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load close button pixmaps */ 
  load_pixmap_file(pixmap_dir, "close-active.xpm", &config.close.pixmap[FRAME_ACTIVE], &config.close.mask[0], &config.close.width, &config.close.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "close-inactive.xpm", &config.close.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "close-pressed.xpm", &config.close.pixmap[BUTTON_PRESSED], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load title pixmaps */ 
  load_pixmap_file(pixmap_dir, "title-active.xpm", &config.title.pixmap[FRAME_ACTIVE], NULL, NULL, &config.title.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "title-inactive.xpm", &config.title.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "title-active-shaded.xpm", &config.title.pixmap[FRAME_ACTIVE_SHADED], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "title-inactive-shaded.xpm", &config.title.pixmap[FRAME_INACTIVE_SHADED], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load top-left pixmaps */ 
  load_pixmap_file(pixmap_dir, "top-left-active.xpm", &config.top_left.pixmap[FRAME_ACTIVE], &config.top_left.mask[0], &config.top_left.width, &config.top_left.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-left-inactive.xpm", &config.top_left.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-left-active-shaded.xpm", &config.top_left.pixmap[FRAME_ACTIVE_SHADED], &config.top_left.mask[1], NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-left-inactive-shaded.xpm", &config.top_left.pixmap[FRAME_INACTIVE_SHADED], NULL, NULL, NULL, colsym, numsyms); 
  
  /* Load top-right pixmaps */ 
  load_pixmap_file(pixmap_dir, "top-right-active.xpm", &config.top_right.pixmap[FRAME_ACTIVE], &config.top_right.mask[0], &config.top_right.width, &config.top_right.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-right-inactive.xpm", &config.top_right.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-right-active-shaded.xpm", &config.top_right.pixmap[FRAME_ACTIVE_SHADED], &config.top_right.mask[1], NULL, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "top-right-inactive-shaded.xpm", &config.top_right.pixmap[FRAME_INACTIVE_SHADED], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load left pixmaps */ 
  load_pixmap_file(pixmap_dir, "left-active.xpm", &config.left.pixmap[FRAME_ACTIVE], NULL, &config.left.width, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "left-inactive.xpm", &config.left.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load right pixmaps */ 
  load_pixmap_file(pixmap_dir, "right-active.xpm", &config.right.pixmap[FRAME_ACTIVE], NULL, &config.right.width, NULL, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "right-inactive.xpm", &config.right.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load bottom-left pixmaps */ 
  load_pixmap_file(pixmap_dir, "bottom-left-active.xpm", &config.bottom_left.pixmap[FRAME_ACTIVE], &config.bottom_left.mask[0], &config.bottom_left.width, &config.bottom_left.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "bottom-left-inactive.xpm", &config.bottom_left.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
 
  /* Load bottom pixmaps */ 
  load_pixmap_file(pixmap_dir, "bottom-active.xpm", &config.bottom.pixmap[FRAME_ACTIVE], NULL, NULL, &config.bottom.height, colsym, numsyms); 
  load_pixmap_file(pixmap_dir, "bottom-inactive.xpm", &config.bottom.pixmap[FRAME_INACTIVE], NULL, NULL, NULL, colsym, numsyms); 
} 
 

