<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns="http://www.w3.org/1999/xhtml">

  <xsl:template match="benchmark">
  <html>
    <head>
      
      <style type="text/css">
        body { font:14px helvetica; text-align:center; font-weight:bold}
        table { color: white; }
        td {background-color: #333333 ; padding:5px;}
        h1 { text-align:left; }
        h2 { text-align:left; }
        .invis {background-color: transparent}
        .minus {background-color: #CC0000}
        .plus {background-color: #006600}
        .null {background-color: #0066CC}
        .none {background-color: #FF9900}
      </style>

      <title><xsl:value-of select="title"/></title>

    </head>
    <body>
      <h1><xsl:value-of select="title"/></h1>
      <h2>runned <xsl:value-of select="date"/></h2>
      <table>
        <xsl:call-template name = "table_head" />
        <xsl:for-each select="test">
          <xsl:sort select="date"/>
          <xsl:call-template name = "table_columns" />
        </xsl:for-each>
      </table>
    </body>
  </html>     

  </xsl:template>

  <xsl:template name = "table_head" >
  <tr>
    <td class="invis"></td>
      <xsl:for-each select="test">
        <xsl:sort select="date"/>
        <td><xsl:value-of select="date"/><br/>[<xsl:value-of select="run_time"/>]</td>
      </xsl:for-each>
    </tr>
  </xsl:template>

  <xsl:template name = "table_columns" >
    <tr>
      <td><xsl:value-of select="date"/></td>

        <xsl:variable name="current_runtime">
          <xsl:value-of select="run_time"/>
        </xsl:variable>
   
    <xsl:for-each select="./../test">
      <xsl:sort select="date"/>
        <xsl:variable name="diff_percent">
          <xsl:value-of select="-round(((run_time - $current_runtime) * 100) div $current_runtime)"/>
        </xsl:variable>

        <td>
      	  <xsl:choose>
            <xsl:when test="$diff_percent = 'NaN' ">
              <xsl:attribute name="class">none</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$diff_percent &gt; 0"><xsl:attribute name="class">plus</xsl:attribute></xsl:if>
              <xsl:if test="$diff_percent &lt; 0"><xsl:attribute name="class">minus</xsl:attribute></xsl:if>  
              <xsl:if test="$diff_percent = 0"><xsl:attribute name="class">null</xsl:attribute></xsl:if> 
              <xsl:value-of select="$diff_percent" />%
            </xsl:otherwise>
          </xsl:choose>
        </td>

      </xsl:for-each>
    </tr>
  </xsl:template>

</xsl:stylesheet>
