/*
 * Copyright (C) 2007 Loic Dachary <loic@dachary.org>
 * (C) 2004-2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include <UnitTest++.h>
#include <map>
#include <vector>
#include <string>
#include <iostream>
#include <glib.h>
#include "osgCal/Model"

#include "osgcal.h"

#ifdef WIN32
#define DATA_DIR "../../data/MC/"
#undef main
#endif

int main(int argc, char *argv[])
{
	return UnitTest::RunAllTests();
}


namespace osgCal {
  bool Model::installOutfitFromXMLString(const std::string& xmlString) { return true;}


  Model::Model() {}
  Model::Model(Model const&, osg::CopyOp const&) {}
  Model::~Model() {}
  bool Model::setCoreModel(osgCal::CoreModel*) { return true;}
  bool Model::setUseVertexProgram(bool, unsigned int) { return true;}
  bool Model::initOutfitFromXMLString(std::string const&, std::vector<std::string> *) { return true;}
  bool Model::create() { return true;}
  bool Model::applyParameterFromOutfitDescription() { return true;}
};

osgUtil::SceneView* osgViewer::GetSceneView() { return 0;}
bool ParseDirectory(const std::string& input, std::vector<std::string>& result);
osg::Group* osgViewer::GetRoot() { return 0;}

TEST(parseCommandLineGood1)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(11,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood2)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(10,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood3)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(7,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood4)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(9,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood5)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(7,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood6)
{
  char* input[] = { "osgcal",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(4,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  delete arg;
}

TEST(parseCommandLineGood7)
{
  std::map<std::string,std::string> line;
  char* input[] = { "osgcal",
                     "--directory",
                     DATA_DIR,
                     "cal3d.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(4,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(true, rc);
  for (int i = 0;i <arg->mPositional_arguments.size(); i++)
    line[arg->mPositional_arguments[i] ] = arg->mPositional_arguments[i];
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit00.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit01.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit02.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit03.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit04.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit05.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit06.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit07.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit08.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit09.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit10.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit11.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit12.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit13.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit14.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("outfit15.xfg")) != line.end());
  CHECK_EQUAL(true, line.find(std::string(DATA_DIR) + std::string(G_DIR_SEPARATOR_S) + std::string("cal3d.xfg")) != line.end());
  delete arg;
}

TEST(parseCommandLineBad1)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     //                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(10,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}

TEST(parseCommandLineBad2)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     //"3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(10,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}

TEST(parseCommandLineBad3)
{
  char* input[] = { "osgcal",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(10,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}

TEST(parseCommandLineBad4)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.bd", // bad argument must be a cal3d.xfg
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(11,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}

TEST(parseCommandLineBad5)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "cal3d.xfg",
                     "--directory",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(12,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}


TEST(parseCommandLineBad6)
{
  char* input[] = { "osgcal",
                     "--benchmark",
                     "--vertexprogram",
                     "--fixcam",
                     "--numberloops",
                     "10",
                     "--numberframe",
                     "3",
                     "--directory",
                     "yo.xfg",
                     "da.xfg",
                    0};

  ParseArguments* arg = new ParseArguments(11,input);
  bool rc = arg->Parse();
  CHECK_EQUAL(false, rc);
  delete arg;
}
