

#include <stdio.h>
#include <regex.h>

#define TRUE 1
#define FALSE !TRUE

#define REGEX_FLAGS   (REG_EXTENDED|REG_ICASE|REG_NOSUB)
typedef int osi_bool;


osi_bool name_regex( const char *name, const char *pattern )
{
    regex_t preg;
    regmatch_t results;

    if( name != NULL && pattern != NULL )
    {
        if( strlen( pattern ) == 1 && pattern[0] == '*' )
        {
            return TRUE;
        }

        memset( &preg, 0, sizeof( preg ) );
        memset( &results, 0, sizeof( results ) );

        if( regcomp( &preg, pattern, REGEX_FLAGS ) == 0 )
        {
            if( regexec( &preg, name, 1, &results, 0 ) == 0 )
            {
                return TRUE;
            }
        }
    }

    return FALSE;
}


#define BASE "C:\\Program Files\\Altiris\\eXpress\\NS Client\\Queue\\NSA-SJC-003.CISCO.COM"
#define CASE ".*NSA-SJC-003*"

int main()
{
    if( name_regex( BASE, CASE ) )
    {
        fprintf(stderr," (%s) matches regex (%s)\n", BASE, CASE );
    }
    
    else
    {
        fprintf(stderr," (%s) does NOT match regex (%s)\n", BASE, CASE );
    }

    return 0;
}
