# This makefile is used in conjunction with the Knit-generated makefile
# code.  It provides default settings for variables and OSKit-specific
# linking information.

# This rule goes first to make it the default
default	::

.SUFFIXES:
CFLAGS = -O -g
AR = /usr/bin/ar
RM = /bin/rm -f
RENAME_DOT_O_FILES = rename_dot_o_files

## If -s is passed to make, make things quiet but echo an explanation of
## what make is doing at each stage.

ifeq (s,$(findstring s,$(MAKEFLAGS)))
KNIT_QUIET_MAKE_INFORM=@echo
ARFLAGS=r  ## drop the v from the default
else
KNIT_QUIET_MAKE_INFORM=@true
endif

# This makefile includes the (giant) makefile generated by Knit
# which should define OSKITDIR, BUILDDIR and KNIT_LIBS

include knit_generated.mk

# Now we build OSKIT-specific .o files and link the result into a kernel

knit_inits.o : knit_inits.c
	$(KNIT_QUIET_MAKE_INFORM) Building $@
	$(CC) $(CFLAGS) -o knit_inits.o -c knit_inits.c

mb_wrapper.o : ${OSKITDIR}/knit/c/mb_wrapper.c
	$(KNIT_QUIET_MAKE_INFORM) Building $@
	$(CC) $(CFLAGS) -c -I ${OSKITDIR} -I ${BUILDDIR} ${OSKITDIR}/knit/c/mb_wrapper.c

kernel : knit_inits.o mb_wrapper.o $(KNIT_LIBS)
	$(KNIT_QUIET_MAKE_INFORM) Building $@
	$(LD) -Ttext 100000 $(LDFLAGS) ${BUILDDIR}/lib/multiboot.o mb_wrapper.o knit_inits.o --start-group $(KNIT_LIBS) --end-group ${BUILDDIR}/lib/crtn.o -o kernel
	size kernel


# If you want to include boot modules, do this:
# 
#   make MB_FILES='src_file1:tgt_file1 src_file2:tgt_file2' Image
#
# where the name before each colon is the file to include and the name
# after each colon is the name you want the bootmodule to have (often a
# Unix-style filename).
#
# If you want, you can specify the value for MB_FILES when invoking Knit
# (since Knit variables get copied into the Knit-generated part of the 
# makefile).  A little care is required to get the quoting right.
# 
#   Knit OSKITDIR=${SRC}/oskit \
#        BUILDDIR=${SRC}/knit_oskit \
#        UNIT_PATH=${SRC}/oskit/knit \
#        MAKEFILE=${SRC}/oskit/knit/knit.mk \
#        MB_FILES=\'/etc/passwd\'  \
#        Delta.unit Cat_Delta
#
# Note that there's no dependency on MB_FILES because it isn't a 
# simple file list.  So if you change the files, delete Image.

Image : kernel
	mkmbimage kernel ${MB_FILES}

# The kernel is one of our default targets.
# Multiboot images are not because we only need them if we want to add
# boot modules.
default :: kernel

clean :: 
	$(RM) Image kernel knit_inits.o mb_wrapper.o
clean :: 
	$(RM) $(KNIT_LIBS)
clean :: 
	$(RM) *_anon_*.c
clean :: 
	find . -name '*.[do]' | xargs $(RM)
clean :: 
	find . -name 'rename*' | xargs $(RM)
clean :: 
	find . -name '*xxx' | xargs $(RM)
clean :: 
	find . -name '*yyy' | xargs $(RM)

# End of file
