<?php
// $Id: pnadmin.php
// ----------------------------------------------------------------------
// POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WIthOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Filename: 1.0
// Based on : pnOwl
// Postnuked for .723 by Cas Nuy
// Purpose of file:  Admin functions for pnOwl
// ----------------------------------------------------------------------

/**
 * the main administration function
 */
function pnOwl_admin_main()
{

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'pnOwl::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_PNOWLNOAUTH));
        return $output->GetOutput();
    }

    // Add menu to output
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->Text(pnOwl_adminmenu());
    $output->SetInputMode(_PNH_PARSEINPUT);

    // Return the output that has been generated by this function
    return $output->GetOutput();
}

/*
 * Main administration menu
 */
function pnOwl_adminmenu() {

   $theme = pnUserGetTheme();
	pnThemeLoad($theme);

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'pnOwl::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_PNOWLNOAUTH));
        return $output->GetOutput();
    }

	//Title
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Title(pnVarPrepHTMLDisplay('<b>'._PNOWL.'</b>'));
    $output->Text(pnVarPrepHTMLDisplay(_PNOWLMODIFYCONFIG));
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// Start form
    $output->FormStart(pnModURL('pnOwl', 'admin', 'updateconfig'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());


    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();

	// Owl location
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODSUBJECT));
    $row[] = $output->FormText('_owlloc', pnModGetVar('pnOwl', '_owlloc'), 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');
    //$output->SetInputMode(_PNH_PARSEINPUT);



	// Warning
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWARNING));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	// Owl DB
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODDB));
    $row[] = $output->FormText('_owldb', pnModGetVar('pnOwl', '_owldb'), 25, 25);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');



	// Use PostWrap
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWRAP));
    $row[] = $output->FormCheckbox('_owlwrap', pnModGetVar('pnOwl', '_owlwrap'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	// Draw Frame
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODFRAME));
    $row[] = $output->FormCheckbox('_owlframe', pnModGetVar('pnOwl', '_owlframe'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Open in New >Window
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWINDOW));
    $row[] = $output->FormCheckbox('_owlwindow', pnModGetVar('pnOwl', '_owlwindow'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Create users
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODUSERS));
    $row[] = $output->FormCheckbox('_owlusers', pnModGetVar('pnOwl', '_owlusers'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Default group for new users
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODGROUP));
    $row[] = $output->FormText('_owlgrp', pnModGetVar('pnOwl', '_owlgrp'), 3, 3);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// How to call folders
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODFOLDER));
    $row[] = $output->FormText('_owlfolder', pnModGetVar('pnOwl', '_owlfolder'), 1, 1);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Allow Guest
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODGUEST));
    $row[] = $output->FormCheckbox('_owlguest', pnModGetVar('pnOwl', '_owlguest'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_PNOWLUPDATE));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();

	// Return the output that has been generated by this function
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
	return $output->GetOutput();
}

function pnOwl_admin_updateconfig()
{
    // Get parameters from whatever input we need.
	$_owlloc = pnVarCleanFromInput('_owlloc');
	$_owlguest = pnVarCleanFromInput('_owlguest');
	$_owlwindow = pnVarCleanFromInput('_owlwindow');
	$_owlwrap = pnVarCleanFromInput('_owlwrap');
	$_owlusers = pnVarCleanFromInput('_owlusers');
	$_owlgrp = pnVarCleanFromInput('_owlgrp');
	$_owlgrp = pnVarCleanFromInput('_owlgrp');
	$_owldb = pnVarCleanFromInput('_owldb');
	$_owlframe = pnVarCleanFromInput('_owlframe');
	$_owlfolder = pnVarCleanFromInput('_owlfolder');


    // Confirm authorisation code.
    if (!pnSecConfirmAuthKey()) {
        pnSessionSetVar('errormsg', _BADAUTHKEY);
        pnRedirect(pnModURL('pnOwl', 'admin', ''));
        return true;
    }

    // Update module variables.
    pnModSetVar('pnOwl', '_owlloc', $_owlloc);
    pnModSetVar('pnOwl', '_owlguest', $_owlguest);
    pnModSetVar('pnOwl', '_owlwindow', $_owlwindow);
    pnModSetVar('pnOwl', '_owlwrap', $_owlwrap);
    pnModSetVar('pnOwl', '_owlusers', $_owlusers);
    pnModSetVar('pnOwl', '_owlgrp', $_owlgrp);
    pnModSetVar('pnOwl', '_owldb', $_owldb);
    pnModSetVar('pnOwl', '_owlframe', $_owlframe);
    pnModSetVar('pnOwl', '_owlfolder', $_owlfolder);
    // This function generated no output, and so now it is complete we redirect
    // the user to an appropriate page for them to carry on their work
    pnRedirect('admin.php');

    // Return
    return true;
}
?>
