
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: logger.c,v 1.4 2005/12/06 21:09:48 mschwerin Exp $
 *
 */

#include <stdarg.h>
#include <stdio.h>

#include "logger.h"

void
_log (int level, const char *file, int line, const char *format, ...)
{
    char *level_str[] = { "FATAL", "ERROR", "WARN", "INFO", "DEBUG" };
    char log_format[1024];

    sprintf (log_format, "%5s: [%15s:%4d] %s\n", level_str[level], file,
             line, format);

    va_list args;

    char *logfile = "/tmp/oxine.log";
    FILE *f = fopen (logfile, "a");
    if (f != NULL) {
        va_start (args, format);
        vfprintf (f, log_format, args);
        va_end (args);
        fclose (f);
    }
    va_start (args, format);
    if (level < LEVEL_INFO) {
        vfprintf (stderr, log_format, args);
    } else {
        vfprintf (stdout, log_format, args);
    }
    va_end (args);
}
