
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk_post.c,v 1.2 2005/12/08 17:22:47 mschwerin Exp $
 *
 * This file is part of the odk system.
 *
 */

#include "config.h"

#include <assert.h>
#include <xine.h>

#include "heap.h"
#include "i18n.h"
#include "odk_private.h"

#define DEFAULT_DEINTERLACER "tvtime:method=LinearBlend,cheap_mode=1,pulldown=0,use_progressive_frame_flag=1"

void
odk_post_init (odk_t * odk)
{
    // post audio plugin
    const char *const *pol = xine_list_post_plugins_typed (odk->xine,
                                                           XINE_POST_TYPE_AUDIO_VISUALIZATION);
    if (pol) {
        int num_plug = 0;
        char **post_audio_plugins = ho_malloc (sizeof (char *));

        while (pol[num_plug]) {
            post_audio_plugins = (char **) ho_realloc (post_audio_plugins,
                                                       sizeof (char *) *
                                                       (num_plug + 3));

            post_audio_plugins[num_plug] = ho_strdup (pol[num_plug]);
            post_audio_plugins[num_plug + 1] = NULL;
            num_plug++;
        }

        xine_config_register_enum (odk->xine,
                                   "gui.post_audio_plugin", 0,
                                   post_audio_plugins,
                                   _("audio visualization plugin"),
                                   _("Post audio plugin to used "
                                     "when playing streams without video"),
                                   10, NULL, NULL);

        while (num_plug >= 0) {
            if (post_audio_plugins[num_plug])
                ho_free (post_audio_plugins[num_plug]);
            num_plug--;
        }

        ho_free (post_audio_plugins);
    }
    // post deinterlace plugin
    /*
       xine_config_register_string (odk->xine,
       "gui.deinterlace_plugin",
       DEFAULT_DEINTERLACER,
       _("Deinterlace plugin."),
       _("Plugin (with optional parameters) to use "
       "when deinterlace is used (plugin separator is ';')."),
       10, NULL, NULL);
     */

    odk->novideo_post = NULL;
}

void
odk_post_audio_rewire (odk_t * odk)
{
    xine_cfg_entry_t centry;
    xine_config_lookup_entry (odk->xine, "gui.post_audio_plugin", &centry);

    odk->novideo_post =
        xine_post_init (odk->xine,
                        centry.enum_values[centry.num_value], 0,
                        &odk->win->audio_port, &odk->win->video_port);

    if (odk->novideo_post) {
        xine_post_out_t *audio_source =
            xine_get_audio_source (odk->win->stream);
        xine_post_in_t *input =
            (xine_post_in_t *) xine_post_input (odk->novideo_post,
                                                "audio in");
        xine_post_wire (audio_source, input);
    }
}

void
odk_post_audio_unwire (odk_t * odk)
{
    assert (odk->novideo_post);

    xine_post_out_t *pp = xine_get_audio_source (odk->win->stream);
    xine_post_wire_audio_port (pp, odk->win->audio_port);
    xine_post_dispose (odk->xine, odk->novideo_post);

    odk->novideo_post = NULL;
}
